/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.control.UtilsBase;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.StringSplit;
import com.scudata.ide.common.control.CellRect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JViewport;

public class ControlUtilsBase
extends UtilsBase {
    private static ThreadLocal<Graphics> tlDisplayG = new ThreadLocal<Graphics>(){

        @Override
        protected synchronized Graphics initialValue() {
            BufferedImage bi = new BufferedImage(10, 10, 1);
            return bi.getGraphics();
        }
    };
    public static Color ACTIVE_BACK_COLOR = new Color(128, 160, 192);
    public static Color SELECTED_BACK_COLOR = new Color(153, 153, 102);

    public static Area adjustArea(Area area) {
        int tmp;
        int startRow = area.getBeginRow();
        int endRow = area.getEndRow();
        int startCol = area.getBeginCol();
        int endCol = area.getEndCol();
        if (startRow > endRow) {
            tmp = startRow;
            startRow = endRow;
            endRow = tmp;
            area.setBeginRow(startRow);
            area.setEndRow(endRow);
        }
        if (startCol > endCol) {
            tmp = startCol;
            startCol = endCol;
            endCol = tmp;
            area.setBeginCol(startCol);
            area.setEndCol(endCol);
        }
        return area;
    }

    public static Vector<CellLocation> listSelectedCells(Area area) {
        Vector<CellLocation> cells = new Vector<CellLocation>();
        if (area != null) {
            int r = area.getBeginRow();
            while (r <= area.getEndRow()) {
                int c = area.getBeginCol();
                while (c <= area.getEndCol()) {
                    cells.add(new CellLocation(r, c));
                    ++c;
                }
                ++r;
            }
        }
        return cells;
    }

    public static Vector<CellLocation> listSelectedCells(Vector<CellRect> selectedAreas) {
        Vector<CellLocation> cells = new Vector<CellLocation>();
        int i = 0;
        while (i < selectedAreas.size()) {
            CellRect rect = selectedAreas.get(i);
            if (rect != null) {
                Area area = rect.getArea();
                cells.addAll(ControlUtilsBase.listSelectedCells(area));
            }
            ++i;
        }
        return cells;
    }

    public static HashSet<Integer> listSelectedCols(Vector<Object> selectedAreas) {
        HashSet<Integer> cols = new HashSet<Integer>();
        int i = 0;
        while (i < selectedAreas.size()) {
            block4: {
                Area area;
                block6: {
                    Object areaOrRect;
                    block5: {
                        areaOrRect = selectedAreas.get(i);
                        if (areaOrRect == null) break block4;
                        if (!(areaOrRect instanceof CellRect)) break block5;
                        area = ((CellRect)areaOrRect).getArea();
                        break block6;
                    }
                    if (!(areaOrRect instanceof Area)) break block4;
                    area = (Area)areaOrRect;
                }
                int c = area.getBeginCol();
                while (c <= area.getEndCol()) {
                    Integer col = new Integer(c);
                    cols.add(col);
                    ++c;
                }
            }
            ++i;
        }
        return cols;
    }

    public static HashSet<Integer> listSelectedRows(Vector<Object> selectedAreas) {
        HashSet<Integer> rows = new HashSet<Integer>();
        int i = 0;
        while (i < selectedAreas.size()) {
            block4: {
                Area area;
                block6: {
                    Object areaOrRect;
                    block5: {
                        areaOrRect = selectedAreas.get(i);
                        if (areaOrRect == null) break block4;
                        if (!(areaOrRect instanceof CellRect)) break block5;
                        area = ((CellRect)areaOrRect).getArea();
                        break block6;
                    }
                    if (!(areaOrRect instanceof Area)) break block4;
                    area = (Area)areaOrRect;
                }
                int r = area.getBeginRow();
                while (r <= area.getEndRow()) {
                    Integer row = new Integer(r);
                    rows.add(row);
                    ++r;
                }
            }
            ++i;
        }
        return rows;
    }

    public static boolean scrollToVisible(JViewport viewport, Rectangle fieldArea) {
        Rectangle viewArea = viewport.getViewRect();
        if (ControlUtilsBase.containsArea(viewArea, fieldArea)) {
            return false;
        }
        Point pos = new Point();
        pos.x = viewArea.x;
        if (fieldArea.x + fieldArea.width > viewArea.x + viewArea.width) {
            pos.x = fieldArea.x + fieldArea.width - viewArea.width / 2;
        }
        int n = pos.x = pos.x > fieldArea.x ? fieldArea.x - 5 : pos.x;
        if (pos.x + viewArea.width > viewport.getView().getWidth()) {
            pos.x = viewport.getView().getWidth() - viewArea.width;
        }
        pos.y = viewArea.y;
        if (fieldArea.y + fieldArea.height > viewArea.y + viewArea.height) {
            pos.y = fieldArea.y + fieldArea.height - viewArea.height / 2;
        }
        int n2 = pos.y = pos.y > fieldArea.y ? fieldArea.y - 5 : pos.y;
        if (pos.y + viewArea.height > viewport.getView().getHeight()) {
            pos.y = viewport.getView().getHeight() - viewArea.height;
        }
        viewport.setViewPosition(pos);
        return true;
    }

    private static boolean containsArea(Rectangle viewArea, Rectangle cellArea) {
        if (viewArea == null || cellArea == null) {
            return false;
        }
        if (!ControlUtilsBase.isAreaCoincide(viewArea.x, viewArea.x + viewArea.width, cellArea.x, cellArea.x + cellArea.width)) {
            return false;
        }
        return ControlUtilsBase.isAreaCoincide(viewArea.y, viewArea.y + viewArea.height, cellArea.y, cellArea.y + cellArea.height);
    }

    private static boolean isAreaCoincide(int a1, int a2, int b1, int b2) {
        return a1 <= b1 && a2 >= b1;
    }

    public static void drawHeader(Graphics g, int x, int y, int w, int h, String label, float scale, Color backColor, byte selectState, boolean editable) {
        Shape oldShape = g.getClip();
        try {
            Rectangle drawRect = oldShape.getBounds();
            int drawX = x;
            int drawY = y;
            int drawWidth = w;
            int drawHeight = h;
            if (x < drawRect.x) {
                drawX = drawRect.x;
            }
            if (y < drawRect.y) {
                drawY = drawRect.y;
            }
            if (x + w > drawRect.x + drawRect.width) {
                drawWidth -= x + w - (drawRect.x + drawRect.width);
            }
            if (y + h > drawRect.y + drawRect.height) {
                drawHeight -= y + h - (drawRect.y + drawRect.height);
            }
            g.setClip(drawX, drawY, drawWidth, drawHeight);
            Color fontColor = Color.black;
            if (backColor.equals(Color.gray)) {
                fontColor = Color.white;
            }
            Font font = GM.getScaleFont(scale);
            switch (selectState) {
                case 1: {
                    if (ConfigOptions.getHeaderColor() != null) {
                        backColor = ConfigOptions.getHeaderColor();
                        break;
                    }
                    backColor = ACTIVE_BACK_COLOR;
                    break;
                }
                case 3: 
                case 4: {
                    fontColor = Color.white;
                    backColor = SELECTED_BACK_COLOR;
                }
            }
            if (editable) {
                if (selectState == 1) {
                    ControlUtilsBase.gradientPaint(g, x, y, w, h, backColor, false);
                } else {
                    ControlUtilsBase.gradientPaint(g, x, y, w, h, backColor);
                }
            } else {
                g.clearRect(x, y, w, h);
                fontColor = Color.lightGray.darker();
            }
            g.setColor(new Color(236, 236, 236));
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y, x, y + h);
            g.setColor(Color.darkGray);
            g.drawLine(x + w, y + h, x, y + h);
            g.drawLine(x + w, y + h, x + w, y);
            g.setColor(fontColor);
            int fontW = ControlUtilsBase.stringWidth(g.getFontMetrics(font), label);
            g.setFont(font);
            g.drawString(label, x + (w - fontW) / 2, y + h / 2 + 5);
        }
        finally {
            g.setClip(oldShape);
        }
    }

    public static void gradientPaint(Graphics g, int x, int y, int w, int h, Color c) {
        ControlUtilsBase.gradientPaint(g, x, y, w, h, c, true);
    }

    public static void gradientPaint(Graphics g, int x, int y, int w, int h, Color c, boolean isBrighter) {
        Graphics2D g2 = (Graphics2D)g;
        Paint storedPaint = g2.getPaint();
        if (isBrighter) {
            g2.setPaint(new GradientPaint(x + w / 2, y + h / 2, c, x + w / 2, y, c.brighter()));
        } else {
            g2.setPaint(new GradientPaint(x + w / 2, y + h / 2, c, x + w / 2, y, c));
        }
        g2.fillRect(x, y, w, h);
        g2.setPaint(storedPaint);
    }

    public static String getCellText(ICellSet cellSet, int row, int col, boolean isEditing) {
        String value;
        String textValue = null;
        INormalCell nc = cellSet.getCell(row, col);
        if (nc == null) {
            return "";
        }
        if (!isEditing) {
            Object o = nc.getValue();
            if (o instanceof String) {
                textValue = (String)o;
            } else if (o != null) {
                textValue = o.toString();
            }
            if (textValue != null) {
                return textValue;
            }
        }
        String string = textValue = (value = nc.getExpString()) == null ? GC.NULL : value.toString();
        if (textValue != null && textValue.length() > 0) {
            return textValue;
        }
        return "";
    }

    public static float getStringHeight(String text, float fixedWidth, Font font) {
        return ControlUtilsBase.getStringHeight(text, fixedWidth, font, -1.0f);
    }

    public static float getStringHeight(String text, float fixedWidth, Font font, float maxH) {
        Graphics fg = ControlUtilsBase.getDisplayGraphics();
        FontMetrics fm = fg.getFontMetrics(font);
        return ControlUtilsBase.getStringHeight(fm, text, fixedWidth, maxH);
    }

    public static float getStringHeight(FontMetrics fm, String text, float fixedWidth) {
        return ControlUtilsBase.getStringHeight(fm, text, fixedWidth, -1.0f);
    }

    public static float getStringHeight(FontMetrics fm, String text, float fixedWidth, float maxH) {
        if (fixedWidth < 1.0f) {
            return Float.MAX_VALUE;
        }
        float linH = fm.getHeight();
        int maxRow = -1;
        if (maxH > 0.0f) {
            maxRow = (int)(maxH / linH) + 10;
        }
        ArrayList<String> wrapString = ControlUtilsBase.wrapString(text, fm, (int)fixedWidth, maxRow);
        return (float)wrapString.size() * linH;
    }

    public static int getStringMaxWidth(String text, Font font) {
        return ControlUtilsBase.getStringMaxWidth(text, font, 0);
    }

    public static int getStringMaxWidth(String text, Font font, int indent) {
        Graphics fg = ControlUtilsBase.getDisplayGraphics();
        FontMetrics fm = fg.getFontMetrics(font);
        return ControlUtilsBase.getStringMaxWidth(fm, text, font, indent);
    }

    public static int getStringMaxWidth(FontMetrics fm, String text) {
        return ControlUtilsBase.getStringMaxWidth(fm, text, fm.getFont());
    }

    public static int getStringMaxWidth(FontMetrics fm, String text, Font font) {
        return ControlUtilsBase.getStringMaxWidth(fm, text, font, 0);
    }

    public static int getStringMaxWidth(FontMetrics fm, String text, Font font, int indent) {
        String hashKey = String.valueOf(text) + font.hashCode();
        ArrayList<String> wrapString = (ArrayList<String>)wrapStringBuffer.get(hashKey);
        if (wrapString == null) {
            wrapString = new ArrayList<String>();
            if (text.indexOf(10) < 0) {
                wrapString.add(text);
            } else {
                StringSplit at = new StringSplit(text, '\n', true, true, true);
                while (at.hasNext()) {
                    wrapString.add(at.next());
                }
            }
        }
        int w = 0;
        int i = 0;
        while (i < wrapString.size()) {
            String line = (String)wrapString.get(i);
            int len = ControlUtilsBase.stringWidth(fm, line);
            if (i == 0) {
                len += indent;
            }
            if (len > w) {
                w = len;
            }
            ++i;
        }
        return w;
    }

    public static int drawText(Graphics g, String text, int x, int y, int w, int h, boolean underLine, byte halign, byte valign, Font font, Color c, int indent) {
        return ControlUtilsBase.drawText(g, text, x, y, w, h, underLine, halign, valign, font, c, indent, true);
    }

    public static int drawText(Graphics g, String text, int x, int y, int w, int h, boolean underLine, byte halign, byte valign, Font font, Color c, int indent, boolean wordWrap) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        g.setColor(c);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        if (halign == 0) {
            x += indent;
            w -= indent;
        } else if (halign == 4) {
            w -= indent;
        }
        int fw = ControlUtilsBase.stringWidth(fm, text);
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        if (!wordWrap) {
            float topSpace = (float)(h - fm.getHeight()) / 2.0f;
            if (topSpace > 3.0f) {
                topSpace = 3.0f;
            }
            if (topSpace > 0.0f) {
                y += (int)topSpace;
                h -= (int)(topSpace * 2.0f);
            }
            if (fw > w) {
                text = ControlUtilsBase.getCanDisplayText(text, fm, w);
                fw = ControlUtilsBase.stringWidth(fm, text);
            }
            int x1 = x;
            if (halign == 2) {
                x1 = x + (w - fw) / 2;
            } else if (halign == 4) {
                x1 = x + w - fw;
            }
            int y1 = y + ascent;
            if (valign == 16) {
                y1 = y + (h - ascent - descent) / 2 + ascent;
            } else if (valign == 32) {
                y1 = y + h - descent;
            }
            ControlUtilsBase.outText(g, text, x1, y1, fw, underLine, font, c, descent);
            return fw;
        }
        int lineH = fm.getHeight();
        int maxRow = h / lineH + 10;
        ArrayList<String> al = ControlUtilsBase.wrapString(text, fm, w, maxRow);
        if (al.size() <= 1) {
            float topSpace = (float)(h - fm.getHeight()) / 2.0f;
            if (topSpace > 3.0f) {
                topSpace = 3.0f;
            }
            if (topSpace > 0.0f) {
                y += (int)topSpace;
                h -= (int)(topSpace * 2.0f);
            }
            if (lineH > h) {
                lineH = h;
            }
        }
        int yy = y;
        if (valign == 16) {
            yy = y + (h - lineH * al.size()) / 2;
        } else if (valign == 32) {
            yy = y + h - lineH * al.size();
        }
        if (yy < y) {
            yy = y;
        }
        int maxW = 0;
        int i = 0;
        while (i < al.size()) {
            if (yy > y + h || i > 0 && yy + lineH > y + h) break;
            String wrapedText = al.get(i);
            fw = ControlUtilsBase.stringWidth(fm, wrapedText);
            int x1 = x;
            if (halign == 2) {
                x1 = x + (w - fw) / 2;
            } else if (halign == 4) {
                x1 = x + w - fw;
            }
            int y1 = yy + ascent;
            ControlUtilsBase.outText(g, wrapedText, x1, y1, fw, underLine, font, c, descent);
            maxW = Math.max(maxW, fw);
            yy += lineH;
            ++i;
        }
        return maxW;
    }

    private static String getCanDisplayText(String text, FontMetrics fm, int w) {
        String newText = text;
        int w1 = ControlUtilsBase.stringWidth(fm, newText);
        if (w1 < w) {
            return text;
        }
        if (w1 < w * 2) {
            while (ControlUtilsBase.stringWidth(fm, newText) > w) {
                if (newText.trim().length() == 0) {
                    return "";
                }
                newText = newText.substring(0, newText.length() - 1);
            }
        } else {
            newText = "";
            int index = 0;
            while (ControlUtilsBase.stringWidth(fm, newText) < w) {
                newText = text.substring(0, ++index);
            }
            if (index == 0) {
                return "";
            }
            newText = text.substring(0, index - 1);
        }
        return newText;
    }

    /*
     * Unable to fully structure code
     */
    public static void outText(Graphics g, String text, int x, int y, int w, boolean underLine, Font font, Color c, int descent) {
        if (text != null && text.length() != 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            text = text.substring(0, text.length() - 1);
lbl4:
            // 2 sources

            ** while (text.endsWith((String)"\n"))
        }
lbl5:
        // 1 sources

        text = text.replaceAll("\t", "          ");
        g.setColor(c);
        g.setFont(font);
        stringWidth = ControlUtilsBase.drawString(g, text, x, y, w);
        if (underLine) {
            g.setPaintMode();
            g.drawLine(x, y + descent, x + stringWidth, y + descent);
        }
    }

    public static int drawString(Graphics g, String text, int x, int y, int w) {
        Vector v = ControlUtilsBase.calcCharactersX2(text, x, g.getFont(), w);
        int[] xx = (int[])v.get(0);
        int strWidth = (Integer)v.get(1);
        ControlUtilsBase.drawString(g, text, xx, y);
        return strWidth;
    }

    private static void drawString(Graphics g, String text, int[] xx, int y) {
        Font fontOld = g.getFont();
        int[] codePoints = ControlUtilsBase.getCodePoints(text);
        int count = codePoints.length;
        boolean isDialogFont = ControlUtilsBase.isDialogFont(fontOld);
        Font fontDialog = null;
        int i = 0;
        while (i < count) {
            boolean changeFont = false;
            if (!isDialogFont && !fontOld.canDisplay(codePoints[i])) {
                changeFont = true;
                if (fontDialog == null) {
                    fontDialog = ControlUtilsBase.getDialogFont(fontOld);
                }
                if (fontDialog.canDisplay(codePoints[i])) {
                    g.setFont(fontDialog);
                }
            }
            g.drawString(new String(codePoints, i, 1), xx[i], y);
            if (changeFont) {
                g.setFont(fontOld);
            }
            ++i;
        }
    }

    public static int[] getCodePoints(String text) {
        if (text == null) {
            return null;
        }
        int count = text.codePointCount(0, text.length());
        int len = text.length();
        int[] codePoints = new int[count];
        int index = 0;
        int i = 0;
        while (i < len) {
            int codePoint;
            codePoints[index] = codePoint = text.codePointAt(i);
            char[] bytes = Character.toChars(codePoint);
            i += bytes.length - 1;
            ++index;
            ++i;
        }
        return codePoints;
    }

    public static boolean isDialogFont(Font font) {
        return "Dialog".equals(font.getFontName());
    }

    public static Font getDialogFont(Font font) {
        return new Font("Dialog", font.getStyle(), font.getSize());
    }

    /*
     * Unable to fully structure code
     */
    public static Vector calcCharactersX2(String text, int x1, Font font, int width) {
        dispg = ControlUtilsBase.getDisplayGraphics();
        fm = dispg.getFontMetrics(font);
        codePoints = ControlUtilsBase.getCodePoints(text);
        count = codePoints.length;
        isDialogFont = ControlUtilsBase.isDialogFont(font);
        xx = new int[count];
        fontDialog = null;
        fmDialog = null;
        x2 = x1;
        i = 0;
        while (i < count) {
            xx[i] = x2;
            if (isDialogFont || font.canDisplay(codePoints[i])) ** GOTO lbl-1000
            if (fontDialog == null) {
                fontDialog = ControlUtilsBase.getDialogFont(font);
                fmDialog = dispg.getFontMetrics(fontDialog);
            }
            if (fontDialog.canDisplay(codePoints[i])) {
                x2 += fmDialog.charWidth(codePoints[i]);
            } else lbl-1000:
            // 2 sources

            {
                x2 += fm.charWidth(codePoints[i]);
            }
            ++i;
        }
        v = new Vector<Object>();
        v.add(xx);
        v.add(x2 - x1);
        return v;
    }

    public static Graphics getDisplayGraphics() {
        if (tlDisplayG == null) {
            BufferedImage bi = new BufferedImage(10, 10, 1);
            return bi.getGraphics();
        }
        return tlDisplayG.get();
    }

    public static void clearWrapBuffer() {
        wrapStringBuffer.clear();
    }

    public static int lookupHeaderIndex(int curr, int[] start, int[] len) {
        int i = 1;
        while (i < start.length) {
            if (curr > start[i] && curr <= start[i] + len[i]) {
                return i;
            }
            ++i;
        }
        if (curr > start[start.length - 1] && curr > start[start.length - 1] + len[start.length - 1]) {
            return start.length - 1;
        }
        return -1;
    }

    public static byte[] getStreamBytes(InputStream is) throws Exception {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }

    public static CellLocation checkPosition(CellLocation cp, ICellSet ics) {
        if (cp == null) {
            return null;
        }
        if (cp.getRow() < 1) {
            cp.setRow(1);
        }
        if (cp.getRow() > ics.getRowCount()) {
            cp.setRow(ics.getRowCount());
        }
        if (cp.getCol() < 1) {
            cp.setCol(1);
        }
        if (cp.getCol() > ics.getColCount()) {
            cp.setCol(ics.getColCount());
        }
        return cp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canDisplayText(Font font, String text) {
        try {
            if (font == null) return true;
            if (text == null) return true;
            if (font.getName().equalsIgnoreCase("DIALOG")) return true;
            int[] codePoints = ControlUtilsBase.getCodePoints(text);
            if (codePoints == null) return true;
            int count = codePoints.length;
            int i = 0;
            while (true) {
                if (i >= count) {
                    return true;
                }
                if (!font.canDisplay(codePoints[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

