/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.IntArrayList;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GMSE;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.function.EditingFuncInfo;
import com.scudata.ide.common.function.EditingFuncParam;
import com.scudata.ide.common.function.FuncInfo;
import com.scudata.ide.common.function.FuncManager;
import com.scudata.ide.common.function.FuncOption;
import com.scudata.ide.common.function.FuncParam;
import com.scudata.ide.common.function.ParamUtil;
import com.scudata.ide.common.swing.FreeConstraints;
import com.scudata.ide.common.swing.FreeLayout;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.spl.GVSpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class FuncWindow
extends JWindow {
    private static final long serialVersionUID = 1L;
    private JPanel panelMain = new JPanel();
    private JListEx listFunc = new JListEx();
    private JTextPane textDesc = new JTextPane();
    private FuncManager funcManager = FuncManager.getManager();
    private boolean isEnabled = false;
    private boolean preventChange = false;
    private JScrollPane jSPFunc = new JScrollPane(this.listFunc);
    private JScrollPane jSPDesc = new JScrollPane(this.textDesc);
    private HashMap<FuncInfo, FuncInfo> matchedMap = new HashMap();
    private EditingFuncInfo efi;
    private boolean isDisplay = false;
    private String oldEfo;
    private String oldFuncName;
    private int funcIndex = -1;
    private int x;
    private int y;
    private int w;

    public FuncWindow() {
        super(GV.appFrame);
        this.panelMain.setLayout(new FreeLayout());
        this.panelMain.setBorder(BorderFactory.createLineBorder(Color.black));
        this.textDesc.setContentType("text/html");
        this.textDesc.setFont(GC.font);
        this.getContentPane().add(this.panelMain);
        this.setBounds(-100, -100, 5, 5);
        this.textDesc.setEditable(false);
        this.listFunc.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JEditorPane jtf = new JEditorPane();
                String exp = value == null ? "" : value.toString();
                jtf.setContentType("text/html");
                jtf.setFont(GC.font);
                jtf.setText(exp);
                if (isSelected) {
                    jtf.setBackground(list.getSelectionBackground());
                    jtf.setForeground(list.getSelectionForeground());
                } else {
                    jtf.setBackground(list.getBackground());
                    jtf.setForeground(list.getForeground());
                }
                jtf.setEnabled(list.isEnabled());
                jtf.setFont(list.getFont());
                jtf.setBorder(null);
                return jtf;
            }
        });
    }

    public boolean isFuncEnabled() {
        return this.isEnabled;
    }

    public void setFuncEnabled(boolean enabled) {
        this.isEnabled = ConfigOptions.bFuncNotice != false ? true : enabled;
        this.resetOldFunc();
    }

    public boolean isDisplay() {
        return this.isEnabled && this.isDisplay;
    }

    public void setPosition(int x, int y, int w) {
        this.x = x;
        this.y = y;
        this.w = w;
    }

    private int getListHeight() {
        FontMetrics fm = new JTextField().getFontMetrics(GC.font);
        int h = this.listFunc.data.getSize() * (fm.getHeight() + 4);
        return h;
    }

    private int getDescHeight(FuncInfo fi) {
        String text = GMSE.getFuncDesc(fi, null, null, -1);
        FontMetrics fm = this.textDesc.getFontMetrics(this.textDesc.getStyledDocument().getFont(this.textDesc.getCharacterAttributes()));
        IntArrayList list = new IntArrayList();
        GM.transTips(text, list, fm, this.w - 6);
        int height = list.getInt(1);
        int lineCount = height / fm.getHeight();
        return 22 + lineCount * (fm.getHeight() + 6);
    }

    private int getTotalHeight(FuncInfo fi) {
        return this.getListHeight() + this.getDescHeight(fi) + 14;
    }

    private void resetOldFunc() {
        this.oldFuncName = null;
        this.funcIndex = -1;
    }

    public void hideWindow() {
        this.invalidate();
        this.setBounds(-100, -100, 5, 5);
        Thread t = new Thread(){

            @Override
            public void run() {
                FuncWindow.this.validate();
                FuncWindow.this.repaint();
            }
        };
        SwingUtilities.invokeLater(t);
        this.isDisplay = false;
    }

    public void showNextFunc(JTextComponent textExp) {
        if (this.listFunc.isSelectionEmpty()) {
            return;
        }
        if (!this.isFuncEnabled()) {
            return;
        }
        int index = this.listFunc.getSelectedIndex();
        index = index == this.listFunc.data.size() - 1 ? 0 : ++index;
        this.listFunc.setSelectedIndex(index);
        this.showFunc(index, textExp);
    }

    private void showFunc(int index, JTextComponent textExp) {
        this.funcIndex = index;
        Object disp = this.listFunc.data.getElementAt(index);
        Object code = this.listFunc.x_getCodeItem((String)disp);
        FuncInfo fi = (FuncInfo)code;
        FuncInfo matchedFi = this.matchedMap.get(fi);
        ActiveParamConfig apc = this.getActiveParamConfig(matchedFi, this.efi, textExp);
        FuncParam activeParam = null;
        int paramCaret = -1;
        if (apc != null) {
            activeParam = apc.activeParam;
            paramCaret = apc.paramCaret;
        }
        String efo = this.getActiveFuncOption(this.efi, textExp);
        this.textDesc.setText(GMSE.getFuncDesc(fi, efo, activeParam, paramCaret));
        this.resetUI(fi);
    }

    public void caretPositionChanged(JTextComponent textExp, Context ctx) {
        this.caretPositionChanged(textExp, ctx, false);
    }

    public void caretPositionChanged(final JTextComponent textExp, Context ctx, boolean resizeFuncWin) {
        if (!this.isEnabled) {
            return;
        }
        ListSelectionListener[] listeners = this.listFunc.getListSelectionListeners();
        if (listeners != null) {
            int len = listeners.length;
            int i = len - 1;
            while (i >= 0) {
                this.listFunc.removeListSelectionListener(listeners[i]);
                --i;
            }
        }
        this.listFunc.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FuncWindow.this.preventChange) {
                    return;
                }
                if (FuncWindow.this.listFunc.isSelectionEmpty()) {
                    return;
                }
                if (!FuncWindow.this.isFuncEnabled()) {
                    return;
                }
                int index = FuncWindow.this.listFunc.getSelectedIndex();
                FuncWindow.this.showFunc(index, textExp);
            }
        });
        this.matchedMap.clear();
        PgmCellSet cellSet = null;
        if (GVSpl.splEditor != null) {
            cellSet = GVSpl.splEditor.getComponent().cellSet;
        }
        if (cellSet == null) {
            this.hideWindow();
            return;
        }
        this.efi = ParamUtil.getEditingFunc(textExp, cellSet, ctx);
        if (this.efi == null) {
            this.hideWindow();
            return;
        }
        String name = this.efi.getFuncName();
        ArrayList<FuncInfo> funcs = this.funcManager.getFunc(name);
        if (funcs == null) {
            this.hideWindow();
            return;
        }
        ArrayList<FuncInfo> filterFuncs = new ArrayList<FuncInfo>();
        int i = 0;
        while (i < funcs.size()) {
            FuncInfo fi = funcs.get(i);
            if (this.efi.getMajorType() == fi.getMajorType() || this.efi.getMajorType() == 102 || fi.getMajorType() == 102) {
                filterFuncs.add(fi);
            }
            ++i;
        }
        funcs = filterFuncs;
        if (funcs.isEmpty()) {
            this.hideWindow();
            return;
        }
        if (this.oldFuncName == null || !this.oldFuncName.equals(name)) {
            this.resetOldFunc();
        }
        this.oldFuncName = name;
        i = 0;
        while (i < funcs.size()) {
            FuncInfo fi = null;
            try {
                fi = ParamUtil.matchFuncInfoParams(funcs.get(i), this.efi.getFuncParam().getParamString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (fi != null) {
                this.matchedMap.put(funcs.get(i), fi);
            }
            ++i;
        }
        int size = this.matchedMap.size();
        if (size > 1) {
            ArrayList<FuncInfo> optFuncs = new ArrayList<FuncInfo>();
            for (FuncInfo key : this.matchedMap.keySet()) {
                FuncInfo fi = this.matchedMap.get(key);
                if (this.compareFuncOption(fi, this.efi)) continue;
                optFuncs.add(key);
            }
            if (size - optFuncs.size() >= 1) {
                int i2 = 0;
                while (i2 < optFuncs.size()) {
                    this.matchedMap.remove(optFuncs.get(i2));
                    ++i2;
                }
            }
        }
        this.setFuncInfo(funcs, this.efi, textExp, this.matchedMap, resizeFuncWin);
    }

    private void setFuncInfo(ArrayList<FuncInfo> fList, EditingFuncInfo efi, JTextComponent textExp, HashMap<FuncInfo, FuncInfo> matchedMap, boolean resizeFuncWin) {
        int size;
        this.preventChange = true;
        Vector<FuncInfo> codes = new Vector<FuncInfo>();
        Vector<String> disps = new Vector<String>();
        String efo = this.getActiveFuncOption(efi, textExp);
        int listIndex = this.funcIndex;
        String newDesc = null;
        int i = 0;
        while (i < fList.size()) {
            FuncInfo fi = fList.get(i);
            FuncInfo matchedFi = matchedMap.get(fi);
            ActiveParamConfig apc = this.getActiveParamConfig(matchedFi, efi, textExp);
            FuncParam activeParam = null;
            int paramCaret = -1;
            if (apc != null) {
                activeParam = apc.activeParam;
                paramCaret = apc.paramCaret;
                if (listIndex == -1) {
                    listIndex = i;
                    newDesc = GMSE.getFuncDesc(fi, efo, activeParam, paramCaret);
                } else if (this.funcIndex == i) {
                    newDesc = GMSE.getFuncDesc(fi, efo, activeParam, paramCaret);
                }
            }
            codes.add(fi);
            disps.add(FuncWindow.getFuncString(fi, efo, activeParam, paramCaret));
            ++i;
        }
        if (newDesc == null) {
            if (listIndex < 0) {
                listIndex = 0;
            }
            newDesc = GMSE.getFuncDesc(fList.get(listIndex), efo, null, -1);
        }
        if (!resizeFuncWin && this.isDisplay && (size = this.listFunc.data.size()) == codes.size()) {
            boolean sameFunc = true;
            int i2 = 0;
            while (i2 < size) {
                Object disp = this.listFunc.data.getElementAt(i2);
                Object code = this.listFunc.x_getCodeItem((String)disp);
                if (!code.equals(codes.get(i2)) || !disp.equals(disps.get(i2))) {
                    sameFunc = false;
                    break;
                }
                ++i2;
            }
            if (sameFunc && listIndex == this.listFunc.getSelectedIndex()) {
                if (this.oldEfo == null && efo == null) {
                    return;
                }
                if (this.oldEfo != null && this.oldEfo.equals(efo)) {
                    return;
                }
            }
        }
        this.oldEfo = efo;
        try {
            this.textDesc.setText(newDesc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.listFunc.x_setData(codes, disps);
        this.listFunc.setSelectedIndex(listIndex);
        this.resetUI(fList.get(listIndex));
        this.isDisplay = true;
        this.preventChange = false;
    }

    private String getActiveFuncOption(EditingFuncInfo efi, JTextComponent textExp) {
        String efo = efi.getFuncOption();
        if (StringUtils.isValidString(efo)) {
            int fos = efi.getFuncOptionStart();
            int oPos = textExp.getCaretPosition() - fos - 1;
            if (oPos < efo.length() && oPos > -1) {
                char foChar = efo.charAt(oPos);
                return String.valueOf(foChar);
            }
        }
        return null;
    }

    private ActiveParamConfig getActiveParamConfig(FuncInfo matchedFi, EditingFuncInfo efi, JTextComponent textExp) {
        if (matchedFi == null || efi == null) {
            return null;
        }
        EditingFuncParam efp = efi.getFuncParam();
        if (efp == null) {
            return null;
        }
        int paramStart = efi.getFuncParamStart();
        int caretPos = textExp.getCaretPosition();
        int paramPos = caretPos - paramStart;
        String paramString = efp.getParamString();
        ArrayList<FuncParam> params = matchedFi.getParams();
        if (!StringUtils.isValidString(efp.getParamString()) || paramPos < 0) {
            return new ActiveParamConfig();
        }
        if (params != null && params.size() > 0) {
            if (paramPos == 0) {
                FuncParam fp = params.get(0);
                return new ActiveParamConfig(fp, 0);
            }
            int preSize = 0;
            int j = 0;
            while (j < params.size()) {
                FuncParam fp = params.get(j);
                if (!StringUtils.isValidString(fp.getParamValue())) {
                    if (!StringUtils.isValidString(paramString)) {
                        return new ActiveParamConfig(fp, paramPos - preSize);
                    }
                    if (paramString.startsWith(String.valueOf(fp.getPreSign()))) {
                        paramString = paramString.substring(1);
                        ++preSize;
                        if (!StringUtils.isValidString(paramString)) {
                            return new ActiveParamConfig(fp, paramPos - preSize);
                        }
                    }
                } else {
                    int start = paramString.indexOf(fp.getParamValue());
                    int end = start + fp.getParamValue().length();
                    if (start + preSize <= paramPos && end + preSize >= paramPos || j == params.size() - 1) {
                        return new ActiveParamConfig(fp, paramPos - start - preSize);
                    }
                    paramString = paramString.substring(end);
                    preSize += end;
                    if (!StringUtils.isValidString(paramString)) {
                        return new ActiveParamConfig(fp, paramPos - preSize);
                    }
                }
                ++j;
            }
        }
        return null;
    }

    private void resetUI(FuncInfo fi) {
        int h = this.getListHeight() + 2;
        this.panelMain.add((Component)this.jSPFunc, new FreeConstraints(3, 3, this.w - 6, h));
        this.panelMain.add((Component)this.jSPDesc, new FreeConstraints(3, 5 + h, this.w - 6, this.getDescHeight(fi) + 2));
        this.invalidate();
        this.setBounds(this.x, this.y, this.w, this.getTotalHeight(fi));
        this.validate();
        this.repaint();
    }

    public static String getFuncString(FuncInfo fi, String efo, FuncParam activeParam, int paramCaret) {
        return FuncWindow.getFuncString(fi, efo, activeParam, paramCaret, true);
    }

    public static String getFuncString(FuncInfo fi, String efo, FuncParam activeParam, int paramCaret, boolean getFullString) {
        String optChar;
        FuncOption fo;
        StringBuffer sb = new StringBuffer();
        if (getFullString && StringUtils.isValidString(fi.getPostfix())) {
            sb.append(fi.getPostfix());
        }
        if (StringUtils.isValidString(fi.getDisplayStr())) {
            sb.append(fi.getDisplayStr());
            return sb.toString();
        }
        sb.append(fi.getName());
        ArrayList<FuncOption> options = fi.getOptions();
        if (getFullString && options != null && options.size() > 0) {
            sb.append("@");
            int i = 0;
            while (i < options.size()) {
                fo = options.get(i);
                optChar = fo.getOptionChar();
                if (StringUtils.isValidString(efo) && efo.indexOf(optChar) > -1) {
                    optChar = "<b>" + optChar + "</b>";
                }
                sb.append(optChar);
                ++i;
            }
        }
        sb.append("(");
        ArrayList<FuncParam> params = fi.getParams();
        if (params != null && params.size() != 0) {
            int i = 0;
            while (i < params.size()) {
                FuncParam fp = params.get(i);
                boolean isActiveParam = activeParam != null && fp.getDesc().equals(activeParam.getDesc());
                String name = FuncWindow.getFuncParamName(fp);
                char activeOptChar = '@';
                if (isActiveParam) {
                    name = "<b>" + name + "</b>";
                    String paramValue = activeParam.getParamValue();
                    int optPos = paramValue.indexOf("@");
                    if (optPos > -1 && paramCaret > optPos) {
                        activeOptChar = paramValue.charAt(paramCaret - 1);
                    }
                }
                char preSign = fp.getPreSign();
                StringBuffer option = new StringBuffer();
                options = fp.getOptions();
                if (fp.isIdentifierOnly() && options != null && options.size() > 0) {
                    option.append("@");
                    int j = 0;
                    while (j < options.size()) {
                        fo = options.get(j);
                        optChar = fo.getOptionChar();
                        if (optChar.equals(String.valueOf(activeOptChar))) {
                            optChar = "<b>" + optChar + "</b>";
                        }
                        option.append(optChar);
                        ++j;
                    }
                }
                if (fp.isRepeatable()) {
                    FuncParam fpNext;
                    if (i != 0) {
                        sb.append(preSign);
                    }
                    boolean hasSub = false;
                    if (i < params.size() - 1 && (fpNext = params.get(i + 1)).getPreSign() == ':') {
                        hasSub = true;
                        sb.append(name);
                        if (option.length() > 0) {
                            sb.append(option);
                        }
                        sb.append(fpNext.getPreSign());
                        isActiveParam = activeParam != null && fpNext.getDesc().equals(activeParam.getDesc());
                        name = FuncWindow.getFuncParamName(fpNext);
                        if (isActiveParam) {
                            name = "<b>" + name + "</b>";
                        }
                        sb.append(name);
                        sb.append(preSign);
                        sb.append("...");
                        ++i;
                    } else if (!hasSub) {
                        sb.append(name);
                        if (option.length() > 0) {
                            sb.append(option);
                        }
                        sb.append(preSign);
                        sb.append("...");
                    }
                } else {
                    if (i != 0) {
                        sb.append(preSign);
                    }
                    sb.append(name);
                    if (option.length() > 0) {
                        sb.append(option);
                    }
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getFuncParamName(FuncParam fp) {
        String name = fp.getDesc();
        int index = name.indexOf("(");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private boolean compareFuncOption(FuncInfo fi, EditingFuncInfo efi) {
        int i;
        String opts = efi.getFuncOption();
        ArrayList<FuncOption> options = fi.getOptions();
        Vector<String> allOpts = new Vector<String>();
        if (options != null) {
            i = 0;
            while (i < options.size()) {
                FuncOption fo = options.get(i);
                allOpts.add(String.valueOf(fo.getOptionChar()));
                ++i;
            }
        }
        i = 0;
        while (i < opts.length()) {
            if (!allOpts.contains(opts.substring(i, i + 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class ActiveParamConfig {
        FuncParam activeParam;
        int paramCaret;

        public ActiveParamConfig() {
        }

        public ActiveParamConfig(FuncParam activeParam, int paramCaret) {
            this.activeParam = activeParam;
            this.paramCaret = paramCaret;
        }
    }
}

