/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.swing.JListEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;

public abstract class JWindowList
extends JWindow {
    private static final long serialVersionUID = 1L;
    private JTextField textFilter = new JTextField();
    private JListEx listWindow = new JListEx();
    private Vector<String> paths = new Vector();
    private Vector<String> names = new Vector();
    private Vector<String> filterPaths = new Vector();
    private Vector<String> filterNames = new Vector();
    private HashSet<String> existPaths = new HashSet();
    private Map<String, ImageIcon> typeMap = new HashMap<String, ImageIcon>();
    private final Color BACK_COLOR = new Color(255, 255, 214);
    private final Color DEFAULT_BACK_COLOR = new JList().getBackground();
    private final Color SELECTED_BACK_COLOR = new JList().getSelectionBackground();

    public JWindowList(int buttonSize) {
        super(GV.appFrame);
        this.getContentPane().add((Component)this.textFilter, "North");
        JScrollPane jSPWin = new JScrollPane(this.listWindow);
        this.getContentPane().add((Component)jSPWin, "Center");
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (JWindowList.this.isClickButton()) {
                    return;
                }
                JWindowList.this.dispose();
            }
        });
        this.setFocusable(true);
        GV.appFrame.getAllSheets();
        JInternalFrame[] sheets = GV.appFrame.getAllSheets();
        if (sheets != null) {
            int i = 0;
            while (i < sheets.length) {
                String filePath;
                String fileName = filePath = ((IPrjxSheet)sheets[i]).getSheetTitle();
                try {
                    File f = new File(filePath);
                    fileName = f.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.names.add(fileName);
                this.paths.add(filePath);
                if (i < buttonSize) {
                    this.existPaths.add(filePath);
                }
                this.filterNames.add(fileName);
                this.filterPaths.add(filePath);
                this.typeMap.put(filePath, this.getSheetIcon(sheets[i]));
                ++i;
            }
        }
        this.listWindow.x_setData(this.filterPaths, this.filterNames);
        ListCellRenderer cellRenderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                final JPanel panel = new JPanel(new BorderLayout());
                String filePath = (String)JWindowList.this.filterPaths.get(index);
                ImageIcon ii = (ImageIcon)JWindowList.this.typeMap.get(filePath);
                JLabel label = new JLabel(ii);
                panel.add((Component)label, "West");
                final JTextField text = new JTextField((String)JWindowList.this.filterNames.get(index));
                text.setBackground(JWindowList.this.BACK_COLOR);
                if (!JWindowList.this.existPaths.contains(filePath)) {
                    Font font = text.getFont();
                    text.setFont(new Font(font.getFontName(), 1, font.getSize() + 2));
                }
                text.setBorder(null);
                panel.add((Component)text, "Center");
                panel.setToolTipText(filePath);
                text.setToolTipText(filePath);
                label.setToolTipText(filePath);
                panel.setMinimumSize(new Dimension(0, 20));
                panel.setPreferredSize(new Dimension(0, 20));
                MouseAdapter listener = new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        panel.setBackground(JWindowList.this.SELECTED_BACK_COLOR);
                        text.setBackground(JWindowList.this.SELECTED_BACK_COLOR);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        panel.setBackground(JWindowList.this.DEFAULT_BACK_COLOR);
                        text.setBackground(JWindowList.this.DEFAULT_BACK_COLOR);
                    }
                };
                panel.addMouseListener(listener);
                return panel;
            }
        };
        this.listWindow.setCellRenderer(cellRenderer);
        this.listWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                int index = JWindowList.this.listWindow.getSelectedIndex();
                try {
                    if (JWindowList.this.showSheet((String)JWindowList.this.filterPaths.get(index))) {
                        JWindowList.this.dispose();
                    }
                }
                catch (Exception e1) {
                    GM.showException(e1);
                }
            }
        });
        this.textFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JWindowList.this.filter();
            }
        });
        this.textFilter.requestFocusInWindow();
        this.setBackground(this.BACK_COLOR);
        this.textFilter.setBackground(this.BACK_COLOR);
        this.listWindow.setBackground(this.BACK_COLOR);
        jSPWin.setBackground(this.BACK_COLOR);
    }

    public abstract ImageIcon getSheetIcon(JInternalFrame var1);

    public abstract boolean showSheet(String var1);

    public abstract boolean isClickButton();

    public void setPos(int x, int y) {
        int height = (this.paths.size() + 1) * 20 + 10;
        height = Math.min((int)((double)GV.appFrame.getHeight() * 0.5), height);
        this.setBounds(x, y, 200, height);
    }

    private void filter() {
        String filter = this.textFilter.getText();
        if (filter != null) {
            filter = filter.toLowerCase();
        }
        this.filterPaths = new Vector();
        this.filterNames = new Vector();
        int i = 0;
        while (i < this.names.size()) {
            String fileName = this.names.get(i);
            if (filter != null) {
                if (fileName.toLowerCase().startsWith(filter)) {
                    this.filterPaths.add(this.paths.get(i));
                    this.filterNames.add(this.names.get(i));
                }
            } else {
                this.filterPaths.add(this.paths.get(i));
                this.filterNames.add(this.names.get(i));
            }
            ++i;
        }
        this.listWindow.x_setData(this.filterPaths, this.filterNames);
    }
}

