/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.app.common.Section;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Param;
import com.scudata.dm.Table;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.control.PanelEditTable_this_changeAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;

public class PanelEditTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final byte TAB_NORMAL = 0;
    private final byte TAB_DATA = 1;
    private MessageManager mm = IdeCommonMessage.get();
    private final byte COL_INDEX = 0;
    private final byte COL_NAME = 1;
    private final byte COL_PK = (byte)2;
    private final String STR_INDEX = this.mm.getMessage("paneledittable.index");
    private JTableEx tableNormal = new JTableEx(this.mm.getMessage("paneledittable.tablenormal")){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            switch (col) {
                case 1: {
                    GM.dialogEditTableText(PanelEditTable.this.parent, PanelEditTable.this.tableNormal, row, col);
                }
            }
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!this.isItemDataChanged(row, column, aValue)) {
                return;
            }
            String oldName = null;
            if (column == 1 && this.getValueAt(row, column) != null) {
                oldName = (String)this.data.getValueAt(row, column);
            }
            if (PanelEditTable.this.preventChange) {
                super.setValueAt(aValue, row, column);
                return;
            }
            if (column == 1) {
                String newName;
                String string = newName = aValue == null ? null : (String)aValue;
                if (!PanelEditTable.this.alterTable(newName, oldName)) {
                    return;
                }
                super.setValueAt(aValue, row, column);
                PanelEditTable.this.tableStructChanged();
            } else {
                super.setValueAt(aValue, row, column);
            }
        }
    };
    private JTabbedPane jTabMain = new JTabbedPane();
    private JTableEx tableData;
    private boolean preventChange = false;
    private Param param;
    private Table table;
    private Component parent;

    public PanelEditTable(Component parent, Param param) {
        try {
            try {
                this.preventChange = true;
                this.parent = parent;
                this.param = param;
                this.rqInit();
                this.table = (Table)param.getValue();
                this.initConstTable();
            }
            catch (Exception ex) {
                GM.showException(parent, ex);
                this.preventChange = false;
            }
        }
        finally {
            this.preventChange = false;
        }
    }

    public Param getParam() {
        this.table.dataStruct().setPrimary(this.getPrimary());
        this.param.setValue(this.table);
        return this.param;
    }

    private boolean alterTable(String newName, String oldName) {
        return this.alterTable(newName, oldName, -1);
    }

    private boolean alterTable(String newName, String oldName, int row) {
        int index;
        String[] newNames;
        String[] oldNames;
        if (!StringUtils.isValidString(newName) && !StringUtils.isValidString(oldName)) {
            return false;
        }
        int rowCount = this.tableNormal.getRowCount();
        if (rowCount < 0) {
            return false;
        }
        if (StringUtils.isValidString(newName) && (this.table == null || this.table.dataStruct() == null || this.table.dataStruct().getFieldCount() == 0)) {
            this.table = new Table(new String[]{newName});
            return true;
        }
        String[] nNames = this.table.dataStruct().getFieldNames();
        if (StringUtils.isValidString(oldName) && StringUtils.isValidString(newName)) {
            oldNames = new String[nNames.length];
            newNames = new String[nNames.length];
            index = -1;
            int i = 0;
            while (i < nNames.length) {
                if (oldName.equals(nNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
            System.arraycopy(nNames, 0, oldNames, 0, nNames.length);
            System.arraycopy(nNames, 0, newNames, 0, nNames.length);
            if (index > -1) {
                newNames[index] = newName;
            }
        } else if (StringUtils.isValidString(oldName)) {
            oldNames = new String[nNames.length - 1];
            newNames = new String[nNames.length - 1];
            index = -1;
            int i = 0;
            while (i < nNames.length) {
                if (oldName.equals(nNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index > 0) {
                System.arraycopy(nNames, 0, oldNames, 0, index);
                System.arraycopy(nNames, 0, newNames, 0, index);
            }
            if (index != nNames.length - 1) {
                System.arraycopy(nNames, index + 1, oldNames, index, nNames.length - 1 - index);
                System.arraycopy(nNames, index + 1, newNames, index, nNames.length - 1 - index);
            }
        } else {
            oldNames = new String[nNames.length + 1];
            newNames = new String[oldNames.length];
            if (row >= 0) {
                if (row > 0) {
                    System.arraycopy(nNames, 0, oldNames, 0, row);
                    System.arraycopy(nNames, 0, newNames, 0, row);
                }
                newNames[row] = newName;
                System.arraycopy(nNames, row, oldNames, row + 1, oldNames.length - row - 1);
                System.arraycopy(nNames, row, newNames, row + 1, oldNames.length - row - 1);
            } else {
                System.arraycopy(nNames, 0, oldNames, 0, nNames.length);
                System.arraycopy(nNames, 0, newNames, 0, nNames.length);
                newNames[nNames.length] = newName;
            }
        }
        try {
            this.table.alter(newNames, oldNames);
        }
        catch (Exception e) {
            GM.showException(this.parent, e);
            return false;
        }
        return true;
    }

    void rqInit() throws Exception {
        JPanel panelNormal = new JPanel(new GridBagLayout());
        this.jTabMain.addChangeListener(new PanelEditTable_this_changeAdapter(this));
        panelNormal.add((Component)new JScrollPane(this.tableNormal), GM.getGBC(0, 0, true, true));
        this.jTabMain.add((Component)panelNormal, this.mm.getMessage("paneledittable.normal"));
        this.tableData = new JTableEx(){
            private static final long serialVersionUID = 1L;

            @Override
            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                if (col <= 0) {
                    return;
                }
                GM.dialogEditTableText(PanelEditTable.this.parent, PanelEditTable.this.tableData, row, col);
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!this.isItemDataChanged(row, column, aValue)) {
                    return;
                }
                if (!PanelEditTable.this.preventChange) {
                    BaseRecord record = PanelEditTable.this.table.getRecord(row + 1);
                    int nc = record.getFieldCount();
                    if (--column < nc) {
                        if (aValue instanceof String) {
                            aValue = PgmNormalCell.parseConstValue((String)aValue);
                        }
                        record.set(column, aValue);
                    }
                    ++column;
                }
                super.setValueAt(aValue, row, column);
            }
        };
        this.tableData.setSelectionMode(0);
        this.tableData.setRowHeight(20);
        this.tableData.setAutoResizeMode(0);
        this.tableData.getTableHeader().setReorderingAllowed(false);
        this.tableData.setClickCountToStart(1);
        this.jTabMain.add((Component)new JScrollPane(this.tableData), this.mm.getMessage("paneledittable.data"));
        this.initTable(this.tableNormal);
        this.tableNormal.setColumnCheckBox(2);
        this.tableNormal.getColumn(2).setMaxWidth(80);
        this.tableNormal.setColumnWidth(2, 80);
        this.tableNormal.getColumn(2).setMaxWidth(500);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTabMain, "Center");
    }

    private void initConstTable() {
        if (this.table == null) {
            return;
        }
        DataStruct ds = this.table.dataStruct();
        if (ds == null) {
            return;
        }
        this.initNormalTable(ds.getFieldNames(), ds.getPrimary());
        this.resetTableData();
    }

    private void initNormalTable(String[] normalNames, String[] primarys) {
        if (normalNames == null) {
            return;
        }
        Section pks = null;
        if (primarys != null) {
            pks = new Section(primarys);
        }
        int i = 0;
        while (i < normalNames.length) {
            this.tableNormal.addRow();
            this.tableNormal.data.setValueAt(normalNames[i], i, 1);
            Boolean isPk = Boolean.FALSE;
            if (pks != null && pks.containsSection(normalNames[i])) {
                isPk = Boolean.TRUE;
            }
            this.tableNormal.data.setValueAt(isPk, i, 2);
            ++i;
        }
    }

    private JTableEx getEditingTable() {
        switch (this.jTabMain.getSelectedIndex()) {
            case 0: {
                return this.tableNormal;
            }
            case 1: {
                return this.tableData;
            }
        }
        return null;
    }

    public boolean checkData() {
        this.tableNormal.acceptText();
        this.tableData.acceptText();
        HashSet<String> keys = new HashSet<String>();
        int count = this.tableNormal.getRowCount();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                String key = (String)this.tableNormal.data.getValueAt(i, 1);
                if (!StringUtils.isValidString(key)) {
                    this.jTabMain.setSelectedIndex(0);
                    GM.messageDialog(this.parent, this.mm.getMessage("paneledittable.emptyname", String.valueOf(i + 1)));
                    return false;
                }
                if (keys.contains(key)) {
                    this.jTabMain.setSelectedIndex(0);
                    GM.messageDialog(this.parent, this.mm.getMessage("paneledittable.existname", String.valueOf(i + 1)));
                    return false;
                }
                keys.add(key);
                ++i;
            }
        } else {
            int option = GM.optionDialog(this.parent, this.mm.getMessage("paneledittable.norow"), this.mm.getMessage("public.prompt"), 2);
            switch (option) {
                case 0: {
                    this.jTabMain.setSelectedIndex(0);
                    this.addRow();
                    break;
                }
                case 2: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private String[] getPrimary() {
        Section pks = new Section();
        int i = 0;
        while (i < this.tableNormal.getRowCount()) {
            Object pk = this.tableNormal.data.getValueAt(i, 2);
            if (pk != null && ((Boolean)pk).booleanValue()) {
                pks.addSection((String)this.tableNormal.data.getValueAt(i, 1));
            }
            ++i;
        }
        return pks.toStringArray();
    }

    public void rowUp() {
        JTableEx editingTable = this.getEditingTable();
        if (editingTable == null) {
            return;
        }
        editingTable.acceptText();
        int row = editingTable.getSelectedRow();
        if (row < 1) {
            return;
        }
        editingTable.shiftRowUp(row);
    }

    public void rowDown() {
        JTableEx editingTable = this.getEditingTable();
        if (editingTable == null) {
            return;
        }
        int row = editingTable.getSelectedRow();
        if (row < 0 || row == editingTable.getRowCount() - 1) {
            return;
        }
        editingTable.shiftRowDown(row);
    }

    public void addRow() {
        JTableEx editingTable = this.getEditingTable();
        if (editingTable == null) {
            return;
        }
        editingTable.acceptText();
        if (editingTable.equals(this.tableData)) {
            if (this.table == null) {
                return;
            }
            int count = this.tableData.getSelectedRowCount();
            if (count == 0) {
                count = 1;
            }
            int i = 0;
            while (i < count) {
                this.tableData.addRow();
                this.table.newLast();
                ++i;
            }
            int rowCount = this.tableData.getRowCount();
            this.tableData.setRowSelectionInterval(rowCount - count, rowCount - 1);
        } else {
            String name = null;
            switch (this.jTabMain.getSelectedIndex()) {
                case 0: {
                    name = GM.getTableUniqueName(this.tableNormal, 1, "col");
                }
            }
            int r = editingTable.addRow();
            editingTable.data.setValueAt(name, r, 1);
            if (this.jTabMain.getSelectedIndex() == 0) {
                this.tableNormal.data.setValueAt(Boolean.FALSE, r, 2);
                this.alterTable(name, null);
                this.tableStructChanged();
            }
        }
    }

    public void insertRow() {
        JTableEx editingTable = this.getEditingTable();
        if (editingTable == null) {
            return;
        }
        editingTable.acceptText();
        int selectedRow = editingTable.getSelectedRow();
        if (selectedRow < 0) {
            selectedRow = 0;
        }
        if (editingTable.equals(this.tableData)) {
            if (this.table == null) {
                return;
            }
            this.tableData.insertRow(selectedRow, new Object[this.tableData.getColumnCount()]);
            this.table.insert(selectedRow + 1);
        } else {
            String name = null;
            switch (this.jTabMain.getSelectedIndex()) {
                case 0: {
                    name = GM.getTableUniqueName(this.tableNormal, 1, "col");
                }
            }
            editingTable.insertRow(selectedRow, new Object[editingTable.getColumnCount()]);
            editingTable.data.setValueAt(name, selectedRow, 1);
            if (this.jTabMain.getSelectedIndex() == 0) {
                this.tableNormal.data.setValueAt(Boolean.FALSE, selectedRow, 2);
                this.alterTable(name, null, selectedRow);
                this.tableStructChanged();
            }
        }
    }

    public void deleteRows() {
        JTableEx editingTable = this.getEditingTable();
        if (editingTable == null) {
            return;
        }
        if (editingTable.getSelectedRowCount() == 0) {
            return;
        }
        if (editingTable.equals(this.tableNormal)) {
            if (this.tableNormal.getRowCount() == 1) {
                GM.messageDialog(this.parent, this.mm.getMessage("paneledittable.atleastonerow"));
                return;
            }
            int row = this.tableNormal.getSelectedRow();
            String oldName = null;
            if (this.tableNormal.data.getValueAt(row, 1) != null) {
                oldName = (String)this.tableNormal.data.getValueAt(row, 1);
            }
            this.alterTable(null, oldName);
            editingTable.deleteSelectedRow();
            this.tableStructChanged();
        } else {
            editingTable.deleteSelectedRow();
            this.tableStructChanged();
            if (editingTable.equals(this.tableData)) {
                int[] rows = this.tableData.getSelectedRows();
                int i = rows.length - 1;
                while (i >= 0) {
                    this.table.delete(rows[i] + 1);
                    --i;
                }
            }
        }
    }

    private void initTable(JTableEx table) {
        table.setSelectionMode(0);
        table.setRowHeight(20);
        table.getTableHeader().setReorderingAllowed(false);
        table.setIndexCol(0);
        table.setClickCountToStart(1);
    }

    private void tableStructChanged() {
        if (this.preventChange) {
            return;
        }
        this.resetTableData();
    }

    private void resetTableData() {
        this.tableData.data.setRowCount(0);
        int colCount = this.tableData.getColumnCount();
        int i = colCount - 1;
        while (i >= 0) {
            this.tableData.deleteColumn(this.tableData.getColumn(i));
            --i;
        }
        if (this.table == null) {
            return;
        }
        DataStruct ds = this.table.dataStruct();
        if (ds == null) {
            return;
        }
        String[] colNames = ds.getFieldNames();
        if (colNames != null) {
            this.tableData.addColumn(this.STR_INDEX);
            int i2 = 0;
            while (i2 < colNames.length) {
                this.tableData.addColumn(colNames[i2]);
                ++i2;
            }
        }
        if (this.tableData.getColumnCount() > 0) {
            this.tableData.setIndexCol(0);
        }
        this.resetTableDataStyle();
        int rowCount = this.table.length();
        if (rowCount == 0) {
            return;
        }
        int i3 = 1;
        while (i3 <= rowCount) {
            BaseRecord record = this.table.getRecord(i3);
            int r = this.tableData.addRow();
            int j = 0;
            while (j < colNames.length) {
                block14: {
                    Object val = null;
                    try {
                        val = record.getFieldValue(colNames[j]);
                    }
                    catch (Exception e) {
                        break block14;
                    }
                    if (val != null) {
                        if (val instanceof BaseRecord) {
                            BaseRecord tmp = (BaseRecord)val;
                            val = GM.getRecordDispName(tmp, new Context());
                        } else {
                            val = Variant.toString(val);
                        }
                    }
                    this.tableData.data.setValueAt(val, r, j + 1);
                }
                ++j;
            }
            ++i3;
        }
        this.tableData.repaint();
    }

    private void resetTableDataStyle() {
        if (this.table == null) {
            return;
        }
        DataStruct ds = this.table.dataStruct();
        if (ds == null) {
            return;
        }
        int i = 1;
        while (i <= ds.getFieldCount()) {
            this.tableData.setColumnDefaultEditor(i);
            ++i;
        }
        GM.setEditStyle(this.tableData);
        this.tableData.repaint();
    }

    void this_stateChanged(ChangeEvent e) {
        if (this.preventChange) {
            return;
        }
        this.tableNormal.acceptText();
        if (this.jTabMain.getSelectedIndex() == 1) {
            this.resetTableData();
        }
    }
}

