/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PanelSeries
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private final int COL_INDEX = 0;
    private final int COL_VALUE = 1;
    private JTableEx tableSeq = new JTableEx(this.mm.getMessage("panelseries.tableparam")){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            GM.dialogEditTableText(PanelSeries.this.parent, PanelSeries.this.tableSeq, row, col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!this.isItemDataChanged(row, column, aValue)) {
                return;
            }
            super.setValueAt(aValue, row, column);
            if (PanelSeries.this.preventChange) {
                return;
            }
            try {
                if (StringUtils.isValidString(aValue)) {
                    aValue = PgmNormalCell.parseConstValue((String)aValue);
                }
                PanelSeries.this.seq.set(row + 1, aValue);
            }
            catch (Exception e) {
                GM.showException(PanelSeries.this.parent, e);
                return;
            }
        }
    };
    private Sequence seq;
    private boolean preventChange = false;
    private Component parent;

    public PanelSeries(Component parent) {
        try {
            this.parent = parent;
            this.rqInit();
            this.initTable();
        }
        catch (Exception ex) {
            GM.showException(parent, ex);
        }
    }

    private void rqInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tableSeq), "Center");
    }

    public void setSequence(Sequence seq) {
        if (seq == null) {
            this.tableSeq.data.setRowCount(0);
            this.seq = new Sequence();
        } else {
            this.seq = seq;
            this.preventChange = true;
            this.refresh();
            this.preventChange = false;
        }
    }

    public Sequence getSequence() {
        return this.seq;
    }

    private void refresh() {
        this.tableSeq.removeAllRows();
        this.tableSeq.data.setRowCount(0);
        int rowCount = this.seq.length();
        if (rowCount < 1) {
            return;
        }
        int i = 1;
        while (i <= rowCount) {
            int r = this.tableSeq.addRow();
            Object value = this.seq.get(i);
            this.tableSeq.data.setValueAt(value, r, 1);
            ++i;
        }
    }

    public void selectAll() {
        this.tableSeq.acceptText();
        this.tableSeq.selectAll();
    }

    public void rowUp() {
        this.tableSeq.acceptText();
        int row = this.tableSeq.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableSeq.shiftRowUp(row);
    }

    public void rowDown() {
        this.tableSeq.acceptText();
        int row = this.tableSeq.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.tableSeq.shiftRowDown(row);
    }

    public void addRow() {
        this.tableSeq.acceptText();
        this.seq.add(null);
        this.refresh();
    }

    public void insertRow() {
        this.tableSeq.acceptText();
        int row = this.tableSeq.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.seq.insert(row + 1, null);
        this.refresh();
        this.tableSeq.setRowSelectionInterval(row, row);
    }

    public boolean checkData() {
        this.tableSeq.acceptText();
        return true;
    }

    public void clipBoard() {
        String blockData = this.tableSeq.getBlockData();
        GM.clipBoard(blockData);
    }

    public void deleteRows() {
        this.tableSeq.acceptText();
        int[] rows = this.tableSeq.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int i = rows.length - 1;
        while (i >= 0) {
            this.seq.delete(rows[i] + 1);
            --i;
        }
        this.refresh();
    }

    private void initTable() {
        this.preventChange = true;
        this.tableSeq.setSelectionMode(0);
        this.tableSeq.setRowHeight(20);
        this.tableSeq.setAutoResizeMode(0);
        this.tableSeq.getTableHeader().setReorderingAllowed(false);
        this.tableSeq.setClickCountToStart(1);
        this.tableSeq.setIndexCol(0);
        this.tableSeq.setColumnWidth(1, 250);
        this.preventChange = false;
    }
}

