/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogArgument_jBAdd_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBCancel_focusAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBDel_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBDown_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_jBUp_actionAdapter;
import com.scudata.ide.common.dialog.DialogArgument_this_windowAdapter;
import com.scudata.ide.common.dialog.DialogMaxmizable;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogArgument
extends DialogMaxmizable {
    private static final long serialVersionUID = 1L;
    protected MessageManager mm = IdeCommonMessage.get();
    protected final byte COL_INDEX = 0;
    protected final byte COL_NAME = 1;
    protected final byte COL_VALUE = (byte)2;
    protected final byte COL_REMARK = (byte)3;
    protected final String TITLE_INDEX = this.mm.getMessage("dialogargument.index");
    protected final String TITLE_NAME = this.mm.getMessage("dialogargument.name");
    protected final String TITLE_VALUE = this.mm.getMessage("dialogargument.value");
    protected final String TITLE_REMARK = this.mm.getMessage("dialogparameter.remark");
    public JTableEx paraTable = new JTableEx(String.valueOf(this.TITLE_INDEX) + "," + this.TITLE_NAME + "," + this.TITLE_VALUE + "," + this.TITLE_REMARK){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (col != 0) {
                GM.dialogEditTableText(DialogArgument.this, DialogArgument.this.paraTable, row, col);
            }
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!this.isItemDataChanged(row, column, aValue)) {
                return;
            }
            this.data.setValueAt(aValue, row, column);
        }
    };
    protected JButton jBOK = new JButton();
    protected JButton jBCancel = new JButton();
    protected JButton jBAdd = new JButton();
    protected JButton jBDel = new JButton();
    protected JButton jBUp = new JButton();
    protected JButton jBDown = new JButton();
    protected JButton buttonAll = new JButton(this.mm.getMessage("button.selectall"));
    protected JButton buttonCopy = new JButton(this.mm.getMessage("dialogparameter.copy"));
    protected JButton buttonPaste = new JButton(this.mm.getMessage("button.paste"));
    protected JCheckBox jcbUserChange = new JCheckBox(this.mm.getMessage("dialogparameter.setbeforerun"));
    protected JPanel jPButton = new JPanel(new VFlowLayout());
    private JCheckBox jCBDynamicParam = new JCheckBox(this.mm.getMessage("dialogargument.dynamicparam"));
    protected int m_option = -1;
    protected PgmCellSet cellSet;
    protected ParamList pl;
    private ParamList paramList = null;

    public DialogArgument() {
        super(GV.appFrame, "\u53c2\u6570\u7f16\u8f91", true);
        try {
            this.initUI();
            this.init();
            this.resetLangText();
            this.setSize(450, 370);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.setResizable(true);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private void init() {
        this.paraTable.setIndexCol(0);
        this.paraTable.setSelectionMode(0);
        this.paraTable.setRowHeight(20);
        this.paraTable.setColumnWidth(1, 100);
        this.paraTable.setClickCountToStart(1);
    }

    public int getOption() {
        return this.m_option;
    }

    public void setParameter(PgmCellSet cellSet) {
        this.cellSet = cellSet;
        ParamList pl = cellSet.getParamList();
        this.jCBDynamicParam.setSelected(cellSet.isDynamicParam());
        if (pl == null) {
            return;
        }
        this.pl = pl;
        this.jcbUserChange.setSelected(pl.isUserChangeable());
        ParamList argList = new ParamList();
        pl.getAllVarParams(argList);
        if (argList.count() == 0) {
            pl.getAllArguments(argList);
        }
        int i = 0;
        while (i < argList.count()) {
            Param p = argList.get(i);
            if (p != null) {
                int row = this.paraTable.addRow();
                Object value = p.getValue();
                if (value != null && p.getEditValue() == null) {
                    p.setEditValue(AppUtil.getEditValueByValue(value));
                }
                this.paraTable.data.setValueAt(p.getName(), row, 1);
                this.paraTable.data.setValueAt(p.getEditValue(), row, 2);
                this.paraTable.data.setValueAt(p.getRemark(), row, 3);
            }
            ++i;
        }
        this.paraTable.resetIndex();
    }

    public ParamList getParameter() {
        return this.paramList;
    }

    private boolean saveParamList() {
        if (this.cellSet != null) {
            this.cellSet.setDynamicParam(this.jCBDynamicParam.isSelected());
        }
        if (this.paraTable.getRowCount() < 1) {
            return true;
        }
        this.paramList = new ParamList();
        ParamList otherList = new ParamList();
        if (this.pl != null) {
            this.pl.getAllConsts(otherList);
        }
        this.paramList.setUserChangeable(this.jcbUserChange.isSelected());
        int i = 0;
        while (i < this.paraTable.getRowCount()) {
            String name = (String)this.paraTable.getValueAt(i, 1);
            if (StringUtils.isValidString(name)) {
                Object o;
                Param v = new Param();
                v.setKind((byte)0);
                v.setName(name);
                Object editValue = o = this.paraTable.data.getValueAt(i, 2);
                if (o != null) {
                    if (o instanceof String) {
                        if (!StringUtils.isValidString(o)) {
                            editValue = null;
                        }
                    } else {
                        editValue = Variant.toString(o);
                    }
                }
                v.setEditValue(editValue);
                if (editValue == null) {
                    v.setValue(null);
                } else {
                    try {
                        v.setValue(PgmNormalCell.parseConstValue((String)editValue));
                    }
                    catch (Exception ex) {
                        this.paraTable.selectRow(i);
                        GM.showException(this, ex, true, GM.getLogoImage(this, true), IdeSplMessage.get().getMessage("dialoginputargument.parseerrorpre", name));
                        return false;
                    }
                }
                o = this.paraTable.data.getValueAt(i, 3);
                if (!StringUtils.isValidString(o)) {
                    v.setRemark(null);
                } else {
                    v.setRemark((String)o);
                }
                this.paramList.add(v);
            }
            ++i;
        }
        int count = otherList.count();
        int i2 = 0;
        while (i2 < count) {
            this.paramList.add(otherList.get(i2));
            ++i2;
        }
        return true;
    }

    private void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogparameter.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBAdd.setText(this.mm.getMessage("button.add"));
        this.jBDel.setText(this.mm.getMessage("button.delete"));
        this.jBUp.setText(this.mm.getMessage("button.shiftup"));
        this.jBDown.setText(this.mm.getMessage("button.shiftdown"));
    }

    private void initUI() throws Exception {
        this.addWindowListener(new DialogArgument_this_windowAdapter(this));
        this.getContentPane().setLayout(new BorderLayout());
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogArgument_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addFocusListener(new DialogArgument_jBCancel_focusAdapter(this));
        this.jBCancel.addActionListener(new DialogArgument_jBCancel_actionAdapter(this));
        this.jBAdd.setAlignmentX(0.0f);
        this.jBAdd.setAlignmentY(5.0f);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(new DialogArgument_jBAdd_actionAdapter(this));
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBDel.addActionListener(new DialogArgument_jBDel_actionAdapter(this));
        this.jBUp.setActionCommand("");
        this.jBUp.setMnemonic('U');
        this.jBUp.setText("\u4e0a\u79fb(U)");
        this.jBUp.addActionListener(new DialogArgument_jBUp_actionAdapter(this));
        this.jBDown.setToolTipText("");
        this.jBDown.setMnemonic('W');
        this.jBDown.setText("\u4e0b\u79fb(W)");
        this.jBDown.addActionListener(new DialogArgument_jBDown_actionAdapter(this));
        this.buttonAll.setMnemonic('A');
        this.buttonCopy.setMnemonic('X');
        this.buttonPaste.setMnemonic('P');
        this.buttonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogArgument.this.paraTable.selectAll();
            }
        });
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = DialogArgument.this.paraTable.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    GM.messageDialog(DialogArgument.this, DialogArgument.this.mm.getMessage("dialogparameter.selectrow"));
                    return;
                }
                DialogArgument.this.paraTable.acceptText();
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < rows.length) {
                    String rowStr;
                    if (i != 0) {
                        buf.append('\n');
                    }
                    buf.append((rowStr = DialogArgument.this.paraTable.getRowData(rows[i])) == null ? "" : rowStr);
                    ++i;
                }
                GM.clipBoard(buf.toString());
            }
        });
        this.buttonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = GM.clipBoard(false);
                if (!StringUtils.isValidString(str)) {
                    GM.messageDialog(DialogArgument.this, DialogArgument.this.mm.getMessage("dialogparameter.copyrow"));
                    return;
                }
                try {
                    DialogArgument.this.paraTable.acceptText();
                    Matrix m = GM.getClipboardMatrix();
                    if (m.getColSize() != DialogArgument.this.paraTable.getColumnCount()) {
                        GM.messageDialog(DialogArgument.this, DialogArgument.this.mm.getMessage("dialogparameter.copyrow"));
                        return;
                    }
                    int count = m.getRowSize();
                    int i = 0;
                    while (i < count) {
                        DialogArgument.this.paraTable.addRow(m.getRow(i));
                        ++i;
                    }
                }
                catch (Exception ex) {
                    GM.showException(DialogArgument.this, ex);
                }
            }
        });
        this.jPButton.add((Component)this.jBOK, null);
        this.jPButton.add((Component)this.jBCancel, null);
        this.jPButton.add((Component)new JLabel(" "), null);
        this.jPButton.add((Component)this.jBAdd, null);
        this.jPButton.add((Component)this.jBDel, null);
        this.jPButton.add((Component)this.jBUp, null);
        this.jPButton.add((Component)this.jBDown, null);
        this.jPButton.add((Component)new JLabel(), null);
        this.jPButton.add((Component)this.buttonAll, null);
        this.jPButton.add((Component)this.buttonCopy, null);
        this.jPButton.add((Component)this.buttonPaste, null);
        JPanel panelMain = new JPanel();
        panelMain.setLayout(new GridBagLayout());
        panelMain.add((Component)this.jcbUserChange, GM.getGBC(1, 1, true));
        panelMain.add((Component)new JScrollPane(this.paraTable), GM.getGBC(2, 1, true, true));
        panelMain.add((Component)this.jCBDynamicParam, GM.getGBC(3, 1, true));
        this.getContentPane().add((Component)panelMain, "Center");
        this.getContentPane().add((Component)this.jPButton, "East");
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.paraTable.deleteSelectedRows();
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        String name = GM.getTableUniqueName(this.paraTable, 1, "arg");
        int r = this.paraTable.addRow();
        this.paraTable.clearSelection();
        this.paraTable.selectRow(r);
        this.paraTable.data.setValueAt(name, r, 1);
    }

    void jBOK_actionPerformed(ActionEvent e) {
        if (!this.paraTable.verifyColumnData(1, this.TITLE_NAME, true, this)) {
            return;
        }
        if (!this.saveParamList()) {
            this.paramList = null;
            return;
        }
        GM.setWindowDimension(this);
        this.m_option = 0;
        this.dispose();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBUp_actionPerformed(ActionEvent e) {
        this.paraTable.shiftRowUp(-1);
    }

    void jBDown_actionPerformed(ActionEvent e) {
        this.paraTable.shiftRowDown(-1);
    }

    void this_windowClosing(WindowEvent e) {
        this.jBCancel_actionPerformed(null);
    }

    void jBCancel_focusGained(FocusEvent e) {
        this.jBCancel.requestFocus();
    }
}

