/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.Logger;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.ICheckHandler;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogSerialNo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogCheckUpdate
extends RQDialog {
    private static final long serialVersionUID = 1L;
    public static int SET_OPTION = 999;
    private ICheckHandler handler;
    private JButton jBSN = new JButton(IdeCommonMessage.get().getMessage("button.sn"));
    private JLabel label2 = new JLabel();
    private JLabel label3 = new JLabel();

    public DialogCheckUpdate(Frame parent, boolean forceUpdate, String productName, Image logoImage) {
        super(parent, IdeCommonMessage.get().getMessage("updatemanager.downloadprompt"), GM.isChineseLanguage() ? 350 : 500, forceUpdate ? 190 : 140);
        this.init(forceUpdate, productName, logoImage, false);
    }

    public DialogCheckUpdate(Dialog parent, boolean forceUpdate, String productName, Image logoImage) {
        super(parent, IdeCommonMessage.get().getMessage("updatemanager.downloadprompt"), GM.isChineseLanguage() ? 350 : 500, forceUpdate ? 190 : 140);
        this.init(forceUpdate, productName, logoImage, true);
    }

    public void setCheckHandler(ICheckHandler handler) {
        this.handler = handler;
    }

    @Override
    protected void dialogOpened() {
        this.jBOK.requestFocusInWindow();
    }

    @Override
    protected void closeDialog(int option) {
        super.closeDialog(option);
        GM.setWindowDimension(this);
    }

    private void init(boolean forceUpdate, String productName, final Image logoImage, final boolean isEdit) {
        try {
            this.label2.setText(IdeCommonMessage.get().getMessage("updatemanager.neednewversion"));
            this.label3.setText(IdeCommonMessage.get().getMessage("updatemanager.neednewversion1", productName));
            JLabel label1 = new JLabel(IdeCommonMessage.get().getMessage("updatemanager.loadnewversion"));
            label1.setFont(new Font("Dialog", 0, 14));
            label1.setHorizontalAlignment(0);
            this.label2.setFont(new Font("Dialog", 0, 14));
            this.label2.setHorizontalAlignment(0);
            this.label3.setFont(new Font("Dialog", 0, 14));
            this.label3.setHorizontalAlignment(0);
            this.panelCenter.setLayout(new GridBagLayout());
            this.panelCenter.add((Component)label1, GM.getGBC(0, 0, true));
            if (forceUpdate) {
                this.panelCenter.add((Component)this.label2, GM.getGBC(1, 0, true));
                this.panelCenter.add((Component)this.label3, GM.getGBC(2, 0, true));
            }
            this.jBOK.setText(IdeCommonMessage.get().getMessage("button.yes"));
            this.jBOK.setMnemonic('Y');
            this.jBCancel.setText(IdeCommonMessage.get().getMessage("button.no"));
            this.jBCancel.setMnemonic('N');
            this.panelSouth.removeAll();
            this.panelSouth.setLayout(new GridBagLayout());
            this.panelSouth.add((Component)new JPanel(), GM.getGBC(0, 2, true));
            if (forceUpdate) {
                this.panelSouth.add((Component)this.jBSN, GM.getGBC(0, 3, false, false, 3));
            }
            this.panelSouth.add((Component)this.jBOK, GM.getGBC(0, 4, false, false, 3, 10));
            this.panelSouth.add((Component)this.jBCancel, GM.getGBC(0, 5, false, false, 3));
            this.panelSouth.add((Component)new JPanel(), GM.getGBC(0, 6, false, false, 3));
            this.jBSN.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSerialNo dsn = new DialogSerialNo(DialogCheckUpdate.this, GV.config.getEsprocSerialNo(), "", logoImage, isEdit){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void updateSerialNo(String serialNo) throws Exception {
                            DialogCheckUpdate.this.updateSN(serialNo);
                        }

                        @Override
                        public String getDownloadUrl() {
                            return DialogCheckUpdate.this.getUrl();
                        }
                    };
                    dsn.setVisible(true);
                    if (dsn.getOption() == 0) {
                        DialogCheckUpdate.this.writeSN();
                        boolean forceUpdate = DialogCheckUpdate.this.forceUpdate();
                        if (!forceUpdate) {
                            DialogCheckUpdate.this.closeDialog(SET_OPTION);
                        } else {
                            DialogCheckUpdate.this.label2.setVisible(true);
                            DialogCheckUpdate.this.label3.setVisible(true);
                        }
                        DialogCheckUpdate.this.repaint();
                    }
                }
            });
            GM.centerWindow(this);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    protected boolean forceUpdate() {
        return SplEditorSE.forceUpdate();
    }

    protected void updateSN(String serialNo) throws Exception {
        GMSplSE.updateSerialNo(serialNo);
        IDEBase.checkExpirationSystem();
        SplEditorSE.checkNoIDE();
        if (this.handler != null) {
            this.handler.check();
        }
        try {
            ConfigUtilIde.writeActiveConfig(false);
        }
        catch (Exception e1) {
            Logger.error(e1);
        }
    }

    protected String getUrl() {
        return GMSplSE.getDownloadUrl();
    }

    protected void writeSN() {
        try {
            ConfigUtilIde.writeActiveConfig(false);
        }
        catch (Exception e1) {
            Logger.error(e1);
        }
    }
}

