/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.DBConfig;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.DBTypeEx;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.common.dialog.DialogDataSource;
import com.scudata.ide.common.dialog.DialogDataSourcePara_WindowAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jBAdd_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jBDel_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jDBTitle_itemAdapter;
import com.scudata.ide.common.dialog.DialogDataSourcePara_jTabbedPaneAttr_changeAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.CheckBoxRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;

public class DialogDataSourcePara
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private final byte COL_INDEX = 0;
    private final byte COL_NAME = 1;
    private final byte COL_VALUE = (byte)2;
    private final byte COL_ISNEED = (byte)3;
    private JTableEx tableExtend = new JTableEx(this.mm.getMessage("dialogdatasourcepara.colnames"));
    private JTextField jTextName = new JTextField();
    private JLabel jLabel7 = new JLabel("\u9a71\u52a8\u7a0b\u5e8f");
    private JLabel jLabel1 = new JLabel("\u6570\u636e\u6e90\u540d\u79f0");
    private JLabel jLabel3 = new JLabel("\u6570\u636e\u6e90URL\uff1a\u6ce8\u610f\u66ff\u6362\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9");
    private JLabel jLabel4 = new JLabel("\u7528\u6237");
    private JLabel jLabel5 = new JLabel("\u53e3\u4ee4");
    private JButton jBOK = new JButton("\u786e\u5b9a");
    private JButton jBCancel = new JButton("\u53d6\u6d88");
    private JButton jBDel = new JButton();
    private JButton jBAdd = new JButton();
    private JComboBox<String> jComboBoxDriver = new JComboBox();
    private JComboBox<String> jDBTitles = new JComboBox();
    private JComboBox<String> jComboBoxURL = new JComboBox();
    private JTextField jTextUser = new JTextField();
    private JPasswordField jPassword = new JPasswordField();
    private int m_option = 2;
    private JTabbedPane jTabbedPaneAttr = new JTabbedPane();
    private JCheckBox jCBUseSchema = new JCheckBox();
    private JLabel jLabel6 = new JLabel();
    private JCheckBox jCBIsAddTilde = new JCheckBox();
    private String extend;
    private String oldName = "";
    private JSpinner jSBatchSize = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    private Vector<String> existNames;
    private static final int TAB_EXTEND = 1;

    public DialogDataSourcePara(JDialog parent) {
        super(parent, "\u6570\u636e\u6e90", true);
        String[] dbTitles = DBTypeEx.listDBTitles(this.getXMLFile());
        int i = 0;
        while (i < dbTitles.length) {
            this.jDBTitles.addItem(dbTitles[i]);
            ++i;
        }
        this.jDBTitle_itemStateChanged(null);
        this.initUI();
        this.init();
        this.resetLangText();
        int height = 420;
        if (!this.showBottomOptions()) {
            height -= 60;
        }
        if (GM.isChineseLanguage()) {
            this.setSize(600, height);
        } else {
            this.setSize(650, height);
        }
        GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
    }

    protected boolean showBottomOptions() {
        return true;
    }

    protected XMLFile getXMLFile() {
        ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
        if (sysConfig == null) {
            return null;
        }
        return sysConfig.xmlFile();
    }

    private void init() {
        TableColumn tc = this.tableExtend.getColumn(3);
        JCheckBox checkBoxEditor = new JCheckBox();
        checkBoxEditor.setEnabled(false);
        checkBoxEditor.setBackground(Color.lightGray);
        checkBoxEditor.setHorizontalAlignment(0);
        DefaultCellEditor cellEditor = new DefaultCellEditor(checkBoxEditor);
        CheckBoxRenderer cellRenderer = new CheckBoxRenderer();
        tc.setCellEditor(cellEditor);
        tc.setCellRenderer(cellRenderer);
        this.tableExtend.setIndexCol(0);
    }

    private void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogdatasourcepara.title"));
        this.jLabel7.setText(this.mm.getMessage("dialogdatasourcepara.engine"));
        this.jLabel1.setText(this.mm.getMessage("dialogdatasourcepara.datasrcname"));
        this.jLabel3.setText(this.mm.getMessage("dialogdatasourcepara.datasrcurl"));
        this.jLabel4.setText(this.mm.getMessage("dialogdatasourcepara.user"));
        this.jLabel5.setText(this.mm.getMessage("dialogdatasourcepara.pw"));
        this.jBOK.setActionCommand(this.mm.getMessage("public.ok"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBDel.setText(this.mm.getMessage("button.delete"));
        this.jBAdd.setText(this.mm.getMessage("button.add"));
        this.jCBUseSchema.setText(this.mm.getMessage("dialogdatasourcepara.useschema"));
        this.jLabel6.setText(this.mm.getMessage("dialogdatasourcepara.datasettype"));
        this.jTabbedPaneAttr.setTitleAt(0, this.mm.getMessage("dialogdatasourcepara.general"));
        this.jTabbedPaneAttr.setTitleAt(1, this.mm.getMessage("dialogdatasourcepara.extend"));
        this.jCBIsAddTilde.setText(this.mm.getMessage("dialogdatasourcepara.isaddtilde"));
    }

    private void initUI() {
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.jBOK.setDebugGraphicsOptions(0);
        this.jBOK.setActionCommand("\u786e\u5b9a");
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogDataSourcePara_jBOK_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogDataSourcePara_jBCancel_actionAdapter(this));
        this.jDBTitles.addItemListener(new DialogDataSourcePara_jDBTitle_itemAdapter(this));
        this.jComboBoxURL.setPreferredSize(new Dimension(387, 25));
        this.jComboBoxURL.setEditable(true);
        this.jComboBoxDriver.setPreferredSize(new Dimension(387, 25));
        this.jComboBoxDriver.setEditable(true);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanelCB = new JPanel();
        JPanel jPanelCB2 = new JPanel();
        jPanelCB.setLayout(new FlowLayout(0));
        jPanelCB2.setLayout(new GridLayout(1, 2));
        JPanel jPanelOKCancel = new JPanel(new VFlowLayout());
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportBorder(null);
        jScrollPane1.setAlignmentX(5.0f);
        jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane1.setPreferredSize(new Dimension(40, 40));
        jScrollPane1.setVerifyInputWhenFocusTarget(true);
        JPanel jPanelExtend = new JPanel(new BorderLayout());
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jBDel.addActionListener(new DialogDataSourcePara_jBDel_actionAdapter(this));
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBAdd.addActionListener(new DialogDataSourcePara_jBAdd_actionAdapter(this));
        JPanel jPanel4 = new JPanel(new VFlowLayout());
        this.jTabbedPaneAttr.addChangeListener(new DialogDataSourcePara_jTabbedPaneAttr_changeAdapter(this));
        this.jCBUseSchema.setText("\u4f7f\u7528\u5e26\u6a21\u5f0f\u7684\u8868\u540d\u79f0");
        this.jLabel6.setText("\u6570\u636e\u5e93\u7c7b\u578b");
        JPanel jPanel1 = new JPanel();
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.setColumns(2);
        gridLayout3.setHgap(5);
        gridLayout3.setRows(2);
        jPanel1.setLayout(gridLayout3);
        this.jCBIsAddTilde.setText("\u4f7f\u7528\u5e26\u5f15\u53f7\u7684SQL");
        JPanel jPanelGeneral = new JPanel();
        jPanelGeneral.add((Component)jPanel1, null);
        jPanel1.add((Component)this.jLabel1, null);
        jPanel1.add((Component)this.jLabel6, null);
        jPanel1.add((Component)this.jTextName, null);
        jPanel1.add(this.jDBTitles, null);
        jPanelGeneral.add(this.jLabel7);
        jPanelGeneral.add(this.jComboBoxDriver);
        jPanelGeneral.add((Component)this.jLabel3, null);
        jPanelGeneral.add(this.jComboBoxURL, null);
        jPanelGeneral.add((Component)jPanel3, null);
        jPanelGeneral.add((Component)jPanelCB, null);
        JPanel panelBatchSize = new JPanel(new BorderLayout());
        panelBatchSize.add((Component)new JLabel(this.mm.getMessage("dialogdatasourcepara.batchsize")), "West");
        panelBatchSize.add((Component)this.jSBatchSize, "Center");
        jPanelCB2.add((Component)this.jCBUseSchema, null);
        jPanelCB2.add((Component)this.jCBIsAddTilde, null);
        if (this.showBottomOptions()) {
            jPanelGeneral.add((Component)panelBatchSize, null);
            jPanelGeneral.add((Component)jPanelCB2, null);
        }
        jPanel3.add((Component)this.jLabel4, GM.getGBC(1, 1, true, false, 0));
        jPanel3.add((Component)this.jLabel5, GM.getGBC(1, 2, true, false, 0));
        jPanel3.add((Component)this.jTextUser, GM.getGBC(2, 1, true, false, 0));
        jPanel3.add((Component)this.jPassword, GM.getGBC(2, 2, true, false, 0));
        this.getContentPane().add((Component)jPanelOKCancel, "East");
        jPanelGeneral.setLayout(new VFlowLayout());
        jPanelOKCancel.add((Component)this.jBOK, null);
        jPanelOKCancel.add((Component)this.jBCancel, null);
        this.getContentPane().add((Component)this.jTabbedPaneAttr, "Center");
        this.jTabbedPaneAttr.add((Component)jPanelGeneral, "  \u5e38\u89c4\u5c5e\u6027  ");
        this.jTabbedPaneAttr.add((Component)jPanelExtend, "  \u6269\u5c55\u5c5e\u6027  ");
        jPanelExtend.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.tableExtend, null);
        jPanelExtend.add((Component)jPanel4, "East");
        jPanel4.add((Component)this.jBAdd, null);
        jPanel4.add((Component)this.jBDel, null);
        if (GM.isChineseLanguage()) {
            this.tableExtend.getColumn(3).setMaxWidth(70);
        }
        this.tableExtend.getColumn(1).setPreferredWidth(70);
        this.setResizable(true);
        this.addWindowListener(new DialogDataSourcePara_WindowAdapter(this));
    }

    public void set(DBConfig ds) {
        if (!DialogDataSource.isLocalDataSource(this, new DataSource(ds), false)) {
            this.jBOK.setEnabled(false);
        }
        this.oldName = ds.getName();
        this.jTextName.setText(ds.getName());
        String dbVender = DBTypeEx.getDBTypeName(ds.getDBType(), this.getXMLFile());
        this.jDBTitles.setSelectedItem(dbVender);
        this.jDBTitle_itemStateChanged(null);
        this.jComboBoxDriver.setSelectedItem(ds.getDriver());
        this.jComboBoxURL.setSelectedItem(ds.getUrl());
        this.jTextUser.setText(ds.getUser());
        String pwd = ds.getPassword();
        try {
            this.jPassword.setText(pwd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jCBUseSchema.setSelected(ds.isUseSchema());
        this.jCBIsAddTilde.setSelected(ds.isAddTilde());
        this.extend = ds.getExtend();
        this.tableExtend.setIndexCol(0);
        this.jSBatchSize.setValue(new Integer(ds.getBatchSize()));
    }

    public void setExistNames(Vector<String> existNames) {
        this.existNames = existNames;
    }

    public boolean isNameChanged() {
        return !this.jTextName.getText().equalsIgnoreCase(this.oldName);
    }

    public DataSource get() {
        DBConfig config = new DBConfig();
        config.setName(this.jTextName.getText());
        config.setDriver(((String)this.jComboBoxDriver.getSelectedItem()).trim());
        config.setUrl(((String)this.jComboBoxURL.getSelectedItem()).trim());
        config.setUser(this.jTextUser.getText());
        String pwd = new String(this.jPassword.getPassword());
        config.setPassword(pwd);
        config.setUseSchema(this.jCBUseSchema.isSelected());
        config.setAddTilde(this.jCBIsAddTilde.isSelected());
        config.setBatchSize(((Number)this.jSBatchSize.getValue()).intValue());
        this.tableExtend.acceptText();
        StringBuffer sb = new StringBuffer();
        Properties porps = new Properties();
        int i = 0;
        while (i < this.tableExtend.getRowCount()) {
            Object val;
            Object key = this.tableExtend.data.getValueAt(i, 1);
            if (StringUtils.isValidString(key) && StringUtils.isValidString(val = this.tableExtend.data.getValueAt(i, 2))) {
                porps.put((String)key, (String)val);
                sb.append(";" + key + "=" + val);
            }
            ++i;
        }
        config.setInfo(porps);
        if (sb.length() > 1) {
            config.setExtend(sb.substring(1));
        } else {
            config.setExtend("");
        }
        String dbTitle = (String)this.jDBTitles.getSelectedItem();
        DataSource ds = new DataSource(config);
        config.setDBType(DBTypeEx.getDBType(dbTitle, this.getXMLFile()));
        return ds;
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jDBTitle_itemStateChanged(ItemEvent e) {
        String dbTitle = (String)this.jDBTitles.getSelectedItem();
        String[] tmpListVal = DBTypeEx.getDBSampleDriver(dbTitle, this.getXMLFile());
        Object tmpVal = this.jComboBoxDriver.getSelectedItem();
        this.jComboBoxDriver.removeAllItems();
        int k = 0;
        while (k < tmpListVal.length) {
            this.jComboBoxDriver.addItem(tmpListVal[k]);
            ++k;
        }
        this.jComboBoxDriver.setSelectedItem(tmpVal);
        tmpListVal = DBTypeEx.getDBSampleURL(dbTitle, this.getXMLFile());
        tmpVal = this.jComboBoxURL.getSelectedItem();
        this.jComboBoxURL.removeAllItems();
        k = 0;
        while (k < tmpListVal.length) {
            this.jComboBoxURL.addItem(tmpListVal[k]);
            ++k;
        }
        this.jComboBoxURL.setSelectedItem(tmpVal);
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (!StringUtils.isValidString(this.jTextName.getText())) {
                throw new Exception(this.mm.getMessage("dialogdatasourcepara.emptydsname"));
            }
            if (!StringUtils.isValidString(this.jComboBoxURL.getSelectedItem())) {
                throw new Exception(this.mm.getMessage("dialogdatasourcepara.emptyurl"));
            }
            if (!StringUtils.isValidString(this.jComboBoxDriver.getSelectedItem())) {
                throw new Exception(this.mm.getMessage("dialogdatasourcepara.emptyengine"));
            }
            if (this.existNames != null) {
                if (this.existNames.contains(this.jTextName.getText())) {
                    GM.messageDialog(this, String.valueOf(this.mm.getMessage("dialogdatasource.existdsname")) + this.jTextName.getText(), this.mm.getMessage("public.note"), 0);
                    return;
                }
            } else if (this.isNameChanged() && GM.isExistDataSource(this, this.get())) {
                return;
            }
            this.m_option = 0;
            GM.setWindowDimension(this);
            this.dispose();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    public int getOption() {
        return this.m_option;
    }

    void jTabbedPaneAttr_stateChanged(ChangeEvent e) {
        try {
            int newIndex = this.jTabbedPaneAttr.getSelectedIndex();
            if (newIndex != 1) {
                return;
            }
            this.tableExtend.removeAllRows();
            this.tableExtend.clearSelection();
            this.tableExtend.acceptText();
            if (!StringUtils.isValidString(this.jComboBoxDriver.getSelectedItem())) {
                return;
            }
            String driver = (String)this.jComboBoxDriver.getSelectedItem();
            if (!StringUtils.isValidString(this.jComboBoxURL.getSelectedItem())) {
                return;
            }
            String url = (String)this.jComboBoxURL.getSelectedItem();
            Driver d = (Driver)Class.forName(driver).newInstance();
            DriverPropertyInfo[] dpi = d.getPropertyInfo(url, new Properties());
            Arrays.sort(dpi, new Comparator<DriverPropertyInfo>(){

                @Override
                public int compare(DriverPropertyInfo o1, DriverPropertyInfo o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return Variant.compare(o1.name, o2.name, false);
                }
            });
            int i = 0;
            while (i < dpi.length) {
                if (!dpi[i].name.equalsIgnoreCase("user") && !dpi[i].name.equalsIgnoreCase("password")) {
                    int row = this.tableExtend.addRow(false);
                    this.tableExtend.data.setValueAt(dpi[i].name, row, 1);
                    this.tableExtend.data.setValueAt(new Boolean(dpi[i].required), row, 3);
                }
                ++i;
            }
            this.tableExtend.resetIndex();
            String tmpSeg = this.extend;
            if (!StringUtils.isValidString(tmpSeg)) {
                tmpSeg = "";
            }
            StringTokenizer st = new StringTokenizer(tmpSeg, ";");
            while (st.hasMoreTokens()) {
                tmpSeg = st.nextToken();
                int index = tmpSeg.indexOf("=");
                String key = tmpSeg.substring(0, index);
                String val = tmpSeg.substring(index + 1);
                int r = this.tableExtend.searchName(key, 1, false);
                if (r == -1) {
                    r = this.tableExtend.addRow();
                    this.tableExtend.data.setValueAt(key, r, 1);
                    this.tableExtend.data.setValueAt(val, r, 2);
                    continue;
                }
                this.tableExtend.data.setValueAt(val, r, 2);
            }
        }
        catch (Exception t) {
            GM.showException(this, t);
        }
    }

    void tableExtend_focusLost(FocusEvent e) {
        this.tableExtend.acceptText();
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        int r = this.tableExtend.addRow();
        this.tableExtend.data.setValueAt(Boolean.FALSE, r, 3);
    }

    void jBDel_actionPerformed(ActionEvent e) {
        this.tableExtend.acceptText();
        this.tableExtend.deleteSelectedRows();
    }
}

