/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.ByteMap;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogDemoFiles_jBClose_actionAdapter;
import com.scudata.ide.common.dialog.DialogDemoFiles_jBOpen_actionAdapter;
import com.scudata.ide.common.dialog.DialogDemoFiles_m_Tree_mouseAdapter;
import com.scudata.ide.common.dialog.DialogDemoFiles_m_Tree_treeSelectionAdapter;
import com.scudata.ide.common.dialog.DialogDemoFiles_this_windowAdapter;
import com.scudata.ide.common.dialog.FileNode;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.util.CellSetUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DialogDemoFiles
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jBOpen = new JButton();
    private JButton jBClose = new JButton();
    private MessageManager mm = IdeCommonMessage.get();
    private JTree m_Tree = new JTree();
    private JEditorPane tpDesc = new JEditorPane();
    private String[] fileExts;

    public DialogDemoFiles() {
        this("splx,spl,dfx".split(","));
    }

    public DialogDemoFiles(String[] fileExts) {
        super(GV.appFrame, "\u4f8b\u5b50\u6587\u4ef6", true);
        try {
            this.fileExts = fileExts;
            this.initUI();
            this.resetLangText();
            this.setSize(800, 560);
            this.load();
            GM.setDialogDefaultButton(this, this.jBOpen, this.jBClose);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    private static File[] listSubFiles(String filePath, final String[] fileExts) {
        File f = new File(filePath);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String extName = file.getName().toLowerCase();
                if (file.isDirectory()) {
                    return true;
                }
                String[] stringArray = fileExts;
                int n = fileExts.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileExt = stringArray[n2];
                    if (extName.endsWith(fileExt)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        return f.listFiles(ff);
    }

    private boolean loadSubFiles(DefaultMutableTreeNode parent, String filePath) {
        File[] list = DialogDemoFiles.listSubFiles(filePath, this.fileExts);
        if (list == null) {
            return false;
        }
        boolean r = false;
        int i = 0;
        while (i < list.length) {
            String text = list[i].getName();
            if (text.indexOf(".") > 0) {
                text = text.substring(0, text.length() - 4);
            }
            if (list[i].isDirectory()) {
                DefaultMutableTreeNode p = new DefaultMutableTreeNode(text);
                boolean subr = this.loadSubFiles(p, list[i].getAbsolutePath());
                if (subr) {
                    parent.add(p);
                }
                r = r || subr;
            } else {
                String absolutePath = list[i].getAbsolutePath();
                String title = text;
                String desc = "";
                ByteMap bm = CellSetUtil.readCsCustomPropMap(absolutePath);
                if (bm != null) {
                    String val = (String)bm.get((byte)0);
                    if (val != null) {
                        title = val;
                    }
                    if ((val = (String)bm.get((byte)1)) != null) {
                        desc = val;
                    }
                }
                FileNode fileObject = new FileNode(absolutePath, title, desc);
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(fileObject);
                parent.add(fileNode);
                r = true;
            }
            ++i;
        }
        return r;
    }

    public static boolean isExistDemoFiles(String[] fileExts) {
        String filePath = GM.getAbsolutePath("demo/" + GM.getLanguageSuffix().substring(1));
        File[] list = DialogDemoFiles.listSubFiles(filePath, fileExts);
        return list != null && list.length != 0;
    }

    private void load() {
        String filePath = GM.getAbsolutePath("demo/" + GM.getLanguageSuffix().substring(1));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(filePath);
        DefaultTreeModel m_TreeModel = new DefaultTreeModel(root);
        this.m_Tree.setModel(m_TreeModel);
        File[] list = DialogDemoFiles.listSubFiles(filePath, this.fileExts);
        if (list == null || list.length == 0) {
            return;
        }
        this.loadSubFiles(root, filePath);
        TreeNode childNode = root.getFirstChild();
        if (childNode != null) {
            TreePath path = new TreePath(new Object[]{root, childNode});
            this.m_Tree.setSelectionPath(path);
            this.m_Tree_mouseClicked(null);
        }
    }

    private void resetLangText() {
        this.setTitle(new StringTokenizer(this.mm.getMessage("menu.help.demofiles"), "(").nextToken());
        this.jBOpen.setText(this.mm.getMessage("menu.file.open"));
        this.jBClose.setText(this.mm.getMessage("button.close"));
    }

    private void initUI() throws Exception {
        this.jBOpen.setMnemonic('O');
        this.jBOpen.setText("\u6253\u5f00(O)");
        this.jBOpen.addActionListener(new DialogDemoFiles_jBOpen_actionAdapter(this));
        this.jBClose.setMnemonic('C');
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogDemoFiles_jBClose_actionAdapter(this));
        JPanel jPanel2 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        jPanel2.setLayout(vFlowLayout1);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogDemoFiles_this_windowAdapter(this));
        this.m_Tree.addMouseListener(new DialogDemoFiles_m_Tree_mouseAdapter(this));
        this.m_Tree.addTreeSelectionListener(new DialogDemoFiles_m_Tree_treeSelectionAdapter(this));
        this.getContentPane().add((Component)jPanel2, "East");
        jPanel2.add((Component)this.jBOpen, null);
        jPanel2.add((Component)this.jBClose, null);
        JSplitPane splitPane = new JSplitPane(1);
        this.getContentPane().add((Component)splitPane, "Center");
        splitPane.add((Component)jScrollPane1, "left");
        jScrollPane1.getViewport().add((Component)this.m_Tree, null);
        splitPane.add((Component)jPanel1, "right");
        jPanel1.setLayout(new GridBagLayout());
        this.tpDesc.setEditable(false);
        this.tpDesc.setContentType("text/html");
        JScrollPane spDesc = new JScrollPane(this.tpDesc);
        spDesc.setHorizontalScrollBarPolicy(31);
        jPanel1.add((Component)spDesc, GM.getGBC(1, 1, true, true, 0, 0));
        splitPane.setDividerLocation(300);
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBOpen_actionPerformed(ActionEvent e) {
        Object selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof FileNode) {
            try {
                JInternalFrame sheet = GV.appFrame.openSheetFile(((FileNode)selectedNode).getAbsolutePath());
                if (sheet != null) {
                    GM.setWindowDimension(this);
                    this.dispose();
                }
            }
            catch (Throwable sheet) {}
        } else if (GM.getOperationSytem() == 0) {
            try {
                String directory = (String)selectedNode;
                Runtime.getRuntime().exec("cmd /C start explorer.exe " + directory);
            }
            catch (Exception x) {
                GM.showException(this, x);
            }
        }
    }

    void jBClose_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private Object getSelectedNode() {
        TreePath[] paths = this.m_Tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)paths[paths.length - 1].getLastPathComponent();
        Object lastNode = dmt.getUserObject();
        if (lastNode instanceof FileNode) {
            return lastNode;
        }
        TreeNode[] tns = dmt.getPath();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tns.length) {
            if (i > 0) {
                sb.append("\\");
            }
            sb.append(tns[i]);
            ++i;
        }
        return sb.toString();
    }

    void m_Tree_mouseClicked(MouseEvent e) {
        Object selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        boolean isFileNode = selectedNode instanceof FileNode;
        if (!isFileNode) {
            this.tpDesc.setText("");
        } else {
            FileNode fn = (FileNode)selectedNode;
            StringBuffer buf = new StringBuffer();
            buf.append("<font size=\"6\">");
            buf.append(fn.getTitle());
            buf.append("</font > <br> <br> <font size=\"5\">");
            buf.append(fn.getDesc());
            buf.append("</font> <br> <br> <font color=#0000C6 size=\"4\">");
            buf.append(fn.getAbsolutePath());
            buf.append("</font>");
            this.tpDesc.setText(buf.toString());
            this.tpDesc.setCaretPosition(0);
            if (e != null && e.getClickCount() == 2) {
                this.jBOpen_actionPerformed(null);
            }
        }
    }

    void m_Tree_valueChanged(TreeSelectionEvent e) {
        this.m_Tree_mouseClicked(null);
    }
}

