/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogInputText_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogInputText_jBCopy_actionAdapter;
import com.scudata.ide.common.dialog.DialogInputText_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogInputText_jBPaste_actionAdapter;
import com.scudata.ide.common.dialog.DialogMaxmizable;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogInputText
extends DialogMaxmizable {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    public JButton jBOK = new JButton();
    public JButton jBCancel = new JButton();
    public JButton jBCopy = new JButton();
    public JButton jBPaste = new JButton();
    public JEditorPane jTextPane1 = new JEditorPane();
    protected int m_option = -1;

    public DialogInputText(boolean editable) {
        this((Frame)GV.appFrame, editable);
    }

    public DialogInputText(Frame frame, boolean editable) {
        this(frame, IdeCommonMessage.get().getMessage("dialoginputtext.texteditbox"), editable);
    }

    public DialogInputText(Frame frame, String title, boolean editable) {
        super(frame, title, true);
        this.initDialog(editable);
    }

    public DialogInputText(Dialog parent, boolean editable) {
        this(parent, IdeCommonMessage.get().getMessage("dialoginputtext.texteditbox"), true);
    }

    public DialogInputText(Dialog parent, String title, boolean editable) {
        super(parent, IdeCommonMessage.get().getMessage("dialoginputtext.texteditbox"), true);
        this.initDialog(editable);
    }

    private void initDialog(boolean editable) {
        try {
            this.initUI();
            this.jTextPane1.setEditable(editable);
            this.setSize(400, 300);
            this.resetLongText(editable);
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public void setText(String text) {
        this.jTextPane1.setText(text);
        this.jTextPane1.selectAll();
    }

    public String getText() {
        return this.jTextPane1.getText();
    }

    public void setRichText(String url) {
        try {
            File file = new File(url);
            this.jTextPane1.setContentType("text/html");
            this.jTextPane1.setPage("file:" + file.getAbsolutePath());
            this.jTextPane1.setEditable(false);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public void setMessageMode() {
        this.jBOK.setEnabled(false);
        this.jBOK.setVisible(false);
        this.jBCancel.setText(this.mm.getMessage("button.closex"));
        this.jBCancel.setMnemonic('X');
        this.jBPaste.setEnabled(false);
        this.jBPaste.setVisible(false);
    }

    private void resetLongText(boolean editable) {
        this.setTitle(editable ? IdeCommonMessage.get().getMessage("dialoginputtext.texteditbox") : this.mm.getMessage("dialoginputtext.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("dialoginputtext.buttoncancel"));
        this.jBCopy.setText(this.mm.getMessage("button.copy"));
        this.jBPaste.setText(this.mm.getMessage("button.paste"));
    }

    private void initUI() throws Exception {
        JPanel panel1 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        panel1.setLayout(borderLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogInputText_jBOK_actionAdapter(this));
        jPanel1.setLayout(vFlowLayout1);
        this.jBCancel.setMnemonic('X');
        this.jBCancel.setText("\u53d6\u6d88(X)");
        this.jBCancel.addActionListener(new DialogInputText_jBCancel_actionAdapter(this));
        this.jBCopy.setMnemonic('C');
        this.jBCopy.setText("\u590d\u5236(C)");
        this.jBCopy.addActionListener(new DialogInputText_jBCopy_actionAdapter(this));
        this.jBPaste.setMnemonic('P');
        this.jBPaste.setText("\u7c98\u8d34(P)");
        this.jBPaste.addActionListener(new DialogInputText_jBPaste_actionAdapter(this));
        this.getContentPane().add(panel1);
        panel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.jTextPane1, null);
        panel1.add((Component)jPanel1, "East");
        jPanel1.add((Component)this.jBOK, null);
        jPanel1.add((Component)this.jBCancel, null);
        jPanel1.add((Component)this.jBCopy, null);
        jPanel1.add((Component)this.jBPaste, null);
    }

    void jBOK_actionPerformed(ActionEvent e) {
        this.m_option = 0;
        this.dispose();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        this.dispose();
    }

    void jBCopy_actionPerformed(ActionEvent e) {
        this.jTextPane1.copy();
    }

    void jBPaste_actionPerformed(ActionEvent e) {
        this.jTextPane1.setText(GM.clipBoard(false));
    }
}

