/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.common.DBConfig;
import com.scudata.common.MessageManager;
import com.scudata.common.ODBCUtil;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.DialogDataSource;
import com.scudata.ide.common.dialog.DialogODBCDataSource_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogODBCDataSource_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogODBCDataSource_this_windowAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogODBCDataSource
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private int m_option = 2;
    private String oldDSName;
    public static final String ODBC_URL = "jdbc:odbc:";
    public static final String ODBC_CHARSET = "GBK";
    public static final String ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private JButton jBCancel = new JButton();
    private JButton jBOK = new JButton();
    private JLabel jLabel1 = new JLabel();
    private JTextField jDSName = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JComboBoxEx jODBCName = new JComboBoxEx();
    private JLabel jLabel4 = new JLabel();
    private JTextField jUser = new JTextField();
    private JLabel jLabel5 = new JLabel();
    private JPasswordField jPassword = new JPasswordField();
    private JCheckBox jUseSchema = new JCheckBox();
    private JCheckBox jCaseSentence = new JCheckBox();
    private JCheckBox jCBIsAddTilde = new JCheckBox();
    private Vector<String> existNames;

    public DialogODBCDataSource(JDialog parent) {
        super(parent, "ODBC\u6570\u636e\u6e90", true);
        try {
            this.setSize(400, 300);
            this.initUI();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogodbcdatasource.title"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jLabel1.setText(this.mm.getMessage("dialogodbcdatasource.dsname"));
        this.jLabel3.setText(this.mm.getMessage("dialogodbcdatasource.odbcname"));
        this.jLabel4.setText(this.mm.getMessage("dialogodbcdatasource.user"));
        this.jLabel5.setText(this.mm.getMessage("dialogodbcdatasource.password"));
        this.jUseSchema.setText(this.mm.getMessage("dialogodbcdatasource.useschema"));
        this.jCaseSentence.setText(this.mm.getMessage("dialogodbcdatasource.casesentence"));
        this.jCBIsAddTilde.setText(this.mm.getMessage("dialogdatasourcepara.isaddtilde"));
    }

    public void set(DBConfig config) {
        if (!DialogDataSource.isLocalDataSource(this, new DataSource(config), false)) {
            this.jBOK.setEnabled(false);
        }
        this.oldDSName = config.getName();
        this.jDSName.setText(config.getName());
        String url = config.getUrl();
        if (url.startsWith(ODBC_URL)) {
            url = url.substring(ODBC_URL.length());
        }
        this.jODBCName.setSelectedItem(url);
        this.jUser.setText(config.getUser());
        String pwd = config.getPassword();
        try {
            this.jPassword.setText(pwd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jUseSchema.setSelected(config.isUseSchema());
        this.jCaseSentence.setSelected(config.isCaseSentence());
        this.jCBIsAddTilde.setSelected(config.isAddTilde());
    }

    public DataSource get() {
        DBConfig config = new DBConfig();
        config.setName(this.jDSName.getText());
        config.setDriver(ODBC_DRIVER);
        config.setUrl(ODBC_URL + (String)this.jODBCName.getSelectedItem());
        config.setUser(this.jUser.getText());
        String pwd = new String(this.jPassword.getPassword());
        config.setPassword(pwd);
        config.setUseSchema(this.jUseSchema.isSelected());
        config.setCaseSentence(this.jCaseSentence.isSelected());
        config.setAddTilde(this.jCBIsAddTilde.isSelected());
        DataSource ds = new DataSource(config);
        return ds;
    }

    public void setExistNames(Vector<String> existNames) {
        this.existNames = existNames;
    }

    public int getOption() {
        return this.m_option;
    }

    public boolean isNameChanged() {
        return !this.jDSName.getText().equalsIgnoreCase(this.oldDSName);
    }

    private void initUI() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogODBCDataSource_this_windowAdapter(this));
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        VFlowLayout vFlowLayout1 = new VFlowLayout();
        jPanel2.setLayout(vFlowLayout1);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogODBCDataSource_jBCancel_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogODBCDataSource_jBOK_actionAdapter(this));
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel5 = new JPanel();
        jPanel1.setLayout(gridBagLayout1);
        this.jLabel1.setText("\u6570\u636e\u6e90\u540d\u79f0");
        this.jLabel3.setText("ODBC\u540d\u79f0");
        this.jLabel4.setText("\u7528\u6237\u540d");
        this.jLabel5.setText("\u5bc6\u7801");
        this.jUseSchema.setText("\u4f7f\u7528\u5e26\u6a21\u5f0f\u7684\u8868\u540d\u79f0");
        this.jCaseSentence.setText("\u5927\u5c0f\u5199\u654f\u611f");
        this.jCBIsAddTilde.setText("\u4f7f\u7528\u5e26\u5f15\u53f7\u7684SQL");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout2);
        this.getContentPane().add((Component)jPanel1, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        jPanel2.add((Component)this.jBOK, null);
        jPanel2.add((Component)this.jBCancel, null);
        jPanel1.add((Component)jPanel3, GM.getGBC(1, 1, true));
        jPanel1.add((Component)jPanel5, GM.getGBC(3, 1, true, true));
        jPanel3.add((Component)this.jLabel1, GM.getGBC(1, 1));
        jPanel3.add((Component)this.jDSName, GM.getGBC(1, 2, true));
        jPanel3.add((Component)this.jLabel3, GM.getGBC(3, 1));
        jPanel3.add((Component)this.jODBCName, GM.getGBC(3, 2, true));
        jPanel3.add((Component)this.jLabel4, GM.getGBC(4, 1));
        jPanel3.add((Component)this.jUser, GM.getGBC(4, 2, true));
        jPanel3.add((Component)this.jLabel5, GM.getGBC(5, 1));
        jPanel3.add((Component)this.jPassword, GM.getGBC(5, 2, true));
        GridBagConstraints gbc = GM.getGBC(6, 1, true);
        gbc.gridwidth = 2;
        jPanel3.add((Component)this.jUseSchema, gbc);
        gbc = GM.getGBC(7, 1, true);
        gbc.gridwidth = 2;
        jPanel3.add((Component)this.jCaseSentence, gbc);
        gbc = GM.getGBC(8, 1, true);
        gbc.gridwidth = 2;
        jPanel3.add((Component)this.jCBIsAddTilde, gbc);
    }

    private void init() {
        int height = 28;
        this.jDSName.setPreferredSize(new Dimension(0, height));
        this.jODBCName.setPreferredSize(new Dimension(0, height));
        this.jUser.setPreferredSize(new Dimension(0, height));
        this.jPassword.setPreferredSize(new Dimension(0, height));
        this.jUseSchema.setPreferredSize(new Dimension(0, height));
        this.jCaseSentence.setPreferredSize(new Dimension(0, height));
        this.jODBCName.setEditable(true);
        ArrayList<String> dsList = ODBCUtil.getDataSourcesName(3);
        this.jODBCName.setListData(dsList.toArray());
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (!StringUtils.isValidString(this.jDSName.getText())) {
                throw new Exception(this.mm.getMessage("dialogdatasourcepara.emptydsname"));
            }
            if (!StringUtils.isValidString(this.jODBCName.getSelectedItem())) {
                throw new Exception(this.mm.getMessage("dialogdatasourcepara.emptyodbc"));
            }
            if (this.existNames != null) {
                if (this.existNames.contains(this.jDSName.getText())) {
                    GM.messageDialog(this, String.valueOf(this.mm.getMessage("dialogdatasource.existdsname")) + this.jDSName.getText(), this.mm.getMessage("public.note"), 0);
                    return;
                }
            } else if (this.isNameChanged() && GM.isExistDataSource(this, this.get())) {
                return;
            }
            GM.setWindowDimension(this);
            this.m_option = 0;
            this.dispose();
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

