/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.dialog;

import com.scudata.app.common.Section;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.DBInfo;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.dialog.DialogSQLEditor_fromButtonLeft_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_fromButtonRight_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_groupL_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_groupR_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jBCancel_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jBOK_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jButtonOL_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jButtonOR_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jButtonSL_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jButtonSR_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jCBSchema_actionAdapter;
import com.scudata.ide.common.dialog.DialogSQLEditor_jTextPaneSql_keyAdapter;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogSQLEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int TAB_FROM = 0;
    public static final int TAB_SELECT = 1;
    public static final int TAB_WHERE = 2;
    public static final int TAB_JOIN = 3;
    public static final int TAB_GROUP = 4;
    public static final int TAB_HAVING = 5;
    public static final int TAB_ORDER = 6;
    public static final int TAB_SQL = 7;
    private static final int COL_ID = 0;
    private static final int COL_FIELD = 1;
    private static final int COL_OPT = 2;
    private static final int COL_VAL = 3;
    private static final int COL_CONNECT = 4;
    private TableChanged tableChanged = new TableChanged(this);
    private Vector codeTable = new Vector();
    private DefaultComboBoxModel dispTable = new DefaultComboBoxModel();
    private Vector codeFields = new Vector();
    private DefaultListModel dispFields = new DefaultListModel();
    private Vector<String> operateCodeItems = new Vector();
    private Vector<String> operateDispItems = new Vector();
    private Vector<String> connectCodeItems = new Vector();
    private Vector<String> connectDispItems = new Vector();
    private JTabbedPane jTabbedPaneSql = new JTabbedPane();
    private JTextPane jTextPaneSql = new JTextPane();
    private JButton fromButtonRight = new JButton();
    private JButton fromButtonLeft = new JButton();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JButton selectButtonRight = new JButton();
    private JButton selectButtonLeft = new JButton();
    private JButton groupButtonRight = new JButton();
    private JButton groupButtonLeft = new JButton();
    private JButton orderButtonRight = new JButton();
    private JButton orderButtonLeft = new JButton();
    private JComboBoxEx selectComboSum = new JComboBoxEx();
    private JPanel fromPanel = new JPanel();
    private JComboBoxEx selectComboLeft = new JComboBoxEx();
    private JComboBoxEx groupComboLeft = new JComboBoxEx();
    private JComboBoxEx orderComboLeft = new JComboBoxEx();
    protected int m_option = -1;
    private JButton whereButtonAdd = new JButton();
    private JButton whereButtonDel = new JButton();
    private MessageManager mm = IdeCommonMessage.get();
    private final String TABLE_COLS = this.mm.getMessage("dialogsqleditor.tablecols");
    private JTableEx whereTable = new JTableEx(this.TABLE_COLS);
    private JButton joinButtonAdd = new JButton();
    private JButton joinButtonDel = new JButton();
    private JTableEx joinTable = new JTableEx(this.TABLE_COLS);
    private JButton havingButtonAdd = new JButton();
    private JButton havingButtonDel = new JButton();
    private JTableEx havingTable = new JTableEx(this.TABLE_COLS);
    private JComboBox<String> jCBSchema = new JComboBox();
    private String currentFrom = null;
    private boolean bEditByHand = false;
    private boolean afterInit = false;
    private DataSource ds;
    private JListEx fromListLeft = new JListEx();
    private JListEx fromListRight = new JListEx();
    private JListEx selectListLeft = new JListEx();
    private JListEx selectListRight = new JListEx();
    private JListEx groupListLeft = new JListEx();
    private JListEx groupListRight = new JListEx();
    private JListEx orderListLeft = new JListEx();
    private JListEx orderListRight = new JListEx();
    private final String AVAILABLE_TABLE = this.mm.getMessage("dialogsqleditor.availabletable");
    private final String SELECTED_TABLE = this.mm.getMessage("dialogsqleditor.selectedtable");
    private final String SELECTED_FIELD = this.mm.getMessage("dialogsqleditor.selectedfield");
    private final String OPT_NUL = "";
    private final String OPT_SUM = "SUM";
    private final String OPT_MAX = "MAX";
    private final String OPT_MIN = "MIN";
    private final String OPT_COUNT = "COUNT";
    private final String OPT_AVG = "AVG";
    private final String OPT_EQUAL = "=";
    private final String OPT_NOT_EQUAL = "<>";
    private final String OPT_MORE = ">";
    private final String OPT_LESS = "<";
    private final String OPT_AND = "and";
    private final String OPT_OR = "or";
    private boolean isCopyMode = false;
    public ProcessWindow pw;

    public DialogSQLEditor(DataSource ds) {
        super(GV.appFrame, "", false);
        this.ds = ds;
        this.enableEvents(64L);
        try {
            try {
                this.selectComboLeft.x_setModel(this.codeTable, this.dispTable);
                this.groupComboLeft.x_setModel(this.codeTable, this.dispTable);
                this.orderComboLeft.x_setModel(this.codeTable, this.dispTable);
                this.selectListLeft.x_setModel(this.codeFields, this.dispFields);
                this.groupListLeft.x_setModel(this.codeFields, this.dispFields);
                this.orderListLeft.x_setModel(this.codeFields, this.dispFields);
                this.fromListLeft.x_setData(new Vector(), new Vector());
                this.initUI();
                this.setSize(600, 420);
                GM.loadSchemas(ds, this.jCBSchema);
                GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
                this.resetLangText();
                try {
                    this.pw = new ProcessWindow();
                    GM.centerWindow(this.pw);
                    this.pw.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                block12: {
                                    try {
                                        try {
                                            DialogSQLEditor.this.refreshTables();
                                        }
                                        catch (Throwable x) {
                                            GM.showException(DialogSQLEditor.this, x);
                                            if ((this).DialogSQLEditor.this.pw == null) break block12;
                                            try {
                                                (this).DialogSQLEditor.this.pw.disposeWindow();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            (this).DialogSQLEditor.this.pw = null;
                                        }
                                    }
                                    finally {
                                        if ((this).DialogSQLEditor.this.pw != null) {
                                            try {
                                                (this).DialogSQLEditor.this.pw.disposeWindow();
                                            }
                                            catch (Exception exception) {}
                                            (this).DialogSQLEditor.this.pw = null;
                                        }
                                    }
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                GM.showException(this, e);
                this.afterInit = true;
            }
        }
        finally {
            this.afterInit = true;
        }
    }

    public void setCopyMode() {
        this.isCopyMode = true;
        this.jBOK.setText(this.mm.getMessage("button.copy"));
        this.jBCancel.setText(this.mm.getMessage("button.close"));
    }

    public int getOption() {
        return this.m_option;
    }

    private void changeSelectTable(String table) throws Exception {
        if (table == null) {
            return;
        }
        this.dispFields.removeAllElements();
        this.updateTableFields(table);
    }

    private void refreshTables() {
        String realSchema = GM.getRealSchema(this.jCBSchema.getSelectedItem());
        Vector<String> v = GM.listSchemaTables(this, this.ds, realSchema, false);
        if (v == null || v.isEmpty()) {
            this.fromListLeft.x_setData(new Vector(), new Vector());
        } else {
            Object[] tableNames = v.toArray();
            Arrays.sort(tableNames);
            List<Object> tableList = Arrays.asList(tableNames);
            this.fromListLeft.x_setData(tableList, tableList);
        }
    }

    public String getSQL() {
        return this.jTextPaneSql.getText();
    }

    private JPanel getVPanel(Component bt1, Component bt2, Component bt3) {
        VFlowLayout vf = new VFlowLayout();
        vf.setHorizontalFill(true);
        vf.setAlignment(1);
        JPanel p = new JPanel(vf);
        p.add(bt1);
        if (bt2 != null) {
            p.add(bt2);
            if (bt3 != null) {
                p.add(bt3);
            }
        }
        return p;
    }

    private void resetLangText() {
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
    }

    private JPanel getFromPanel() {
        JLabel fromLabelTable = new JLabel();
        JLabel fromLabelSelects = new JLabel();
        fromLabelTable.setText(this.AVAILABLE_TABLE);
        fromLabelSelects.setText(this.SELECTED_TABLE);
        this.fromButtonRight.setText(">");
        this.fromButtonRight.addActionListener(new DialogSQLEditor_fromButtonRight_actionAdapter(this));
        this.fromButtonLeft.setText("<");
        this.fromButtonLeft.addActionListener(new DialogSQLEditor_fromButtonLeft_actionAdapter(this));
        this.fromListLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.jButtonFR_actionPerformed(null);
                }
            }
        });
        this.fromListRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.jButtonFL_actionPerformed(null);
                }
            }
        });
        this.fromPanel.setLayout(new GridBagLayout());
        this.fromPanel.add((Component)fromLabelTable, GM.getGBC(1, 1));
        this.fromPanel.add((Component)fromLabelSelects, GM.getGBC(1, 3));
        JScrollPane fromScrollPaneRight = new JScrollPane();
        fromScrollPaneRight.getViewport().add((Component)this.fromListRight, null);
        JScrollPane fromScrollPaneLeft = new JScrollPane();
        fromScrollPaneLeft.getViewport().add((Component)this.fromListLeft, null);
        this.fromPanel.add((Component)fromScrollPaneLeft, GM.getGBC(2, 1, true, true));
        this.fromPanel.add((Component)this.getVPanel(this.fromButtonRight, this.fromButtonLeft, null), GM.getGBC(2, 2, false, true));
        this.fromPanel.add((Component)fromScrollPaneRight, GM.getGBC(2, 3, true, true));
        return this.fromPanel;
    }

    private JPanel getSelectPanel() {
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        this.selectComboLeft.addItemListener(this.tableChanged);
        this.selectButtonRight.setText(">");
        this.selectButtonRight.addActionListener(new DialogSQLEditor_jButtonSR_actionAdapter(this));
        this.selectButtonLeft.setText("<");
        this.selectButtonLeft.addActionListener(new DialogSQLEditor_jButtonSL_actionAdapter(this));
        JLabel selectLabelRight = new JLabel();
        selectLabelRight.setText(this.SELECTED_FIELD);
        this.selectListLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.jButtonSR_actionPerformed(null);
                }
            }
        });
        this.selectListRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.jButtonSL_actionPerformed(null);
                }
            }
        });
        this.selectComboSum.setEnabled(false);
        this.selectListRight.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                DialogSQLEditor.this.selectComboSum.setEnabled(!DialogSQLEditor.this.selectListRight.isSelectionEmpty());
                String exp = (String)DialogSQLEditor.this.selectListRight.getSelectedValue();
                if (exp == null) {
                    return;
                }
                String[] exps = DialogSQLEditor.this.parseComputedField(exp);
                DialogSQLEditor.this.selectComboSum.x_setSelectedCodeItem(StringUtils.isValidString(exps[0]) ? exps[0] : "");
            }
        });
        Vector<String> codeOpts = new Vector<String>();
        Vector<String> dispOpts = new Vector<String>();
        codeOpts.add("");
        codeOpts.add("SUM");
        codeOpts.add("MAX");
        codeOpts.add("MIN");
        codeOpts.add("COUNT");
        codeOpts.add("AVG");
        dispOpts.add("");
        dispOpts.add(this.mm.getMessage("dialogsqleditor.sum"));
        dispOpts.add(this.mm.getMessage("dialogsqleditor.max"));
        dispOpts.add(this.mm.getMessage("dialogsqleditor.min"));
        dispOpts.add(this.mm.getMessage("dialogsqleditor.count"));
        dispOpts.add(this.mm.getMessage("dialogsqleditor.avg"));
        this.selectComboSum.x_setData(codeOpts, dispOpts);
        this.selectComboSum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DialogSQLEditor.this.selectListRight.isSelectionEmpty()) {
                    return;
                }
                String selectedFunc = (String)DialogSQLEditor.this.selectComboSum.x_getSelectedItem();
                String exp = (String)DialogSQLEditor.this.selectListRight.getSelectedValue();
                if (exp == null) {
                    return;
                }
                String[] exps = DialogSQLEditor.this.parseComputedField(exp);
                exp = StringUtils.isValidString(selectedFunc) ? String.valueOf(selectedFunc) + "(" + exps[1] + ")" : exps[1];
                int index = DialogSQLEditor.this.selectListRight.getSelectedIndex();
                ((DialogSQLEditor)DialogSQLEditor.this).selectListRight.data.set(index, exp);
                DialogSQLEditor.this.selectedFieldChanged();
            }
        });
        selectPanel.add((Component)this.selectComboLeft, GM.getGBC(1, 1));
        selectPanel.add((Component)selectLabelRight, GM.getGBC(1, 3));
        JScrollPane selectScrollPaneRight = new JScrollPane();
        selectScrollPaneRight.getViewport().add((Component)this.selectListRight, null);
        JScrollPane selectScrollPaneLeft = new JScrollPane();
        selectScrollPaneLeft.getViewport().add((Component)this.selectListLeft, null);
        selectPanel.add((Component)selectScrollPaneLeft, GM.getGBC(2, 1, true, true));
        selectPanel.add((Component)this.getVPanel(this.selectButtonRight, this.selectButtonLeft, this.selectComboSum), GM.getGBC(2, 2, false, true, 0));
        JPanel selectPanelRight = new JPanel(new BorderLayout());
        selectPanelRight.add((Component)selectScrollPaneRight, "Center");
        selectPanelRight.add((Component)this.selectComboSum, "South");
        selectPanel.add((Component)selectPanelRight, GM.getGBC(2, 3, true, true));
        return selectPanel;
    }

    private String[] parseComputedField(String exp) {
        if (exp == null) {
            return null;
        }
        exp = exp.trim();
        int indexL = exp.indexOf("(");
        int indexR = exp.indexOf(")");
        String[] stringArray = new String[2];
        stringArray[1] = exp;
        String[] exps = stringArray;
        if (indexL > -1 && indexR == exp.length() - 1) {
            String func = exp.substring(0, indexL);
            if ((func = func.trim()).equalsIgnoreCase("SUM") || func.equalsIgnoreCase("MAX") || func.equalsIgnoreCase("MIN") || func.equalsIgnoreCase("COUNT") || func.equalsIgnoreCase("AVG")) {
                exps[0] = func;
                exps[1] = exp.substring(indexL + 1, indexR);
            }
        }
        return exps;
    }

    private JPanel getWherePanel() {
        this.whereButtonAdd.setToolTipText(this.mm.getMessage("dialogsqleditor.add"));
        this.whereButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.whereTable.addRow();
            }
        });
        this.whereButtonAdd.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_addrecord.gif"));
        this.initIconButton(this.whereButtonAdd);
        this.whereButtonDel.setToolTipText(this.mm.getMessage("dialogsqleditor.delete"));
        this.whereButtonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.whereTable.deleteSelectedRow();
            }
        });
        this.whereButtonDel.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_deleterecord.gif"));
        this.initIconButton(this.whereButtonDel);
        this.whereTable.setRowHeight(20);
        this.whereTable.setIndexCol(0);
        this.whereTable.setColumnDropDown(2, this.operateCodeItems, this.operateCodeItems, true);
        this.whereTable.setColumnDropDown(4, this.connectCodeItems, this.connectCodeItems, true);
        JScrollPane whereScrollPane = new JScrollPane(this.whereTable);
        JPanel wherePanel = new JPanel();
        wherePanel.setLayout(new GridBagLayout());
        wherePanel.add((Component)new JLabel(), GM.getGBC(1, 1, true));
        wherePanel.add((Component)this.whereButtonAdd, GM.getGBC(1, 2));
        wherePanel.add((Component)this.whereButtonDel, GM.getGBC(1, 3));
        GridBagConstraints gbc = GM.getGBC(2, 1, true, true);
        gbc.gridwidth = 3;
        wherePanel.add((Component)whereScrollPane, gbc);
        return wherePanel;
    }

    private JPanel getJoinPanel() {
        this.joinButtonAdd.setToolTipText(this.mm.getMessage("dialogsqleditor.add"));
        this.joinButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.joinTable.addRow();
            }
        });
        this.joinButtonAdd.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_addrecord.gif"));
        this.initIconButton(this.joinButtonAdd);
        this.joinButtonDel.setToolTipText(this.mm.getMessage("dialogsqleditor.delete"));
        this.joinButtonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.joinTable.deleteSelectedRow();
            }
        });
        this.joinButtonDel.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_deleterecord.gif"));
        this.initIconButton(this.joinButtonDel);
        this.joinTable.setRowHeight(20);
        this.joinTable.setIndexCol(0);
        this.joinTable.setColumnDropDown(2, this.operateCodeItems, this.operateCodeItems, true);
        this.joinTable.setColumnDropDown(4, this.connectCodeItems, this.connectCodeItems, true);
        JPanel joinPanel = new JPanel();
        JScrollPane joinScrollPane = new JScrollPane(this.joinTable);
        joinPanel.setLayout(new GridBagLayout());
        joinPanel.add((Component)new JLabel(), GM.getGBC(1, 1, true));
        joinPanel.add((Component)this.joinButtonAdd, GM.getGBC(1, 2));
        joinPanel.add((Component)this.joinButtonDel, GM.getGBC(1, 3));
        GridBagConstraints gbc = GM.getGBC(2, 1, true, true);
        gbc.gridwidth = 3;
        joinPanel.add((Component)joinScrollPane, gbc);
        return joinPanel;
    }

    private void initIconButton(JButton b) {
        Dimension d = new Dimension(22, 22);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
    }

    private JPanel getGroupPanel() {
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new GridBagLayout());
        this.groupComboLeft.addItemListener(this.tableChanged);
        this.groupButtonRight.setText(">");
        this.groupButtonRight.addActionListener(new DialogSQLEditor_groupR_actionAdapter(this));
        this.groupButtonLeft.setText("<");
        this.groupButtonLeft.addActionListener(new DialogSQLEditor_groupL_actionAdapter(this));
        JLabel groupLabelRight = new JLabel();
        groupLabelRight.setText(this.SELECTED_FIELD);
        this.groupListLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.groupR_actionPerformed(null);
                }
            }
        });
        this.groupListRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.groupL_actionPerformed(null);
                }
            }
        });
        JButton bAuto = new JButton();
        bAuto.setToolTipText(this.mm.getMessage("dialogsqleditor.autogen"));
        bAuto.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_loaddb.gif"));
        bAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Section s = new Section(DialogSQLEditor.this.selectListRight.totalItems());
                Vector fields = DialogSQLEditor.this.getNormalFields(s);
                Section old = new Section(DialogSQLEditor.this.groupListRight.totalItems());
                int i = 0;
                while (i < fields.size()) {
                    String field = (String)fields.get(i);
                    if (!old.containsSection(field)) {
                        old.addSection(field);
                    }
                    ++i;
                }
                Vector v = old.toVector();
                DialogSQLEditor.this.groupListRight.x_setData(v, v);
            }
        });
        this.initIconButton(bAuto);
        groupPanel.add((Component)this.groupComboLeft, GM.getGBC(1, 1));
        groupPanel.add((Component)groupLabelRight, GM.getGBC(1, 3));
        JScrollPane groupScrollPaneRight = new JScrollPane();
        groupScrollPaneRight.getViewport().add((Component)this.groupListRight, null);
        JScrollPane groupScrollPaneLeft = new JScrollPane();
        groupScrollPaneLeft.getViewport().add((Component)this.groupListLeft, null);
        groupPanel.add((Component)groupScrollPaneLeft, GM.getGBC(2, 1, true, true));
        groupPanel.add((Component)this.getVPanel(this.groupButtonRight, this.groupButtonLeft, bAuto), GM.getGBC(2, 2, false, true));
        groupPanel.add((Component)groupScrollPaneRight, GM.getGBC(2, 3, true, true));
        return groupPanel;
    }

    private JPanel getHavingPanel() {
        this.havingButtonAdd.setToolTipText(this.mm.getMessage("dialogsqleditor.add"));
        this.havingButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.havingTable.addRow();
            }
        });
        this.havingButtonAdd.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_addrecord.gif"));
        this.initIconButton(this.havingButtonAdd);
        this.havingButtonDel.setToolTipText(this.mm.getMessage("dialogsqleditor.delete"));
        this.havingButtonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSQLEditor.this.havingTable.deleteSelectedRow();
            }
        });
        this.havingButtonDel.setIcon(GM.getImageIcon(this, "/com/scudata/ide/common/resources/m_deleterecord.gif"));
        this.initIconButton(this.havingButtonDel);
        this.havingTable.setRowHeight(20);
        this.havingTable.setIndexCol(0);
        this.havingTable.setColumnDropDown(2, this.operateCodeItems, this.operateCodeItems, true);
        this.havingTable.setColumnDropDown(4, this.connectCodeItems, this.connectCodeItems, true);
        JPanel havingPanel = new JPanel();
        JScrollPane havingScrollPane = new JScrollPane(this.havingTable);
        havingPanel.setLayout(new GridBagLayout());
        havingPanel.add((Component)new JLabel(), GM.getGBC(1, 1, true));
        havingPanel.add((Component)this.havingButtonAdd, GM.getGBC(1, 2));
        havingPanel.add((Component)this.havingButtonDel, GM.getGBC(1, 3));
        GridBagConstraints gbc = GM.getGBC(2, 1, true, true);
        gbc.gridwidth = 3;
        havingPanel.add((Component)havingScrollPane, gbc);
        return havingPanel;
    }

    private JPanel getOrderPanel() {
        this.orderButtonRight.setText(">");
        this.orderButtonRight.addActionListener(new DialogSQLEditor_jButtonOR_actionAdapter(this));
        this.orderButtonLeft.setText("<");
        this.orderButtonLeft.addActionListener(new DialogSQLEditor_jButtonOL_actionAdapter(this));
        JLabel orderLabelRight = new JLabel();
        orderLabelRight.setText(this.mm.getMessage("dialogsqleditor.order"));
        this.orderComboLeft.addItemListener(this.tableChanged);
        this.orderListLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DialogSQLEditor.this.jButtonOR_actionPerformed(null);
                }
            }
        });
        this.orderListRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    int index = DialogSQLEditor.this.orderListRight.getSelectedIndex();
                    String item = ((DialogSQLEditor)DialogSQLEditor.this).orderListRight.data.getElementAt(index).toString();
                    item = (item = item.trim()).toUpperCase().endsWith("ASC") ? String.valueOf(item.substring(0, item.length() - 3)) + "DESC" : String.valueOf(item.substring(0, item.length() - 4)) + "ASC";
                    ((DialogSQLEditor)DialogSQLEditor.this).orderListRight.data.set(index, item);
                }
            }
        });
        JPanel orderPanel = new JPanel();
        orderPanel.setLayout(new GridBagLayout());
        orderPanel.add((Component)this.orderComboLeft, GM.getGBC(1, 1));
        orderPanel.add((Component)orderLabelRight, GM.getGBC(1, 3));
        JScrollPane orderScrollPaneRight = new JScrollPane();
        orderScrollPaneRight.getViewport().add((Component)this.orderListRight, null);
        JScrollPane orderScrollPaneLeft = new JScrollPane();
        orderScrollPaneLeft.getViewport().add((Component)this.orderListLeft, null);
        orderPanel.add((Component)orderScrollPaneLeft, GM.getGBC(2, 1, true, true));
        orderPanel.add((Component)this.getVPanel(this.orderButtonRight, this.orderButtonLeft, null), GM.getGBC(2, 2, false, true));
        orderPanel.add((Component)orderScrollPaneRight, GM.getGBC(2, 3, true, true));
        return orderPanel;
    }

    private JPanel getSqlPanel() {
        JPanel jPanelSql = new JPanel();
        BorderLayout borderLayout3 = new BorderLayout();
        jPanelSql.setLayout(borderLayout3);
        this.jTextPaneSql.addKeyListener(new DialogSQLEditor_jTextPaneSql_keyAdapter(this));
        JScrollPane jScrollPaneSql = new JScrollPane();
        jScrollPaneSql.getViewport().add((Component)this.jTextPaneSql, null);
        jPanelSql.add((Component)jScrollPaneSql, "Center");
        return jPanelSql;
    }

    private FKMap getFKMap(DataSource ds, String schema) {
        String str = this.fromListRight.totalItems();
        if (!StringUtils.isValidString(str)) {
            return null;
        }
        Section tables = new Section(str);
        if (tables.size() == 0) {
            return null;
        }
        FKMap map = new FKMap();
        int i = 0;
        while (i < tables.size()) {
            String table = tables.getSection(i);
            try {
                FKMap tableMap = this.getTableFKMap(ds, schema, table, tables);
                map.addAll(tableMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return map;
    }

    private FKMap getTableFKMap(DataSource ds, String schema, String table, Section tables) throws Throwable {
        Connection con = (Connection)ds.getDBSession().getSession();
        DatabaseMetaData md = con.getMetaData();
        DBInfo dbInfo = ds.getDBInfo();
        String dbcs = dbInfo.getDBCharset();
        String ccs = dbInfo.getClientCharset();
        boolean convert = dbcs != null && !dbcs.equals(ccs);
        String[] schemaTable = GM.getRealSchemaTable(con, schema, table);
        schema = schemaTable[0];
        table = schemaTable[1];
        if (convert) {
            schema = GM.convertDBSearchString(ds, schema);
            table = GM.convertDBSearchString(ds, table);
        }
        FKMap fkMap = new FKMap();
        try (ResultSet rs = null;){
            rs = md.getImportedKeys(null, schema, table);
            while (rs.next()) {
                String pkTableName = rs.getString("PKTABLE_NAME");
                if (convert) {
                    pkTableName = GM.convertDBString(ds, pkTableName);
                }
                if (!tables.containsSection(pkTableName)) continue;
                String pkColName = rs.getString("PKCOLUMN_NAME");
                String colName = rs.getString("FKCOLUMN_NAME");
                if (convert) {
                    pkColName = GM.convertDBString(ds, pkColName);
                    colName = GM.convertDBString(ds, colName);
                }
                if (!colName.startsWith(String.valueOf(table) + ".")) {
                    colName = String.valueOf(table) + "." + colName;
                }
                if (!pkColName.startsWith(String.valueOf(pkTableName) + ".")) {
                    pkColName = String.valueOf(pkTableName) + "." + pkColName;
                }
                fkMap.add(colName, pkColName);
            }
        }
        return fkMap;
    }

    private void initUI() throws Exception {
        JLabel jLBSchema = new JLabel();
        jLBSchema.setText(this.mm.getMessage("dialogsqleditor.schema"));
        this.jCBSchema.addActionListener(new DialogSQLEditor_jCBSchema_actionAdapter(this));
        this.setDefaultCloseOperation(0);
        JPanel jPanel1 = new JPanel();
        VFlowLayout verticalFlowLayout1 = new VFlowLayout();
        BorderLayout borderLayout2 = new BorderLayout();
        jPanel1.setLayout(verticalFlowLayout1);
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(" ");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout1);
        this.setTitle(this.mm.getMessage("dialogsqleditor.sqleditor"));
        this.getContentPane().setLayout(borderLayout2);
        this.jBOK.setText("OK");
        this.jBOK.setMnemonic('O');
        this.jBOK.addActionListener(new DialogSQLEditor_jBOK_actionAdapter(this));
        this.jBCancel.setText("Cancel");
        this.jBCancel.setMnemonic('C');
        this.jBCancel.addActionListener(new DialogSQLEditor_jBCancel_actionAdapter(this));
        this.jTabbedPaneSql.setTabPlacement(1);
        JPanel jPanel3 = new JPanel();
        BorderLayout borderLayout4 = new BorderLayout();
        jPanel3.setLayout(borderLayout4);
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel1, "East");
        jPanel1.add((Component)this.jBOK, null);
        jPanel1.add((Component)this.jBCancel, null);
        jPanel1.add((Component)jLabel1, null);
        jPanel2.add((Component)jLBSchema, GM.getGBC(1, 1));
        jPanel2.add(this.jCBSchema, GM.getGBC(1, 2, true));
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel3.add((Component)this.jTabbedPaneSql, "Center");
        int i = 2;
        this.fromListLeft.setSelectionMode(i);
        this.selectListLeft.setSelectionMode(i);
        this.selectListRight.setSelectionMode(i);
        this.groupListLeft.setSelectionMode(i);
        this.groupListRight.setSelectionMode(i);
        this.orderListLeft.setSelectionMode(i);
        this.orderListRight.setSelectionMode(i);
        this.operateCodeItems.add("");
        this.operateCodeItems.add("=");
        this.operateCodeItems.add("<>");
        this.operateCodeItems.add(">");
        this.operateCodeItems.add("<");
        this.operateDispItems.add("");
        this.operateDispItems.add("=");
        this.operateDispItems.add("<>");
        this.operateDispItems.add(">");
        this.operateDispItems.add("<");
        this.connectCodeItems.add("");
        this.connectCodeItems.add("and");
        this.connectCodeItems.add("or");
        this.connectDispItems.add("");
        this.connectDispItems.add("and");
        this.connectDispItems.add("or");
        this.jTabbedPaneSql.addChangeListener(new TabChangeListener());
        this.jTabbedPaneSql.add((Component)this.getFromPanel(), this.mm.getMessage("dialogsqleditor.table"));
        this.jTabbedPaneSql.add((Component)this.getSelectPanel(), this.mm.getMessage("dialogsqleditor.field"));
        this.jTabbedPaneSql.add((Component)this.getWherePanel(), this.mm.getMessage("dialogsqleditor.where"));
        this.jTabbedPaneSql.add((Component)this.getJoinPanel(), this.mm.getMessage("dialogsqleditor.join"));
        this.jTabbedPaneSql.add((Component)this.getGroupPanel(), this.mm.getMessage("dialogsqleditor.group"));
        this.jTabbedPaneSql.add((Component)this.getHavingPanel(), this.mm.getMessage("dialogsqleditor.having"));
        this.jTabbedPaneSql.add((Component)this.getOrderPanel(), this.mm.getMessage("dialogsqleditor.sort"));
        this.jTabbedPaneSql.add((Component)this.getSqlPanel(), this.mm.getMessage("dialogsqleditor.sql"));
        this.jTabbedPaneSql.setSelectedComponent(this.fromPanel);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            if (this.pw != null) {
                try {
                    this.pw.disposeWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pw = null;
            }
            GM.setWindowDimension(this);
            this.dispose();
        }
    }

    private void updateTableName(String tables) throws Exception {
        this.codeTable.removeAllElements();
        this.dispTable.removeAllElements();
        if (tables == null) {
            return;
        }
        Vector v = new Section((String)tables, (char)',', (boolean)false, (boolean)false).sections;
        this.codeTable.addAll(v);
        int k = 0;
        while (k < v.size()) {
            this.dispTable.addElement(v.get(k).toString());
            ++k;
        }
        if (this.codeTable.size() > 0) {
            this.changeSelectTable((String)this.codeTable.get(0));
        }
    }

    private void updateTableFields(String tableName) throws Exception {
        this.codeFields.removeAllElements();
        this.dispFields.removeAllElements();
        Vector<String> v = this.getListTableColumns(GM.getRealSchema(this.jCBSchema.getSelectedItem()), tableName);
        if (v != null) {
            this.codeFields.addAll(v);
            int k = 0;
            while (k < v.size()) {
                this.dispFields.addElement(v.get(k));
                ++k;
            }
        }
        this.selectListLeft.x_sort(true, true);
    }

    private Vector<String> getListTableColumns(String schema, String tableName) {
        DatabaseMetaData dbmd;
        Connection con;
        Vector<String> colNames;
        block19: {
            block18: {
                block17: {
                    block16: {
                        if (this.ds != null) break block16;
                        return null;
                    }
                    if (!this.ds.isOLAP()) break block17;
                    return null;
                }
                colNames = new Vector<String>();
                con = (Connection)this.ds.getDBSession().getSession();
                if (con != null) break block18;
                return null;
            }
            dbmd = con.getMetaData();
            if (dbmd != null) break block19;
            return null;
        }
        try {
            String name;
            boolean convert;
            String[] schemaTable = GM.getRealSchemaTable(con, schema, tableName);
            if (schemaTable != null) {
                schema = schemaTable[0];
                tableName = schemaTable[1];
            }
            DBInfo dbInfo = this.ds.getDBInfo();
            String dbcs = dbInfo.getDBCharset();
            String ccs = dbInfo.getClientCharset();
            boolean bl = convert = dbcs != null && !dbcs.equals(ccs);
            if (convert) {
                schema = GM.convertDBSearchString(this.ds, schema);
                tableName = GM.convertDBSearchString(this.ds, tableName);
            }
            String tilde = dbmd.getIdentifierQuoteString();
            int index = tableName.indexOf(46);
            if (index > -1) {
                schema = tableName.substring(0, index);
                if (schema.startsWith(tilde)) {
                    schema = schema.substring(tilde.length(), schema.length() - tilde.length());
                }
                if ((name = tableName.substring(index + 1, tableName.length())).startsWith(tilde)) {
                    name = name.substring(tilde.length(), name.length() - tilde.length());
                }
            } else {
                name = tableName;
                if (name.startsWith(tilde)) {
                    name = name.substring(tilde.length(), name.length() - tilde.length());
                }
            }
            boolean isAddTilde = this.ds.getDBConfig().isAddTilde();
            ResultSet rs = dbmd.getColumns(con.getCatalog(), schema, tableName, null);
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                if (convert) {
                    colName = GM.convertDBString(this.ds, colName);
                }
                if (isAddTilde) {
                    colName = GM.tildeString(colName, tilde);
                }
                colNames.addElement(colName);
            }
            rs.close();
            Collections.sort(colNames);
            return colNames;
        }
        catch (Throwable ex) {
            GM.showException(this, ex);
            return null;
        }
    }

    private void setSelectedItems(String currentTable, JListEx source, Object target) {
        currentTable = this.addTableQuote(currentTable);
        Object[] items = source.x_getSelectedValues();
        if (target instanceof JListEx) {
            JListEx tarList = (JListEx)target;
            int i = 0;
            while (i < items.length) {
                if (currentTable == null) {
                    if (!tarList.data.contains(items[i])) {
                        tarList.data.addElement(items[i]);
                    }
                } else if (!tarList.data.contains(String.valueOf(currentTable) + "." + items[i])) {
                    tarList.data.addElement(String.valueOf(currentTable) + "." + items[i]);
                }
                ++i;
            }
        } else {
            JTextPane text = (JTextPane)target;
            String str = text.getText();
            String buf = new String();
            int i = 0;
            while (i < items.length) {
                buf = currentTable == null ? String.valueOf(buf) + " " + items[i].toString() + " " : String.valueOf(buf) + " " + currentTable + "." + items[i].toString() + " ";
                ++i;
            }
            if (buf.length() == 0) {
                return;
            }
            text.setText(String.valueOf(str) + buf);
        }
    }

    private void setSelectedSortItems(String table, JListEx source, JListEx target) {
        table = this.addTableQuote(table);
        Object[] tables = source.x_getSelectedValues();
        int i = 0;
        while (i < tables.length) {
            String tmpSA = String.valueOf(table) + "." + tables[i].toString() + " ASC";
            String tmpSD = String.valueOf(table) + "." + tables[i].toString() + " DESC";
            if (!target.data.contains(tmpSA) && !target.data.contains(tmpSD)) {
                target.data.addElement(tmpSA);
            }
            ++i;
        }
    }

    private String addTableQuote(String fromStr) {
        if (fromStr == null) {
            return null;
        }
        if (!StringUtils.isValidString(fromStr)) {
            return "";
        }
        String driver = this.ds.getDBConfig().getDriver();
        if (!"com.esproc.jdbc.InternalDriver".equalsIgnoreCase(driver)) {
            return fromStr;
        }
        ArgumentTokenizer sections = new ArgumentTokenizer(fromStr, ',', true, true, true, true);
        StringBuffer buf = new StringBuffer();
        while (sections.hasMoreTokens()) {
            String tableName;
            if (buf.length() > 0) {
                buf.append(',');
            }
            if (!((tableName = sections.nextToken()).indexOf(".") <= -1 || tableName.startsWith("\"") && tableName.endsWith("\""))) {
                tableName = Escape.addEscAndQuote(tableName);
            }
            buf.append(tableName);
        }
        return buf.toString();
    }

    void jButtonFR_actionPerformed(ActionEvent e) {
        this.setSelectedItems(null, this.fromListLeft, this.fromListRight);
        String sSql = this.jTextPaneSql.getText();
        String tmpFrom = this.addTableQuote(this.fromListRight.totalItems());
        if (!sSql.trim().toLowerCase().startsWith("select")) {
            sSql = "SELECT *";
        }
        this.jTextPaneSql.setText(GM.modifySql(sSql, tmpFrom, "f"));
        this.selectedTableChanged();
    }

    void jButtonFL_actionPerformed(ActionEvent e) {
        this.fromListRight.removeSelectedItems();
        String sSql = this.jTextPaneSql.getText();
        String tmpFrom = this.addTableQuote(this.fromListRight.totalItems());
        sSql = !StringUtils.isValidString(tmpFrom) ? "" : GM.modifySql(sSql, tmpFrom, "f");
        this.jTextPaneSql.setText(sSql);
        this.selectedTableChanged();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        this.m_option = 0;
        if (!this.isCopyMode) {
            this.generateSql(this.jTabbedPaneSql.getSelectedIndex());
            String ls_sql = this.jTextPaneSql.getText();
            if (!StringUtils.isValidString(ls_sql)) {
                return;
            }
            if ((ls_sql = ls_sql.trim()).startsWith("FROM")) {
                ls_sql = "SELECT * " + ls_sql;
                this.jTextPaneSql.setText(ls_sql);
            }
            GM.setWindowDimension(this);
            this.dispose();
        } else {
            if (this.jTabbedPaneSql.getSelectedIndex() != 7) {
                this.jTabbedPaneSql.setSelectedIndex(7);
            }
            GM.clipBoard(this.getSQL());
        }
    }

    void jButtonSR_actionPerformed(ActionEvent e) {
        this.setSelectedItems((String)this.selectComboLeft.x_getSelectedItem(), this.selectListLeft, this.selectListRight);
        this.selectedFieldChanged();
    }

    void jButtonSL_actionPerformed(ActionEvent e) {
        this.selectListRight.removeSelectedItems();
        this.selectedFieldChanged();
    }

    private void selectedTableChanged() {
        FKMap map = this.getFKMap(this.ds, GM.getRealSchema(this.jCBSchema.getSelectedItem()));
        this.joinTable.acceptText();
        this.joinTable.removeAllRows();
        this.joinTable.clearSelection();
        if (map == null) {
            return;
        }
        int row = -1;
        int i = 0;
        while (i < map.size()) {
            String pkName;
            String fkName = map.getFKName(i);
            if (!this.existWhere(fkName, pkName = map.getPKName(i))) {
                row = this.joinTable.addRow(false);
                this.joinTable.data.setValueAt(fkName, row, 1);
                this.joinTable.data.setValueAt("=", row, 2);
                this.joinTable.data.setValueAt(pkName, row, 3);
                if (row > 0) {
                    this.joinTable.data.setValueAt("and", row - 1, 4);
                }
            }
            ++i;
        }
        if (row > -1) {
            this.joinTable.setEditingRow(row);
            this.joinTable.resetIndex();
            this.joinTable.selectRow(row);
        }
    }

    private boolean existWhere(String f1, String f2) {
        int i = 0;
        while (i < this.whereTable.getRowCount()) {
            Object tmp1 = this.whereTable.data.getValueAt(i, 2);
            if ("=".equals(tmp1)) {
                tmp1 = this.whereTable.data.getValueAt(i, 1);
                Object tmp2 = this.whereTable.data.getValueAt(i, 3);
                if (f1.equals(tmp1) && f2.equals(tmp2) || f1.equals(tmp2) && f2.equals(tmp1)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void selectedFieldChanged() {
        Section s = new Section(this.selectListRight.totalItems());
        Vector all = s.toVector();
        this.whereTable.setColumnDropDown(1, all, all, true);
        Vector<String> computedFields = this.getComputedFields(s);
        this.havingTable.setColumnDropDown(1, computedFields, computedFields, true);
    }

    private Vector<String> getComputedFields(Section s) {
        if (s == null || s.size() == 0) {
            return new Vector<String>();
        }
        Vector<String> computedFields = new Vector<String>();
        int i = 0;
        while (i < s.size()) {
            String exp = s.getSection(i);
            String[] exps = this.parseComputedField(exp);
            if (StringUtils.isValidString(exps[0])) {
                computedFields.add(exp);
            }
            ++i;
        }
        return computedFields;
    }

    private Vector<String> getNormalFields(Section s) {
        if (s == null || s.size() == 0) {
            return new Vector<String>();
        }
        Vector<String> fields = new Vector<String>();
        int i = 0;
        while (i < s.size()) {
            String exp = s.getSection(i);
            String[] exps = this.parseComputedField(exp);
            if (!StringUtils.isValidString(exps[0])) {
                fields.add(exp);
            }
            ++i;
        }
        return fields;
    }

    void jButtonOR_actionPerformed(ActionEvent e) {
        this.setSelectedSortItems((String)this.orderComboLeft.x_getSelectedItem(), this.orderListLeft, this.orderListRight);
    }

    void jButtonOL_actionPerformed(ActionEvent e) {
        this.orderListRight.removeSelectedItems();
    }

    void messageBox(String text) {
        GM.messageDialog(this, text, this.mm.getMessage("dialogsqlsrcdata.prompt"), 2);
    }

    private String getWhere(JTableEx table) {
        table.acceptText();
        int c = table.getRowCount();
        if (c == 0) {
            return "";
        }
        StringBuffer where = new StringBuffer();
        int i = 0;
        while (i < c) {
            Object connect;
            Object val;
            Object opt;
            Object field = table.data.getValueAt(i, 1);
            if (field != null && (opt = table.data.getValueAt(i, 2)) != null && (val = table.data.getValueAt(i, 3)) != null && ((connect = table.data.getValueAt(i, 4)) != null || i == c - 1)) {
                where.append(" ");
                where.append(field);
                where.append(" ");
                where.append(opt);
                where.append(" ");
                where.append(val);
                if (i != c - 1) {
                    where.append(" ");
                    where.append(connect);
                }
            }
            ++i;
        }
        if (where.length() == 0) {
            return "";
        }
        String whereStr = where.toString().trim();
        String lastOpt = null;
        if (whereStr.endsWith("and")) {
            lastOpt = "and";
        } else if (whereStr.endsWith("or")) {
            lastOpt = "or";
        }
        if (lastOpt != null) {
            whereStr = whereStr.substring(0, whereStr.length() - lastOpt.length());
        }
        return whereStr.trim();
    }

    private String generateSql(int tabIndex) {
        String sSql = this.jTextPaneSql.getText();
        switch (tabIndex) {
            case 0: {
                break;
            }
            case 1: {
                Section selects = new Section(this.selectListRight.totalItems(), ',', false, false);
                selects.removeSection("*");
                String sTmp = selects.toString();
                if (!StringUtils.isValidString(sTmp)) {
                    sTmp = "*";
                }
                sSql = GM.modifySql(sSql, sTmp, "s");
                break;
            }
            case 2: 
            case 3: {
                String where1 = this.getWhere(this.whereTable);
                String where2 = this.getWhere(this.joinTable);
                if (StringUtils.isValidString(where1)) {
                    if (StringUtils.isValidString(where2)) {
                        where1 = "(" + where1 + ") and (" + where2 + ")";
                    }
                } else if (StringUtils.isValidString(where2)) {
                    where1 = where2;
                }
                sSql = GM.modifySql(sSql, where1, "w");
                break;
            }
            case 4: {
                Section selects = new Section(this.groupListRight.totalItems(), ',', false, false);
                String sTmp = selects.toString();
                sSql = GM.modifySql(sSql, sTmp, "g");
                break;
            }
            case 5: {
                String sTmp = this.getWhere(this.havingTable);
                sSql = GM.modifySql(sSql, sTmp, "h");
                break;
            }
            case 6: {
                Section selects = new Section(this.orderListRight.totalItems(), ',', false, false);
                String sTmp = selects.toString();
                sSql = GM.modifySql(sSql, sTmp, "o");
                break;
            }
            case 7: {
                return sSql;
            }
        }
        this.jTextPaneSql.setText(sSql.trim());
        return sSql;
    }

    void jTextPaneSql_keyReleased(KeyEvent e) {
        this.bEditByHand = true;
    }

    void jCBSchema_actionPerformed(ActionEvent e) {
        if (this.afterInit) {
            this.refreshTables();
        }
    }

    void groupR_actionPerformed(ActionEvent e) {
        this.setSelectedItems((String)this.groupComboLeft.x_getSelectedItem(), this.groupListLeft, this.groupListRight);
    }

    void groupL_actionPerformed(ActionEvent e) {
        this.groupListRight.removeSelectedItems();
    }

    class FKMap {
        Section fkNames = new Section();
        Section pkNames = new Section();

        public void add(String fkName, String pkName) {
            int index = this.fkNames.indexOf(fkName);
            if (index > -1) {
                this.pkNames.replaceSection(index, pkName);
            } else {
                this.fkNames.addSection(fkName);
                this.pkNames.addSection(pkName);
            }
        }

        public String getFKName(int i) {
            return this.fkNames.getSection(i);
        }

        public String getPKName(int i) {
            return this.pkNames.getSection(i);
        }

        public int size() {
            return this.fkNames == null ? 0 : this.fkNames.size();
        }

        public void addAll(FKMap map) {
            if (map == null) {
                return;
            }
            int i = 0;
            while (i < map.size()) {
                this.add(map.getFKName(i), map.getPKName(i));
                ++i;
            }
        }
    }

    class ProcessWindow
    extends JWindow {
        private static final long serialVersionUID = 1L;
        private JProgressBar bar;

        ProcessWindow() {
            super(DialogSQLEditor.this);
            this.setSize(350, 60);
            this.bar = new JProgressBar(0, 0, 100);
            this.bar.setStringPainted(false);
            this.bar.setValue(0);
            this.bar.setMinimumSize(new Dimension(1, 20));
            JPanel panelMain = new JPanel(new BorderLayout());
            panelMain.setBorder(BorderFactory.createLineBorder(Color.black));
            JPanel panelCenter = new JPanel(new GridBagLayout());
            panelCenter.add((Component)new JLabel(IdeCommonMessage.get().getMessage("dialogsqleditor.loadds")), GM.getGBC(0, 0, true));
            panelMain.add((Component)panelCenter, "Center");
            panelMain.add((Component)this.bar, "North");
            this.getContentPane().add(panelMain);
            this.bar.setIndeterminate(true);
        }

        public void disposeWindow() {
            this.bar.setIndeterminate(false);
            this.bar.setValue(100);
            super.dispose();
        }
    }

    class TabChangeListener
    implements ChangeListener {
        int oldIndex = 0;

        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            switch (this.oldIndex) {
                case 0: {
                    DialogSQLEditor.this.currentFrom = DialogSQLEditor.this.fromListRight.totalItems();
                    try {
                        DialogSQLEditor.this.updateTableName(DialogSQLEditor.this.currentFrom);
                    }
                    catch (Exception x) {
                        Logger.debug(x);
                    }
                    break;
                }
                case 7: {
                    if (!DialogSQLEditor.this.bEditByHand) break;
                    DialogSQLEditor.this.bEditByHand = false;
                    break;
                }
                default: {
                    DialogSQLEditor.this.generateSql(this.oldIndex);
                }
            }
            this.oldIndex = DialogSQLEditor.this.jTabbedPaneSql.getSelectedIndex();
        }
    }

    class TableChanged
    implements ItemListener {
        private DialogSQLEditor executor = null;

        public TableChanged(DialogSQLEditor executor) {
            this.executor = executor;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            int state = event.getStateChange();
            if (state != 1 || this.executor == null) {
                return;
            }
            JComboBoxEx jcb = (JComboBoxEx)event.getSource();
            try {
                this.executor.changeSelectTable((String)jcb.x_getSelectedItem());
            }
            catch (Exception x) {
                GM.showException(DialogSQLEditor.this, x);
            }
        }
    }
}

