/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.function;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.function.EditingFuncParam;
import com.scudata.ide.common.function.EditingText;
import com.scudata.ide.common.function.FuncInfo;
import java.util.ArrayList;
import javax.swing.text.JTextComponent;

public class EditingFuncInfo {
    private String funcName;
    private String funcOption;
    private EditingFuncParam funcParam;
    private byte majorType = (byte)102;
    private Object majorValue;
    private FuncInfo funcInfo;
    private JTextComponent editor;
    private String oldExp;
    private int funcStart;
    private int funcEnd;

    public EditingFuncInfo(JTextComponent editor, String funcName, String funcOption, EditingFuncParam funcParam, int funcStart, int funcEnd) {
        this.editor = editor;
        this.oldExp = editor.getText();
        this.funcName = funcName;
        this.funcOption = funcOption;
        this.funcParam = funcParam;
        this.funcStart = funcStart;
        this.funcEnd = funcEnd;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncOption(String funcOption) {
        this.funcOption = funcOption;
        this.refreshEditor();
    }

    public String getFuncOption() {
        return this.funcOption;
    }

    public void setFuncParam(EditingFuncParam funcParam) {
        this.funcParam = funcParam;
        this.refreshEditor();
    }

    public EditingFuncParam getFuncParam() {
        return this.funcParam;
    }

    public void setMajorType(byte type) {
        this.majorType = type;
    }

    public byte getMajorType() {
        return this.majorType;
    }

    public void setMajorValue(Object value) {
        this.majorValue = value;
    }

    public Object getMajorValue() {
        return this.majorValue;
    }

    public void setFuncInfo(FuncInfo funcInfo) {
        this.funcInfo = funcInfo;
    }

    public FuncInfo getFuncInfo() {
        return this.funcInfo;
    }

    public int getFuncStart() {
        return this.funcStart;
    }

    public int getFuncOptionStart() {
        return this.funcStart + this.funcName.length() + 1;
    }

    public int getFuncParamStart() {
        return this.funcStart + this.getPreFuncString().length() + 1;
    }

    private StringBuffer getPreFuncString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.funcName);
        if (StringUtils.isValidString(this.funcOption)) {
            sb.append("@");
            sb.append(this.funcOption);
        }
        return sb;
    }

    public String toString() {
        StringBuffer sb = this.getPreFuncString();
        if (StringUtils.isValidString(this.funcParam)) {
            sb.append("(");
            sb.append(this.funcParam);
            sb.append(")");
        } else {
            sb.append("()");
        }
        return sb.toString();
    }

    public void appendEditingText(ArrayList<EditingText> container) {
        container.add(new EditingText(this.getPreFuncString().toString()));
        if (this.funcParam != null) {
            container.add(new EditingText("(", EditingText.STYLE_HIGHLIGHT));
            this.funcParam.appendEditingText(container);
            container.add(new EditingText(")", EditingText.STYLE_HIGHLIGHT));
        } else {
            container.add(new EditingText("()"));
        }
    }

    public void refreshEditor() {
        int caretPos = this.editor.getCaretPosition();
        int ss = this.editor.getSelectionStart();
        int se = this.editor.getSelectionEnd();
        ArrayList<EditingText> container = new ArrayList<EditingText>();
        container.add(new EditingText(this.oldExp.substring(0, this.funcStart)));
        this.appendEditingText(container);
        container.add(new EditingText(this.oldExp.substring(this.funcEnd)));
        this.editor.setCaretPosition(caretPos);
        this.editor.setSelectionStart(ss);
        this.editor.setSelectionEnd(se);
    }
}

