/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.JTableEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AllPurposeEditor
extends DefaultCellEditor
implements KeyListener,
MouseListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private JTableEx parent;
    private JTextField textField;
    private Object value;

    public AllPurposeEditor(JTextField tf, JTableEx parent) {
        super(tf);
        this.textField = tf;
        tf.addKeyListener(this);
        tf.addFocusListener(this);
        tf.addMouseListener(this);
        this.textField.setFont(parent.getFont());
        tf.setBorder(BorderFactory.createEmptyBorder());
        this.parent = parent;
        this.setClickCountToStart(1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent editor = (JComponent)e.getSource();
        Container ct = editor.getTopLevelAncestor();
        int absoluteX = e.getX() + editor.getX();
        int absoluteY = e.getY() + editor.getY();
        Container p = editor.getParent();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.parent.fireClicked(absoluteX, absoluteY, e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.parent.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public Object getCellEditorValue() {
        String editorText = this.textField.getText();
        if (editorText.equals(GM.renderValueText(this.value))) {
            return this.value;
        }
        return editorText;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.textField.isEditable();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        this.textField.setText(GM.renderValueText(value));
        Color bc = table.getBackground();
        this.textField.setBackground(bc);
        return this.textField;
    }
}

