/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Object color;
    private final int w = 37;
    private final int h = 15;

    public ColorIcon() {
        this(Color.gray, 0, 0);
    }

    public ColorIcon(Color color, int w, int h) {
        this.color = color;
    }

    public static void fillTransparent(Graphics g, int w, int h, int L) {
        g.setColor(Color.gray);
        g.fillRect(1, 1, w - 2, h - 2);
        g.setColor(Color.white);
        int x = 1;
        int y = 1;
        int r = 0;
        while (y < h) {
            x = r % 2 == 0 ? 1 : 1 + L;
            while (x < w) {
                g.fillRect(x, y, L, L);
                x += L * 2;
            }
            ++r;
            y += L;
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color instanceof String) {
            g.setColor(Color.white);
            g.fillRect(0, 0, 1000, 1000);
            g.setColor(Color.black);
            g.drawString((String)this.color, 2, 14);
        } else {
            g.translate(x, y);
            Color cc = null;
            if (this.color instanceof Color) {
                cc = (Color)this.color;
            } else if (this.color instanceof Integer) {
                cc = new Color((Integer)this.color, true);
            }
            if (cc == null || cc.getAlpha() == 0) {
                ColorIcon.fillTransparent(g, 37, 15, 4);
            } else {
                g.setColor(cc);
                g.fillRect(1, 1, 35, 13);
            }
            g.setColor(Color.black);
            g.drawRect(0, 0, 36, 14);
            g.translate(-x, -y);
        }
    }

    public Color getColor() {
        if (this.color instanceof Color) {
            return (Color)this.color;
        }
        return null;
    }

    public void setColor(Object color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return 37;
    }

    @Override
    public int getIconHeight() {
        return 15;
    }
}

