/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.app.common.Section;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.MonthlyCalendar;
import com.scudata.ide.common.swing.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DatetimeChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private Calendar calendar;
    private Calendar retCal;
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;
    private MonthlyCalendar monthCalendar;
    private JSpinner jSpinH;
    private JSpinner jSpinM;
    private JSpinner jSpinS;

    public DatetimeChooser() {
        this.init();
    }

    public DatetimeChooser(Dialog owner) {
        super(owner);
        this.init();
    }

    public DatetimeChooser(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DatetimeChooser(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public DatetimeChooser(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DatetimeChooser(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DatetimeChooser(Frame owner) {
        super(owner);
        this.init();
    }

    public DatetimeChooser(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DatetimeChooser(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public DatetimeChooser(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DatetimeChooser(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public void initDate(Calendar calendar) {
        int m = calendar.get(2);
        this.jComboBox1.setSelectedIndex(m);
        this.jSpinner1.setValue(calendar.getTime());
        this.monthCalendar.setYearMonth(calendar);
        this.jSpinH.setValue(new Integer(calendar.get(10)));
        this.jSpinM.setValue(new Integer(calendar.get(12)));
        this.jSpinS.setValue(new Integer(calendar.get(13)));
    }

    private void init() {
        this.initComponents();
        this.calendar = Calendar.getInstance();
        this.initDate(this.calendar);
    }

    private void initComponents() {
        JPanel basePanel = new JPanel();
        JPanel containerPanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jSpinner1 = new JSpinner();
        JPanel viewPanel = new JPanel();
        this.monthCalendar = new MonthlyCalendar(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void dateSelected() {
                DatetimeChooser.this.doSelection();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle(this.mm.getMessage("datechooser.selectdate"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DatetimeChooser.this.formWindowClosing(evt);
            }
        });
        basePanel.setLayout(new VFlowLayout());
        basePanel.setBackground(new Color(252, 250, 252));
        containerPanel.setLayout(new BorderLayout());
        containerPanel.setBorder(new TitledBorder(this.mm.getMessage("datechooser.date")));
        containerPanel.setOpaque(false);
        controlPanel.setLayout(new FlowLayout(1, 12, 0));
        controlPanel.setBorder(new EmptyBorder(new Insets(5, 0, 10, 0)));
        controlPanel.setOpaque(false);
        this.jComboBox1.setMaximumRowCount(7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new Section(this.mm.getMessage("datechooser.month")).toStringArray()));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DatetimeChooser.this.jComboBox1ItemStateChanged(evt);
            }
        });
        controlPanel.add(this.jComboBox1);
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "yyyy"));
        this.jSpinner1.setPreferredSize(this.jComboBox1.getPreferredSize());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DatetimeChooser.this.jSpinner1StateChanged(evt);
            }
        });
        controlPanel.add(this.jSpinner1);
        containerPanel.add((Component)controlPanel, "North");
        viewPanel.setLayout(new FlowLayout(1, 0, 0));
        viewPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        viewPanel.setOpaque(false);
        this.monthCalendar.setBorder(new BevelBorder(1));
        viewPanel.add(this.monthCalendar);
        containerPanel.add((Component)viewPanel, "Center");
        basePanel.add(containerPanel);
        this.getContentPane().add((Component)basePanel, "Center");
        JPanel timePanel = new JPanel();
        timePanel.setBackground(new Color(252, 250, 252));
        timePanel.setBorder(new TitledBorder(this.mm.getMessage("datetimechooser.time")));
        timePanel.setOpaque(false);
        timePanel.setLayout(new GridLayout(1, 3));
        JLabel labelH = new JLabel(this.mm.getMessage("datetimechooser.h"));
        JLabel labelM = new JLabel(this.mm.getMessage("datetimechooser.m"));
        JLabel labelS = new JLabel(this.mm.getMessage("datetimechooser.s"));
        labelH.setBackground(new Color(252, 250, 252));
        labelM.setBackground(new Color(252, 250, 252));
        labelS.setBackground(new Color(252, 250, 252));
        this.jSpinH = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        this.jSpinM = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.jSpinS = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        JPanel panelH = new JPanel(new BorderLayout());
        panelH.add((Component)this.jSpinH, "Center");
        panelH.add((Component)labelH, "East");
        JPanel panelM = new JPanel(new BorderLayout());
        panelM.add((Component)this.jSpinM, "Center");
        panelM.add((Component)labelM, "East");
        JPanel panelS = new JPanel(new BorderLayout());
        panelS.add((Component)this.jSpinS, "Center");
        panelS.add((Component)labelS, "East");
        timePanel.add(panelH);
        timePanel.add(panelM);
        timePanel.add(panelS);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 10, 10));
        bottomPanel.setBackground(new Color(252, 250, 252));
        bottomPanel.add(timePanel);
        basePanel.add(bottomPanel);
        JPanel panelButton = new JPanel(new VFlowLayout());
        JButton jBOK = new JButton();
        jBOK.setMnemonic('O');
        jBOK.setText(this.mm.getMessage("button.ok"));
        jBOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatetimeChooser.this.okActionPerformed();
            }
        });
        JButton jBCancel = new JButton();
        jBCancel.setMnemonic('C');
        jBCancel.setText(this.mm.getMessage("button.cancel"));
        jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatetimeChooser.this.cancelActionPerformed();
            }
        });
        panelButton.add(jBOK);
        panelButton.add(jBCancel);
        panelButton.setBackground(new Color(252, 250, 252));
        this.getContentPane().add((Component)panelButton, "East");
        this.pack();
    }

    private void okActionPerformed() {
        if (this.monthCalendar.getSelectedIndex() < 0) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("datetimechooser.notselect"));
            return;
        }
        GM.setWindowDimension(this);
        this.dispose();
    }

    private void cancelActionPerformed() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Date date = (Date)this.jSpinner1.getValue();
        this.calendar.setTime(date);
        this.monthCalendar.setYear(this.calendar.get(1));
        this.monthCalendar.repaint();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        this.monthCalendar.setMonth(this.jComboBox1.getSelectedIndex() + 1);
        this.monthCalendar.repaint();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.retCal = null;
    }

    @Override
    public void setVisible(boolean b) {
        this.monthCalendar.resetHighlight();
        super.setVisible(b);
    }

    private void doSelection() {
        this.retCal = this.monthCalendar.getSelectedDate();
    }

    public Calendar getSelectedDatetime() {
        int h = (Integer)this.jSpinH.getValue();
        int m = (Integer)this.jSpinM.getValue();
        int s = (Integer)this.jSpinS.getValue();
        this.retCal.set(this.retCal.get(1), this.retCal.get(2), this.retCal.get(5), h, m, s);
        return this.retCal;
    }

    public void setYearMonth(int y, int m) {
        if (y < 1970) {
            throw new IllegalArgumentException(this.mm.getMessage("datechooser.err1"));
        }
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException(this.mm.getMessage("datechooser.err2"));
        }
        this.jComboBox1.setSelectedIndex(m - 1);
        this.calendar.set(1, y);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.monthCalendar.setWeekStartOnSunday(b);
    }

    public boolean getWeekStartOnSunday() {
        return this.monthCalendar.getWeekStartOnSunday();
    }
}

