/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.swing.ICellComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ESPasswordBoxRenderer
implements TableCellRenderer,
ICellComponent {
    private JPasswordField pw1 = new JPasswordField();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.getCellComponent(value);
        CellAppr appr = this.getCellAppr(table, isSelected);
        return appr.apply(c);
    }

    @Override
    public Component getCellComponent(Object value) {
        if (value != null) {
            if (StringUtils.isValidString(value)) {
                this.pw1.setText((String)value);
            } else {
                try {
                    this.pw1.setText(String.valueOf(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.pw1;
    }

    @Override
    public void setCellEditable(boolean editable) {
    }

    @Override
    public String getStringValue() {
        return "";
    }

    public CellAppr getCellAppr(JTable table, boolean isSelected) {
        CellAppr appr = new CellAppr();
        if (isSelected) {
            appr.setForeground(table.getSelectionForeground());
            appr.setBackground(table.getSelectionBackground());
        } else {
            appr.setForeground(table.getForeground());
            appr.setBackground(table.getBackground());
        }
        return appr;
    }

    class CellAppr {
        private Color foreground = Color.black;
        private Color background = Color.white;
        private Font font;

        public CellAppr() {
        }

        public CellAppr(Color foreground, Color background) {
            this.foreground = foreground;
            this.background = background;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setForeground(Color c) {
            this.foreground = c;
        }

        public void setBackground(Color c) {
            this.background = c;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public Component apply(Component c) {
            if (c instanceof Container) {
                Container con = (Container)c;
                if (con.getComponentCount() == 0) {
                    c.setForeground(this.getForeground());
                    c.setBackground(this.getBackground());
                    if (this.font != null) {
                        c.setFont(this.font);
                    }
                } else {
                    Component[] cons = con.getComponents();
                    int i = 0;
                    while (i < cons.length) {
                        this.apply(cons[i]);
                        ++i;
                    }
                }
            } else {
                c.setForeground(this.getForeground());
                c.setBackground(this.getBackground());
                if (this.font != null) {
                    c.setFont(this.font);
                }
            }
            return c;
        }
    }
}

