/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.ide.common.swing.FreeConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class FreeLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private Hashtable<Component, FreeConstraints> hashtable = new Hashtable();
    private static final FreeConstraints DEFAULT_CONSTRAINTS = new FreeConstraints();

    public FreeLayout() {
    }

    public FreeLayout(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String toString() {
        return "[width=" + this.width + ",height=" + this.height + "]";
    }

    @Override
    public void addLayoutComponent(String s, Component component1) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.hashtable.remove(c);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int count = container.getComponentCount();
        int i = 0;
        while (i < count) {
            Component c = container.getComponent(i);
            if (c.isVisible()) {
                Rectangle r = this.getComponentBounds(c, true);
                c.setBounds(insets.left + r.x, insets.top + r.y, r.width, r.height);
            }
            ++i;
        }
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (constraints instanceof FreeConstraints) {
            this.hashtable.put(c, (FreeConstraints)constraints);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(100000, 100000);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    Rectangle getComponentBounds(Component c, boolean doPreferred) {
        FreeConstraints constraints = this.hashtable.get(c);
        if (constraints == null) {
            constraints = DEFAULT_CONSTRAINTS;
        }
        Rectangle r = new Rectangle(constraints.x, constraints.y, constraints.w, constraints.h);
        if (r.width <= 0 || r.height <= 0) {
            Dimension d;
            Dimension dimension = d = doPreferred ? c.getPreferredSize() : c.getMinimumSize();
            if (r.width <= 0) {
                r.width = d.width;
            }
            if (r.height <= 0) {
                r.height = d.height;
            }
        }
        return r;
    }

    Dimension getLayoutSize(Container container, boolean doPreferred) {
        Dimension dim = new Dimension(1, 1);
        if (this.width <= 0 || this.height <= 0) {
            int count = container.getComponentCount();
            int i = 0;
            while (i < count) {
                Component c = container.getComponent(i);
                if (c.isVisible()) {
                    Rectangle r = this.getComponentBounds(c, doPreferred);
                    dim.width = Math.max(dim.width, r.x + r.width);
                    dim.height = Math.max(dim.height, r.y + r.height);
                }
                ++i;
            }
        }
        if (this.width > 0) {
            dim.width = this.width;
        }
        if (this.height > 0) {
            dim.height = this.height;
        }
        Insets insets = container.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }
}

