/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.spl.control.ControlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JLabelUnderLine
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Color underLineColor = Color.BLUE;
    Object value = null;
    String dispText = null;

    public JLabelUnderLine() {
        super("");
        this.setBackground(new JTextField().getBackground());
        this.setBorder(null);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setDispText(String dispText) {
        this.dispText = dispText;
    }

    public Color getUnderLineColor() {
        return this.underLineColor;
    }

    public void setUnderLineColor(Color pUnderLineColor) {
        this.underLineColor = pUnderLineColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        byte halign;
        super.paintComponent(g);
        int width = this.getWidth();
        if (width <= 0) {
            return;
        }
        ControlUtils.setGraphicsRenderingHints(g);
        float underLineSize = 0.75f;
        ((Graphics2D)g).setStroke(new BasicStroke(underLineSize));
        boolean underLine = this.value != null && this.value instanceof String;
        switch (this.getHorizontalAlignment()) {
            case 2: {
                halign = 0;
                break;
            }
            case 0: {
                halign = 2;
                break;
            }
            default: {
                halign = 4;
            }
        }
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        int indent = fm.stringWidth(" ");
        ControlUtilsBase.drawText(g, this.dispText, 0, 0, this.getWidth(), this.getHeight(), underLine, halign, (byte)16, font, this.getForeground(), indent, false);
    }
}

