/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.app.common.Section;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.MessageManager;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.CheckBoxRenderer;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JComboBoxExEditor;
import com.scudata.ide.common.swing.JComboBoxExRenderer;
import com.scudata.ide.common.swing.JTableExListener;
import com.scudata.ide.common.swing.JTextAreaEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableEx
extends JTable
implements MouseListener,
JTableExListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    public DefaultTableModel data = new DefaultTableModel();
    private int indexCol = -1;
    private HashMap<Object, TableColumn> columnKeeper = new HashMap();
    private boolean ifFireRowfocusChangedEvent = true;
    public HashSet<JTableExListener> clickedListener = new HashSet();
    private transient HashMap<Integer, String> minimizedColumn = new HashMap();
    public static int ALIGN_LEFT = 2;
    public static int ALIGN_CENTER = 0;
    public static int ALIGN_RIGHT = 4;
    private int oldRow = -1;
    private Color disabledBackColor = Color.lightGray;
    private Color disabledForeColor = Color.black;

    public JTableEx() {
        this.setModel(this.data);
        this.addMouseListener(this);
        this.addTableExListener(this);
        this.getColumnModel().addColumnModelListener(new TableColListener(this));
        this.getTableHeader().setReorderingAllowed(false);
    }

    public JTableEx(String[] colNames) {
        this();
        int i = 0;
        while (i < colNames.length) {
            this.addColumn(colNames[i]);
            this.setColumnDefaultEditor(i);
            ++i;
        }
        this.holdColumnNames();
        this.oldRow = -1;
    }

    public JTableEx(String columnNames) {
        this(new Section(columnNames).toStringArray());
    }

    @Override
    public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    @Override
    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    @Override
    public void clicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    @Override
    public void rowfocusChanged(int oldRow, int newRow) {
    }

    public void rowfocusChanging(int oldRow, int newRow) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Container p = this.getParent();
        Container ct = this.getTopLevelAncestor();
        int absoluteX = e.getX();
        int absoluteY = e.getY();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.fireClicked(absoluteX, absoluteY, e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    void holdColumnNames() {
        if (this.columnKeeper == null) {
            return;
        }
        this.columnKeeper.clear();
        TableColumnModel cm = this.getColumnModel();
        Enumeration<TableColumn> cols = cm.getColumns();
        while (cols.hasMoreElements()) {
            TableColumn tmpCol = cols.nextElement();
            tmpCol.setCellEditor(new SimpleEditor(new JTextField(), this));
            Object tmpName = tmpCol.getIdentifier();
            this.columnKeeper.put(tmpName, tmpCol);
        }
    }

    public void setClickCountToStart(int startCount) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                TableCellEditor editor = this.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(startCount);
                }
                ++col;
            }
            ++row;
        }
    }

    protected boolean isItemDataChanged(int row, int column, Object newValue) {
        if (column == this.indexCol) {
            return false;
        }
        Object oldValue = this.getValueAt(row, column);
        if (oldValue instanceof String && newValue instanceof String) {
            if (StringUtils.isValidString(oldValue)) {
                return !oldValue.equals(newValue);
            }
            return StringUtils.isValidString(newValue);
        }
        if (oldValue != null) {
            return !oldValue.equals(newValue);
        }
        return newValue != null && !newValue.equals("");
    }

    public boolean exportData(boolean exportTitle, FileWriter fw, boolean dosFormat) throws Exception {
        int c;
        String sRow = "";
        String sTmp = "";
        int cc = this.getColumnCount();
        int rc = this.getRowCount();
        String rowSep = dosFormat ? "\r\n" : "\r";
        if (exportTitle) {
            if (cc == 0) {
                return false;
            }
            c = 0;
            while (c < cc) {
                sTmp = String.valueOf(sTmp) + "\t" + this.getColumnName(c);
                ++c;
            }
            sRow = String.valueOf(rowSep) + sTmp.substring(1);
        }
        int r = 0;
        while (r < rc) {
            sTmp = "";
            c = 0;
            while (c < cc) {
                sTmp = String.valueOf(sTmp) + "\t" + this.data.getValueAt(r, c);
                ++c;
            }
            sRow = String.valueOf(sRow) + rowSep + sTmp.substring(1);
            ++r;
        }
        fw.write(sRow.substring(rowSep.length()));
        return true;
    }

    @Override
    public void setModel(TableModel dataModel) {
        this.data = (DefaultTableModel)dataModel;
        super.setModel(this.data);
        this.holdColumnNames();
        this.oldRow = -1;
    }

    public void resetColumns(ArrayList newColNames) {
        this.data.setColumnCount(0);
        int i = 0;
        while (i < newColNames.size()) {
            this.data.addColumn(newColNames.get(i));
            ++i;
        }
        this.holdColumnNames();
    }

    public void acceptText() {
        if (this.getCellEditor() != null && this.getRowCount() > 0) {
            int r = this.getSelectedRow();
            int c = this.getRowCount();
            int e = this.getEditingRow();
            if (e >= c) {
                return;
            }
            this.getCellEditor().stopCellEditing();
        }
    }

    public void addTableExListener(JTableExListener jcl) {
        this.clickedListener.add(jcl);
    }

    public void removeClickedListener(JTableExListener jcl) {
        this.clickedListener.remove(jcl);
    }

    @Override
    public void fireClicked(int xpos, int ypos, MouseEvent e) {
        Iterator<JTableExListener> it = this.clickedListener.iterator();
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.rowAtPoint(new Point(e.getX(), e.getY()));
        }
        int pcol = this.columnAtPoint(new Point(e.getX(), e.getY()));
        if (e.getButton() == 3) {
            if (col != pcol && pcol > -1) {
                col = pcol;
                this.setColumnSelectionInterval(col, col);
            }
        } else if (col == -1) {
            col = pcol;
            this.setColumnSelectionInterval(col, col);
        }
        while (it.hasNext()) {
            JTableExListener lis = it.next();
            if (e.getButton() == 3) {
                lis.rightClicked(xpos, ypos, row, col, e);
                continue;
            }
            if (e.getButton() != 1) continue;
            switch (e.getClickCount()) {
                case 1: {
                    lis.clicked(xpos, ypos, row, col, e);
                    break;
                }
                case 2: {
                    lis.doubleClicked(xpos, ypos, row, col, e);
                    break;
                }
            }
        }
    }

    public void addColumn(String colName) {
        this.data.addColumn(colName);
        this.holdColumnNames();
    }

    public void deleteColumn(TableColumn aColumn) {
        String colName = (String)aColumn.getIdentifier();
        int cc = this.data.getColumnCount();
        DefaultTableModel dataModel = new DefaultTableModel();
        int i = 0;
        while (i < cc) {
            String tmpName = this.data.getColumnName(i);
            if (!tmpName.equalsIgnoreCase(colName)) {
                Vector<Object> cData = this.getColumnData(i);
                dataModel.addColumn((Object)tmpName, cData);
            }
            ++i;
        }
        this.setModel(dataModel);
    }

    public TableColumn getColumn(int columnIndex) {
        return this.getColumnModel().getColumn(columnIndex);
    }

    public int getColumnIndex(String colName) {
        return this.getColumnIndex(colName, false);
    }

    public int getColumnIndex(String colName, boolean includeHideColumns) {
        if (includeHideColumns) {
            int i = 0;
            while (i < this.data.getColumnCount()) {
                String name = this.data.getColumnName(i);
                if (name.equals(colName)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getColumnCount()) {
                String name = this.getColumnName(i);
                if (name.equals(colName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void removeAllRows() {
        this.data.setRowCount(0);
        this.oldRow = -1;
    }

    public Vector<Object> getColumnData(int colIndex) {
        Vector<Object> cData = new Vector<Object>();
        int r = 0;
        while (r < this.data.getRowCount()) {
            cData.add(this.data.getValueAt(r, colIndex));
            ++r;
        }
        return cData;
    }

    public void minimizeColumn(int columnIndex) {
        TableColumn tc = this.getColumn(columnIndex);
        if (tc.getPreferredWidth() == 0) {
            return;
        }
        String oldConfig = String.valueOf(tc.getMaxWidth()) + "|" + tc.getMinWidth() + "|" + tc.getPreferredWidth();
        this.minimizedColumn.put(columnIndex, oldConfig);
        tc.setMaxWidth(0);
        tc.setMinWidth(0);
        tc.setPreferredWidth(0);
        tc.setResizable(false);
    }

    public void recoverColumn(int columnIndex) {
        TableColumn tc = this.getColumn(columnIndex);
        tc.setResizable(true);
        String oldConfig = this.minimizedColumn.get(columnIndex);
        if (oldConfig == null) {
            return;
        }
        ArgumentTokenizer at = new ArgumentTokenizer(oldConfig, '|');
        try {
            tc.setMaxWidth(Integer.parseInt(at.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tc.setMinWidth(Integer.parseInt(at.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tc.setPreferredWidth(Integer.parseInt(at.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hideColumn(String columnName) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        Object id = col.getIdentifier();
        this.columnKeeper.put(id, col);
        this.removeColumn(col);
    }

    public void setColumnEnable(int columnIndex, boolean enable) {
        this.setColumnEnable(this.getColumnName(columnIndex), enable);
    }

    public void setColumnEnable(String columnName, boolean enable) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        TableCellRenderer o = col.getCellRenderer();
        int align = ALIGN_LEFT;
        if (o != null && o instanceof DefaultTableCellRenderer) {
            align = ((DefaultTableCellRenderer)o).getHorizontalAlignment();
        }
        JTextField jtf = new JTextField();
        jtf.setHorizontalAlignment(align);
        if (enable) {
            col.setCellEditor(new DefaultCellEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(align);
            col.setCellRenderer(dtcr);
        } else {
            col.setCellEditor(new DisabledEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(align);
            dtcr.setForeground(this.disabledForeColor);
            dtcr.setBackground(this.disabledBackColor);
            col.setCellRenderer(dtcr);
        }
    }

    public TableCellEditor getColumnEditor(int columnIndex) {
        TableColumn tc = this.getColumn(this.getColumnName(columnIndex));
        return tc.getCellEditor();
    }

    public void setColumnDefaultEditor(int columnIndex) {
        this.setColumnDefaultEditor(this.getColumnName(columnIndex));
    }

    public void setColumnDefaultEditor(String columnName) {
        TableColumn col = this.getColumn(columnName);
        col.setCellEditor(new SimpleEditor(new JTextField(), this));
        DefaultTableCellRenderer dr = new DefaultTableCellRenderer();
        col.setCellRenderer(dr);
    }

    public void setColumnSpinner(int columnIndex) {
        this.setColumnSpinner(this.getColumnName(columnIndex));
    }

    public void setColumnSpinner(String columnName) {
        JTextAreaEditor integerEditor = new JTextAreaEditor(this, 3);
        TableColumn tc = this.getColumn(columnName);
        tc.setCellEditor(integerEditor);
    }

    public void setColumnCheckBox(int columnIndex) {
        this.setColumnCheckBox(this.getColumnName(columnIndex));
    }

    public void setColumnCheckBox(int columnIndex, boolean enable) {
        this.setColumnCheckBox(this.getColumnName(columnIndex), enable);
    }

    public void setColumnCheckBox(String columnName) {
        this.setColumnCheckBox(columnName, true);
    }

    public void setColumnCheckBox(String columnName, final boolean enable) {
        JCheckBox checkBoxEditor = new JCheckBox();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTableEx.this.stateChanged(new ChangeEvent(e.getSource()));
            }
        };
        checkBoxEditor.addActionListener(al);
        checkBoxEditor.setEnabled(enable);
        checkBoxEditor.setHorizontalAlignment(0);
        DefaultCellEditor cellEditor = new DefaultCellEditor(checkBoxEditor){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return enable;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (isSelected) {
                    c.setForeground(table.getSelectionForeground());
                    c.setBackground(table.getSelectionBackground());
                } else {
                    c.setForeground(table.getForeground());
                    c.setBackground(table.getBackground());
                }
                return c;
            }
        };
        CheckBoxRenderer cellRenderer = new CheckBoxRenderer();
        TableColumn col = this.getColumn(columnName);
        col.setCellEditor(cellEditor);
        col.setCellRenderer(cellRenderer);
    }

    public JComboBoxEx setColumnDropDown(int columnIndex, Vector codeItems, Vector dispItems) {
        return this.setColumnDropDown(this.getColumnName(columnIndex), codeItems, dispItems);
    }

    public JComboBoxEx setColumnDropDown(int columnIndex, Vector codeItems, Vector dispItems, boolean editable) {
        this.acceptText();
        return this.setColumnDropDown(this.getColumnName(columnIndex), codeItems, dispItems, editable);
    }

    public JComboBoxEx setColumnDropDown(String columnName, Vector codeItems, Vector dispItems) {
        return this.setColumnDropDown(columnName, codeItems, dispItems, false);
    }

    public JComboBoxEx setColumnDropDown(String columnName, Vector codeItems, Vector dispItems, boolean editable) {
        JComboBoxEx combo = new JComboBoxEx();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeEvent ce = new ChangeEvent(e.getSource());
                JTableEx.this.stateChanged(ce);
            }
        };
        combo.addActionListener(al);
        combo.x_setData(codeItems, dispItems);
        combo.setEditable(editable);
        TableColumn col = this.getColumn(columnName);
        JComboBoxExEditor cellEditor = new JComboBoxExEditor(combo);
        JComboBoxExRenderer cellRenderer = new JComboBoxExRenderer(combo);
        col.setCellEditor(cellEditor);
        col.setCellRenderer(cellRenderer);
        return combo;
    }

    public void setColumnEditable(int columnIndex, boolean allowEdit) {
        this.setColumnEditable(this.getColumnName(columnIndex), allowEdit);
    }

    public void setColumnEditable(int columnIndex, boolean allowEdit, boolean centerAlign) {
        this.setColumnEditable(this.getColumnName(columnIndex), allowEdit, centerAlign);
    }

    public void setColumnEditable(String columnName, boolean allowEdit) {
        this.setColumnEditable(columnName, allowEdit, false);
    }

    public void setColumnEditable(String columnName, boolean allowEdit, final boolean centerAlign) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        if (!allowEdit) {
            TableColumn col = this.getColumn(columnName);
            col.setCellEditor(new JTextAreaEditor(this, 7){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(EventObject anEvent) {
                    return false;
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    if (isSelected) {
                        JTableEx.this.setForeground(table.getSelectionForeground());
                        JTableEx.this.setBackground(table.getSelectionBackground());
                    } else {
                        JTableEx.this.setForeground(table.getForeground());
                        JTableEx.this.setBackground(table.getBackground());
                    }
                    if (centerAlign && c instanceof JLabel) {
                        JLabel text = (JLabel)c;
                        text.setHorizontalAlignment(0);
                    }
                    return c;
                }
            });
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (isSelected) {
                        this.setForeground(table.getSelectionForeground());
                        this.setBackground(table.getSelectionBackground());
                    } else {
                        this.setForeground(table.getForeground());
                        this.setBackground(table.getBackground());
                    }
                    if (c instanceof JLabel) {
                        Font font;
                        JLabel jLabel = (JLabel)c;
                        if (centerAlign) {
                            jLabel.setHorizontalAlignment(0);
                        }
                        if (!ControlUtilsBase.canDisplayText(font = jLabel.getFont(), jLabel.getText())) {
                            font = new Font("Dialog", font.getStyle(), font.getSize());
                            jLabel.setFont(font);
                        }
                    }
                    return c;
                }
            };
            col.setCellRenderer(tcr);
        } else {
            this.setColumnDefaultEditor(columnName);
        }
    }

    public void setColumnFixedWidth(int columnIndex, int width) {
        String columnName = this.getColumnName(columnIndex);
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        col.setPreferredWidth(width);
        col.setMaxWidth(width);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.setColumnWidth(this.getColumnName(columnIndex), width);
    }

    public void setColumnWidth(String columnName, int width) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        col.setPreferredWidth(width);
    }

    public void setColumnAlign(int columnIndex, int alignment) {
        this.setColumnAlign(this.getColumnName(columnIndex), alignment);
    }

    public void setColumnAlign(String columnName, int alignment) {
        TableCellEditor oldEditor;
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        TableCellRenderer oldRender = col.getCellRenderer();
        if (oldRender == null || oldRender != null && oldRender instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer cbRender = new DefaultTableCellRenderer();
            cbRender.setHorizontalAlignment(alignment);
            col.setCellRenderer(cbRender);
        }
        if ((oldEditor = col.getCellEditor()) == null || oldEditor != null && oldEditor instanceof SimpleEditor) {
            JTextField tf = new JTextField();
            tf.setHorizontalAlignment(alignment);
            col.setCellEditor(new SimpleEditor(tf, this));
        }
    }

    public Object[] getRowDataArray(int row) {
        int colCount = this.data.getColumnCount();
        Object[] rowData = new Object[colCount];
        if (row >= 0 && row < this.data.getRowCount()) {
            int i = 0;
            while (i < colCount) {
                rowData[i] = this.data.getValueAt(row, i);
                ++i;
            }
        }
        return rowData;
    }

    public String getRowData(int row) {
        StringBuffer rowData = new StringBuffer(1024);
        Object[] rowVals = this.getRowDataArray(row);
        int i = 0;
        while (i < rowVals.length) {
            Object val = rowVals[i];
            if (val == null) {
                val = "";
            }
            rowData.append(val.toString());
            if (i < rowVals.length - 1) {
                rowData.append("\t");
            }
            ++i;
        }
        return rowData.toString();
    }

    public String getBlockData() {
        StringBuffer sb = new StringBuffer(1024);
        this.acceptText();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isRowSelected(i)) {
                String row = this.getRowData(i);
                sb.append(row);
                if (i < this.getRowCount() - 1) {
                    sb.append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public int setBlockData(String ls_data) {
        this.acceptText();
        if (!StringUtils.isValidString(ls_data)) {
            return -1;
        }
        int r = 0;
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row < 0) {
            row = this.getRowCount() + 1;
        }
        if (col < 0) {
            col = 0;
        }
        ls_data = Sentence.replace(ls_data, "\r\n", "\r", 1);
        ls_data = Sentence.replace(ls_data, "\n", "\r", 1);
        ArgumentTokenizer rows = new ArgumentTokenizer(ls_data, '\r');
        while (rows.hasMoreTokens()) {
            String ls_row = rows.nextToken();
            if (!StringUtils.isValidString(ls_row)) continue;
            if (row >= this.getRowCount()) {
                row = this.addRow();
            }
            int li_col = col;
            int colCount = this.data.getColumnCount();
            ArgumentTokenizer items = new ArgumentTokenizer(ls_row, '\t');
            while (items.hasMoreTokens()) {
                String item = items.nextToken();
                this.data.setValueAt(item, row, li_col);
                if (++li_col == colCount) break;
            }
            ++row;
            ++r;
        }
        return r;
    }

    public void setIndexCol(int indexCol) {
        this.indexCol = indexCol;
        this.setColumnAlign(indexCol, ALIGN_CENTER);
        this.setColumnEditable(indexCol, false, true);
        this.setColumnFixedWidth(indexCol, 40);
    }

    public void resetIndex() {
        if (this.indexCol == -1) {
            return;
        }
        int c = this.getRowCount();
        int i = 0;
        while (i < c) {
            this.data.setValueAt(new Integer(i + 1), i, this.indexCol);
            ++i;
        }
    }

    public boolean verifyColumnData(int colIndex, String colDesc) {
        return this.verifyColumnData(colIndex, colDesc, true);
    }

    public boolean verifyColumnData(int colIndex, String colDesc, boolean caseRepeat) {
        return this.verifyColumnData(colIndex, colDesc, caseRepeat, GV.appFrame);
    }

    public boolean verifyColumnData(int colIndex, String colDesc, boolean caseRepeat, Component parent) {
        return this.verifyColumnData(colIndex, colDesc, true, caseRepeat, parent);
    }

    public boolean verifyColumnData(int colIndex, String colDesc, boolean caseNull, boolean caseRepeat, Component parent) {
        this.acceptText();
        HashSet<String> keys = new HashSet<String>();
        int r = this.getRowCount();
        int nullCount = 0;
        int i = 0;
        while (i < r) {
            String key;
            Object tmp = this.data.getValueAt(i, colIndex);
            String string = key = tmp != null ? tmp.toString() : null;
            if (caseNull && !StringUtils.isValidString(key)) {
                GM.messageDialog(parent, this.mm.getMessage("jtableex.null", String.valueOf(i + 1), colDesc), this.mm.getMessage("public.note"), 2);
                return false;
            }
            if (caseRepeat && keys.contains(key)) {
                GM.messageDialog(parent, this.mm.getMessage("jtableex.repeat", colDesc, key), this.mm.getMessage("public.note"), 2);
                return false;
            }
            if (!StringUtils.isValidString(key)) {
                ++nullCount;
            }
            if (caseRepeat && nullCount > 1) {
                GM.messageDialog(parent, String.valueOf(this.mm.getMessage("jtableex.repeat")) + colDesc + ": " + key, this.mm.getMessage("public.note"), 2);
                return false;
            }
            keys.add(key);
            ++i;
        }
        return true;
    }

    public void setColumnVisible(String colName, boolean vis) {
        if (vis) {
            this.showColumn(colName);
        } else {
            this.hideColumn(colName);
        }
    }

    public int shiftUp() {
        return this.shiftRowUp(-1);
    }

    public int shiftRowUp(int row) {
        int end;
        int start;
        this.acceptText();
        if (row < 0) {
            int[] rows = this.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return -1;
            }
            start = rows[0];
            end = rows[rows.length - 1];
        } else {
            start = row;
            end = row;
        }
        if (start <= 0) {
            return -1;
        }
        this.data.moveRow(start, end, start - 1);
        this.selectRows(start - 1, end - 1);
        this.setEditingRow(start - 1);
        this.oldRow = start - 1;
        this.resetIndex();
        return start - 1;
    }

    public int shiftDown() {
        return this.shiftRowDown(-1);
    }

    public int shiftRowDown(int row) {
        int end;
        int start;
        this.acceptText();
        if (row < 0) {
            int[] rows = this.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return -1;
            }
            start = rows[0];
            end = rows[rows.length - 1];
        } else {
            start = row;
            end = row;
        }
        if (start < 0 || end >= this.getRowCount() - 1) {
            return -1;
        }
        this.data.moveRow(start, end, start + 1);
        this.selectRow(start + 1);
        this.resetIndex();
        return start + 1;
    }

    public void showColumn(String columnName) {
        if (this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.columnKeeper.get(columnName);
        if (col == null) {
            return;
        }
        this.addColumn(col);
    }

    public boolean deleteSelectedRows() {
        this.acceptText();
        int cr = this.getSelectedRow();
        if (cr < 0) {
            return false;
        }
        this.removeCurrentRow();
        int r = this.getRowCount() - 1;
        this.clearSelection();
        if (cr < r) {
            r = cr;
        }
        this.selectRow(r);
        this.resetIndex();
        return true;
    }

    public boolean deleteSelectedRow() {
        this.acceptText();
        int cr = this.getSelectedRow();
        if (cr < 0) {
            return false;
        }
        this.data.removeRow(this.getSelectedRow());
        int r = this.getRowCount() - 1;
        this.clearSelection();
        if (cr < r) {
            r = cr;
        }
        this.selectRow(r);
        this.resetIndex();
        return true;
    }

    public int removeCurrentRow() {
        this.acceptText();
        int cr = 0;
        int i = this.getRowCount();
        while (i >= 0) {
            if (this.isRowSelected(i)) {
                this.data.removeRow(i);
                ++cr;
            }
            --i;
        }
        return cr;
    }

    public int removeRow(int row) {
        if (row < 0) {
            return -1;
        }
        int c = this.data.getRowCount();
        if (row >= c) {
            return -1;
        }
        this.data.removeRow(row);
        int t = this.getRowCount();
        if (t == row) {
            --row;
        }
        this.selectRow(row);
        this.setEditingRow(row);
        return row;
    }

    public void selectRow(int row) {
        DefaultListSelectionModel selectModel = new DefaultListSelectionModel();
        selectModel.addSelectionInterval(row, row);
        this.setSelectionModel(selectModel);
        this.setEditingRow(row);
        int n = row;
        this.fireRowfocusChanged(this.oldRow, row);
        this.oldRow = n;
    }

    void selectRows(int start, int end) {
        DefaultListSelectionModel selectModel = new DefaultListSelectionModel();
        selectModel.addSelectionInterval(start, end);
        this.setSelectionModel(selectModel);
    }

    public void selectRows(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        DefaultListSelectionModel selectModel = new DefaultListSelectionModel();
        int i = 0;
        while (i < rows.length) {
            selectModel.addSelectionInterval(rows[i], rows[i]);
            ++i;
        }
        this.setSelectionModel(selectModel);
    }

    public void selectCols(int[] cols) {
        if (cols == null || cols.length == 0) {
            return;
        }
        this.setColumnSelectionInterval(cols[0], cols[cols.length - 1]);
    }

    public void selectCol(int col) {
        this.setColumnSelectionInterval(col, col);
    }

    public int searchValue(Object value, int searchColumn) {
        int i = 0;
        while (i < this.getRowCount()) {
            Object o = this.getValueAt(i, searchColumn);
            if (value.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int searchName(String name, int searchColumn, boolean caseSens) {
        int i = 0;
        while (i < this.getRowCount()) {
            Object o = this.getValueAt(i, searchColumn);
            if (caseSens ? name.equals(o) : StringUtils.isValidString(o) && name.equalsIgnoreCase((String)o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addRow() {
        return this.addRow(true);
    }

    public int addRow(boolean resetIndex) {
        return this.insertRow(-1, null, resetIndex);
    }

    public int addRow(Object[] oa) {
        return this.addRow(oa, true);
    }

    public int addRow(Object[] oa, boolean resetIndex) {
        return this.insertRow(-1, oa, resetIndex);
    }

    public int insertRow(int row, Object[] rowData) {
        return this.insertRow(row, rowData, true);
    }

    public int insertRow(int row, Object[] rowData, boolean resetIndex) {
        int r;
        this.acceptText();
        if (row > -1 && row < this.data.getRowCount()) {
            this.data.insertRow(row, rowData);
            r = row;
        } else {
            this.data.addRow(rowData);
            r = this.data.getRowCount() - 1;
        }
        if (resetIndex) {
            this.setEditingRow(r);
            this.resetIndex();
            this.selectRow(r);
        }
        return r;
    }

    public boolean isColumnVisible(Object column) {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn tc = cm.getColumn(i);
            if (tc.getIdentifier().equals(column)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireRowfocusChanged(int oldRow, int newRow) {
        if (!this.ifFireRowfocusChangedEvent) {
            return;
        }
        Iterator<JTableExListener> it = this.clickedListener.iterator();
        if (oldRow >= this.getRowCount()) {
            oldRow = -1;
        }
        while (it.hasNext()) {
            JTableExListener lis = it.next();
            lis.rowfocusChanged(oldRow, newRow);
        }
        this.resizeAndRepaint();
    }

    public void disableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = false;
    }

    public void enableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int r = this.getSelectedRow();
        if (r < 0) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        int n = r;
        if (n == this.oldRow) {
            return;
        }
        this.fireRowfocusChanged(this.oldRow, r);
        this.oldRow = n;
    }

    public void setDisabledColor(Color foreColor, Color backColor) {
        this.disabledForeColor = foreColor;
        this.disabledBackColor = backColor;
    }

    public void focusGained(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public DefaultCellEditor getDefaultCellEditor(JTextField tf, JTableEx parent) {
        return new SimpleEditor(tf, parent);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    class DisabledEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public DisabledEditor(JTextField jTxt) {
            super(jTxt);
            jTxt.setBackground(JTableEx.this.disabledBackColor);
            jTxt.setEditable(false);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    }

    class SimpleEditor
    extends DefaultCellEditor
    implements KeyListener,
    MouseListener,
    FocusListener {
        private static final long serialVersionUID = 1L;
        JTableEx parent;

        public SimpleEditor(JTextField tf, JTableEx parent) {
            super(tf);
            tf.addKeyListener(this);
            tf.addFocusListener(this);
            tf.addMouseListener(this);
            tf.setBorder(BorderFactory.createEmptyBorder());
            this.parent = parent;
            this.setClickCountToStart(1);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JComponent editor = (JComponent)e.getSource();
            Container ct = editor.getTopLevelAncestor();
            int absoluteX = e.getX() + editor.getX();
            int absoluteY = e.getY() + editor.getY();
            Container p = editor.getParent();
            while (p != ct) {
                absoluteX += p.getX();
                absoluteY += p.getY();
                p = p.getParent();
            }
            this.parent.fireClicked(absoluteX, absoluteY, e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.parent.focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.parent.keyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e != null) {
                JTextField txt;
                Object src = e.getSource();
                if (src instanceof JTextField && !(txt = (JTextField)src).isEditable()) {
                    return;
                }
                JTableEx.this.stateChanged(new ChangeEvent(src));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class TableColListener
    implements TableColumnModelListener {
        JTableEx table;

        public TableColListener(JTableEx table) {
            this.table = table;
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.table.acceptText();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

