/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.ide.common.EditListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class JTextFieldReadOnly
extends JTextField {
    private static final long serialVersionUID = 1L;

    public JTextFieldReadOnly() {
        this(0);
    }

    public JTextFieldReadOnly(int columns) {
        this(new String(), columns);
    }

    public JTextFieldReadOnly(String s) {
        this(s, 0);
    }

    public JTextFieldReadOnly(String s, int columns) {
        this(s, columns, null);
    }

    public JTextFieldReadOnly(String s, int columns, final EditListener el) {
        super(s, columns);
        this.setEditable(el != null);
        if (el != null) {
            KeyListener kl = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    Object src;
                    if (e != null && (src = e.getSource()) instanceof JTextField) {
                        JTextField txt = (JTextField)src;
                        if (!txt.isEditable()) {
                            return;
                        }
                        if (e.isControlDown() || e.isAltDown() || e.isShiftDown()) {
                            return;
                        }
                        if (e.isActionKey()) {
                            return;
                        }
                        if (e.getKeyCode() < 32) {
                            return;
                        }
                        String newTxt = txt.getText();
                        Object newVal = PgmNormalCell.parseConstValue(newTxt);
                        el.editChanged(newVal);
                    }
                }
            };
            this.addKeyListener(kl);
        }
        this.addFocusListener(new FocusListener(){
            int caretPosition = 0;

            @Override
            public void focusGained(FocusEvent e) {
                if (!JTextFieldReadOnly.this.getCaret().isVisible()) {
                    JTextFieldReadOnly.this.getCaret().setVisible(true);
                    JTextFieldReadOnly.this.setCaretPosition(this.caretPosition);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (JTextFieldReadOnly.this.getCaretPosition() > 0) {
                    this.caretPosition = JTextFieldReadOnly.this.getCaretPosition();
                }
            }
        });
    }
}

