/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.CellLocation;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.common.swing.SPLTokenMaker;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.control.JWindowNames;
import com.scudata.ide.spl.control.SplControl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public class RSyntaxTextAreaEx
extends RSyntaxTextArea {
    private static final long serialVersionUID = 1L;
    protected volatile boolean preventChanged = false;
    private final int STYLE_MAX_LENGTH = 100000;
    private MutableAttributeSet[] as = new MutableAttributeSet[REF_COLORS.length];
    private static final Color REF_COLOR1 = RSyntaxTextAreaEx.getLightColor(Color.BLUE);
    private static final Color REF_COLOR2 = RSyntaxTextAreaEx.getLightColor(Color.RED);
    private static final Color REF_COLOR3 = RSyntaxTextAreaEx.getLightColor(Color.PINK);
    private static final Color REF_COLOR4 = RSyntaxTextAreaEx.getLightColor(Color.GREEN);
    private static final Color REF_COLOR5 = RSyntaxTextAreaEx.getLightColor(Color.MAGENTA);
    private static final Color REF_COLOR6 = RSyntaxTextAreaEx.getLightColor(Color.ORANGE);
    private static final Color REF_COLOR7 = RSyntaxTextAreaEx.getLightColor(Color.CYAN);
    private static final Color[] REF_COLORS = new Color[]{REF_COLOR1, REF_COLOR2, REF_COLOR3, REF_COLOR4, REF_COLOR5, REF_COLOR6, REF_COLOR7};
    private final int SEARCH_FLAG = 10;
    private List<INormalCell> refCells = new ArrayList<INormalCell>();

    public RSyntaxTextAreaEx() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RSyntaxTextAreaEx.this.docUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RSyntaxTextAreaEx.this.docUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RSyntaxTextAreaEx.this.docUpdate();
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                RSyntaxTextAreaEx.this.caretChanged(e.getDot());
            }
        });
        this.setHighlightCurrentLine(false);
        this.setTabSize(10);
    }

    public void setPreventChange(boolean preventChanged) {
        this.preventChanged = preventChanged;
    }

    protected void docUpdate() {
        if (this.preventChanged) {
            return;
        }
        this.setStyleText(true);
    }

    public void checkFont() {
        try {
            Font font = this.getFont();
            if (!this.canDisplayText()) {
                font = new Font("Dialog", font.getStyle(), font.getSize());
                super.setFont(font);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFont(Font font) {
        if (this.preventChanged) {
            return;
        }
        if (!this.canDisplayText()) {
            font = new Font("Dialog", font.getStyle(), font.getSize());
        }
        super.setFont(font);
    }

    protected boolean canDisplayText() {
        try {
            return ControlUtilsBase.canDisplayText(this.getFont(), this.getText());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Rectangle modelToView(int pos) throws BadLocationException {
        try {
            return super.modelToView(pos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void caretChanged(int caret) {
        if (!this.isVisible()) {
            return;
        }
        if (this.preventChanged) {
            return;
        }
        if (JWindowNames.isMatching()) {
            try {
                String text = this.getText();
                if (!StringUtils.isValidString(text)) {
                    JWindowNames.stopMatch();
                    return;
                }
                int p = this.getCaretPosition();
                int[] pos = GM.getCurrentWordPosition(text, p);
                if (pos == null) {
                    JWindowNames.stopMatch();
                    return;
                }
                int start = pos[0];
                int end = pos[1];
                String name = text.substring(start, end);
                boolean find = GVSplSE.matchWindow.searchName(name);
                if (!find) {
                    JWindowNames.stopMatch();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean isMatching() {
        if (GVSplSE.matchWindow == null) {
            return false;
        }
        return JWindowNames.isMatching();
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean isUpdate) {
        try {
            try {
                this.preventChanged = true;
                super.setText(text);
                if (text == null || text.length() <= 100000) {
                    String style = "text/c";
                    AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
                    try {
                        atmf.putMapping("text/c", SPLTokenMaker.class.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setSyntaxEditingStyle("text/c");
                } else {
                    this.setSyntaxEditingStyle("text/plain");
                }
                this.setStyleText(isUpdate);
            }
            catch (Exception exception) {
                this.preventChanged = false;
            }
        }
        finally {
            this.preventChanged = false;
        }
    }

    private void setStyleText(boolean isUpdate) {
        String text = this.getText();
        try {
            try {
                char firstChar;
                this.preventChanged = true;
                try {
                    SyntaxScheme defaultScheme = new SyntaxScheme(this.getFont(), true);
                    if (defaultScheme != null) {
                        SyntaxScheme currentScheme = this.getSyntaxScheme();
                        int i = 0;
                        while (i < currentScheme.getStyleCount()) {
                            Style currentStyle = currentScheme.getStyle(i);
                            Style defaultStyle = defaultScheme.getStyle(i);
                            currentStyle.foreground = defaultStyle.foreground;
                            currentStyle.background = defaultStyle.background;
                            currentStyle.font = defaultStyle.font;
                            ++i;
                        }
                    }
                }
                catch (Throwable defaultScheme) {
                    // empty catch block
                }
                this.checkFont();
                Font font = this.getFont();
                SyntaxScheme scheme = this.getSyntaxScheme();
                boolean isComment = false;
                if (text != null && text.length() > 0 && (firstChar = text.charAt(0)) == '/') {
                    if (text.length() > 1) {
                        char secChar = text.charAt(1);
                        if (firstChar == '/' && secChar != '*') {
                            isComment = true;
                        }
                    } else {
                        isComment = true;
                    }
                }
                if (StringUtils.isValidString(text)) {
                    if (isComment) {
                        int i = 0;
                        while (i < scheme.getStyleCount()) {
                            Style style = scheme.getStyle(i);
                            if (style != null) {
                                style.foreground = Color.GREEN.darker();
                            }
                            ++i;
                        }
                    } else {
                        Style commentStyle = new Style(Color.GREEN.darker(), null, new Font(font.getFontName(), 0, font.getSize()));
                        scheme.setStyle(1, commentStyle);
                        Style multiCommentStyle = new Style(ConfigOptions.iCellNoteFColor, null, new Font(font.getFontName(), 2, font.getSize()));
                        scheme.setStyle(2, multiCommentStyle);
                    }
                }
                this.initRefCells(isUpdate);
                this.repaint();
            }
            catch (Exception exception) {
                this.preventChanged = false;
            }
        }
        finally {
            this.preventChanged = false;
        }
    }

    public void setSyntaxScheme(SyntaxScheme scheme) {
        try {
            super.setSyntaxScheme(scheme);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<INormalCell> getRefCells() {
        return this.refCells;
    }

    private synchronized void initRefCells(boolean isUpdate) {
        if (!this.isVisible()) {
            return;
        }
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        String text = this.getText();
        if (text != null && text.length() > 100000) {
            return;
        }
        ArrayList<INormalCell> lastRefCells = new ArrayList<INormalCell>();
        if (this.refCells != null) {
            lastRefCells.addAll(this.refCells);
            this.refCells.clear();
        }
        try {
            SplControl control = null;
            PgmCellSet cellSet = null;
            if (GVSpl.splEditor != null && (control = GVSpl.splEditor.getComponent()) != null) {
                cellSet = control.cellSet;
            }
            if (cellSet != null && text != null) {
                if (isUpdate) {
                    if (StringUtils.isValidString(text) && !text.startsWith("/")) {
                        Command cmd = null;
                        try {
                            cmd = Command.parse(text);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (cmd != null) {
                            IParam param = cmd.getParam(control.cellSet, new Context());
                            if (param != null) {
                                param.getUsedCells(this.refCells);
                            }
                        } else {
                            Expression exp = new Expression(cellSet, new Context(), text);
                            exp.getUsedCells(this.refCells);
                        }
                    }
                } else {
                    CellLocation cl = control.getActiveCell();
                    PgmNormalCell activeCell = control.cellSet.getPgmNormalCell(cl.getRow(), cl.getCol());
                    if (activeCell != null) {
                        activeCell.getUsedCells(this.refCells);
                    }
                }
                if (!this.refCells.isEmpty()) {
                    int i = 0;
                    while (i < this.refCells.size()) {
                        INormalCell cell = this.refCells.get(i);
                        if (cell != null) {
                            int index;
                            int colorIndex = i % REF_COLORS.length;
                            if (this.as[colorIndex] == null) {
                                this.as[colorIndex] = new SimpleAttributeSet();
                                StyleConstants.setForeground(this.as[colorIndex], REF_COLORS[colorIndex]);
                            }
                            String cellId = cell.getCellId();
                            int start = 0;
                            while ((index = Sentence.indexOf(text, start, cellId, 10)) >= 0) {
                                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(REF_COLORS[colorIndex]);
                                highlighter.addHighlight(index, index + cellId.length(), painter);
                                start = index + cellId.length();
                            }
                        }
                        ++i;
                    }
                }
            }
            if (control != null) {
                boolean isSame = false;
                if (lastRefCells != null && this.refCells != null && lastRefCells.size() == this.refCells.size()) {
                    isSame = true;
                    for (INormalCell cell1 : this.refCells) {
                        boolean hasCell = false;
                        for (INormalCell cell2 : lastRefCells) {
                            if (cell1.getRow() != cell2.getRow() || cell1.getCol() != cell2.getCol()) continue;
                            hasCell = true;
                        }
                        if (hasCell) continue;
                        isSame = false;
                        break;
                    }
                }
                if (!isSame) {
                    control.getContentPanel().repaint();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Color getRefCellColor(int row, int col) {
        if (this.refCells == null || this.refCells.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.refCells.size()) {
            INormalCell cell = this.refCells.get(i);
            if (cell != null && cell.getRow() == row && cell.getCol() == col) {
                return REF_COLORS[i % REF_COLORS.length];
            }
            ++i;
        }
        return null;
    }

    private static Color getLightColor(Color originalColor) {
        int alpha = 80;
        Color lighterColor = new Color(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), alpha);
        return lighterColor;
    }
}

