/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class ToolbarGradient
extends JToolBar {
    private static final long serialVersionUID = 1L;

    public ToolbarGradient() {
    }

    public ToolbarGradient(String name) {
        super(name);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isOpaque()) {
            return;
        }
        Color control = UIManager.getColor("control");
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        Paint storedPaint = g2.getPaint();
        g2.setPaint(new GradientPaint(width / 2, (int)((double)height * 1.5), control.darker(), width / 2, 0.0f, control));
        g2.fillRect(0, 0, width, height);
        g2.setPaint(storedPaint);
    }

    public JButton getButton(short cmdId, String menuId, String menuText, ActionListener actionNormal) {
        int index;
        ImageIcon img = GM.getMenuImageIcon(menuId);
        JButton b = new JButton(img);
        b.setOpaque(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        if (StringUtils.isValidString(menuText) && (index = menuText.indexOf("(")) > 0) {
            menuText = menuText.substring(0, index);
        }
        b.setToolTipText(menuText);
        b.setActionCommand(Short.toString(cmdId));
        b.addActionListener(actionNormal);
        Dimension d = new Dimension(28, 28);
        b.setPreferredSize(d);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        return b;
    }
}

