/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VFlowLayout
extends FlowLayout
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private volatile int hgap;
    private volatile int vgap;
    private volatile boolean hfill;
    private volatile boolean vfill;

    public VFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VFlowLayout(boolean hfill, boolean vfill) {
        this(0, 5, 5, hfill, vfill);
    }

    public VFlowLayout(int align) {
        this(align, 5, 5, true, false);
    }

    public VFlowLayout(int align, boolean hfill, boolean vfill) {
        this(align, 5, 5, hfill, vfill);
    }

    public VFlowLayout(int align, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.setAlignment(align);
        this.hgap = hgap;
        this.vgap = vgap;
        this.hfill = hfill;
        this.vfill = vfill;
    }

    @Override
    public int getHgap() {
        return this.hgap;
    }

    @Override
    public void setHgap(int hgap) {
        super.setHgap(hgap);
        this.hgap = hgap;
    }

    @Override
    public int getVgap() {
        return this.vgap;
    }

    @Override
    public void setVgap(int vgap) {
        super.setVgap(vgap);
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(1, 1);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getPreferredSize();
                    dim.width = Math.max(dim.width, d.width);
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        dim.height += this.vgap;
                    }
                    dim.height += d.height;
                }
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(1, 1);
            int nmembers = target.getComponentCount();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d = m.getMinimumSize();
                    dim.width = Math.max(dim.width, d.width);
                    if (i > 0) {
                        dim.height += this.vgap;
                    }
                    dim.height += d.height;
                }
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    public void setVerticalFill(boolean vfill) {
        this.vfill = vfill;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    private void move(Container target, int x, int y, int width, int height, int first, int last) {
        int align = this.getAlignment();
        switch (align) {
            case 1: {
                y += height / 2;
                break;
            }
            case 2: {
                y += height;
            }
        }
        int i = first;
        while (i < last) {
            Component m = target.getComponent(i);
            Dimension md = m.getSize();
            if (m.isVisible()) {
                int px = x + (width - md.width) / 2;
                m.setLocation(px, y);
                y += this.vgap + md.height;
            }
            ++i;
        }
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int nmembers = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int colw = 0;
        int start = 0;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                if (this.vfill && i == nmembers - 1) {
                    d.height = Math.max(maxheight - y, d.height);
                }
                if (this.hfill) {
                    m.setSize(maxwidth, d.height);
                    d.width = maxwidth;
                } else {
                    m.setSize(d.width, d.height);
                }
                if (y + d.height > maxheight) {
                    this.move(target, x, insets.top + this.vgap, colw, maxheight - y, start, i);
                    y = d.height;
                    x += this.hgap + colw;
                    colw = d.width;
                    start = i;
                } else {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    colw = Math.max(colw, d.width);
                }
            }
            ++i;
        }
        this.move(target, x, insets.top + this.vgap, colw, maxheight - y, start, nmembers);
    }
}

