/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.custom;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_DIRECTORY = 1;
    private static final int MODE_READ = 0;
    private static final int MODE_WRITE = 1;
    private static final int MODE_DELETE = 2;
    private String filename;
    private int type;
    private long lastModified;
    private long len;
    private int mode;
    private byte version = 1;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLen() {
        return this.len;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isFile() {
        return this.type == 0;
    }

    public boolean isDirectory() {
        return this.type == 1;
    }

    public boolean canRead() {
        int c = this.mode & 1;
        return c != 0;
    }

    public boolean canWrite() {
        int c = this.mode & 2;
        return c != 0;
    }

    public boolean canDelete() {
        int c = this.mode & 4;
        return c != 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.version);
        out.writeObject(this.filename);
        out.writeInt(this.type);
        out.writeLong(this.lastModified);
        out.writeLong(this.len);
        out.writeInt(this.mode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readByte();
        this.filename = (String)in.readObject();
        this.type = in.readInt();
        this.lastModified = in.readLong();
        this.len = in.readLong();
        this.mode = in.readInt();
    }
}

