/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.ide.common.GM;
import com.scudata.ide.spl.ProcessWatchThread;
import com.scudata.ide.spl.http.HttpServerExcel;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.JSONUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

public class ExcelServer {
    private static Process nodeJsProcess;
    private static final String KEY_PATH = "Path";
    private static final String JSON_CONFIG_FILE = "config.json";
    public static final String KEY_PORT = "port";
    public static final String KEY_HTTP_PORT = "httpPort";

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ExcelServer.stop();
                }
                catch (Throwable t) {
                    Logger.error(t);
                }
            }
        });
        nodeJsProcess = null;
    }

    public static void start() throws Exception {
        HttpServerExcel.startHttpServer();
        ExcelServer.startNodejs();
    }

    public static void stop() throws Exception {
        HttpServerExcel.stopHttpServer();
        ExcelServer.stopNodejs();
    }

    public static void startNodejs() {
        String[] cmds = ExcelServer.getExecCmds("startdevserver", null);
        final ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        Map<String, String> env = processBuilder.environment();
        String paths = env.get(KEY_PATH);
        if (StringUtils.isValidString(paths)) {
            if (!paths.trim().endsWith(";")) {
                paths = String.valueOf(paths) + ";";
            }
            paths = String.valueOf(paths) + ExcelServer.getNodejsDir().getAbsolutePath();
        } else {
            paths = ExcelServer.getNodejsDir().getAbsolutePath();
        }
        env.put(KEY_PATH, paths);
        processBuilder.directory(ExcelServer.getExcelAddinDir());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    nodeJsProcess = processBuilder.start();
                    ExcelServer.watchThread(nodeJsProcess);
                }
                catch (Exception e1) {
                    Logger.error(e1);
                }
            }
        };
        t.start();
    }

    public static void stopNodejs() throws Exception {
        if (nodeJsProcess != null) {
            int port = ExcelServer.getConfigPort(KEY_PORT);
            String processName = "node";
            String[] cmds = ExcelServer.getExecCmds("stopdevserver", new String[]{String.valueOf(port), processName});
            ProcessBuilder processBuilder = new ProcessBuilder(cmds);
            processBuilder.directory(ExcelServer.getExcelAddinDir());
            nodeJsProcess = processBuilder.start();
            ExcelServer.watchThread(nodeJsProcess);
            nodeJsProcess = null;
        }
    }

    private static File getBinDir() {
        String startHome = System.getProperty("start.home");
        File binDir = new File(startHome, "bin");
        return binDir;
    }

    private static File getExcelAddinDir() {
        String startHome = System.getProperty("start.home");
        File binDir = new File(startHome, "exceladdin");
        return binDir;
    }

    private static File getNodejsDir() {
        String startHome = System.getProperty("start.home");
        File nodejsDir = new File(startHome, "nodejs");
        return nodejsDir;
    }

    private static String[] getExecCmds(String execFileName, String[] args) {
        String[] cmds;
        block8: {
            block6: {
                block7: {
                    cmds = null;
                    if (!GM.isWindowsOS()) break block6;
                    if (args != null) break block7;
                    File nodejsDir = ExcelServer.getNodejsDir();
                    String npmFile = new File(nodejsDir, "npm").getAbsolutePath();
                    cmds = new String[]{"cmd", "/c", "start", "/B", " ", npmFile, "run", "dev-server"};
                    break block8;
                }
                String port = args[0];
                String pid = ExcelServer.getPIDByPort(port);
                if (pid == null) break block8;
                cmds = new String[]{"taskkill", "/PID", pid, "/F"};
                break block8;
            }
            if (GM.isMacOS()) {
                File binDir = ExcelServer.getBinDir();
                if (!binDir.exists() || !binDir.isDirectory()) {
                    GM.outputMessage(IdeSplMessage.get().getMessage("dialogexeccmd.binnotexist", binDir.getAbsolutePath()));
                    return null;
                }
                File exeFile = new File(binDir, String.valueOf(execFileName) + ".sh");
                if (!exeFile.isFile() || !exeFile.exists()) {
                    GM.outputMessage(IdeSplMessage.get().getMessage("dialogexeccmd.exenotexist", exeFile.getAbsolutePath()));
                    return null;
                }
                int argCount = 0;
                if (args != null) {
                    argCount = args.length;
                }
                cmds = new String[2 + argCount];
                cmds[0] = "sh";
                cmds[1] = exeFile.getAbsolutePath();
                if (args != null) {
                    int i = 0;
                    while (i < argCount) {
                        cmds[2 + i] = args[i];
                        ++i;
                    }
                }
            }
        }
        return cmds;
    }

    /*
     * Exception decompiling
     */
    private static String getPIDByPort(String port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void outputMessage(String line) {
        line = line.replaceAll("\u001b\\[", " ");
        line = line.replaceAll(" 39m 22m", "");
        line = line.replaceAll(" 1m 32m", "");
        line = line.replaceAll(" 1m 33m", "");
        line = line.replaceAll(" 1m", "");
        line = line.replaceAll(" 36m", "");
        line = line.replaceAll(" 39m", "");
        System.out.println(line);
    }

    private static void watchThread(Process proc) throws InterruptedException {
        ProcessWatchThread wt1 = new ProcessWatchThread(proc.getInputStream()){

            @Override
            protected void outputLine(String line) {
                ExcelServer.outputMessage(line);
            }
        };
        wt1.start();
        ProcessWatchThread wt2 = new ProcessWatchThread(proc.getErrorStream()){

            @Override
            protected void outputLine(String line) {
                ExcelServer.outputMessage(line);
            }
        };
        wt2.start();
        int code = proc.waitFor();
        if (code != 0) {
            Logger.info("Process code: " + code);
        }
        wt1.setOver(true);
        wt2.setOver(true);
    }

    public static int getConfigPort(String key) {
        File jsonFile;
        File dir = new File(GM.getAbsolutePath("exceladdin"));
        if (dir.exists() && (jsonFile = new File(dir, JSON_CONFIG_FILE)).exists()) {
            try {
                BaseRecord record;
                Object port;
                String json = new String(Files.readAllBytes(Paths.get(jsonFile.getAbsolutePath(), new String[0])), "UTF-8");
                char[] chars = json.toCharArray();
                Object obj = JSONUtil.parseJSON(chars, 0, chars.length - 1);
                if (obj != null && obj instanceof BaseRecord && (port = (record = (BaseRecord)obj).getFieldValue(key)) != null && port instanceof Number) {
                    return ((Number)port).intValue();
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        if (KEY_PORT.equals(key)) {
            return 8602;
        }
        return 8603;
    }
}

