/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.app.common.Section;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.ConfigWriter;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.SplServerConfig;
import com.scudata.common.StringUtils;
import com.scudata.ide.spl.InputStreamFlusher;
import com.scudata.ide.spl.UnitServerConsole;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitContext;
import com.scudata.server.IServer;
import com.scudata.server.http.HttpContext;
import com.scudata.server.http.SplxServerInIDE;
import com.scudata.server.odbc.DataTypes;
import com.scudata.server.odbc.OdbcContext;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.unit.ShutdownUnitServer;
import com.scudata.server.unit.UnitServer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.UIManager;

public class ServerConsole {
    private static ArrayList<Object> runningServers = new ArrayList();
    private static RaqsoftConfig rc = null;
    static UnitServerConsole webStartServer = null;
    protected static String unitServerName = null;
    protected static String unitServerConsoleName = "com.scudata.ide.spl.UnitServerConsole";

    public static ArrayList<Object> getRunningServers() {
        return runningServers;
    }

    public static InputStream getConfigIS(String configFile) throws Exception {
        return UnitContext.getUnitInputStream(configFile);
    }

    public static boolean isRunning(List<IServer> servers) {
        for (IServer server : servers) {
            if (server == null || !server.isRunning()) continue;
            return true;
        }
        return false;
    }

    private static void initLang(boolean init) {
        try {
            if (init) {
                ServerConsole.loadRaqsoftConfig();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setRaqsoftConfig(RaqsoftConfig config) {
        rc = config;
    }

    public static RaqsoftConfig loadRaqsoftConfig() throws Exception {
        if (rc == null) {
            InputStream inputStream = ServerConsole.getConfigIS("raqsoftConfig.xml");
            rc = ConfigUtil.load(inputStream, true);
            inputStream.close();
        }
        return rc;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        System.out.println("os.name:" + osName);
        return osName.startsWith("Windows");
    }

    private static boolean isNimbusVisible() {
        try {
            Class<?> c = Class.forName("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            return c != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setDefaultLNF() {
        String lnf = ServerConsole.isWindows() ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (ServerConsole.isNimbusVisible() ? "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel" : UIManager.getSystemLookAndFeelClassName());
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static boolean startUnitServer() throws Exception {
        if (webStartServer == null) {
            ServerConsole.setDefaultLNF();
            webStartServer = new UnitServerConsole(null, 0);
        }
        webStartServer.setVisible(true);
        return webStartServer.webStartUnitServer();
    }

    public static boolean isUnitServerRunning() {
        if (webStartServer != null) {
            return webStartServer.isWebUnitServerRunning();
        }
        return false;
    }

    public static void stopUnitServer() throws Exception {
        if (webStartServer != null) {
            webStartServer.webStopUnitServer();
        }
    }

    static void exit(int second) {
        ServerConsole.sleep(second);
        System.exit(0);
    }

    static void sleep(int second) {
        try {
            Thread.sleep(second * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static UnitServer getUnitServerInstance(String host, int port, String cfgPath) throws Exception {
        Class[] argTypes;
        Object[] args;
        if (unitServerName == null) {
            throw new Exception("Current version does not support Node Server");
        }
        if (cfgPath == null) {
            args = new Object[]{host, port};
            argTypes = new Class[]{String.class, Integer.TYPE};
        } else {
            args = new Object[]{host, port, cfgPath};
            argTypes = new Class[]{String.class, Integer.TYPE, String.class};
        }
        return (UnitServer)AppUtil.invokeStaticMethod(unitServerName, "getInstance", args, argTypes);
    }

    static UnitServerConsole getUnitServerConsoleInstance(String host, int port) throws Exception {
        Class<?> cls = Class.forName(unitServerConsoleName);
        Constructor<?> con = cls.getConstructor(String.class, Integer.TYPE);
        Object[] objectArray = new Object[2];
        objectArray[1] = 0;
        Object usc = con.newInstance(objectArray);
        return (UnitServerConsole)usc;
    }

    public static void main(String[] args) {
        String usage = "\u8be5\u7c7b\u6839\u636e\u9009\u9879\u6765\u542f\u52a8\u6216\u505c\u6b62\u5404\u79cd\u670d\u52a1\uff0c\u683c\u5f0f\u4e3a ServerConsole.sh -[options] -[options]...\r\n\u5f53\u6307\u5b9a\u4e86\u67d0\u79cd\u9009\u9879\u7528\u4e8e\u542f\u52a8\u76f8\u5e94\u670d\u52a1\u65f6\uff0c\u90fd\u662f\u542f\u52a8\u975e\u56fe\u5f62\u73af\u5883\u4e0b\u7684\u8be5\u7c7b\u670d\u52a1\u3002\r\n\u4e5f\u53ef\u4ee5\u4e0d\u5e26\u4efb\u4f55\u9009\u9879\uff0c\u8868\u793a\u542f\u52a8\u670d\u52a1\u63a7\u5236\u53f0\u7a0b\u5e8f[\u56fe\u5f62\u7a97\u53e3\u63a7\u5236\u53f0]\u3002\r\n\u5982\u4e0b\u6240\u6709\u9009\u9879\u9664\u4e86 -a , -x \u4e0d\u80fd\u540c\u65f6\u51fa\u73b0\uff0c\u5176\u4ed6\u9009\u9879\u90fd\u53ef\u4ee5\u7ec4\u5408\u3002\r\n\r\n-c port cfg\t\u4f7f\u7528\u914d\u7f6ecfg\u542f\u52a8\u6216\u505c\u6b62\u5206\u673a \uff0c\u5f53\u7701\u7565cfg\u65f6\uff0c\u5219\u505c\u6b62\u5206\u673a\u3002\r\n-o\t\u542f\u52a8 ODBC \u670d\u52a1\u3002\r\n-h\t\u542f\u52a8 HTTP \u670d\u52a1\u3002\r\n-x[ip:port]\t\u505c\u6b62\u6307\u5b9a\u5206\u673a\u3002\u5f53\u7701\u7565ip:port\u65f6\uff0c\u505c\u6b62\u672c\u5730\u542f\u52a8\u7684\u6240\u6709\u670d\u52a1\u3002\r\n-a\t\u542f\u52a8\u6240\u6709\u670d\u52a1\u3002\r\n-?\t\u6216\u8005\u9519\u8bef\u9009\u9879\u65f6\uff0c\u6253\u5370\u5f53\u524d\u5e2e\u52a9\u4fe1\u606f\u3002\r\n\r\n \u793a\u4f8b\uff1aServerConsole.sh -a  \u542f\u52a8\u5168\u90e8\u670d\u52a1,\u76f8\u5f53\u4e8e ServerConsole.sh -p -o -h\r\n\r\n \u793a\u4f8b\uff1aServerConsole.sh -o  \u4ec5\u542f\u52a8odbc\u670d\u52a1\r\n\r\n";
        String usageEn = "The class starts or stops services according to the option used, format is ServerConsole.sh -[options] -[options]....\r\nWhen an option is specified to start the corresponding service, it starts the service in a non-GUI environment.\r\nWhen no option is specified, start the service console [graphics console].\r\nIn the following options, any options can work together except for -a and -x.\r\n\r\n-c port cfg\tUse configuration cfg to start or stop a node; when cfg is absent, just stop the node.\r\n-o\tStart ODBC service.\r\n-h\tStart HTTP service.\r\n-x[ip:port]\tStop assigning nodes; when ip:port are absent, stop all working services on the local machine. \r\n-a\tStart all services.\r\n-?\tOr print the current help information when the error option is present. \r\n\r\n Example\uff1aServerConsole.sh -a  Start all services, which is equivalent to ServerConsole.sh -p -o -h\r\n\r\n Example\uff1aServerConsole.sh -o  Start odbc service only.\r\n\r\n";
        String lang = Locale.getDefault().toString();
        if (lang.equalsIgnoreCase("en")) {
            usage = usageEn;
        }
        ServerConsole.doMain(args, usage);
    }

    public static void otelJvmBufferMetrics() {
    }

    public static void doMain(String[] args, String usage) {
        IServer server;
        String arg;
        boolean init = true;
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0 && arg.charAt(1) != ':') {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        boolean printHelp = false;
        boolean isP = false;
        boolean isO = false;
        boolean isH = false;
        boolean isX = false;
        boolean isC = false;
        boolean isS = false;
        String host = null;
        String cfgPath = null;
        int port = 0;
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = args[i];
                if (!arg.equalsIgnoreCase("com.scudata.ide.spl.ServerConsole")) {
                    UnitClient uc;
                    String tmp;
                    String address;
                    int index;
                    if (arg.equalsIgnoreCase("-a")) {
                        if (unitServerName != null) {
                            isP = true;
                        }
                        isO = true;
                        isH = true;
                        break;
                    }
                    if (arg.toLowerCase().startsWith("-p")) {
                        index = arg.indexOf(58);
                        address = null;
                        if (index > 0) {
                            address = arg.substring(2).trim();
                        } else if (index < 0 && i + 1 < args.length && (index = (address = args[i + 1]).indexOf(58)) > 0) {
                            ++i;
                        }
                        if (index > 0 && address != null) {
                            tmp = address;
                            uc = new UnitClient(tmp);
                            host = uc.getHost();
                            port = uc.getPort();
                        }
                        isP = true;
                    } else if (arg.equalsIgnoreCase("-o")) {
                        isO = true;
                    } else if (arg.equalsIgnoreCase("-h")) {
                        isH = true;
                    } else {
                        if (arg.toLowerCase().startsWith("-x")) {
                            index = arg.indexOf(58);
                            address = null;
                            if (index > 0) {
                                address = arg.substring(2).trim();
                            } else if (index < 0 && i + 1 < args.length && (index = (address = args[i + 1]).indexOf(58)) > 0) {
                                ++i;
                            }
                            if (index > 0 && address != null) {
                                tmp = address;
                                uc = new UnitClient(tmp);
                                host = uc.getHost();
                                port = uc.getPort();
                            }
                            isX = true;
                            break;
                        }
                        if (arg.toLowerCase().startsWith("-s")) {
                            isS = true;
                            index = arg.indexOf(58);
                            host = arg.substring(2, index).trim();
                            port = Integer.parseInt(arg.substring(index + 1).trim());
                            break;
                        }
                        if (arg.toLowerCase().startsWith("-c")) {
                            host = "127.0.0.1";
                            if (i + 1 < args.length) {
                                String buf = args[i + 1];
                                port = Integer.parseInt(buf);
                                ++i;
                            }
                            if (i + 1 < args.length) {
                                cfgPath = Escape.removeEscAndQuote(args[i + 1]);
                                Logger.debug("Config file:" + cfgPath);
                                ++i;
                            }
                            if (cfgPath == null) {
                                isX = true;
                                break;
                            }
                            isC = true;
                            try {
                                FileInputStream is = new FileInputStream(cfgPath);
                                SplServerConfig ssc = SplServerConfig.getCfg(is);
                                init = !StringUtils.isValidString(ssc.splConfig);
                                ((InputStream)is).close();
                            }
                            catch (Exception ssc) {}
                            break;
                        }
                        printHelp = true;
                    }
                }
                ++i;
            }
        }
        if (printHelp) {
            System.err.println(usage);
            System.err.println("Press enter to exit.");
            try {
                System.in.read();
            }
            catch (Exception i) {
                // empty catch block
            }
            ServerConsole.exit(0);
        }
        ServerConsole.initLang(init);
        ServerConsole.otelJvmBufferMetrics();
        if (isS) {
            try {
                RaqsoftConfig rc = ServerConsole.loadRaqsoftConfig();
                UnitServer server2 = ServerConsole.getUnitServerInstance(host, port, null);
                runningServers.add(server2);
                server2.setRaqsoftConfig(rc);
                server2.run();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            System.exit(0);
        }
        if (isC) {
            try {
                UnitServer server3 = ServerConsole.getUnitServerInstance(host, port, cfgPath);
                runningServers.add(server3);
                server3.run();
            }
            catch (Exception x) {
                x.printStackTrace();
                System.exit(-1);
            }
            System.exit(0);
        }
        if (isX) {
            ConfigWriter ctx2;
            try {
                if (host != null) {
                    ShutdownUnitServer.close(host, port);
                    System.exit(0);
                } else {
                    ShutdownUnitServer.autoClose();
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            try {
                ctx2 = new OdbcContext();
                host = ((OdbcContext)ctx2).getHost();
                port = ((OdbcContext)ctx2).getPort();
                Socket s = new Socket();
                s.connect(new InetSocketAddress(host, port), 1000);
                OutputStream os = s.getOutputStream();
                DataTypes.writeInt(os, -1);
                os.close();
            }
            catch (Exception ctx2) {
                // empty catch block
            }
            try {
                ctx2 = new HttpContext(true);
                host = ((HttpContext)ctx2).getHost();
                port = ((HttpContext)ctx2).getPort();
                String durl = ((HttpContext)ctx2).getDefaultUrl();
                URL url = new URL(String.valueOf(durl) + "/shutdown");
                URLConnection uc = url.openConnection();
                InputStream is = uc.getInputStream();
                is.close();
            }
            catch (Exception ctx3) {
                // empty catch block
            }
            System.exit(0);
        }
        RaqsoftConfig rc = null;
        try {
            rc = ServerConsole.loadRaqsoftConfig();
        }
        catch (Exception x) {
            x.printStackTrace();
            ServerConsole.exit(3);
        }
        if (!(isP || isO || isH)) {
            ServerConsole.setDefaultLNF();
            try {
                UnitServerConsole usc = ServerConsole.getUnitServerConsoleInstance(null, 0);
                runningServers.add(usc);
                usc.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Thread tp = null;
        Thread to = null;
        ArrayList flushers = new ArrayList();
        if (isP) {
            try {
                server = ServerConsole.getUnitServerInstance(host, port, null);
                runningServers.add(server);
                ((UnitServer)server).setRaqsoftConfig(rc);
                tp = new Thread(server);
                tp.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isO) {
            try {
                server = OdbcServer.getInstance();
                runningServers.add(server);
                ((OdbcServer)server).setRaqsoftConfig(rc);
                to = new Thread(server);
                to.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SplxServerInIDE thServer = null;
        if (isH) {
            try {
                thServer = SplxServerInIDE.getInstance();
                runningServers.add(thServer);
                thServer.setRaqsoftConfig(rc);
                thServer.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            if (tp != null) {
                tp.join();
            }
            if (to != null) {
                to.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (thServer != null) {
            while (thServer.isRunning()) {
                ServerConsole.sleep(3);
            }
        }
        for (InputStreamFlusher flusher : flushers) {
            flusher.shutDown();
        }
        ServerConsole.exit(3);
    }
}

