/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.IByteMap;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.ToolBarPropertyBase;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.control.CellEditingListener;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;

public class ToolBarProperty
extends ToolBarPropertyBase {
    private static final long serialVersionUID = 1L;

    @Override
    public void setTextEditorText(String newText) {
        this.setTextEditorText(newText, false);
    }

    public void setTextEditorText(String newText, boolean isRefresh) {
        if (!isRefresh && !GV.isCellEditing) {
            return;
        }
        try {
            this.preventAction = true;
            this.textEditor.setPreventChange(true);
            try {
                Font font;
                SplControl control;
                if (GVSpl.splEditor != null && (control = GVSpl.splEditor.getComponent()) != null && this.textEditorFont != (font = GM.getScaleFont(control.scale))) {
                    this.setEditorFont(font);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.textEditor.setText(newText, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.textChanged();
        }
        finally {
            this.preventAction = false;
            this.textEditor.setPreventChange(false);
        }
    }

    @Override
    public void init() {
        super.init();
        if (GVSpl.splEditor == null) {
            return;
        }
        SplControl control = GVSpl.splEditor.getComponent();
        ContentPanel cp = control.getContentPanel();
        this.addCellEditingListener((JTextComponent)((Object)this.textEditor), control, cp);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void removeCellEditingListeners() {
        KeyListener[] kls = this.textEditor.getKeyListeners();
        if (kls != null) {
            int len = kls.length;
            int i = len - 1;
            while (i >= 0) {
                if (kls[i] instanceof CellEditingListener) {
                    this.textEditor.removeKeyListener(kls[i]);
                }
                --i;
            }
        }
    }

    protected void addCellEditingListener(JTextComponent jtext, SplControl control, ContentPanel cp) {
        this.removeCellEditingListeners();
        CellEditingListener listener = new CellEditingListener(control, cp);
        jtext.addKeyListener(listener);
    }

    @Override
    public void refresh(byte selectState, IByteMap values) {
        if (GVSpl.cmdSender == this) {
            return;
        }
        try {
            CellRect rect;
            this.preventAction = true;
            this.setEnabled(true);
            if (values == null || values.size() == 0) {
                this.initProperties();
                return;
            }
            String cellId = "";
            if (GVSpl.splEditor != null && (rect = GVSpl.splEditor.getSelectedRect()) != null) {
                cellId = GMSpl.getCellID(rect.getBeginRow(), rect.getBeginCol());
                if (rect.getRowCount() > 1 || rect.getColCount() > 1) {
                    cellId = String.valueOf(cellId) + "-" + GMSpl.getCellID(rect.getEndRow(), rect.getEndCol());
                }
            }
            this.setCellName(cellId);
            Object o = values.get((byte)1);
            if (StringUtils.isValidString(o)) {
                this.setTextEditorText((String)o, true);
            } else {
                this.setTextEditorText("", true);
            }
            this.selectState = selectState;
        }
        finally {
            this.preventAction = false;
        }
    }

    @Override
    public void textEdited(KeyEvent e) {
        if (this.preventAction) {
            return;
        }
        GVSpl.cmdSender = this;
        GV.isCellEditing = false;
        try {
            String text = this.textEditor.getText();
            this.textChanged();
            GVSpl.splEditor.setEditingText(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void textChanged() {
    }

    @Override
    public void submitEditor(String newText, byte forward) {
        SplControl control = GVSpl.splEditor.getComponent();
        control.fireCellTextInput(control.getActiveCell(), newText);
        switch (forward) {
            case 1: {
                control.scrollToArea(control.toUpCell());
                break;
            }
            case 2: {
                control.scrollToArea(control.toDownCell());
            }
        }
    }

    @Override
    public void editorSelected() {
        if (GVSpl.splEditor == null) {
            return;
        }
        if (GVSpl.splEditor.getComponent() == null) {
            return;
        }
        ContentPanel cp = GVSpl.splEditor.getComponent().getContentPanel();
        if (!cp.isEditing()) {
            cp.initEditor((byte)1);
        }
        GV.isCellEditing = false;
    }

    public void addText(String text) {
        if (!this.isEnabled()) {
            return;
        }
        GM.addText((JTextComponent)((Object)this.textEditor), text);
        this.textEdited(null);
    }

    @Override
    public Context getContext() {
        return GMSpl.prepareParentContext();
    }

    @Override
    protected void setToolBarExpand() {
        ((IDEBase)GV.appFrame).setToolBarExpand();
    }

    @Override
    protected void setActiveCell(int row, int col) {
        PgmNormalCell nc;
        SplEditor editor = GVSpl.splEditor;
        SplControl control = editor.getComponent();
        control.clearSelectedAreas();
        control.setActiveCell(new CellLocation(row, col));
        ContentPanel cp = control.contentView;
        cp.rememberedRow = row;
        cp.rememberedCol = col;
        Area a = new Area(row, col, row, col);
        a = control.setActiveCell(new CellLocation(row, col));
        control.addSelectedArea(a, false);
        control.repaint();
        cp.requestFocus();
        if (control.cellSet.isAutoCalc() && (nc = (PgmNormalCell)control.cellSet.getCell(row, col)) != null) {
            GVSpl.panelValue.tableValue.setValue1(nc.getValue(), nc.getCellId());
        }
        editor.selectedRects.clear();
        editor.selectedRects.add(new CellRect(a));
        editor.selectedCols.clear();
        editor.selectedRows.clear();
        editor.selectState = 1;
        editor.getSplListener().selectStateChanged(editor.selectState, false);
    }

    @Override
    protected String getActiveCellId() {
        SplControl control = GVSpl.splEditor.getComponent();
        CellLocation cl = control.getActiveCell();
        if (cl == null) {
            return null;
        }
        return GM.getCellID(cl.getRow(), cl.getCol());
    }

    @Override
    protected CellLocation getMaxCellLocation() {
        SplControl control = GVSpl.splEditor.getComponent();
        return new CellLocation(control.cellSet.getRowCount(), control.cellSet.getColCount());
    }

    @Override
    public void tabPressed() {
        SplControl control = GVSpl.splEditor.getComponent();
        CellLocation cl = control.getActiveCell();
        if (cl == null) {
            return;
        }
        int curCol = cl.getCol();
        if (curCol == control.cellSet.getColCount()) {
            GVSpl.splEditor.appendCols(1);
        }
        control.scrollToArea(control.toRightCell());
    }

    @Override
    public void editCancel() {
        SplControl control = GVSpl.splEditor.getComponent();
        NormalCell nc = (NormalCell)control.getCellSet().getCell(control.getActiveCell().getRow(), control.getActiveCell().getCol());
        String value = nc.getExpString();
        value = value == null ? GCSpl.NULL : value;
        try {
            this.textEditor.setText(value);
            this.textEdited(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

