/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.common.CellLocation;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.GVSE;
import com.scudata.ide.common.control.FuncWindow;
import com.scudata.ide.common.swing.RSyntaxTextAreaEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.ToolBarProperty;
import com.scudata.ide.spl.control.CellEditingListener;
import com.scudata.ide.spl.control.CellEditingListenerSE;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.FuncListener;
import com.scudata.ide.spl.control.FuncListenerIDE;
import com.scudata.ide.spl.control.JWindowNames;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ToolBarPropertySE
extends ToolBarProperty {
    private static final long serialVersionUID = 1L;
    protected boolean isInit = false;
    protected KeyListener funcListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (e.isAltDown() || e.isShiftDown()) {
                    return;
                }
                if (e.isControlDown()) {
                    GM.addText((JTextComponent)((Object)ToolBarPropertySE.this.textEditor), "\n");
                    ToolBarPropertySE.this.textEdited(e);
                } else {
                    ToolBarPropertySE.this.enterPressed(e);
                }
                e.consume();
            } else if (e.getKeyCode() == 9) {
                ToolBarPropertySE.this.tabPressed();
            } else if (e.isAltDown() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            final FuncWindow funcWindow = GVSE.getFuncWindow();
            if (e.isAltDown()) {
                if (e.getKeyCode() == 40) {
                    if (funcWindow.isDisplay()) {
                        funcWindow.showNextFunc((JTextComponent)((Object)ToolBarPropertySE.this.textEditor));
                    } else {
                        funcWindow.setFuncEnabled(true);
                        ToolBarPropertySE.this.resetTextWindow();
                    }
                } else if (e.getKeyCode() == 38) {
                    funcWindow.setFuncEnabled(false);
                    funcWindow.hideWindow();
                }
                e.consume();
            } else {
                if (e.isControlDown() && (e.getKeyCode() == 32 || e.getKeyCode() == 16)) {
                    return;
                }
                if (e.getKeyCode() == 27) {
                    ToolBarPropertySE.this.editCancel();
                    return;
                }
                if (e.getKeyCode() != 18) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            funcWindow.caretPositionChanged((JTextComponent)((Object)ToolBarPropertySE.this.textEditor), ToolBarPropertySE.this.getContext());
                        }
                    });
                }
            }
        }
    };

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        super.init();
        this.textEditor.setToolTipText(IdeSplMessage.get().getMessage("toolbarproperty.functip"));
        GVSE.getFuncWindow();
        this.textEditor.addKeyListener(this.funcListener);
        this.textEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FuncWindow funcWindow = GVSE.getFuncWindow();
                        funcWindow.caretPositionChanged((JTextComponent)((Object)ToolBarPropertySE.this.textEditor), ToolBarPropertySE.this.getContext());
                    }
                });
            }
        });
        this.textEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                FuncWindow funcWindow = GVSE.getFuncWindow();
                funcWindow.setFuncEnabled(false);
                funcWindow.hideWindow();
            }
        });
    }

    @Override
    protected void addCellEditingListener(JTextComponent jtext, SplControl control, ContentPanel cp) {
        this.removeCellEditingListeners();
        CellEditingListenerSE listener = new CellEditingListenerSE(control, cp);
        jtext.addKeyListener(listener);
        FuncListenerIDE funcListener = new FuncListenerIDE(jtext);
        jtext.addKeyListener(funcListener);
    }

    @Override
    protected void newTextEditor() {
        this.textEditor = new RSyntaxTextAreaEx(){
            private static final long serialVersionUID = 1L;

            public void requestFocus() {
                ToolBarPropertySE.this.editorSelected();
                super.requestFocus();
            }
        };
    }

    @Override
    protected void enterPressed(KeyEvent e) {
        super.enterPressed(e);
    }

    @Override
    public void tabPressed() {
        SplControl control = GVSpl.splEditor.getComponent();
        CellLocation cl = control.getActiveCell();
        if (cl == null) {
            return;
        }
        if (JWindowNames.isMatching()) {
            GVSplSE.matchWindow.selectName();
            return;
        }
    }

    @Override
    public void removeCellEditingListeners() {
        KeyListener[] kls = this.textEditor.getKeyListeners();
        if (kls != null) {
            int len = kls.length;
            int i = len - 1;
            while (i >= 0) {
                if (kls[i] instanceof FuncListener || kls[i] instanceof CellEditingListener) {
                    this.textEditor.removeKeyListener(kls[i]);
                }
                --i;
            }
        }
    }

    @Override
    protected void setToolBarExpand() {
        super.setToolBarExpand();
        this.resetTextWindow();
    }

    @Override
    protected void textChanged() {
        this.resetTextWindow();
    }

    public void resetTextWindow() {
        this.resetTextWindow(false);
    }

    public void resetTextWindow(boolean resizeFuncWin) {
        this.resetTextWindow(resizeFuncWin, false);
    }

    public void resetTextWindow(boolean resizeFuncWin, boolean frameResize) {
        Rectangle srcRect = this.spEditor.getBounds();
        int x = GV.appFrame.getX() + GM.getAbsolutePos((Component)this.spEditor, true) + 5;
        int y = GM.getAbsolutePos((Component)this.spEditor, false) + 2;
        int w = (int)srcRect.getWidth() - 3;
        int h = srcRect.height;
        this.textEditor.setBorder(null);
        FuncWindow funcWindow = GVSE.getFuncWindow();
        if (funcWindow.isFuncEnabled()) {
            funcWindow.setPosition(x, y + h + 10, w);
            funcWindow.caretPositionChanged((JTextComponent)((Object)this.textEditor), this.getContext(), resizeFuncWin);
        } else {
            funcWindow.hideWindow();
        }
    }

    @Override
    protected void setEnabled(boolean enabled, boolean caseFuncWindow) {
        super.setEnabled(enabled, caseFuncWindow);
        if (enabled) {
            this.resetTextWindow();
        } else {
            try {
                try {
                    this.preventAction = true;
                    if (caseFuncWindow) {
                        FuncWindow funcWindow = GVSE.getFuncWindow();
                        funcWindow.setFuncEnabled(false);
                        funcWindow.hideWindow();
                    }
                }
                catch (Exception exception) {
                    this.preventAction = false;
                }
            }
            finally {
                this.preventAction = false;
            }
        }
    }
}

