/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.base.JPanelFileFilter;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class FileComparator
implements Comparator {
    public static final byte TYPE_NAME = 1;
    public static final byte TYPE_DATE = 2;
    public static final byte TYPE_TYPE = 3;
    protected byte type;
    protected boolean desc;

    public FileComparator(byte type, boolean desc) {
        this.type = type;
        this.desc = desc;
    }

    public int compare(Object o1, Object o2) {
        int result = 1;
        if (o1 == null) {
            result = o2 == null ? 0 : 1;
        } else if (o2 == null) {
            result = -1;
        } else {
            FileInfo f1 = (FileInfo)o1;
            FileInfo f2 = (FileInfo)o2;
            switch (this.type) {
                case 1: {
                    String s1 = f1.getFilename();
                    String s2 = f2.getFilename();
                    if (s1 == null) {
                        result = s2 == null ? 0 : 1;
                        break;
                    }
                    if (s2 == null) {
                        result = -1;
                        break;
                    }
                    result = Collator.getInstance(Locale.getDefault()).compare(s1, s2);
                    break;
                }
                case 2: {
                    long t1 = f1.getLastModified();
                    long t2 = f2.getLastModified();
                    result = new Long(t1).compareTo(new Long(t2));
                    break;
                }
                case 3: {
                    String s1 = JPanelFileFilter.getFileType(f1);
                    String s2 = JPanelFileFilter.getFileType(f2);
                    result = s1 == null ? (s2 == null ? 0 : 1) : (s2 == null ? -1 : Collator.getInstance(Locale.getDefault()).compare(s1, s2));
                }
            }
        }
        if (this.desc) {
            result = -result;
        }
        return result;
    }
}

