/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.app.common.AppUtil;
import com.scudata.app.config.ConfigUtil;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.base.FileTreeNode;
import com.scudata.ide.spl.base.FileTreeRender;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static MessageManager mm = IdeSplMessage.get();
    protected FileTreeNode root;
    protected FileTreeNode localRoot;
    private static final String NO_MAIN_PATH = mm.getMessage("filetree.nomainpath");
    private static final String NO_DEMO_DIR = mm.getMessage("filetree.nodemodir");
    public static final String ROOT_TITLE = mm.getMessage("filetree.roottitle");
    private final String NOT_EXPAND = "NOT_EXPAND";
    private boolean isInit = true;
    public static final byte OPEN_FILE = 1;
    public static final byte OPEN_DIR = 2;
    public static final byte OPEN_FILE_DIR = 3;
    public static final byte REFRESH = 4;
    public static final byte SWITCH_PATH = 5;
    protected boolean isCheckNode = false;

    public FileTree() {
        this.setMinimumSize(new Dimension(1, 1));
        this.root = new FileTreeNode((Object)"", 0);
        this.localRoot = new FileTreeNode((Object)"", 1);
        this.root.setDir(true);
        this.root.setTitle(ROOT_TITLE);
        this.root.setExpanded(true);
        this.localRoot.setDir(true);
        if (ConfigOptions.bFileTreeDemo.booleanValue()) {
            this.localRoot.setTitle(NO_DEMO_DIR);
        } else {
            this.localRoot.setTitle(NO_MAIN_PATH);
        }
        this.root.add(this.localRoot);
        this.setModel(new DefaultTreeModel(this.root));
        this.setCellRenderer(new FileTreeRender());
        this.setBorder(BorderFactory.createBevelBorder(1));
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.setSelectionModel(dtsm);
        this.addMouseListener(new mTree_mouseAdapter());
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
                FileTree.this.treeNodeWillExpand(node);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
                if (node != null) {
                    node.setExpanded(false);
                }
            }
        });
    }

    public void saveExpandState(int dl) {
        try {
            ConfigOptions.iConsoleLocation = new Integer(dl);
            if (!this.isExpanded(0)) {
                ConfigOptions.sFileTreeExpand = "NOT_EXPAND";
                ConfigOptions.save(false, true);
                return;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(this.localRoot.getName());
            Enumeration<TreeNode> em = this.localRoot.depthFirstEnumeration();
            while (em.hasMoreElements()) {
                FileTreeNode node = (FileTreeNode)em.nextElement();
                if (!node.isExpanded()) continue;
                buf.append(",");
                buf.append(node.getFullPath());
            }
            ConfigOptions.sFileTreeExpand = buf.toString();
            ConfigOptions.save(false, true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void refreshLocal() {
        this.localRoot.removeAllChildren();
        String home = System.getProperty("start.home");
        String mainPath = null;
        if (ConfigOptions.bFileTreeDemo.booleanValue()) {
            File demoDir = new File(home, "demo");
            if (demoDir.exists() && (demoDir = GC.LANGUAGE == 0 || GC.LANGUAGE == 1 ? new File(demoDir, "zh") : new File(demoDir, "en")).exists()) {
                mainPath = demoDir.getAbsolutePath();
            }
            if (mainPath == null) {
                Logger.info(mm.getMessage("filetree.nodemodir"));
            }
        } else {
            mainPath = ConfigUtil.getPath(home, ConfigOptions.sMainPath);
        }
        if (StringUtils.isValidString(mainPath)) {
            if (!mainPath.equals(this.localRoot.getUserObject())) {
                this.localRoot.setDir(true);
                this.localRoot.setUserObject(mainPath);
                this.localRoot.setTitle(null);
            }
        } else {
            this.localRoot.setDir(true);
            this.localRoot.setUserObject("");
            if (ConfigOptions.bFileTreeDemo.booleanValue()) {
                this.localRoot.setTitle(NO_DEMO_DIR);
            } else {
                this.localRoot.setTitle(NO_MAIN_PATH);
            }
            this.nodeStructureChanged(this.localRoot);
            return;
        }
        this.localRoot.setExpanded(true);
        this.loadSubNode(this.localRoot);
        this.nodeStructureChanged(this.localRoot);
        if (this.isInit) {
            this.isInit = false;
            try {
                String sExpand = ConfigOptions.sFileTreeExpand;
                if (!StringUtils.isValidString(sExpand)) {
                    this.collapsePath(new TreePath(this.localRoot.getPath()));
                    this.loadSubNode(this.localRoot);
                    this.nodeStructureChanged(this.localRoot);
                    return;
                }
                if ("NOT_EXPAND".equals(sExpand)) {
                    this.collapsePath(new TreePath(this.localRoot.getPath()));
                    this.localRoot.setExpanded(false);
                    return;
                }
                String[] expands = sExpand.split(",");
                if (expands != null && expands.length > 0) {
                    List<String> expandList = Arrays.asList(expands);
                    int count = this.localRoot.getChildCount();
                    int i = 0;
                    while (i < count) {
                        this.expandTree((FileTreeNode)this.localRoot.getChildAt(i), expandList);
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void treeNodeWillExpand(FileTreeNode node) {
        if (node != null && !node.isLoaded()) {
            if (node.getType() == 1) {
                this.loadSubNode(node);
            } else if (node.getType() == 0) {
                this.refreshLocal();
            }
            node.setExpanded(true);
            this.nodeStructureChanged(node);
        }
    }

    private void expandTree(FileTreeNode pNode, List<String> expandList) {
        if (expandList.contains(pNode.getFullPath())) {
            this.loadSubNode(pNode);
            int count = pNode.getChildCount();
            int i = 0;
            while (i < count) {
                this.expandTree((FileTreeNode)pNode.getChildAt(i), expandList);
                ++i;
            }
            pNode.setExpanded(true);
            this.nodeStructureChanged(pNode);
            this.expandPath(new TreePath(pNode.getPath()));
        }
    }

    protected void loadSubNode(FileTreeNode pNode) {
        try {
            String pDir = (String)pNode.getUserObject();
            File dir = new File(pDir);
            if (!dir.isDirectory() || !dir.exists()) {
                return;
            }
            pNode.removeAllChildren();
            File[] files = dir.listFiles();
            files = GM.sortFiles(files);
            if (files == null || files.length == 0) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String fileName = f.getName();
                if (StringUtils.isValidString(fileName)) {
                    FileTreeNode node = new FileTreeNode((Object)f.getAbsolutePath(), 1);
                    node.setTitle(fileName);
                    boolean isDir = f.isDirectory();
                    if (isDir) {
                        node.setDir(isDir);
                        pNode.add(node);
                        File[] subFiles = f.listFiles();
                        subFiles = GM.sortFiles(subFiles);
                        if (subFiles != null && subFiles.length > 0) {
                            File[] fileArray2 = subFiles;
                            int n3 = subFiles.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                File subFile = fileArray2[n4];
                                String subName = subFile.getName();
                                if (subFile.isDirectory() || subFile.isFile() && this.isValidFile((byte)1, subName)) {
                                    FileTreeNode subNode = new FileTreeNode((Object)subFile.getAbsolutePath(), 1);
                                    subNode.setTitle(subName);
                                    subNode.setDir(subFile.isDirectory());
                                    node.add(subNode);
                                    break;
                                }
                                ++n4;
                            }
                        }
                    }
                }
                ++n2;
            }
            HashSet<String> existNames = new HashSet<String>();
            int i = 0;
            int cc = pNode.getChildCount();
            while (i < cc) {
                FileTreeNode subNode = (FileTreeNode)pNode.getChildAt(i);
                existNames.add(subNode.getTitle());
                ++i;
            }
            File[] fileArray3 = files;
            int n5 = files.length;
            n = 0;
            while (n < n5) {
                File f = fileArray3[n];
                String fileName = f.getName();
                if (StringUtils.isValidString(fileName) && !existNames.contains(fileName)) {
                    FileTreeNode node = new FileTreeNode((Object)f.getAbsolutePath(), 1);
                    node.setTitle(fileName);
                    boolean isDir = f.isDirectory();
                    if (!isDir && this.isValidFile((byte)1, fileName)) {
                        node.setDir(isDir);
                        pNode.add(node);
                    }
                }
                ++n;
            }
            pNode.setLoaded(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isValidFile(byte type, String fileName) {
        return AppUtil.isSPLFile(fileName);
    }

    public void showNode(FileTreeNode node) {
    }

    protected JPopupMenu getPopupMenu(FileTreeNode node) {
        MenuListener menuListener = new MenuListener(node);
        JPopupMenu popMenu = new JPopupMenu();
        byte type = node.getType();
        if (type == 1) {
            if (node.isDir()) {
                popMenu.add(this.getMenuItem((byte)2, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
            } else {
                popMenu.add(this.getMenuItem((byte)1, menuListener));
                popMenu.add(this.getMenuItem((byte)3, menuListener));
            }
            popMenu.add(this.getMenuItem((byte)5, menuListener));
        }
        return popMenu;
    }

    protected JMenuItem getMenuItem(byte action, ActionListener al) {
        String imgPath;
        String title;
        switch (action) {
            case 1: {
                title = mm.getMessage("filetree.open");
                imgPath = "m_open.gif";
                break;
            }
            case 2: {
                title = mm.getMessage("filetree.opendir");
                imgPath = "m_load.gif";
                break;
            }
            case 3: {
                title = mm.getMessage("filetree.openfiledir");
                imgPath = "m_load.gif";
                break;
            }
            case 4: {
                title = mm.getMessage("filetree.refresh");
                imgPath = "m_refresh.gif";
                break;
            }
            case 5: {
                title = ConfigOptions.bFileTreeDemo != false ? mm.getMessage("filetree.switchmain") : mm.getMessage("filetree.switchdemo");
                imgPath = "switchpath.gif";
                break;
            }
            default: {
                return null;
            }
        }
        JMenuItem mi = new JMenuItem(title);
        mi.setName(String.valueOf(action));
        if (imgPath != null) {
            mi.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/" + imgPath));
        }
        mi.addActionListener(al);
        return mi;
    }

    protected void menuAction(FileTreeNode node, JMenuItem mi) {
        String sAction = mi.getName();
        switch (Byte.parseByte(sAction)) {
            case 1: {
                this.openFile(node);
                break;
            }
            case 2: {
                try {
                    Desktop.getDesktop().open(new File((String)node.getUserObject()));
                }
                catch (Exception ex) {
                    GM.showException(GV.appFrame, ex);
                }
                break;
            }
            case 3: {
                try {
                    Desktop.getDesktop().open(new File((String)node.getUserObject()).getParentFile());
                }
                catch (Exception ex) {
                    GM.showException(GV.appFrame, ex);
                }
                break;
            }
            case 4: {
                this.refreshNode(node);
                break;
            }
            case 5: {
                ConfigOptions.bFileTreeDemo = ConfigOptions.bFileTreeDemo == false;
                this.refreshLocal();
                this.closeActiveNode();
            }
        }
    }

    protected void closeActiveNode() {
    }

    public void refreshNode(FileTreeNode node) {
        if (node == null) {
            return;
        }
        node.setLoaded(false);
        if (node.getType() == 1) {
            this.loadSubNode(node);
        } else if (node.getType() == 0) {
            this.refreshLocal();
        }
        this.nodeStructureChanged(node);
    }

    public void openFile(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            try {
                GV.appFrame.openSheetFile((String)node.getUserObject());
            }
            catch (Exception e) {
                GM.showException(GV.appFrame, e);
            }
        }
    }

    protected void nodeSelected(FileTreeNode node) {
    }

    private void setSubNodesSelected(FileTreeNode pNode, byte state) {
        int i = 0;
        while (i < pNode.getChildCount()) {
            FileTreeNode subNode = (FileTreeNode)pNode.getChildAt(i);
            subNode.setSelectedState(state);
            this.setSubNodesSelected(subNode, state);
            ++i;
        }
    }

    private void setParentNodesSelected(FileTreeNode node) {
        while (node.getParent() instanceof FileTreeNode) {
            FileTreeNode pNode = (FileTreeNode)node.getParent();
            byte tempState = 0;
            boolean allSelected = true;
            int i = 0;
            while (i < pNode.getChildCount()) {
                FileTreeNode subNode = (FileTreeNode)pNode.getChildAt(i);
                if (subNode.getSelectedState() != 1) {
                    allSelected = false;
                }
                if (subNode.getSelectedState() > tempState) {
                    tempState = subNode.getSelectedState();
                }
                ++i;
            }
            if (tempState == 1 && !allSelected) {
                tempState = 2;
            }
            pNode.setSelectedState(tempState);
            node = pNode;
        }
    }

    public void setCheckNodeModel(boolean isCheckNode) {
        this.isCheckNode = isCheckNode;
    }

    public boolean isCheckNodeModel() {
        return this.isCheckNode;
    }

    public FileTreeNode getActiveNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (FileTreeNode)path.getLastPathComponent();
    }

    protected FileTreeNode addFileNode(FileTreeNode pNode, String path, Object data) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        ArrayList<String> paths = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paths.add(st.nextToken());
        }
        if (paths.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < paths.size() - 1) {
            if ((pNode = this.getChildByName(pNode, (String)paths.get(i))) == null) {
                return null;
            }
            ++i;
        }
        String lastName = (String)paths.get(paths.size() - 1);
        FileTreeNode fNode = this.getChildByName(pNode, lastName);
        if (fNode != null) {
            return null;
        }
        fNode = new FileTreeNode(data, 1);
        fNode.setTitle(lastName);
        pNode.add(fNode);
        return fNode;
    }

    protected FileTreeNode locateFileNode(FileTreeNode pNode, String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        ArrayList<String> paths = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paths.add(st.nextToken());
        }
        if (paths.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < paths.size()) {
            if ((pNode = this.getChildByName(pNode, (String)paths.get(i))) == null) {
                return null;
            }
            ++i;
        }
        return pNode;
    }

    protected FileTreeNode locateFileNode(FileTreeNode pNode, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return pNode;
        }
        int size = paths.size();
        int i = size - 1;
        while (i >= 0) {
            if ((pNode = this.getChildByName(pNode, paths.get(i))) == null) {
                return null;
            }
            --i;
        }
        return pNode;
    }

    protected FileTreeNode getChildByName(FileTreeNode pNode, String nodeName) {
        if (nodeName == null) {
            return null;
        }
        int count = pNode.getChildCount();
        int i = 0;
        while (i < count) {
            FileTreeNode childNode = (FileTreeNode)pNode.getChildAt(i);
            if (nodeName.equals(childNode.getTitle())) {
                return childNode;
            }
            ++i;
        }
        return null;
    }

    protected void selectNode(FileTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        this.setSelectionPath(path);
        this.nodeSelected(node);
    }

    protected void nodeChanged(FileTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
    }

    protected void nodeStructureChanged(FileTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        }
    }

    public FileTreeNode getRoot() {
        return this.root;
    }

    public void changeMainPath(String mainPath) {
        ConfigOptions.sMainPath = mainPath;
        this.refreshLocal();
    }

    protected class MenuListener
    implements ActionListener {
        FileTreeNode node;

        public MenuListener(FileTreeNode node) {
            this.node = node;
        }

        public void setFileTreeNode(FileTreeNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            FileTree.this.menuAction(this.node, mi);
        }
    }

    class mTree_mouseAdapter
    extends MouseAdapter {
        mTree_mouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTree mTree = (JTree)e.getSource();
            TreePath path = mTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
            if (node.isCheckNode()) {
                FileTree.this.showNode(node);
                int x = e.getX();
                int level = node.getLevel();
                if (x < 22 + level * 20 && x > level * 20) {
                    byte newState;
                    byte oldState = node.getSelectedState();
                    switch (oldState) {
                        case 0: {
                            newState = 1;
                            break;
                        }
                        case 2: {
                            newState = 0;
                            break;
                        }
                        default: {
                            newState = 0;
                        }
                    }
                    node.setSelectedState(newState);
                    FileTree.this.setSubNodesSelected(node, newState);
                    FileTreeNode tempNode = node;
                    FileTree.this.setParentNodesSelected(tempNode);
                    FileTree.this.nodeChanged(node);
                }
            } else {
                FileTree.this.showNode(node);
            }
            FileTree.this.nodeSelected(node);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            TreePath path = FileTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            FileTree.this.setSelectionPath(path);
            FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
            JPopupMenu pop = FileTree.this.getPopupMenu(node);
            if (pop != null) {
                pop.show(e.getComponent(), e.getX(), e.getY());
            }
            FileTree.this.nodeSelected(node);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1 || e.getClickCount() != 2) {
                return;
            }
            TreePath path = FileTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
            FileTree.this.nodeSelected(node);
            if (!node.isDir()) {
                FileTree.this.openFile(node);
            }
        }
    }
}

