/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.ide.common.GM;
import com.scudata.ide.spl.base.FileTree;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_ROOT = 0;
    public static final byte TYPE_LOCAL = 1;
    public static final byte NOT_SELECTED = 0;
    public static final byte SELECTED = 1;
    public static final byte DONT_CARE = 2;
    private transient byte selectedState = 1;
    private boolean isCheckNode = false;
    private boolean isLoaded = false;
    protected byte type = 1;
    private String title = null;
    protected boolean isDir = false;
    private String filter = null;
    private ArrayList<FileTreeNode> childBuffer = null;
    private boolean isMatched = false;
    private boolean isExpanded = false;

    public FileTreeNode(Object data, byte type) {
        this.setUserObject(data);
        this.type = type;
    }

    public void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public void setMatched(boolean isMatched) {
        this.isMatched = isMatched;
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public ImageIcon getDispIcon() {
        String imgPath = "/com/scudata/ide/common/resources/";
        imgPath = this.type == 0 ? String.valueOf(imgPath) + "tree0.gif" : (this.getLevel() == 1 ? String.valueOf(imgPath) + "treelocal.gif" : (this.isDir ? String.valueOf(imgPath) + "treefolder.gif" : String.valueOf(imgPath) + "file_spl.png"));
        ImageIcon img = GM.getImageIcon(imgPath);
        return img;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getName() {
        return this.toString();
    }

    public String getFullPath() {
        String path = this.getName();
        FileTreeNode pNode = (FileTreeNode)this.getParent();
        while (pNode != null) {
            if (pNode.getName().equals(FileTree.ROOT_TITLE)) break;
            path = String.valueOf(pNode.getName()) + File.separator + path;
            pNode = (FileTreeNode)pNode.getParent();
        }
        return path;
    }

    public String getTitle() {
        return this.title == null ? this.getName() : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public byte getSelectedState() {
        return this.selectedState;
    }

    public void setSelectedState(byte selectedState) {
        this.selectedState = selectedState;
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.filter();
    }

    private void filter() {
        if (this.childBuffer == null) {
            this.childBuffer = new ArrayList();
            int i = 0;
            while (i < this.getChildCount()) {
                this.childBuffer.add((FileTreeNode)this.getChildAt(i));
                ++i;
            }
        }
        this.removeAllChildren();
        int c = 0;
        while (c < this.childBuffer.size()) {
            FileTreeNode childNode = this.childBuffer.get(c);
            String lowerTitle = childNode.getTitle().toLowerCase();
            if (lowerTitle.indexOf(this.filter) >= 0) {
                this.add(childNode);
            }
            ++c;
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isCheckNode() {
        return this.isCheckNode;
    }

    public void setCheckNode(boolean isCheckNode) {
        this.isCheckNode = isCheckNode;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public FileTreeNode deepClone() {
        FileTreeNode newNode = new FileTreeNode(this.getUserObject(), this.type);
        newNode.setTitle(this.title);
        newNode.setMatched(this.isMatched);
        newNode.setSelectedState(this.selectedState);
        newNode.setCheckNode(this.isCheckNode);
        return newNode;
    }

    @Override
    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        Object data = this.getUserObject();
        if (this.type == 1) {
            return data == null ? "" : data.toString();
        }
        return "";
    }
}

