/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.MessageManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.base.JTableJobSpace;
import com.scudata.ide.spl.base.PanelSelectField;
import com.scudata.ide.spl.base.TableVar;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class JTabbedParam
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private final String STR_CS_VAR = this.mm.getMessage("jtabbedparam.csvar");
    private final String STR_SPACE_VAR = this.mm.getMessage("jtabbedparam.spacevar");
    private final String STR_GB_VAR = this.mm.getMessage("jtabbedparam.globalvar");
    private final String STR_WATCH = this.mm.getMessage("jtabbedparam.watch");
    private final String STR_DB = this.mm.getMessage("jtabbedparam.db");
    private final String STR_CONSOLE = IdeSplMessage.get().getMessage("dfx.tabconsole");
    private JPanel jPCsVar = new JPanel(new GridBagLayout());
    private JPanel jPSpaceVar = new JPanel(new GridBagLayout());
    private JPanel jPGbVar = new JPanel(new GridBagLayout());
    private JButton jBCsRefresh = new JButton(IdeSplMessage.get().getMessage("public.refresh"));
    private JButton jBSpaceRefresh = new JButton(IdeSplMessage.get().getMessage("public.refresh"));
    private JButton jBGbRefresh = new JButton(IdeSplMessage.get().getMessage("public.refresh"));
    private TableVar tableCsVar = new TableVar(){
        private static final long serialVersionUID = 1L;

        @Override
        public void select(Object val, String varName) {
            JTabbedParam.this.selectVar(val, varName, null);
        }
    };
    private JTableJobSpace tableSpaceVar = new JTableJobSpace(){
        private static final long serialVersionUID = 1L;

        @Override
        public void select(Object val, String varName, String spaceName) {
            JTabbedParam.this.selectVar(val, varName, spaceName);
        }
    };
    private TableVar tableGbVar = new TableVar(){
        private static final long serialVersionUID = 1L;

        @Override
        public void select(Object val, String varName) {
            JTabbedParam.this.selectVar(val, varName, null);
        }
    };
    private PanelSelectField psf = new PanelSelectField();
    private PanelConsole panelConsole;

    public JTabbedParam() {
        try {
            this.initUI();
            this.resetEnv();
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    public void resetEnv() {
        boolean allClosed = true;
        if (GV.dsModel != null) {
            int i = 0;
            while (i < GV.dsModel.getSize()) {
                DataSource ds = (DataSource)GV.dsModel.get(i);
                if (ds != null && !ds.isClosed()) {
                    allClosed = false;
                    break;
                }
                ++i;
            }
        }
        int index = this.getTabIndex(this.STR_DB);
        if (allClosed) {
            if (index > -1) {
                this.remove(index);
            }
        } else {
            if (index < 0) {
                this.addTab(this.STR_DB, this.psf);
            }
            this.psf.resetEnv();
        }
    }

    public PanelConsole getPanelConsole() {
        return this.panelConsole;
    }

    public void consoleVisible(boolean isVisible) {
        int index = this.getTabIndex(this.STR_CONSOLE);
        if (isVisible) {
            if (index < 0) {
                if (this.panelConsole == null) {
                    this.panelConsole = new PanelConsole(GV.console, true);
                } else {
                    GV.console.clear();
                }
                this.addTab(this.STR_CONSOLE, this.panelConsole);
            }
            this.showConsoleTab();
        } else if (index > -1) {
            this.remove(index);
        }
    }

    public void showConsoleTab() {
        int index = this.getTabIndex(this.STR_CONSOLE);
        if (index > -1) {
            this.setSelectedIndex(index);
        }
    }

    private int getTabIndex(String tabName) {
        int count = this.getTabCount();
        int i = 0;
        while (i < count) {
            if (this.getTitleAt(i).equals(tabName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public abstract void selectVar(Object var1, String var2, String var3);

    public abstract ParamList getCellSetParamList();

    public abstract HashMap<String, Param[]> getSpaceParams();

    public abstract ParamList getEnvParamList();

    public void resetParamList(ParamList paramList, HashMap<String, Param[]> hm, ParamList envParamList) {
        this.tableCsVar.setParamList(paramList);
        this.tableSpaceVar.setJobSpaces(hm);
        this.tableGbVar.setParamList(envParamList);
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(1, 1));
        this.jPCsVar.add((Component)new JPanel(), GM.getGBC(0, 0, true));
        this.jPCsVar.add((Component)this.jBCsRefresh, GM.getGBC(0, 1));
        GridBagConstraints gbc = GM.getGBC(1, 0, true, true);
        gbc.gridwidth = 2;
        this.jPCsVar.add((Component)this.tableCsVar, gbc);
        this.jPSpaceVar.add((Component)new JPanel(), GM.getGBC(0, 0, true));
        this.jPSpaceVar.add((Component)this.jBSpaceRefresh, GM.getGBC(0, 1));
        gbc = GM.getGBC(1, 0, true, true);
        gbc.gridwidth = 2;
        this.jPSpaceVar.add((Component)this.tableSpaceVar, gbc);
        this.jPGbVar.add((Component)new JPanel(), GM.getGBC(0, 0, true));
        this.jPGbVar.add((Component)this.jBGbRefresh, GM.getGBC(0, 1));
        gbc = GM.getGBC(1, 0, true, true);
        gbc.gridwidth = 2;
        this.jPGbVar.add((Component)this.tableGbVar, gbc);
        this.addTab(this.STR_CS_VAR, this.jPCsVar);
        this.addTab(this.STR_SPACE_VAR, this.jPSpaceVar);
        this.addTab(this.STR_GB_VAR, this.jPGbVar);
        this.addTab(this.STR_WATCH, GVSpl.panelSplWatch);
        this.jBCsRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamList pl = JTabbedParam.this.getCellSetParamList();
                JTabbedParam.this.tableCsVar.setParamList(pl);
            }
        });
        this.jBSpaceRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<String, Param[]> hm = JTabbedParam.this.getSpaceParams();
                JTabbedParam.this.tableSpaceVar.setJobSpaces(hm);
            }
        });
        this.jBGbRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamList pl = JTabbedParam.this.getEnvParamList();
                JTabbedParam.this.tableGbVar.setParamList(pl);
            }
        });
    }
}

