/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Param;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public abstract class JTableJobSpace
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private volatile boolean preventChange = false;
    private HashMap<String, Param[]> paramMap;
    private final byte COL_INDEX = 0;
    private final byte COL_SPACE = 1;
    private final byte COL_NAME = (byte)2;
    private final byte COL_VALUE = (byte)3;
    private final byte COL_VAR = (byte)4;
    private final String TITLE_VAR = "TITLE_VAR";
    private JTableEx tableVar = new JTableEx(String.valueOf(this.mm.getMessage("jtablejobspace.tablenames")) + "," + "TITLE_VAR"){
        private static final long serialVersionUID = 1L;

        @Override
        public void rowfocusChanged(int oldRow, int newRow) {
            if (JTableJobSpace.this.preventChange) {
                return;
            }
            if (newRow != -1) {
                JTableJobSpace.this.selectParam(newRow);
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!this.isItemDataChanged(row, col, value)) {
                return;
            }
            super.setValueAt(value, row, col);
            if (JTableJobSpace.this.preventChange) {
                return;
            }
            Param p = (Param)this.data.getValueAt(row, 4);
            if (col == 2) {
                p.setName(value == null ? null : (String)value);
            } else if (value == null) {
                p.setValue(null);
            } else if (StringUtils.isValidString(value)) {
                String str = value.toString();
                Object val = Variant.parse(str);
                p.setValue(val);
                JTableJobSpace.this.preventChange = true;
                this.data.setValueAt(val, row, col);
                JTableJobSpace.this.preventChange = false;
            } else {
                p.setValue(value);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e == null) {
                return;
            }
            Point p = e.getPoint();
            if (p == null) {
                return;
            }
            int row = this.rowAtPoint(p);
            if (row != -1) {
                JTableJobSpace.this.selectParam(row);
            }
        }

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (row != -1) {
                JTableJobSpace.this.selectParam(row);
            }
        }
    };
    private JLabel jLDispRows1 = new JLabel(IdeSplMessage.get().getMessage("panelvalue.disprows1"));
    private JLabel jLDispRows2 = new JLabel(IdeSplMessage.get().getMessage("tablevar.dispvar"));
    private static final int DEFAULT_ROW_COUNT = 100;
    private JSpinner jSDispRows = new JSpinner(new SpinnerNumberModel(100, 1, Integer.MAX_VALUE, 1));
    private JPanel jPSouth = new JPanel(new GridBagLayout());

    public JTableJobSpace() {
        super(new BorderLayout());
        this.setMinimumSize(new Dimension(1, 1));
        this.init();
    }

    public abstract void select(Object var1, String var2, String var3);

    public void selectParam(int row) {
        if (row < 0) {
            return;
        }
        this.select(this.tableVar.data.getValueAt(row, 3), this.getVarName(row), this.getSpaceName(row));
    }

    public synchronized void setJobSpaces(HashMap<String, Param[]> paramMap) {
        this.paramMap = paramMap;
        this.tableVar.acceptText();
        this.tableVar.clearSelection();
        this.tableVar.removeAllRows();
        if (paramMap != null) {
            this.preventChange = true;
            int dispRows = this.getDispRows();
            boolean southVisible = false;
            for (String jsId : paramMap.keySet()) {
                Param[] paras;
                String spaceId;
                if (GV.appSheet != null && ((spaceId = ((SheetSpl)GV.appSheet).getSpaceId()) == null || !spaceId.equals(jsId)) || this.addJobSpaceRow(jsId, paras = paramMap.get(jsId), dispRows)) continue;
                southVisible = true;
                break;
            }
            if (southVisible) {
                if (!this.jPSouth.isVisible()) {
                    this.jPSouth.setVisible(true);
                }
            } else if (this.jPSouth.isVisible()) {
                this.jPSouth.setVisible(false);
            }
            this.preventChange = false;
        } else if (this.jPSouth.isVisible()) {
            this.jPSouth.setVisible(false);
        }
    }

    private boolean addJobSpaceRow(String id, Param[] params, int dispRows) {
        int j = 0;
        while (j < params.length) {
            int row = this.tableVar.addRow();
            this.tableVar.data.setValueAt(id, row, 1);
            this.tableVar.data.setValueAt(params[j].getName(), row, 2);
            this.tableVar.data.setValueAt(params[j].getValue(), row, 3);
            if (row + 1 >= dispRows && j != params.length - 1) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private String getSpaceName(int row) {
        return this.tableVar.data.getValueAt(row, 1) == null ? "" : (String)this.tableVar.data.getValueAt(row, 1);
    }

    private String getVarName(int row) {
        return this.tableVar.data.getValueAt(row, 2) == null ? "" : (String)this.tableVar.data.getValueAt(row, 2);
    }

    private int getDispRows() {
        if (!this.jPSouth.isVisible()) {
            return 100;
        }
        int dispRows = ((Number)this.jSDispRows.getValue()).intValue();
        return dispRows;
    }

    private void init() {
        JScrollPane jSPTable = new JScrollPane(this.tableVar);
        this.add((Component)jSPTable, "Center");
        this.add((Component)this.jPSouth, "South");
        this.jPSouth.setVisible(false);
        this.jPSouth.add((Component)this.jLDispRows1, GM.getGBC(0, 2, false, false, 2));
        this.jPSouth.add((Component)this.jSDispRows, GM.getGBC(0, 3, false, false, 0));
        this.jPSouth.add((Component)this.jLDispRows2, GM.getGBC(0, 4, false, false, 2));
        this.jPSouth.add((Component)new JPanel(), GM.getGBC(0, 5, true));
        this.jSDispRows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTableJobSpace.this.setJobSpaces(JTableJobSpace.this.paramMap);
            }
        });
        this.tableVar.setIndexCol(0);
        this.tableVar.setRowHeight(20);
        TableColumn tc = this.tableVar.getColumn(3);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this.tableVar));
        tc.setCellRenderer(new AllPurposeRenderer());
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    int row = JTableJobSpace.this.tableVar.getSelectedRow();
                    if (!StringUtils.isValidString(((JTableJobSpace)JTableJobSpace.this).tableVar.data.getValueAt(row, 2))) {
                        return;
                    }
                    String name = (String)((JTableJobSpace)JTableJobSpace.this).tableVar.data.getValueAt(row, 2);
                    String data = null;
                    data = dge.getTriggerEvent().isControlDown() ? name : "=" + name;
                    TransferableObject tf = new TransferableObject(data);
                    if (tf != null) {
                        dge.startDrag(GM.getDndCursor(), tf);
                    }
                }
                catch (Exception x) {
                    GM.showException(GV.appFrame, x);
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this.tableVar, 1, dgl);
        this.tableVar.setColumnVisible("TITLE_VAR", false);
        this.tableVar.setColumnVisible(this.tableVar.getColumnName(1), false);
    }
}

