/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ByteMap;
import com.scudata.common.IntArrayList;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Canvas;
import com.scudata.dm.DBObject;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.ide.common.AppendDataThread;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.EditListener;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.CellSelection;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.common.dialog.DialogCellFormat;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextFieldReadOnly;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.base.PanelValue;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.dialog.DialogDisplayChart;
import com.scudata.ide.spl.dialog.DialogTextEditor;
import com.scudata.ide.spl.dialog.DialogZoom;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.Variant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class JTableValue
extends JTableEx {
    private static final long serialVersionUID = -4530154524747498116L;
    private PanelValue panelValue;
    private static MessageManager mm = IdeSplMessage.get();
    private final String TITLE_INDEX = mm.getMessage("public.index");
    private final String TITLE_SERIES = mm.getMessage("jtablevalue.menber");
    private final int COL_FIRST = 0;
    private final byte TYPE_DEFAULT = 0;
    private final byte TYPE_TABLE = 1;
    private final byte TYPE_SERIES = (byte)2;
    private final byte TYPE_RECORD = (byte)3;
    private final byte TYPE_PMT = (byte)4;
    private final byte TYPE_SERIESPMT = (byte)5;
    private final byte TYPE_DB = (byte)6;
    private final byte TYPE_FILE = (byte)7;
    private byte m_type = 0;
    private Object value;
    private Object originalValue;
    private Canvas canvas;
    private boolean editable;
    private Stack<Object> undo = new Stack();
    private Stack<Object> redo = new Stack();
    private volatile boolean isLocked = false;
    private volatile boolean isLocked1 = false;
    private String cellId;
    public static final short iCOPY = 11;
    public static final short iCOPY_COLNAMES = 12;
    private final short iPASTE = (short)13;
    private final short iFORMAT = (short)17;
    private int rowCount = 0;
    private EditListener editListener = null;
    private IntArrayList selectedRows = new IntArrayList();
    private volatile int lastRow = -1;
    private volatile boolean isFirstAdd = true;
    public static final String LABEL_COPY_COLUMN = mm.getMessage("jtablevalue.copycolnames");
    public static final String LABEL_VIEW_TEXT = mm.getMessage("dialogtexteditor.title1");
    public static final String LABEL_ZOOM = mm.getMessage("jtablevalue.zoom");
    private ActionListener popAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mItem = (JMenuItem)e.getSource();
            short cmd = Short.parseShort(mItem.getName());
            switch (cmd) {
                case 11: {
                    JTableValue.this.copyValue();
                    break;
                }
                case 12: {
                    JTableValue.this.copyColumnNames();
                    break;
                }
                case 13: {
                    JTableValue.this.pasteValue();
                    break;
                }
                case 17: {
                    JTableValue.this.colFormat();
                }
            }
        }
    };
    private final int DISP_ROWS = 50;
    private ResetDataThread resetThread = null;
    private volatile int dispStartIndex = 1;
    private Table dbTable = null;
    private final int MAX_COL_WIDTH = 300;
    private final int WIDTH_GAP = 8;
    private volatile float scale = 1.0f;
    private volatile boolean hasIndexCol;
    private Map<Integer, Integer> originColWidthMap = new HashMap<Integer, Integer>();

    public JTableValue(PanelValue panelValue) {
        this.panelValue = panelValue;
        this.setRowHeight(this.getScaleRowHeight());
        this.addMWListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = JTableValue.this.lastRow;
                switch (e.getKeyCode()) {
                    case 38: {
                        if (--row < 0) {
                            row = 0;
                        }
                        JTableValue.this.rowSelected(e, row);
                        break;
                    }
                    case 40: {
                        if (++row > JTableValue.this.rowCount - 1) {
                            row = JTableValue.this.rowCount - 1;
                        }
                        JTableValue.this.rowSelected(e, row);
                        break;
                    }
                    case 33: {
                        if ((row -= JTableValue.this.getPageRows()) < 0) {
                            row = 0;
                        }
                        JTableValue.this.rowSelected(e, row);
                        break;
                    }
                    case 34: {
                        if ((row += JTableValue.this.getPageRows()) > JTableValue.this.rowCount - 1) {
                            row = JTableValue.this.rowCount - 1;
                        }
                        JTableValue.this.rowSelected(e, row);
                        break;
                    }
                    case 65: {
                        if (!e.isControlDown()) break;
                        JTableValue.this.selectedRows.clear();
                        int i = 0;
                        while (i < JTableValue.this.rowCount) {
                            JTableValue.this.selectedRows.addInt(i);
                            ++i;
                        }
                        JTableValue.this.resetSelection();
                        JTableValue.this.lastRow = JTableValue.this.rowCount - 1;
                        break;
                    }
                    case 67: {
                        if (e.isControlDown()) {
                            JTableValue.this.copyValue();
                        }
                        e.consume();
                    }
                }
            }
        });
    }

    public void addDragListener() {
        if (!this.editable) {
            return;
        }
        if (!this.isFirstAdd) {
            return;
        }
        this.isFirstAdd = !this.isFirstAdd;
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    TransferableObject tf = new TransferableObject(JTableValue.this.value);
                    if (tf != null) {
                        dge.startDrag(GM.getDndCursor(), tf);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, dgl);
        DropTargetListener dtl = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                JTableValue.this.acceptText();
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (!JTableValue.this.editable) {
                    return;
                }
                Point p = dtde.getLocation();
                int row = JTableValue.this.rowAtPoint(p);
                int col = JTableValue.this.columnAtPoint(p);
                if (row < 0 || col < 0) {
                    return;
                }
                JTableValue.this.setRowSelectionInterval(row, row);
                JTableValue.this.setColumnSelectionInterval(col, col);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                if (!JTableValue.this.editable) {
                    return;
                }
                Point p = dtde.getLocation();
                int row = JTableValue.this.rowAtPoint(p);
                int col = JTableValue.this.columnAtPoint(p);
                if (row < 0 || col < 0) {
                    return;
                }
                if (!JTableValue.this.isCellEditable(row, col)) {
                    return;
                }
                Object value = null;
                try {
                    value = dtde.getTransferable().getTransferData(TransferableObject.objectFlavor);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (value == null) {
                    return;
                }
                JTableValue.this.setValueAt(value, row, col);
            }
        };
        DropTarget dt = new DropTarget(this, dtl);
        this.setDropTarget(dt);
    }

    private int getScaleRowHeight() {
        return (int)(ConfigOptions.fRowHeight.floatValue() * this.scale);
    }

    public void setEditListener(EditListener el) {
        this.editListener = el;
    }

    private int getPageRows() {
        int height = this.panelValue.spValue.getPreferredSize().height;
        return height / this.getScaleRowHeight() + 1;
    }

    private void rowSelected(InputEvent e, int row) {
        if (e.isControlDown()) {
            if (this.selectedRows.containsInt(row)) {
                this.selectedRows.removeInt(row);
            } else {
                this.selectedRows.addInt(row);
            }
            this.resetSelection();
            this.lastRow = row;
        } else if (e.isShiftDown()) {
            this.selectedRows.clear();
            int min = Math.min(row, this.lastRow);
            int max = Math.max(row, this.lastRow);
            int i = min;
            while (i <= max) {
                this.selectedRows.addInt(i);
                ++i;
            }
            this.resetSelection();
        } else {
            this.selectedRows.clear();
            this.selectedRows.addInt(row);
            this.resetSelection();
            this.lastRow = row;
        }
        if (e instanceof KeyEvent) {
            e.consume();
        }
    }

    public void addMWListener(JComponent com) {
        com.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    int newPercent;
                    int percent = (int)(JTableValue.this.scale * 100.0f);
                    int wr = e.getWheelRotation();
                    if (wr < 0) {
                        newPercent = GCSpl.DEFAULT_SCALES[GCSpl.DEFAULT_SCALES.length - 1];
                        int i = 0;
                        while (i < GCSpl.DEFAULT_SCALES.length) {
                            if (percent < GCSpl.DEFAULT_SCALES[i] - 7) {
                                newPercent = GCSpl.DEFAULT_SCALES[i];
                                break;
                            }
                            ++i;
                        }
                    } else {
                        newPercent = GCSpl.DEFAULT_SCALES[0];
                        int i = GCSpl.DEFAULT_SCALES.length - 1;
                        while (i >= 0) {
                            if (percent > GCSpl.DEFAULT_SCALES[i] + 7) {
                                newPercent = GCSpl.DEFAULT_SCALES[i];
                                break;
                            }
                            --i;
                        }
                    }
                    if (newPercent != percent) {
                        JTableValue.this.setScale(new Float(newPercent).floatValue() / 100.0f);
                        if (GVSpl.splEditor != null) {
                            GVSpl.splEditor.setDataChanged(true);
                        }
                    }
                    return;
                }
                if (e.getScrollType() == 0) {
                    int amount = e.getScrollAmount();
                    int rotation = e.getWheelRotation();
                    if (rotation < 0) {
                        amount = -amount;
                    }
                    JScrollBar sbValue = ((JTableValue)JTableValue.this).panelValue.sbValue;
                    sbValue.setValue(sbValue.getValue() + amount);
                    JTableValue.this.resetData(sbValue.getValue());
                }
            }
        });
    }

    @Override
    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
        this.drillValue(row, col);
    }

    @Override
    public void rightClicked(int xpos, int ypos, final int row, final int col, MouseEvent e) {
        Object cellVal;
        JMenuItem mItem;
        JPopupMenu pm = new JPopupMenu();
        int selectedCol = this.getSelectedColumn();
        if ((this.m_type == 1 || this.m_type == 4 || this.m_type == 5) && (this.hasIndexCol && selectedCol > 0 || !this.hasIndexCol && selectedCol > -1)) {
            mItem = new JMenuItem(mm.getMessage("jtablevalue.editformat"));
            mItem.setIcon(GM.getMenuImageIcon("blank"));
            mItem.setName(String.valueOf(17));
            mItem.addActionListener(this.popAction);
            pm.add(mItem);
        }
        mItem = new JMenuItem(LABEL_COPY_COLUMN);
        mItem.setIcon(GM.getMenuImageIcon("blank"));
        mItem.setName(String.valueOf(12));
        mItem.addActionListener(this.popAction);
        pm.add(mItem);
        if (row > -1 && col > -1 && (cellVal = this.data.getValueAt(row, col)) != null && cellVal instanceof String) {
            mItem = new JMenuItem(LABEL_VIEW_TEXT);
            mItem.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_showtext.gif"));
            mItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JTableValue.this.showText(row, col, cellVal);
                }
            });
            pm.add(mItem);
        }
        mItem = new JMenuItem(LABEL_ZOOM);
        mItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JTableValue.this.dialogZoom();
            }
        });
        pm.add(mItem);
        pm.show(e.getComponent(), e.getX(), e.getY());
        e.consume();
    }

    private void colFormat() {
        int col = this.getSelectedColumn();
        if (col < 0) {
            return;
        }
        String colName = null;
        if (!StringUtils.isValidString(colName)) {
            colName = this.getColumnName(col);
        }
        GM.ValueColInfo colInfo = GM.getValueColInfo(colName);
        String format = null;
        if (colInfo != null) {
            format = colInfo.format;
        }
        DialogCellFormat dcf = new DialogCellFormat();
        if (format != null) {
            dcf.setFormat(format);
        }
        dcf.setVisible(true);
        if (dcf.getOption() == 0) {
            format = dcf.getFormat();
            if (colInfo == null) {
                colInfo = new GM.ValueColInfo();
                colInfo.colWidth = this.getOriginColWidth(col);
            }
            colInfo.format = format;
            GM.saveValueColInfo(colName, colInfo);
            this.setColInfo(col, colInfo);
        }
    }

    private void setColInfo(int col, GM.ValueColInfo colInfo) {
        String format = null;
        int width = 0;
        if (colInfo != null) {
            format = colInfo.format;
            width = colInfo.colWidth;
        }
        TableColumn tc = this.getColumn(col);
        tc.setCellEditor(this.getAllPurposeEditor());
        tc.setCellRenderer(new AllPurposeRenderer(format));
        if (width > 0) {
            this.setColumnWidth(col, width);
        }
        this.repaint();
    }

    public void refresh() {
        this.forceSetValue(this.value);
    }

    public boolean valueIsNull() {
        return this.value == null;
    }

    public void setLocked1(boolean locked1) {
        this.isLocked1 = locked1;
        this.setLocked(locked1);
    }

    public boolean isLocked1() {
        return this.isLocked1;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
        this.panelValue.valueBar.setLocked(locked);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void cursorFetch(int dispRows) {
        if (this.originalValue == null || !(this.originalValue instanceof ICursor) || this.originalValue instanceof IMultipath) {
            return;
        }
        ICursor cursor = (ICursor)this.originalValue;
        Sequence data = cursor.peek(dispRows);
        this.redo.clear();
        this.undo.push(this.getUndoObject());
        this.value = data;
        this.forceSetValue(data);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.refreshValueButton();
        int row = this.rowAtPoint(e.getPoint());
        if (row < 0) {
            return;
        }
        row += this.panelValue.sbValue.getValue() - 1;
        if (this.selectedRows.isEmpty()) {
            this.selectedRows.addInt(row);
            this.resetSelection();
            this.lastRow = row;
            return;
        }
        this.rowSelected(e, row);
    }

    private void refreshValueButton() {
        this.panelValue.valueBar.refresh();
    }

    private void resetSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ListSelectionModel selectModel = JTableValue.this.getSelectionModel();
                    selectModel.clearSelection();
                    if (!JTableValue.this.selectedRows.isEmpty()) {
                        int i = 0;
                        while (i < JTableValue.this.selectedRows.size()) {
                            int r = JTableValue.this.selectedRows.getInt(i);
                            if ((r = r - ((JTableValue)JTableValue.this).panelValue.sbValue.getValue() + 1) > -1 && r < JTableValue.this.getRowCount()) {
                                selectModel.addSelectionInterval(r, r);
                            }
                            ++i;
                        }
                    }
                    JTableValue.this.setSelectionModel(selectModel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void resetData(int index) {
        this.resetData(index, false, this.getColWidths());
    }

    public void resetData(int index, boolean setValue, int[] colWidths) {
        Sequence s;
        if (index <= 0) {
            index = 1;
        }
        this.dispStartIndex = index;
        if (this.resetThread != null) {
            this.resetThread.stopThread();
            try {
                this.resetThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.resetThread = null;
        switch (this.m_type) {
            case 6: {
                s = this.dbTable;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (!(this.value instanceof Sequence)) {
                    return;
                }
                s = (Sequence)this.value;
                break;
            }
            default: {
                this.resetSelection();
                return;
            }
        }
        this.resetThread = new ResetDataThread(s, index, this.m_type, setValue, colWidths);
        SwingUtilities.invokeLater(this.resetThread);
    }

    public Font getScaleFont() {
        return GM.getScaleFont(this.scale);
    }

    private void setRecordRow(BaseRecord record, int r, boolean isSeq, int index, boolean isDup) {
        block15: {
            DataStruct ds;
            String[] colNames;
            block14: {
                if (record == null || r < 0) {
                    return;
                }
                if (this.m_type != 1) break block14;
                int colCount = this.getColumnCount();
                if (isSeq) {
                    this.data.setValueAt(new Integer(index), r, 0);
                }
                int j = isSeq ? 1 : 0;
                while (j < colCount) {
                    this.data.setValueAt(record.getFieldValue(isSeq ? j - 1 : j), r, j);
                    ++j;
                }
                break block15;
            }
            if (isSeq) {
                this.data.setValueAt(new Integer(index), r, 0);
            }
            if ((colNames = (ds = record.dataStruct()).getFieldNames()) == null) break block15;
            if (isDup) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int j = 0;
                while (j < colNames.length) {
                    Object val;
                    try {
                        val = record.getFieldValue(j);
                    }
                    catch (Throwable e) {
                        val = null;
                    }
                    Integer colIndex = (Integer)map.get(colNames[j]);
                    colIndex = colIndex == null ? Integer.valueOf(0) : Integer.valueOf(colIndex + 1);
                    int col = this.getColumnIndex(colNames[j], isSeq ? 1 : 0, colIndex);
                    if (col > -1) {
                        map.put(colNames[j], colIndex);
                        this.data.setValueAt(val, r, col);
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < colNames.length) {
                    Object val;
                    try {
                        val = record.getFieldValue(colNames[j]);
                    }
                    catch (Throwable e) {
                        val = null;
                    }
                    int col = this.getColumnIndex(colNames[j], isSeq ? 1 : 0);
                    if (col > -1) {
                        this.data.setValueAt(val, r, col);
                    }
                    ++j;
                }
            }
        }
    }

    private int getColumnIndex(String colName, int startIndex) {
        return this.getColumnIndex(colName, startIndex, 0);
    }

    private int getColumnIndex(String colName, int startIndex, int colIndex) {
        int dupCount = 0;
        int i = startIndex;
        while (i < this.getColumnCount()) {
            String name = this.getColumnName(i);
            if (name.equals(colName)) {
                if (colIndex > dupCount) {
                    ++dupCount;
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private boolean isDupColNames() {
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < this.getColumnCount()) {
            String name = this.getColumnName(i);
            if (hs.contains(name)) {
                return true;
            }
            hs.add(name);
            ++i;
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (this.m_type) {
            case 1: 
            case 4: 
            case 5: {
                int count;
                Sequence s = (Sequence)this.value;
                if (s.dataStruct() == null || column <= (count = s.dataStruct().getFieldCount())) break;
                return false;
            }
        }
        TableColumn tc = this.getColumn(column);
        TableCellEditor tce = tc.getCellEditor();
        boolean readOnly = true;
        if (tce instanceof AllPurposeEditor) {
            AllPurposeEditor ape = (AllPurposeEditor)tce;
            boolean bl = readOnly = !ape.isCellEditable(null);
        }
        return this.editable && !readOnly;
    }

    public void clear() {
        this.undo.clear();
        this.redo.clear();
        this.isLocked = false;
        this.value = null;
        this.initJTable();
    }

    public void setCellId(String id) {
        if (this.isLocked) {
            return;
        }
        this.cellId = id;
    }

    public String getCellId() {
        return this.cellId;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, String cellId) {
        if (cellId != null && cellId.equals(this.getCellId()) && value == this.getOriginalValue()) {
            return;
        }
        this.setValue(value, false);
    }

    public void setValue1(Object value, String id) {
        this.setValue1(value, id, false);
    }

    public void setValue1(Object value, String id, boolean isRefresh) {
        if (id != null && id.equals(this.getCellId()) && value == this.originalValue && isRefresh) {
            return;
        }
        this.originalValue = value;
        this.setValue(value, false, true, null, true);
        this.cellId = id;
    }

    public void setValue(Object value, boolean editable) {
        this.setValue(value, editable, false);
    }

    private synchronized void setValue(Object value, boolean editable, boolean forceSetValue) {
        this.setValue(value, editable, forceSetValue, null);
    }

    private synchronized void setValue(Object value, boolean editable, boolean forceSetValue, UndoObject uo) {
        this.setValue(value, editable, forceSetValue, uo, !forceSetValue);
    }

    private synchronized void setValue(Object value, boolean editable, boolean forceSetValue, final UndoObject uo, final boolean resetUndo) {
        this.addDragListener();
        if (this.isLocked && !forceSetValue) {
            return;
        }
        if (value != null) {
            if (value instanceof Canvas) {
                this.canvas = (Canvas)value;
                value = ((Canvas)value).getChartElements();
            } else {
                this.canvas = null;
            }
        } else {
            this.canvas = null;
        }
        this.value = value;
        if (!forceSetValue) {
            this.originalValue = value;
        }
        this.editable = editable;
        this.rowCount = 0;
        this.dbTable = null;
        boolean isCursor = false;
        if (this.originalValue != null && this.originalValue instanceof ICursor && !(this.originalValue instanceof IMultipath)) {
            isCursor = true;
        }
        this.panelValue.setCursorValue(isCursor);
        final Object aValue = value;
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                JTableValue.this.resetValue(resetUndo, aValue, uo);
            }
        });
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private synchronized void resetValue(boolean resetUndo, Object aValue, UndoObject uo) {
        block28: {
            try {
                this.initJTable();
                if (resetUndo) {
                    this.undo.clear();
                    this.redo.clear();
                }
                this.refreshValueButton();
                if (GV.appSheet != null || aValue != null) break block28;
                if (this.resetThread != null) {
                    this.resetThread.stopThread();
                    try {
                        this.resetThread.join();
                    }
                    catch (Throwable var4_4) {
                        // empty catch block
                    }
                }
                this.resetThread = null;
            }
            catch (Throwable var5_20) {
                try {
                    if (uo != null) {
                        this.selectedRows = uo.selectedRows;
                        dispStartIndex = uo.dispStartIndex;
                        colWidths /* !! */  = uo.colWidths;
                    } else {
                        this.selectedRows.clear();
                        dispStartIndex = 1;
                        colWidths /* !! */  = (int[])(this.m_type == 2 ? this.getColWidths() : null);
                    }
                    this.panelValue.preventChange = true;
                    this.panelValue.sbValue.setMinimum(1);
                    this.panelValue.sbValue.setMaximum(this.rowCount);
                    this.panelValue.sbValue.setValue(dispStartIndex);
                    this.resetData(dispStartIndex, true, colWidths /* !! */ );
                }
                catch (Throwable var8_12) {
                    horizontalValue = uo != null ? uo.horizontalValue : 0;
                    SwingUtilities.invokeLater(new Runnable(horizontalValue){
                        private final /* synthetic */ int val$horizontalValue;
                        {
                            this.val$horizontalValue = n;
                        }

                        @Override
                        public void run() {
                            JScrollBar jsb = ((JTableValue)JTableValue.this).panelValue.spValue.getHorizontalScrollBar();
                            if (jsb != null) {
                                jsb.setValue(this.val$horizontalValue);
                            }
                        }
                    });
                    this.panelValue.preventChange = false;
                    throw var8_12;
                }
                horizontalValue = uo != null ? uo.horizontalValue : 0;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.panelValue.preventChange = false;
                throw var5_20;
            }
            try {
                if (uo != null) {
                    this.selectedRows = uo.selectedRows;
                    dispStartIndex = uo.dispStartIndex;
                    colWidths /* !! */  = uo.colWidths;
                } else {
                    this.selectedRows.clear();
                    dispStartIndex = 1;
                    colWidths /* !! */  = (int[])(this.m_type == 2 ? this.getColWidths() : null);
                }
                this.panelValue.preventChange = true;
                this.panelValue.sbValue.setMinimum(1);
                this.panelValue.sbValue.setMaximum(this.rowCount);
                this.panelValue.sbValue.setValue(dispStartIndex);
                this.resetData(dispStartIndex, true, colWidths /* !! */ );
            }
            catch (Throwable var8_11) {
                horizontalValue = uo != null ? uo.horizontalValue : 0;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.panelValue.preventChange = false;
                throw var8_11;
            }
            horizontalValue = uo != null ? uo.horizontalValue : 0;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            this.panelValue.preventChange = false;
            return;
        }
        this.setColumnModel();
        this.hasIndexCol = false;
        this.m_type = this.getValueType(aValue);
        switch (this.m_type) {
            case 1: {
                this.rowCount = this.initTable((Table)aValue);
                ** break;
            }
            case 4: {
                this.rowCount = this.initPmt((Sequence)aValue);
                ** break;
            }
            case 3: {
                this.rowCount = this.initRecord((BaseRecord)aValue);
                ** break;
            }
            case 2: {
                this.rowCount = this.initSeries((Sequence)aValue);
                ** break;
            }
            case 5: {
                this.rowCount = this.initSeriesPmt((Sequence)aValue);
                ** break;
            }
            case 6: {
                this.rowCount = this.initDB((DBObject)aValue);
                ** break;
            }
            case 7: {
                this.rowCount = this.initFile((FileObject)aValue);
                ** break;
            }
            default: {
                this.rowCount = this.initDefault(aValue);
                ** break;
            }
        }
lbl96:
        // 8 sources

        try {
            if (uo != null) {
                this.selectedRows = uo.selectedRows;
                dispStartIndex = uo.dispStartIndex;
                colWidths /* !! */  = uo.colWidths;
            } else {
                this.selectedRows.clear();
                dispStartIndex = 1;
                colWidths /* !! */  = (int[])(this.m_type == 2 ? this.getColWidths() : null);
            }
            this.panelValue.preventChange = true;
            this.panelValue.sbValue.setMinimum(1);
            this.panelValue.sbValue.setMaximum(this.rowCount);
            this.panelValue.sbValue.setValue(dispStartIndex);
            this.resetData(dispStartIndex, true, colWidths /* !! */ );
        }
        catch (Throwable var8_13) {
            horizontalValue = uo != null ? uo.horizontalValue : 0;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            this.panelValue.preventChange = false;
            throw var8_13;
        }
        horizontalValue = uo != null ? uo.horizontalValue : 0;
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        this.panelValue.preventChange = false;
    }

    private void initJTable() {
        this.removeAllRows();
        this.data.setColumnCount(0);
        this.data.getDataVector().clear();
        this.originColWidthMap.clear();
    }

    private byte getValueType(Object value) {
        if (value instanceof Table) {
            this.setAutoResizeMode(0);
            return 1;
        }
        if (value instanceof Sequence) {
            if (((Sequence)value).isPurePmt()) {
                this.setAutoResizeMode(0);
                return 4;
            }
            return 2;
        }
        if (value instanceof BaseRecord) {
            this.setAutoResizeMode(0);
            return 3;
        }
        if (value instanceof DBObject) {
            this.setAutoResizeMode(4);
            return 6;
        }
        if (value instanceof FileObject) {
            this.setAutoResizeMode(4);
            return 7;
        }
        this.setAutoResizeMode(4);
        return 0;
    }

    private int initTable(Table table) {
        if (table == null) {
            return 0;
        }
        int len = table.length();
        DataStruct ds = table.dataStruct();
        this.setTableColumns(ds, len, true);
        this.setEditStyle(ds, true);
        return len;
    }

    private int initPmt(Sequence pmt) {
        if (pmt == null) {
            return 0;
        }
        DataStruct ds = pmt.dataStruct();
        int len = pmt.length();
        this.setTableColumns(ds, len, true);
        this.setEditStyle(ds, true);
        return len;
    }

    private int initSeriesPmt(Sequence pmt) {
        if (pmt == null) {
            return 0;
        }
        DataStruct ds = this.getFirstDataStruct(pmt);
        int len = pmt.length();
        this.setTableColumns(ds, len, true);
        this.setEditStyle(ds, true);
        return len;
    }

    private DataStruct getFirstDataStruct(Sequence pmt) {
        int size = pmt.length();
        int i = 1;
        while (i <= size) {
            DataStruct ds;
            Object obj = pmt.get(i);
            if (obj != null && obj instanceof BaseRecord && (ds = ((BaseRecord)obj).dataStruct()) != null && ds.getFieldCount() > 0) {
                return ds;
            }
            ++i;
        }
        return null;
    }

    private int initSeries(Sequence series) {
        this.hasIndexCol = true;
        this.addColumn(this.TITLE_INDEX);
        this.addColumn(this.TITLE_SERIES);
        int width = this.getParent().getWidth();
        width = (int)((float)width / this.scale);
        TableColumn tc = this.getColumn(this.TITLE_INDEX);
        tc.setCellEditor(this.getAllPurposeEditor());
        tc.setCellRenderer(new AllPurposeRenderer(true));
        int INDEX_WIDTH = this.getIndexColWidth(series == null ? 0 : series.length());
        this.setColWidth(0, INDEX_WIDTH, false);
        tc = this.getColumn(this.TITLE_SERIES);
        this.setColWidth(1, width - INDEX_WIDTH);
        tc.setCellEditor(this.getAllPurposeEditor());
        tc.setCellRenderer(new AllPurposeRenderer(true));
        return series == null ? 0 : series.length();
    }

    private int initRecord(BaseRecord record) {
        DataStruct ds = record.dataStruct();
        this.setTableColumns(ds, 1, false);
        try {
            AppendDataThread.addRecordRow(this, record);
        }
        catch (Throwable ex) {
            GM.showException(GV.appFrame, ex);
        }
        this.setEditStyle(ds, false);
        return 1;
    }

    private int initDB(DBObject db) {
        this.dbTable = GMSpl.getDBTable(db);
        this.addColumn(GCSpl.TITLE_NAME);
        this.addColumn(GCSpl.TITLE_PROP);
        int i = 0;
        while (i < this.getColumnCount()) {
            this.setColumnEditable(i, false);
            ++i;
        }
        if (db == null || db.getDbSession() == null) {
            return 0;
        }
        int width = this.getParent().getWidth();
        width = (int)((float)width / this.scale);
        this.setColWidth(0, width / 2, true);
        this.setColWidth(1, width / 2, true);
        return this.dbTable.length();
    }

    private int initFile(FileObject file) {
        this.addColumn(mm.getMessage("jtablevalue.file"));
        return this.initSingleValue(file);
    }

    private int initDefault(Object value) {
        this.addColumn(mm.getMessage("jtablevalue.value"));
        return this.initSingleValue(value);
    }

    private int initSingleValue(Object value) {
        TableColumn tc = this.getColumn(0);
        tc.setCellEditor(this.getAllPurposeEditor());
        tc.setCellRenderer(new AllPurposeRenderer());
        if (this.getRowCount() == 0) {
            this.addRow();
        }
        this.data.setValueAt(value, 0, 0);
        return 1;
    }

    private boolean isPrimary(String[] primaries, String colName) {
        if (primaries == null) {
            return false;
        }
        int i = 0;
        while (i < primaries.length) {
            if (colName.equals(primaries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setEditStyle(DataStruct ds, boolean hasIndex) {
        TableColumn tc;
        if (ds == null) {
            return;
        }
        if (hasIndex) {
            tc = this.getColumn(0);
            tc.setCellRenderer(new AllPurposeRenderer(hasIndex));
        }
        String[] cols = ds.getFieldNames();
        String[] primaries = ds.getPrimary();
        int i = 0;
        while (i < cols.length) {
            tc = hasIndex ? this.getColumn(i + 1) : this.getColumn(i);
            boolean isPrimary = this.isPrimary(primaries, cols[i]);
            boolean editable = !isPrimary;
            tc.setCellEditor(this.getAllPurposeEditor(editable));
            GM.ValueColInfo colInfo = GM.getValueColInfo(cols[i]);
            if (colInfo != null && StringUtils.isValidString(colInfo.format)) {
                tc.setCellRenderer(new AllPurposeRenderer(colInfo.format));
            } else {
                tc.setCellRenderer(new AllPurposeRenderer(hasIndex));
            }
            if (colInfo != null && colInfo.colWidth > 0) {
                this.setColumnWidth(cols[i], colInfo.colWidth);
            }
            ++i;
        }
    }

    public void initScale(PgmCellSet cellSet) {
        Object scaleObj;
        ByteMap bm;
        float scale = 1.0f;
        if (cellSet != null && (bm = cellSet.getCustomPropMap()) != null && (scaleObj = bm.get((byte)22)) != null) {
            scale = ((Number)scaleObj).floatValue();
        }
        this.originColWidthMap.clear();
        this.setScale(scale);
    }

    public void refreshOptions() {
        this.setScale(this.scale);
    }

    private void setScale(float newScale) {
        PgmCellSet cellSet;
        SplControl control;
        this.scale = newScale;
        this.setRowHeight(this.getScaleRowHeight());
        Font scaleFont = this.getScaleFont();
        this.setFont(scaleFont);
        JTableHeader tableHeader = this.getTableHeader();
        Font headerFont = new Font("Dialog", scaleFont.getStyle(), scaleFont.getSize());
        tableHeader.setFont(headerFont);
        tableHeader.repaint();
        int c = 0;
        while (c < this.getColumnCount()) {
            this.setColWidth(c, this.getOriginColWidth(c), !this.hasIndexCol || c != 0);
            ++c;
        }
        if (GVSpl.splEditor != null && (control = GVSpl.splEditor.getComponent()) != null && (cellSet = control.cellSet) != null) {
            ByteMap bm = cellSet.getCustomPropMap();
            if (bm == null) {
                bm = new ByteMap();
                cellSet.setCustomPropMap(bm);
            }
            bm.put((byte)22, Float.valueOf(this.scale));
        }
        this.repaint();
    }

    private synchronized void setTableColumns(DataStruct ds, int len, boolean hasIndexCol) {
        if (ds == null) {
            return;
        }
        this.hasIndexCol = hasIndexCol;
        String[] nNames = ds.getFieldNames();
        if (nNames != null) {
            Vector<String> cols = new Vector<String>();
            if (this.value instanceof Sequence) {
                cols.add(this.TITLE_INDEX);
            }
            int i = 0;
            while (i < nNames.length) {
                cols.add(nNames[i]);
                ++i;
            }
            this.data.setDataVector(null, cols);
        }
        try {
            int startCol;
            int INDEX_WIDTH;
            int cc = this.getColumnCount();
            if (hasIndexCol) {
                INDEX_WIDTH = this.getIndexColWidth(len);
                TableColumn tc = this.getColumn(this.TITLE_INDEX);
                this.setColWidth(0, INDEX_WIDTH, false);
            } else {
                INDEX_WIDTH = 0;
            }
            int[] pkIndex = ds.getPKIndex();
            int IMAGE_WIDTH = 35;
            int i = startCol = hasIndexCol ? 1 : 0;
            while (i < cc) {
                TableColumn tc = this.getColumn(i);
                int titleWidth = this.getFontMetrics(this.getScaleFont()).stringWidth(this.getColumnName(i));
                if (this.isPK(pkIndex, i - startCol)) {
                    tc.setHeaderRenderer(new PKRenderer());
                    titleWidth += 35;
                }
                titleWidth = Math.min(titleWidth + 8, 300);
                int colWidth = Math.max(titleWidth, this.getOriginColWidth(i));
                GM.ValueColInfo colInfo = GM.getValueColInfo(this.getColumnName(i));
                if (colInfo != null && colInfo.colWidth > 0) {
                    colWidth = Math.max(colWidth, colInfo.colWidth);
                }
                this.setColWidth(i, colWidth);
                ++i;
            }
            int totalColWidth = 0;
            int i2 = 0;
            while (i2 < cc) {
                totalColWidth += this.getOriginColWidth(i2);
                ++i2;
            }
            this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                    int i = 0;
                    while (i < JTableValue.this.getColumnCount()) {
                        String colName = JTableValue.this.getColumnName(i);
                        int newWidth = (int)(new Float(JTableValue.this.getColumn(i).getWidth()).floatValue() / JTableValue.this.scale);
                        GM.ValueColInfo ci = GM.getValueColInfo(colName);
                        if (ci != null && StringUtils.isValidString(ci.format)) {
                            ci.colWidth = newWidth;
                            GM.saveValueColInfo(colName, ci);
                        }
                        JTableValue.this.originColWidthMap.put(i, newWidth);
                        ++i;
                    }
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
            int width = this.getParent().getWidth();
            width = (int)((float)width / this.scale);
            if (totalColWidth < width && cc > 0) {
                GM.ValueColInfo ci;
                String colName;
                int formatColCount = 0;
                int c = 0;
                while (c < cc) {
                    colName = this.getColumnName(c);
                    ci = GM.getValueColInfo(colName);
                    if (ci != null && ci.colWidth > 0) {
                        ++formatColCount;
                    }
                    ++c;
                }
                int aveWidth = cc > 1 && hasIndexCol ? width / (cc - 1 - formatColCount) : (width -= totalColWidth) / (cc - formatColCount);
                int i3 = hasIndexCol ? 1 : 0;
                while (i3 < cc) {
                    colName = this.getColumnName(i3);
                    ci = GM.getValueColInfo(colName);
                    if (ci == null || ci.colWidth <= 0) {
                        int newWidth = this.getOriginColWidth(i3) + aveWidth;
                        this.setColWidth(i3, newWidth);
                    }
                    ++i3;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int getOriginColWidth(int col) {
        TableColumn tc = this.getColumn(col);
        int colWidth = tc.getWidth();
        if (this.originColWidthMap.get(col) != null) {
            colWidth = this.originColWidthMap.get(col);
        }
        return colWidth;
    }

    private void setColWidth(int col, int colWidth) {
        this.setColWidth(col, colWidth, true);
    }

    private void setColWidth(int col, int colWidth, boolean canResize) {
        this.originColWidthMap.put(col, colWidth);
        TableColumn tc = this.getColumn(col);
        colWidth = (int)((float)colWidth * this.scale);
        tc.setMinWidth(colWidth);
        tc.setWidth(colWidth);
        tc.setPreferredWidth(colWidth);
        if (canResize) {
            tc.setMinWidth(0);
        }
    }

    public void dialogZoom() {
        DialogZoom dz = new DialogZoom();
        dz.setScale(this.scale);
        dz.setVisible(true);
        if (dz.getOption() == 0) {
            this.setScale(dz.getScale());
            if (GVSpl.splEditor != null) {
                GVSpl.splEditor.setDataChanged(true);
            }
        }
    }

    private boolean isPK(int[] pkIndex, int index) {
        if (pkIndex == null || pkIndex.length == 0) {
            return false;
        }
        int[] nArray = pkIndex;
        int n = pkIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int pk = nArray[n2];
            if (pk == index) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getIndexColWidth(int len) {
        if (len <= 9999) {
            return 45;
        }
        if (len <= 999999) {
            return 65;
        }
        return 85;
    }

    private void setColumnModel() {
        this.setColumnModel(new DefaultTableColumnModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public TableColumn getColumn(int col) {
                try {
                    return super.getColumn(col);
                }
                catch (Throwable ex) {
                    return new TableColumn();
                }
            }
        });
    }

    public AllPurposeEditor getAllPurposeEditor() {
        return this.getAllPurposeEditor(false);
    }

    public AllPurposeEditor getAllPurposeEditor(boolean editable) {
        JTextFieldReadOnly jtf = editable ? new JTextFieldReadOnly(new String(), 0, this.editListener) : new JTextFieldReadOnly();
        return new AllPurposeEditor(jtf, this);
    }

    public void dispCellValue() {
        int r = this.getSelectedRow();
        int c = this.getSelectedColumn();
        this.drillValue(r, c);
    }

    private void drillValue(int row, int col) {
        if (this.editable) {
            return;
        }
        JScrollBar sbValue = this.panelValue.sbValue;
        int scrollVal = Math.max(sbValue.getValue(), 1);
        int realRow = scrollVal + row;
        Object newValue = null;
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (!(this.value instanceof Sequence)) {
                    return;
                }
                Sequence s = (Sequence)this.value;
                Object temp = s.get(realRow);
                if (!(temp instanceof BaseRecord)) break;
                BaseRecord r = (BaseRecord)temp;
                if (r.dataStruct() != null && s.dataStruct() != null && !r.dataStruct().isCompatible(s.dataStruct())) {
                    newValue = temp;
                    break;
                }
                if (2 != this.m_type && 5 != this.m_type) break;
                newValue = temp;
                break;
            }
        }
        if (newValue == null && (newValue = this.data.getValueAt(row, col)) == null) {
            return;
        }
        if (newValue == this.value) {
            return;
        }
        this.redo.clear();
        this.undo.push(this.getUndoObject());
        this.value = newValue;
        this.forceSetValue(this.value);
    }

    private void forceSetValue(Object newValue) {
        this.setValue(newValue, this.editable, true);
    }

    public boolean canUndo() {
        return !this.undo.empty() && !this.editable;
    }

    public boolean canRedo() {
        return !this.redo.empty() && !this.editable;
    }

    public void undo() {
        UndoObject uo = this.getUndoObject();
        this.redo.push(uo);
        uo = (UndoObject)this.undo.pop();
        this.selectedRows = uo.selectedRows;
        this.setValue(uo.value, this.editable, true, uo);
    }

    public void redo() {
        UndoObject uo = this.getUndoObject();
        this.undo.push(uo);
        uo = (UndoObject)this.redo.pop();
        this.selectedRows = uo.selectedRows;
        this.setValue(uo.value, this.editable, true, uo);
    }

    private UndoObject getUndoObject() {
        UndoObject uo = new UndoObject();
        uo.value = this.value;
        uo.horizontalValue = this.panelValue.spValue.getHorizontalScrollBar().getValue();
        if (this.value != null && this.value instanceof Sequence) {
            uo.dispStartIndex = this.dispStartIndex;
            uo.selectedRows.addAll(this.selectedRows);
        } else {
            uo.dispStartIndex = 1;
            if (this.selectedRows.size() == 1 && this.selectedRows.getInt(0) == 0) {
                uo.selectedRows.addInt(0);
            }
        }
        uo.colWidths = this.getColWidths();
        return uo;
    }

    private int[] getColWidths() {
        int cc = this.getColumnCount();
        int[] colWidths = new int[cc];
        int c = 0;
        while (c < cc) {
            String colName = this.getColumnName(c);
            GM.ValueColInfo colInfo = GM.getValueColInfo(colName);
            if (colInfo != null && StringUtils.isValidString(colInfo.format) && colInfo.colWidth > 0) {
                colWidths[c] = colInfo.colWidth;
            } else {
                Integer colWidth = this.originColWidthMap.get(c);
                int newColWidth = new Float((float)this.getColumn(c).getWidth() / this.scale).intValue();
                if (colWidth == null) {
                    colWidth = new Integer(newColWidth);
                } else if (Math.abs(colWidth - newColWidth) > 2) {
                    colWidth = newColWidth;
                }
                colWidths[c] = colWidth;
            }
            ++c;
        }
        return colWidths;
    }

    public boolean canDrawChart() {
        if (this.canvas != null && this.canvas instanceof Canvas) {
            return true;
        }
        if (this.value != null) {
            Sequence seq;
            if (this.value instanceof byte[]) {
                return true;
            }
            if (this.value instanceof Table) {
                return true;
            }
            if (this.value instanceof Sequence && (seq = (Sequence)this.value).isPurePmt()) {
                return true;
            }
        }
        return false;
    }

    public boolean canShowText() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return false;
        }
        Object cellVal = this.data.getValueAt(row, col);
        return StringUtils.isValidString(cellVal);
    }

    private int getCopyStartCol() {
        boolean isSeq = false;
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                isSeq = true;
            }
        }
        int startCol = 0;
        if (isSeq) {
            startCol = 1;
        }
        return startCol;
    }

    public void copyColumnNames() {
        StringBuffer buf = new StringBuffer();
        int c = this.getCopyStartCol();
        while (c < this.getColumnCount()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(this.getColumnName(c));
            ++c;
        }
        GM.clipBoard(buf.toString());
    }

    public boolean copyValue() {
        return this.copyValue(false);
    }

    public boolean copyValue(boolean copyTitle) {
        Matrix matrix;
        IntArrayList selectedRows = this.selectedRows;
        if (selectedRows.isEmpty()) {
            int count = 1;
            if (this.m_type == 6) {
                count = this.dbTable.length();
            } else if (this.value instanceof Sequence) {
                count = ((Sequence)this.value).length();
            }
            int i = 0;
            while (i < count) {
                selectedRows.add(i);
                ++i;
            }
        }
        int startCol = this.getCopyStartCol();
        int cc = this.getColumnCount() - startCol;
        int rowCount = selectedRows.size();
        if (copyTitle) {
            ++rowCount;
        }
        CellRect cr = new CellRect(0, 0, selectedRows.size() - 1, (short)(cc - 1));
        Sequence seq = null;
        switch (this.m_type) {
            case 6: {
                matrix = new Matrix(rowCount, cc);
                seq = this.dbTable;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                matrix = new Matrix(rowCount, cc);
                seq = (Sequence)this.value;
                break;
            }
            default: {
                matrix = new Matrix(selectedRows.size(), cc);
                int r = 0;
                while (r < selectedRows.size()) {
                    int c = startCol;
                    while (c < this.getColumnCount()) {
                        Object value = this.data.getValueAt(selectedRows.getInt(r), c);
                        PgmNormalCell pnc = new PgmNormalCell();
                        pnc.setValue(value);
                        try {
                            pnc.setExpString(Variant.toExportString(value));
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                        matrix.set(r, c, pnc);
                        ++c;
                    }
                    ++r;
                }
                break block4;
            }
        }
        if (seq != null) {
            if (copyTitle) {
                int i = startCol;
                while (i < this.getColumnCount()) {
                    PgmNormalCell pnc = new PgmNormalCell();
                    pnc.setExpString(this.getColumnName(i));
                    matrix.set(0, i - startCol, pnc);
                    ++i;
                }
            }
            ArrayList<String> messages = new ArrayList<String>();
            int i = 0;
            while (i < selectedRows.size()) {
                block31: {
                    Object rowData = seq.get(selectedRows.getInt(i) + 1);
                    int row = i;
                    if (copyTitle) {
                        row = i + 1;
                    }
                    if (rowData instanceof BaseRecord) {
                        BaseRecord rec = (BaseRecord)rowData;
                        Object[] values = rec.getFieldValues();
                        int c = 0;
                        while (c < cc) {
                            PgmNormalCell pnc;
                            block32: {
                                if (c >= values.length) break block31;
                                pnc = new PgmNormalCell();
                                pnc.setValue(values[c]);
                                try {
                                    pnc.setExpString(Variant.toExportString(values[c]));
                                }
                                catch (Throwable ex) {
                                    if (!StringUtils.isValidString(ex.getMessage()) || messages.contains(ex.getMessage())) break block32;
                                    messages.add(ex.getMessage());
                                }
                            }
                            matrix.set(row, c, pnc);
                            ++c;
                        }
                    } else {
                        PgmNormalCell pnc;
                        block33: {
                            pnc = new PgmNormalCell();
                            pnc.setValue(rowData);
                            try {
                                pnc.setExpString(Variant.toExportString(rowData));
                            }
                            catch (Throwable ex) {
                                if (!StringUtils.isValidString(ex.getMessage()) || messages.contains(ex.getMessage())) break block33;
                                messages.add(ex.getMessage());
                            }
                        }
                        matrix.set(row, 0, pnc);
                    }
                }
                ++i;
            }
            if (!messages.isEmpty()) {
                i = 0;
                while (i < messages.size()) {
                    System.out.println((String)messages.get(i));
                    ++i;
                }
            }
        }
        GV.cellSelection = new CellSelection(matrix, cr, null);
        Clipboard cb = null;
        try {
            cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            cb = null;
        }
        String strCS = GM.getCellSelectionString(matrix, false);
        if (cb != null) {
            cb.setContents(new StringSelection(strCS), null);
        }
        GV.cellSelection.systemClip = strCS;
        return true;
    }

    public void pasteValue() {
        if (!this.editable) {
            return;
        }
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return;
        }
        this.acceptText();
        CellSelection cs = GV.cellSelection;
        if (cs != null) {
            this.setMatrix2Table(cs.matrix, row, col);
            this.acceptText();
            return;
        }
        Matrix matrix = GM.getClipboardMatrix();
        this.setMatrix2Table(matrix, row, col);
        this.acceptText();
    }

    public void drawChart() {
        if (!this.canDrawChart()) {
            return;
        }
        DialogDisplayChart ddc = null;
        if (this.canvas != null) {
            ddc = new DialogDisplayChart(this.canvas);
        } else if (this.value instanceof byte[]) {
            ddc = new DialogDisplayChart((byte[])this.value);
        } else if (this.value instanceof Table) {
            ddc = new DialogDisplayChart((Table)this.value);
        } else if (this.value instanceof Sequence) {
            Sequence seq = (Sequence)this.value;
            Table t = seq.derive("o");
            ddc = new DialogDisplayChart(t);
        } else {
            return;
        }
        ddc.setVisible(true);
    }

    public void showText() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return;
        }
        Object cellVal = this.data.getValueAt(row, col);
        if (!StringUtils.isValidString(cellVal)) {
            return;
        }
        this.showText(row, col, cellVal);
    }

    private void showText(int row, int col, Object cellVal) {
        DialogTextEditor dte = new DialogTextEditor(GV.appFrame, false);
        dte.setText((String)cellVal);
        dte.setVisible(true);
    }

    private void setMatrix2Table(Matrix matrix, int row, int col) {
        int rowCount = matrix.getRowSize();
        int colCount = matrix.getColSize();
        int endRow = row + rowCount;
        int endCol = Math.min(col + colCount, this.getColumnCount());
        int i = row;
        while (i < endRow) {
            if (i > this.getRowCount() - 1) {
                this.addRow();
            }
            int j = col;
            while (j < endCol) {
                Object temp = matrix.get(i - row, j - col);
                if (temp == null) {
                    this.setValueAt(null, i, j);
                } else if (temp instanceof NormalCell) {
                    NormalCell nc = (NormalCell)temp;
                    if (nc.getValue() != null) {
                        this.setValueAt(nc.getValue(), i, j);
                    } else if (StringUtils.isValidString(nc.getExpString())) {
                        this.setValueAt(nc.getExpString(), i, j);
                    }
                } else {
                    this.setValueAt(temp, i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            return super.getValueAt(row, col);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            Dimension size = super.getPreferredSize();
            return size;
        }
        catch (Throwable ex) {
            return new Dimension(1, 1);
        }
    }

    static /* synthetic */ byte access$2(JTableValue jTableValue) {
        return jTableValue.m_type;
    }

    static /* synthetic */ boolean access$5(JTableValue jTableValue) {
        return jTableValue.isDupColNames();
    }

    static /* synthetic */ void access$6(JTableValue jTableValue, BaseRecord baseRecord, int n, boolean bl, int n2, boolean bl2) {
        jTableValue.setRecordRow(baseRecord, n, bl, n2, bl2);
    }

    static /* synthetic */ void access$7(JTableValue jTableValue, int n, int n2) {
        jTableValue.setColWidth(n, n2);
    }

    static /* synthetic */ int access$8(JTableValue jTableValue, int n) {
        return jTableValue.getOriginColWidth(n);
    }

    class PKRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBackground(table.getBackground());
            c.setForeground(table.getForeground());
            Font scaleFont = JTableValue.this.getScaleFont();
            Font headerFont = new Font("Dialog", scaleFont.getStyle(), scaleFont.getSize());
            c.setFont(headerFont);
            if (c instanceof JLabel) {
                ((JLabel)c).setText((String)value);
                ((JLabel)c).setHorizontalAlignment(0);
                ((JLabel)c).setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/key.png"));
            }
            return c;
        }
    }

    class ResetDataThread
    extends Thread {
        Sequence seq;
        volatile int index;
        byte dataType;
        volatile boolean isStoped = false;
        volatile boolean isFinished = false;
        volatile boolean setValue = false;
        private int[] colWidths = null;

        ResetDataThread(Sequence s, int index, byte dataType, boolean setValue, int[] colWidths) {
            this.seq = s;
            this.index = index;
            this.dataType = dataType;
            this.colWidths = colWidths;
            this.setValue = setValue;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void stopThread() {
            this.seq = null;
            this.isStoped = true;
        }

        boolean isFinished() {
            return this.isFinished;
        }
    }

    class UndoObject {
        Object value;
        int dispStartIndex = 1;
        int horizontalValue = 0;
        IntArrayList selectedRows = new IntArrayList();
        int[] colWidths = null;

        UndoObject() {
        }
    }
}

