/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DBObject;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.ide.common.AppendDataThread;
import com.scudata.ide.common.DBTypeEx;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.CellSelection;
import com.scudata.ide.common.dialog.DialogCellFormat;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.Variant;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public abstract class JTableView
extends JTableEx {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeSplMessage.get();
    private final String COL_SERIES = this.mm.getMessage("jtablevalue.menber");
    private final byte TYPE_DEFAULT = 0;
    private final byte TYPE_TABLE = 1;
    private final byte TYPE_SERIES = (byte)2;
    private final byte TYPE_RECORD = (byte)3;
    private final byte TYPE_PMT = (byte)4;
    private final byte TYPE_SERIESPMT = (byte)5;
    private final byte TYPE_DB = (byte)6;
    private final byte TYPE_FILE = (byte)7;
    private byte m_type = 0;
    private final int COL_FIRST = 0;
    private Object value;
    private Stack<Object> undo = new Stack();
    private Stack<Object> redo = new Stack();
    private final short iCOPY = (short)11;
    private final short iFORMAT = (short)17;
    private ActionListener popAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mItem = (JMenuItem)e.getSource();
            short cmd = Short.parseShort(mItem.getName());
            switch (cmd) {
                case 11: {
                    JTableView.this.copyValue();
                    break;
                }
                case 17: {
                    JTableView.this.colFormat();
                }
            }
        }
    };
    private ResetDataThread resetThread = null;
    private Table dbTable = null;
    private final String TITLE_NAME = this.mm.getMessage("jtablevalue.name");
    private final String TITLE_PROP = this.mm.getMessage("jtablevalue.property");
    private final String DB_NAME = this.mm.getMessage("jtablevalue.dbname");
    private final String USER = this.mm.getMessage("jtablevalue.user");
    private final String DB_TYPE = this.mm.getMessage("jtablevalue.dbtype");
    private final String DRIVER = this.mm.getMessage("jtablevalue.driver");
    private final String URL = this.mm.getMessage("jtablevalue.url");
    private final String USE_SCHEMA = this.mm.getMessage("jtablevalue.useschema");
    private final String ADD_TILDE = this.mm.getMessage("jtablevalue.addtilde");

    @Override
    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
        this.drillValue(row, col);
    }

    @Override
    public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
        JPopupMenu pm = new JPopupMenu();
        int selectedRow = this.getSelectedRow();
        int selectedCol = this.getSelectedColumn();
        boolean selectCell = selectedRow != -1 && selectedCol != -1;
        JMenuItem mItem = new JMenuItem(this.mm.getMessage("jtablevalue.copy"));
        mItem.setIcon(GM.getMenuImageIcon("copy"));
        mItem.setName(String.valueOf(11));
        mItem.addActionListener(this.popAction);
        mItem.setEnabled(selectCell);
        pm.add(mItem);
        if (selectedCol > -1 && (this.m_type == 1 || this.m_type == 4 || this.m_type == 5)) {
            mItem = new JMenuItem(this.mm.getMessage("jtablevalue.editformat"));
            mItem.setIcon(GM.getMenuImageIcon("blank"));
            mItem.setName(String.valueOf(17));
            mItem.addActionListener(this.popAction);
            pm.addSeparator();
            pm.add(mItem);
        }
        pm.show(e.getComponent(), e.getX(), e.getY());
    }

    private void colFormat() {
        int col = this.getSelectedColumn();
        if (col < 0) {
            return;
        }
        String colName = null;
        if (!StringUtils.isValidString(colName)) {
            colName = this.getColumnName(col);
        }
        String format = GM.getColumnFormat(colName);
        DialogCellFormat dcf = new DialogCellFormat();
        if (format != null) {
            dcf.setFormat(format);
        }
        dcf.setVisible(true);
        if (dcf.getOption() == 0) {
            format = dcf.getFormat();
            GM.saveFormat(colName, format);
            this.setColFormat(col, format);
        }
    }

    private void setColFormat(int col, String format) {
        TableColumn tc = this.getColumn(col);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this));
        tc.setCellRenderer(new AllPurposeRenderer(format));
        this.repaint();
    }

    public void refresh() {
        this.privateAction(this.value);
    }

    public boolean valueIsNull() {
        return this.value == null;
    }

    public abstract void refreshValueButton();

    public void setData() {
        Sequence s;
        if (this.resetThread != null) {
            this.resetThread.stopThread();
            try {
                this.resetThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resetThread = null;
        switch (this.m_type) {
            case 6: {
                s = this.dbTable;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                s = (Sequence)this.value;
                break;
            }
            default: {
                return;
            }
        }
        this.resetThread = new ResetDataThread(s);
        SwingUtilities.invokeLater(this.resetThread);
    }

    private Object[] getRecordData(BaseRecord record, int r) {
        Object[] rowData;
        block7: {
            block6: {
                if (record == null || r < 0) {
                    return null;
                }
                int colCount = this.getColumnCount();
                rowData = new Object[colCount];
                if (this.m_type != 1) break block6;
                int i = 0;
                while (i < colCount) {
                    rowData[i] = record.getFieldValue(i);
                    ++i;
                }
                break block7;
            }
            DataStruct ds = record.dataStruct();
            String[] nNames = ds.getFieldNames();
            if (nNames == null) break block7;
            int j = 0;
            while (j < nNames.length) {
                Object val;
                try {
                    val = record.getFieldValue(nNames[j]);
                }
                catch (Exception e) {
                    val = null;
                }
                int col = this.getColumnIndex(nNames[j]);
                if (col > -1) {
                    rowData[col] = val;
                }
                ++j;
            }
        }
        return rowData;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void clear() {
        this.undo.clear();
        this.redo.clear();
        this.value = null;
        this.initJTable();
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    private synchronized void setValue(Object value, boolean privateAction) {
        this.value = value;
        this.dbTable = null;
        try {
            this.initJTable();
            if (!privateAction) {
                this.undo.clear();
                this.redo.clear();
            }
            this.refreshValueButton();
            if (value == null) {
                if (this.resetThread != null) {
                    this.resetThread.stopThread();
                    try {
                        this.resetThread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.resetThread = null;
                return;
            }
            this.m_type = this.getValueType(value);
            switch (this.m_type) {
                case 1: {
                    this.initTable((Table)value);
                    break;
                }
                case 4: {
                    this.initPmt((Sequence)value);
                    break;
                }
                case 3: {
                    this.initRecord((BaseRecord)value);
                    break;
                }
                case 2: {
                    this.initSeries((Sequence)value);
                    break;
                }
                case 5: {
                    this.initSeriesPmt((Sequence)value);
                    break;
                }
                case 6: {
                    this.initDB((DBObject)value);
                    break;
                }
                case 7: {
                    this.initFile((FileObject)value);
                    break;
                }
                default: {
                    this.initDefault(value);
                    break;
                }
            }
        }
        finally {
            this.setData();
        }
    }

    private void initJTable() {
        this.removeAllRows();
        this.data.getDataVector().clear();
        int colCount = this.getColumnCount();
        if (colCount == 0) {
            return;
        }
        int i = colCount - 1;
        while (i >= 0) {
            try {
                this.deleteColumn(this.getColumn(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
    }

    private byte getValueType(Object value) {
        if (value instanceof Table) {
            return 1;
        }
        if (value instanceof Sequence) {
            if (((Sequence)value).isPurePmt()) {
                return 4;
            }
            if (((Sequence)value).isPmt()) {
                return 5;
            }
            return 2;
        }
        if (value instanceof BaseRecord) {
            return 3;
        }
        if (value instanceof DBObject) {
            return 6;
        }
        if (value instanceof FileObject) {
            return 7;
        }
        return 0;
    }

    private int initTable(Table table) {
        DataStruct ds = table.dataStruct();
        this.setTableColumns(ds);
        this.setEditStyle(ds);
        return table.length();
    }

    private int initPmt(Sequence pmt) {
        DataStruct ds = pmt.dataStruct();
        this.setTableColumns(ds);
        this.setEditStyle(ds);
        return pmt.length();
    }

    private int initSeriesPmt(Sequence pmt) {
        DataStruct ds = ((BaseRecord)pmt.ifn()).dataStruct();
        this.setTableColumns(ds);
        this.setEditStyle(ds);
        return pmt.length();
    }

    private int initSeries(Sequence series) {
        this.addColumn(this.COL_SERIES);
        this.setColumnWidth(0, 200);
        TableColumn tc = this.getColumn(0);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this));
        tc.setCellRenderer(new AllPurposeRenderer());
        return series.length();
    }

    private int initRecord(BaseRecord record) {
        DataStruct ds = record.dataStruct();
        this.setTableColumns(ds);
        try {
            AppendDataThread.addRecordRow(this, record);
        }
        catch (Exception ex) {
            GM.showException(GV.appFrame, ex);
        }
        this.setEditStyle(ds);
        return 1;
    }

    private void setEditStyle(DataStruct ds) {
        String[] cols = ds.getFieldNames();
        int i = 0;
        while (i < cols.length) {
            TableColumn tc = this.getColumn(i);
            String format = GM.getColumnFormat(cols[i]);
            if (StringUtils.isValidString(format)) {
                tc.setCellEditor(new AllPurposeEditor(new JTextField(), this));
                tc.setCellRenderer(new AllPurposeRenderer(format));
            }
            ++i;
        }
        GM.setEditStyle(this);
    }

    private void setTableColumns(DataStruct ds) {
        String[] nNames = ds.getFieldNames();
        if (nNames != null) {
            int i = 0;
            while (i < nNames.length) {
                this.addColumn(nNames[i]);
                ++i;
            }
        }
    }

    private int initDB(DBObject db) {
        this.dbTable = new Table(new String[]{this.TITLE_NAME, this.TITLE_PROP});
        this.addColumn(this.TITLE_NAME);
        this.addColumn(this.TITLE_PROP);
        int i = 0;
        while (i < this.getColumnCount()) {
            this.setColumnEditable(i, false);
            ++i;
        }
        if (db == null || db.getDbSession() == null) {
            return 0;
        }
        this.initDBTable(db);
        return this.dbTable.length();
    }

    private void initDBTable(DBObject db) {
        DBInfo info = db.getDbSession().getInfo();
        this.dbTable.newLast(new Object[]{this.DB_NAME, info.getName()});
        if (info instanceof DBConfig) {
            int type = info.getDBType();
            this.dbTable.newLast(new Object[]{this.DB_TYPE, DBTypeEx.getDBTypeName(type)});
            DBConfig dc = (DBConfig)info;
            this.dbTable.newLast(new Object[]{this.DRIVER, dc.getDriver()});
            this.dbTable.newLast(new Object[]{this.URL, dc.getUrl()});
            this.dbTable.newLast(new Object[]{this.USER, dc.getUser()});
            this.dbTable.newLast(new Object[]{this.USE_SCHEMA, Boolean.toString(dc.isUseSchema())});
            this.dbTable.newLast(new Object[]{this.ADD_TILDE, Boolean.toString(dc.isAddTilde())});
        }
    }

    private int initFile(FileObject file) {
        this.addColumn(this.mm.getMessage("public.file"));
        return this.initSingleValue(file);
    }

    private int initDefault(Object value) {
        this.addColumn(this.mm.getMessage("public.value"));
        return this.initSingleValue(value);
    }

    private int initSingleValue(Object value) {
        this.setColumnWidth(0, 200);
        TableColumn tc = this.getColumn(0);
        tc.setCellEditor(new AllPurposeEditor(new JTextField(), this));
        tc.setCellRenderer(new AllPurposeRenderer());
        if (this.getRowCount() == 0) {
            this.addRow();
        }
        this.data.setValueAt(value, 0, 0);
        return 1;
    }

    public void dispCellValue() {
        int r = this.getSelectedRow();
        int c = this.getSelectedColumn();
        this.drillValue(r, c);
    }

    private void drillValue(int row, int col) {
        Object newValue = null;
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                BaseRecord r;
                Sequence s = (Sequence)this.value;
                Object temp = s.get(row + 1);
                if (!(temp instanceof BaseRecord) || (r = (BaseRecord)temp).dataStruct() == null || s.dataStruct() == null || r.dataStruct().equals(s.dataStruct())) break;
                newValue = temp;
                break;
            }
        }
        if (newValue == null && (newValue = this.data.getValueAt(row, col)) == null) {
            return;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        this.redo.clear();
        this.undo.push(this.value);
        this.value = newValue;
        this.privateAction(this.value);
    }

    private void privateAction(Object newValue) {
        this.setValue(newValue, true);
    }

    public boolean canUndo() {
        return !this.undo.empty();
    }

    public boolean canRedo() {
        return !this.redo.empty();
    }

    public void undo() {
        this.redo.push(this.value);
        this.value = this.undo.pop();
        this.privateAction(this.value);
    }

    public void redo() {
        this.undo.push(this.value);
        this.value = this.redo.pop();
        this.privateAction(this.value);
    }

    public boolean copyValue() {
        int[] rows = this.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return false;
        }
        int cc = this.getColumnCount();
        Matrix matrix = new Matrix(rows.length, cc);
        CellRect cr = new CellRect(0, 0, rows.length - 1, (short)(cc - 1));
        int r = 0;
        while (r < rows.length) {
            int c = 0;
            while (c < this.getColumnCount()) {
                Object value = this.data.getValueAt(rows[r], c);
                PgmNormalCell pnc = new PgmNormalCell();
                pnc.setValue(value);
                try {
                    pnc.setExpString(Variant.toExportString(value));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                matrix.set(r, c, pnc);
                ++c;
            }
            ++r;
        }
        GV.cellSelection = new CellSelection(matrix, cr, null);
        Clipboard cb = null;
        try {
            cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            cb = null;
        }
        String strCS = GM.getCellSelectionString(matrix, false);
        if (cb != null) {
            cb.setContents(new StringSelection(strCS), null);
        }
        GV.cellSelection.systemClip = strCS;
        return true;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            return super.getValueAt(row, col);
        }
        catch (Exception ex) {
            return null;
        }
    }

    class ResetDataThread
    extends Thread {
        Sequence seq;
        volatile boolean isStoped = false;
        volatile boolean isFinished = false;

        ResetDataThread(Sequence seq) {
            this.seq = seq;
        }

        @Override
        public void run() {
            try {
                if (this.seq == null) {
                    JTableView.this.removeAllRows();
                    return;
                }
                if (this.isStoped) {
                    return;
                }
                int i = 1;
                int count = this.seq.length();
                while (i <= count) {
                    if (this.isStoped) {
                        return;
                    }
                    try {
                        Object rowData = this.seq.get(i);
                        if (rowData instanceof BaseRecord) {
                            JTableView.this.insertRow(-1, JTableView.this.getRecordData((BaseRecord)this.seq.get(i), i - 1), false);
                        } else {
                            JTableView.this.insertRow(-1, new Object[]{this.seq.get(i)}, false);
                        }
                        ++i;
                        continue;
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            finally {
                this.isFinished = true;
            }
        }

        void stopThread() {
            this.seq = null;
            this.isStoped = true;
        }

        boolean isFinished() {
            return this.isFinished;
        }
    }
}

