/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.app.common.Section;
import com.scudata.common.DBConfig;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.IconTreeNode;
import com.scudata.ide.common.control.IconTreeRender;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.ToolBarProperty;
import com.scudata.ide.spl.base.PanelSelectField_jBAdd_actionAdapter;
import com.scudata.ide.spl.base.PanelSelectField_jBCopy_actionAdapter;
import com.scudata.ide.spl.control.ContentPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PanelSelectField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    private JButton jBCopy = new JButton();
    private JButton jBAdd = new JButton();
    private JCheckBox jCBOpt = new JCheckBox(this.mm.getMessage("panelselectfield.tablepre"));
    private IconTreeNode root = new IconTreeNode(this.mm.getMessage("panelselectfield.dsname"));
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private JTree mTree = new JTree(this.treeModel);
    private final byte LEVEL_FIELD = (byte)3;
    private JLabel labelMsg = new JLabel();
    private Thread dbThread = null;
    private volatile boolean stoped = false;

    public PanelSelectField() {
        this.init();
        this.resetEnv();
    }

    public void resetEnv() {
        if (this.dbThread != null) {
            this.stoped = true;
        }
        this.root.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.root);
        if (!ConfigOptions.bShowDBStruct.booleanValue()) {
            return;
        }
        this.dbThread = new Thread(){

            @Override
            public void run() {
                PanelSelectField.this.stoped = false;
                final ArrayList<String> dsNames = new ArrayList<String>();
                final ArrayList dsList = new ArrayList();
                try {
                    PanelSelectField.this.labelMsg.setVisible(true);
                    PanelSelectField.this.labelMsg.setText(String.valueOf(PanelSelectField.this.mm.getMessage("panelselectfield.loading")) + "...");
                    int i = 0;
                    while (i < GV.dsModel.getSize()) {
                        block53: {
                            if (PanelSelectField.this.stoped) {
                                return;
                            }
                            DataSource ds = (DataSource)GV.dsModel.get(i);
                            if (ds != null && !ds.isClosed()) {
                                Connection con = null;
                                try {
                                    con = (Connection)ds.getDBSession().getSession();
                                }
                                catch (Throwable e1) {
                                    break block53;
                                }
                                if (con != null) {
                                    DBConfig dbConfig;
                                    if (ds.getDBInfo() instanceof DBConfig && (dbConfig = (DBConfig)ds.getDBInfo()).getDriver().toLowerCase().startsWith("com.scudata.datahub")) {
                                        ArrayList<String> splNames;
                                        DatabaseMetaData dbmd;
                                        ResultSet rs;
                                        block55: {
                                            rs = null;
                                            dbmd = null;
                                            splNames = new ArrayList<String>();
                                            try {
                                                try {
                                                    dbmd = con.getMetaData();
                                                    rs = dbmd.getProcedures(null, null, null);
                                                    while (rs.next()) {
                                                        String splName = rs.getString("PROCEDURE_NAME");
                                                        splNames.add(splName);
                                                    }
                                                }
                                                catch (SQLException splName) {
                                                    if (rs != null) {
                                                        try {
                                                            rs.close();
                                                        }
                                                        catch (SQLException sQLException) {}
                                                    }
                                                    break block55;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                if (rs != null) {
                                                    try {
                                                        rs.close();
                                                    }
                                                    catch (SQLException sQLException) {
                                                        // empty catch block
                                                    }
                                                }
                                                throw throwable;
                                            }
                                            if (rs != null) {
                                                try {
                                                    rs.close();
                                                }
                                                catch (SQLException sQLException) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (!splNames.isEmpty() && dbmd != null) {
                                            ArrayList<TableConfig> tableList = new ArrayList<TableConfig>();
                                            dsList.add(tableList);
                                            int d = 0;
                                            int splSize = splNames.size();
                                            while (d < splSize) {
                                                block57: {
                                                    String splName = (String)splNames.get(d);
                                                    rs = null;
                                                    try {
                                                        try {
                                                            rs = dbmd.getProcedureColumns(null, null, splName, null);
                                                            TableConfig tc = new TableConfig();
                                                            tc.tableName = splName;
                                                            tc.fields = null;
                                                            tableList.add(tc);
                                                        }
                                                        catch (SQLException sQLException) {
                                                            if (rs != null) {
                                                                try {
                                                                    rs.close();
                                                                }
                                                                catch (SQLException sQLException2) {}
                                                            }
                                                            break block57;
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (rs != null) {
                                                            try {
                                                                rs.close();
                                                            }
                                                            catch (SQLException sQLException) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        throw throwable;
                                                    }
                                                    if (rs != null) {
                                                        try {
                                                            rs.close();
                                                        }
                                                        catch (SQLException sQLException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                ++d;
                                            }
                                        }
                                    } else {
                                        String dsName = ds.getName();
                                        dsNames.add(dsName);
                                        Vector<String> tables = GM.listTableNames(dsName);
                                        if (tables != null && !tables.isEmpty()) {
                                            Object[] tableNames = new String[tables.size()];
                                            int s = 0;
                                            while (s < tables.size()) {
                                                tableNames[s] = tables.get(s);
                                                ++s;
                                            }
                                            Arrays.sort(tableNames);
                                            Map<String, Vector<String>> tableFields = null;
                                            if (tables.size() > 300 && !GM.isDataLogicDS(ds)) {
                                                try {
                                                    tableFields = PanelSelectField.getTableFields(con);
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            ArrayList<TableConfig> tableList = new ArrayList<TableConfig>();
                                            dsList.add(tableList);
                                            int t = 0;
                                            while (t < tableNames.length) {
                                                Vector<String> fields;
                                                Object tableName;
                                                if (PanelSelectField.this.stoped) {
                                                    return;
                                                }
                                                TableConfig tc = new TableConfig();
                                                tableList.add(tc);
                                                tc.tableName = tableName = tableNames[t];
                                                Vector<String> vector = fields = tableFields == null ? null : tableFields.get(tableName);
                                                if (fields == null) {
                                                    fields = GM.listColumnNames(dsName, (String)tableName);
                                                }
                                                tc.fields = fields;
                                                try {
                                                    tc.fkMap = PanelSelectField.this.getTableFKMap(ds, null, (String)tableName, con);
                                                }
                                                catch (Throwable e) {
                                                    tc.fkMap = null;
                                                }
                                                ++t;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (PanelSelectField.this.stoped) {
                        return;
                    }
                }
                finally {
                    PanelSelectField.this.labelMsg.setVisible(false);
                }
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        PanelSelectField.this.rebuildTree(dsNames, dsList);
                    }
                });
            }
        };
        this.dbThread.start();
    }

    private synchronized void rebuildTree(List<String> dsNames, List<ArrayList<TableConfig>> dsList) {
        this.root = new IconTreeNode(this.mm.getMessage("panelselectfield.dsname"));
        if (dsList != null && dsNames != null) {
            int i = 0;
            while (i < dsNames.size()) {
                String dsName = dsNames.get(i);
                IconTreeNode dsNode = new IconTreeNode(dsName);
                this.root.add(dsNode);
                if (dsList.size() > i) {
                    ArrayList<TableConfig> tableList = dsList.get(i);
                    int t = 0;
                    while (t < tableList.size()) {
                        TableConfig tc = (TableConfig)tableList.get(t);
                        IconTreeNode tableNode = new IconTreeNode(tc.tableName, 1);
                        dsNode.add(tableNode);
                        Vector<String> fields = tc.fields;
                        if (fields != null) {
                            Map<String, String> fkMap = tc.fkMap;
                            int c = 0;
                            while (c < fields.size()) {
                                String pkName;
                                String fieldName = fields.get(c) == null ? "" : fields.get(c);
                                IconTreeNode fieldNode = new IconTreeNode(fieldName, 2);
                                tableNode.add(fieldNode);
                                if (fkMap != null && (pkName = fkMap.get(fieldName)) != null) {
                                    IconTreeNode pkNode = new IconTreeNode(pkName, 1);
                                    fieldNode.add(pkNode);
                                }
                                ++c;
                            }
                        }
                        this.treeModel.nodeStructureChanged(tableNode);
                        this.treeModel.nodeStructureChanged(dsNode);
                        ++t;
                    }
                }
                ++i;
            }
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.mTree.setModel(this.treeModel);
        this.mTree.setCellRenderer(new IconTreeRender());
    }

    public static Map<String, Vector<String>> getTableFields(Connection con) throws Exception {
        DatabaseMetaData md = con.getMetaData();
        LinkedHashMap<String, Vector<String>> tableFields = new LinkedHashMap<String, Vector<String>>();
        try (ResultSet rs = null;){
            rs = md.getColumns(null, null, null, "%");
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                Vector<String> columns = (Vector<String>)tableFields.get(tableName);
                if (columns == null) {
                    columns = new Vector<String>();
                    tableFields.put(tableName, columns);
                }
                String columnName = rs.getString("COLUMN_NAME");
                columns.add(columnName);
            }
        }
        if (tableFields.isEmpty()) {
            return null;
        }
        return tableFields;
    }

    private String getSelectedValues() {
        Section sec = new Section();
        TreePath[] paths = this.mTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        int i = 0;
        while (i < paths.length) {
            IconTreeNode node = (IconTreeNode)paths[i].getLastPathComponent();
            String val = this.getNodeValue(node);
            if (val != null) {
                sec.addSection(val);
            }
            ++i;
        }
        if (sec.size() == 0) {
            return null;
        }
        return sec.toString();
    }

    private String getNodeValue(IconTreeNode node) {
        IconTreeNode pNode;
        String name = node.getName();
        if (StringUtils.isValidString(name) && node.getLevel() == 3 && this.jCBOpt.isSelected() && (pNode = (IconTreeNode)node.getParent()).getType() == 1 && StringUtils.isValidString(pNode.getName())) {
            name = String.valueOf(pNode.getName()) + "." + name;
        }
        return name;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = GM.getGBC(1, 1);
        gbc.insets = new Insets(3, 8, 3, 3);
        this.add((Component)this.jBAdd, gbc);
        gbc = GM.getGBC(1, 2);
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jBCopy, gbc);
        gbc = GM.getGBC(1, 3, true);
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jCBOpt, gbc);
        gbc = GM.getGBC(4, 1, true, true);
        gbc.gridwidth = 3;
        JScrollPane jScrollPane1 = new JScrollPane();
        this.add((Component)jScrollPane1, gbc);
        gbc = GM.getGBC(5, 1, true);
        gbc.gridwidth = 3;
        this.add((Component)this.labelMsg, gbc);
        jScrollPane1.getViewport().add(this.mTree);
        this.jBAdd.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pmtundo.gif"));
        this.jBCopy.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_copy.gif"));
        this.jBAdd.setToolTipText(this.mm.getMessage("panelselectfield.addtf"));
        this.jBCopy.setToolTipText(this.mm.getMessage("panelselectfield.copyf"));
        this.initButton(this.jBAdd);
        this.initButton(this.jBCopy);
        this.jBAdd.addActionListener(new PanelSelectField_jBAdd_actionAdapter(this));
        this.jBCopy.addActionListener(new PanelSelectField_jBCopy_actionAdapter(this));
        this.mTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                TreePath path = PanelSelectField.this.mTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                IconTreeNode node = (IconTreeNode)path.getLastPathComponent();
                if (node.isRoot()) {
                    return;
                }
                String val = PanelSelectField.this.getNodeValue(node);
                if (val != null) {
                    PanelSelectField.this.add(val);
                }
            }
        });
        this.labelMsg.setVisible(false);
    }

    public void initButton(JButton b) {
        Dimension d = new Dimension(22, 22);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
    }

    private void add(String vals) {
        if (vals == null || GVSpl.splEditor == null || !(GV.appSheet instanceof SheetSpl)) {
            return;
        }
        if (GV.isCellEditing) {
            ContentPanel cp = GVSpl.splEditor.getComponent().getContentPanel();
            if (cp.isEditing()) {
                cp.addText(vals);
            }
        } else {
            ((ToolBarProperty)GV.toolBarProperty).addText(vals);
        }
    }

    private Map<String, String> getTableFKMap(DataSource ds, String schema, String table, Connection con) throws Throwable {
        DatabaseMetaData md = con.getMetaData();
        String[] schemaTable = GM.getRealSchemaTable(con, schema, table);
        schema = schemaTable[0];
        table = schemaTable[1];
        HashMap<String, String> fkMap = new HashMap<String, String>();
        try (ResultSet rs = null;){
            rs = md.getImportedKeys(null, schema, table);
            while (rs.next()) {
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColName = rs.getString("PKCOLUMN_NAME");
                String colName = rs.getString("FKCOLUMN_NAME");
                if (!pkColName.startsWith(String.valueOf(pkTableName) + ".")) {
                    pkColName = String.valueOf(pkTableName) + "." + pkColName;
                }
                fkMap.put(colName, pkColName);
            }
        }
        return fkMap;
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        this.add(this.getSelectedValues());
    }

    void jBCopy_actionPerformed(ActionEvent e) {
        String vals = this.getSelectedValues();
        if (vals == null) {
            return;
        }
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new StringSelection(vals), null);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    class TableConfig {
        String tableName;
        Vector<String> fields;
        Map<String, String> fkMap;
    }
}

