/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.ByteMap;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class PanelSplWatch
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jSPTable = new JScrollPane();
    private final int BLANK_ROW_COUNT = 1;
    private volatile boolean preventChange = false;
    private final byte COL_INDEX = 0;
    private final byte COL_EXP = 1;
    private final byte COL_VALUE = (byte)2;
    private JTableEx tableWatch = new JTableEx(IdeSplMessage.get().getMessage("paneldfxwatch.tablewatch")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!this.isItemDataChanged(row, column, aValue)) {
                if (column == 1 && StringUtils.isValidString(aValue) && this.isEnabled()) {
                    PanelSplWatch.this.recalcTable();
                }
                return;
            }
            super.setValueAt(aValue, row, column);
            if (PanelSplWatch.this.preventChange) {
                return;
            }
            if (column == 1) {
                if (StringUtils.isValidString(aValue) && this.isEnabled()) {
                    PanelSplWatch.this.recalcTable();
                }
                PanelSplWatch.this.dataChanged();
                PanelSplWatch.this.resetRows(true);
            }
        }

        @Override
        public void rowfocusChanged(int oldRow, int newRow) {
            if (PanelSplWatch.this.preventChange) {
                return;
            }
            if (newRow != -1) {
                this.showRow(newRow);
            }
        }

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (col == 1) {
                try {
                    PanelSplWatch.this.preventChange = true;
                    if (GM.dialogEditTableText(GV.appFrame, this, row, col)) {
                        PanelSplWatch.this.dataChanged();
                    }
                    PanelSplWatch.this.resetRows(true);
                    this.showRow(row);
                }
                finally {
                    PanelSplWatch.this.preventChange = false;
                }
            } else if (col == 2) {
                this.showRow(row);
            }
        }

        private void showRow(int row) {
            Object val = this.data.getValueAt(row, 2);
            Object name = this.data.getValueAt(row, 1);
            String varName = name == null ? "" : name.toString();
            GVSpl.panelValue.tableValue.setValue1(val, varName);
            GVSpl.panelValue.valueBar.refresh();
            this.repaint();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 2;
        }
    };

    public PanelSplWatch() {
        try {
            this.preventChange = true;
            this.setLayout(new BorderLayout());
            this.jSPTable.getViewport().add(this.tableWatch);
            this.add((Component)this.jSPTable, "Center");
            this.tableWatch.setRowHeight(20);
            this.tableWatch.setIndexCol(0);
            this.setCellSet(null);
            this.recalcTable();
            this.setWatchEnabled(false);
        }
        finally {
            this.preventChange = false;
        }
    }

    private void resetRows(final boolean requestFocus) {
        int len = this.tableWatch.getRowCount();
        int blankCount = 0;
        int r = len - 1;
        while (r >= 0) {
            if (StringUtils.isValidString(this.tableWatch.data.getValueAt(r, 1))) break;
            ++blankCount;
            --r;
        }
        if (blankCount == 1) {
            return;
        }
        final int bc = blankCount;
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                try {
                    PanelSplWatch.this.preventChange = true;
                    if (bc >= 1) {
                        int i = 0;
                        while (i < bc - 1) {
                            PanelSplWatch.this.tableWatch.removeRow(PanelSplWatch.this.tableWatch.getRowCount() - 1);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < 1 - bc) {
                            PanelSplWatch.this.tableWatch.addRow();
                            ++i;
                        }
                    }
                    if (requestFocus) {
                        PanelSplWatch.this.tableWatch.requestFocus();
                    }
                    PanelSplWatch.this.tableWatch.setColumnSelectionInterval(1, 1);
                    if (PanelSplWatch.this.tableWatch.getSelectedRow() > -1) {
                        PanelSplWatch.this.tableWatch.setEditingRow(PanelSplWatch.this.tableWatch.getSelectedRow());
                    }
                    PanelSplWatch.this.tableWatch.setEditingColumn(1);
                }
                finally {
                    PanelSplWatch.this.preventChange = false;
                }
            }
        });
    }

    public void setCellSet(PgmCellSet cs) {
        try {
            this.preventChange = true;
            this.tableWatch.acceptText();
            this.tableWatch.removeAllRows();
            this.tableWatch.clearSelection();
            if (cs != null) {
                Sequence exps;
                ByteMap bm = cs.getCustomPropMap();
                if (bm != null && (exps = (Sequence)bm.get((byte)11)) != null) {
                    int i = 1;
                    int len = exps.length();
                    while (i <= len) {
                        int row = this.tableWatch.addRow();
                        this.tableWatch.data.setValueAt(exps.get(i), row, 1);
                        ++i;
                    }
                }
                this.resetRows(false);
            }
            this.setWatchEnabled(cs != null);
        }
        finally {
            this.preventChange = false;
        }
    }

    public void watch() {
        try {
            this.preventChange = true;
            this.recalcTable();
        }
        finally {
            this.preventChange = false;
        }
    }

    private void dataChanged() {
        if (this.preventChange) {
            return;
        }
        if (GVSpl.appSheet != null && GVSpl.appSheet instanceof SheetSpl) {
            Sequence exps = new Sequence();
            int i = 0;
            while (i < this.tableWatch.getRowCount()) {
                Object exp = this.tableWatch.data.getValueAt(i, 1);
                if (StringUtils.isValidString(exp)) {
                    exps.add(exp);
                }
                ++i;
            }
            ((SheetSpl)GVSpl.appSheet).setCellSetExps(exps);
        }
    }

    public abstract Object watch(String var1);

    private synchronized void recalcTable() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                try {
                    PanelSplWatch.this.setWatchEnabled(false);
                    int rowCount = PanelSplWatch.this.tableWatch.getRowCount();
                    int i = 0;
                    while (i < rowCount) {
                        ((PanelSplWatch)PanelSplWatch.this).tableWatch.data.setValueAt(null, i, 2);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < rowCount) {
                        Object exp = ((PanelSplWatch)PanelSplWatch.this).tableWatch.data.getValueAt(i2, 1);
                        if (StringUtils.isValidString(exp)) {
                            try {
                                Object val = PanelSplWatch.this.watch((String)exp);
                                ((PanelSplWatch)PanelSplWatch.this).tableWatch.data.setValueAt(val, i2, 2);
                            }
                            catch (Throwable ex) {
                                ((PanelSplWatch)PanelSplWatch.this).tableWatch.data.setValueAt(ex.getMessage(), i2, 2);
                            }
                        }
                        ++i2;
                    }
                }
                finally {
                    PanelSplWatch.this.setWatchEnabled(true);
                }
            }
        });
    }

    public boolean isCalculating() {
        return !this.isEnabled();
    }

    public void setWatchEnabled(boolean enable) {
        this.setEnabled(enable);
        this.jSPTable.setEnabled(enable);
        this.tableWatch.setEnabled(enable);
    }
}

