/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.ide.common.EditListener;
import com.scudata.ide.common.GM;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.base.JTableValue;
import com.scudata.ide.spl.base.PanelValueBar;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PanelValue
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JScrollPane spValue;
    public JTableValue tableValue;
    public PanelValueBar valueBar;
    public JScrollBar sbValue;
    public boolean preventChange = false;
    private JLabel jLCellTime = new JLabel();
    private JLabel jLInterval = new JLabel();
    private JLabel jLDispRows1 = new JLabel(IdeSplMessage.get().getMessage("panelvalue.disprows1"));
    private JLabel jLDispRows2 = new JLabel(IdeSplMessage.get().getMessage("panelvalue.disprows2"));
    private JSpinner jSDispRows = new JSpinner(new SpinnerNumberModel(100, 1, Integer.MAX_VALUE, 1));
    private JButton jBCursorFetch = new JButton(IdeSplMessage.get().getMessage("panelvalue.cursorfetch"));
    private static final String CARD_DEBUG = "CARD_DEBUG";
    private static final String CARD_EMPTY = "CARD_EMPTY";
    private CardLayout cl = new CardLayout();
    private JPanel panelSouth = new JPanel(this.cl);
    private JPanel panelDebug = new JPanel(new GridBagLayout());
    private JPanel panelCursor = new JPanel(new GridBagLayout());

    public PanelValue() {
        this(true);
    }

    public PanelValue(boolean isMainPanel) {
        try {
            this.init(isMainPanel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closePanel() {
    }

    public void setCursorValue(boolean isCursor) {
        this.jLDispRows1.setVisible(isCursor);
        this.jSDispRows.setVisible(isCursor);
        this.jLDispRows2.setVisible(isCursor);
        this.jBCursorFetch.setVisible(isCursor);
        this.panelCursor.setVisible(isCursor);
    }

    public void setCellSet(PgmCellSet cs) {
        if (cs == null) {
            this.panelSouth.setVisible(false);
            this.cl.show(this.panelSouth, CARD_EMPTY);
        } else {
            this.cl.show(this.panelSouth, CARD_DEBUG);
            this.panelSouth.setVisible(true);
        }
    }

    public void setDebugTime(String cellId, Long time) {
        if (cellId == null || time == null) {
            this.jLCellTime.setText(null);
        } else {
            this.jLCellTime.setText(IdeSplMessage.get().getMessage("panelvalue.debugtime", cellId, time));
        }
    }

    public void setInterval(String cellId1, String cellId2, Long interval) {
        if (cellId1 == null || cellId2 == null) {
            this.jLInterval.setText(null);
        } else {
            this.jLInterval.setText(IdeSplMessage.get().getMessage("panelvalue.cellinterval", cellId1, cellId2, interval));
        }
    }

    public void setEditListener(EditListener el) {
        this.tableValue.setEditListener(el);
    }

    private void init(boolean isMainPanel) {
        if (isMainPanel) {
            GVSpl.panelValue = this;
        }
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(1, 1));
        this.valueBar = new PanelValueBar(this, isMainPanel);
        this.add((Component)this.valueBar, "North");
        this.tableValue = new JTableValue(this);
        GM.loadWindowSize(this);
        this.spValue = new JScrollPane(21, 30);
        this.spValue.getViewport().add(this.tableValue);
        this.spValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 3) {
                    return;
                }
                PanelValue.this.tableValue.rightClicked(e.getX(), e.getY(), -1, -1, e);
            }
        });
        this.tableValue.addMWListener(this.spValue);
        this.tableValue.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 3) {
                    return;
                }
                int col = PanelValue.this.tableValue.columnAtPoint(e.getPoint());
                PanelValue.this.tableValue.selectCol(col);
                PanelValue.this.tableValue.rightClicked(e.getX(), e.getY(), PanelValue.this.tableValue.getSelectedRow(), col, e);
            }
        });
        this.add((Component)this.spValue, "Center");
        this.sbValue = new JScrollBar();
        this.sbValue.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (PanelValue.this.preventChange) {
                    return;
                }
                int index = e.getValue();
                if (index > 0) {
                    PanelValue.this.tableValue.resetData(index);
                }
            }
        });
        this.add((Component)this.sbValue, "East");
        this.tableValue.setValue(null);
        this.panelDebug.add((Component)this.jLCellTime, GM.getGBC(0, 0, true, false, 2));
        this.panelDebug.add((Component)this.jLInterval, GM.getGBC(0, 1, true));
        this.panelCursor.add((Component)this.jLDispRows1, GM.getGBC(0, 0, false, false, 2));
        this.panelCursor.add((Component)this.jSDispRows, GM.getGBC(0, 1, false, false, 0));
        this.panelCursor.add((Component)this.jLDispRows2, GM.getGBC(0, 2, false, false, 2));
        this.panelCursor.add((Component)this.jBCursorFetch, GM.getGBC(0, 3));
        this.panelCursor.add((Component)new JPanel(), GM.getGBC(0, 4, true));
        JPanel panelAction = new JPanel(new GridBagLayout());
        panelAction.add((Component)this.panelCursor, GM.getGBC(0, 0, true));
        panelAction.add((Component)this.panelDebug, GM.getGBC(1, 0, true));
        this.panelSouth.setMinimumSize(new Dimension(1, 1));
        this.panelSouth.add(CARD_DEBUG, panelAction);
        JPanel panelEmpty = new JPanel();
        panelEmpty.setMinimumSize(new Dimension(1, 1));
        this.panelSouth.add(CARD_EMPTY, panelEmpty);
        this.cl.show(this.panelSouth, CARD_EMPTY);
        this.panelSouth.setVisible(false);
        this.add((Component)this.panelSouth, "South");
        this.jBCursorFetch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = PanelValue.this.jSDispRows.getValue();
                if (!(value instanceof Number)) {
                    return;
                }
                int dispRows = ((Number)value).intValue();
                PanelValue.this.tableValue.cursorFetch(dispRows);
            }
        });
        Dimension dim = new Dimension(100, 25);
        this.jSDispRows.setPreferredSize(dim);
        this.spValue.setWheelScrollingEnabled(false);
    }
}

