/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.MenuSpl;
import com.scudata.ide.spl.base.JTableValue;
import com.scudata.ide.spl.base.PanelValue;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class PanelValueBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton jBUndo = new JButton();
    private JButton jBRedo = new JButton();
    private JButton jBCell = new JButton();
    private JButton jBCopy = new JButton();
    private JButton jBCopyColNames = new JButton();
    private JButton jBDrawChart = new JButton();
    private JButton jBShowText = new JButton();
    private JButton jBClose = new JButton();
    private JLabel labelCell = new JLabel();
    private JToggleButton jBPin = new JToggleButton();
    private MessageManager splMM = IdeSplMessage.get();
    private final String PIN_ON = this.splMM.getMessage("panelvaluebar.pin1");
    private final String PIN_OFF = this.splMM.getMessage("panelvaluebar.pin2");
    private final short iUNDO = 1;
    private final short iREDO = (short)3;
    private final short iPIN = (short)5;
    private final short iDRILLCELL = (short)6;
    private final short iDRAWCHART = (short)7;
    private final short iCOPY = (short)8;
    private final short iCOPY_COLNAMES = (short)9;
    private final short iSHOW_TEXT = (short)10;
    private final short iCLOSE = (short)11;
    private boolean disablePin = false;
    private PanelValue panelValue = null;
    private final String TIP_COPY_CONTENT = this.splMM.getMessage("panelvaluebar.copy");
    private final String TIP_COPY_COLNAMES = this.splMM.getMessage("panelvaluebar.copycolnames");
    ActionListener popupAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            short cmd = Short.parseShort(button.getName());
            JTableValue table = ((PanelValueBar)PanelValueBar.this).panelValue.tableValue;
            switch (cmd) {
                case 1: {
                    table.undo();
                    break;
                }
                case 3: {
                    table.redo();
                    break;
                }
                case 6: {
                    table.dispCellValue();
                    break;
                }
                case 8: {
                    table.copyValue(e.getModifiers() == 17);
                    break;
                }
                case 9: {
                    table.copyColumnNames();
                    break;
                }
                case 5: {
                    table.setLocked(!table.isLocked());
                    if (table.isLocked()) break;
                    GVSpl.appSheet.refresh();
                    break;
                }
                case 7: {
                    table.drawChart();
                    break;
                }
                case 10: {
                    table.showText();
                    break;
                }
                case 11: {
                    PanelValueBar.this.panelValue.closePanel();
                }
            }
        }
    };

    public PanelValueBar() {
        this(GVSpl.panelValue, true);
    }

    public PanelValueBar(PanelValue panelValue, boolean isMainPanel) {
        this.panelValue = panelValue;
        try {
            this.init();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    protected void closePanel() {
    }

    public void setLocked(boolean isLocked) {
        if (isLocked) {
            this.jBPin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pin2.gif"));
            this.jBPin.setToolTipText(this.PIN_ON);
        } else {
            this.jBPin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pin.gif"));
            this.jBPin.setToolTipText(this.PIN_OFF);
        }
    }

    public void refresh() {
        JTableValue table = this.panelValue.tableValue;
        String id = table.getCellId();
        if (StringUtils.isValidString(id)) {
            this.labelCell.setText(id);
        } else {
            this.labelCell.setText(null);
        }
        this.jBCell.setEnabled(table.getSelectedRow() > -1 && table.getSelectedColumn() > -1);
        this.jBUndo.setEnabled(table.canUndo());
        this.jBRedo.setEnabled(table.canRedo());
        this.jBCopy.setEnabled(!table.valueIsNull());
        this.jBCopyColNames.setEnabled(!table.valueIsNull());
        this.jBDrawChart.setEnabled(table.canDrawChart());
        this.jBShowText.setEnabled(table.canShowText());
        if (this.disablePin) {
            this.jBPin.setEnabled(false);
        } else {
            this.jBPin.setEnabled(StringUtils.isValidString(id));
        }
        if (GV.appMenu instanceof MenuSpl) {
            ((MenuSpl)GV.appMenu).setMenuEnabled((short)1271, table.canDrawChart());
        }
    }

    public void disablePin() {
        this.disablePin = true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jBCell.setEnabled(enabled);
        this.jBUndo.setEnabled(enabled);
        this.jBRedo.setEnabled(enabled);
        this.jBCopy.setEnabled(enabled);
        this.jBDrawChart.setEnabled(enabled);
        this.jBPin.setEnabled(enabled);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.labelCell, this.getGBC(1, 1, true));
        this.jBUndo.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pmtundo.gif"));
        this.jBUndo.setToolTipText(this.splMM.getMessage("panelvaluebar.undo"));
        this.initButton(this.jBUndo, (short)1);
        this.add((Component)this.jBUndo, this.getGBC(1, 2));
        this.jBRedo.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pmtredo.gif"));
        this.jBRedo.setToolTipText(this.splMM.getMessage("panelvaluebar.redo"));
        this.initButton(this.jBRedo, (short)3);
        this.add((Component)this.jBRedo, this.getGBC(1, 3));
        this.jBCell.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pmtcell.gif"));
        this.jBCell.setToolTipText(this.splMM.getMessage("panelvaluebar.cell"));
        this.initButton(this.jBCell, (short)6);
        this.add((Component)this.jBCell, this.getGBC(1, 4));
        this.jBCopy.setIcon(GM.getMenuImageIcon("copy"));
        this.jBCopy.setToolTipText(this.TIP_COPY_CONTENT);
        this.initButton(this.jBCopy, (short)8);
        this.add((Component)this.jBCopy, this.getGBC(1, 5));
        this.jBCopyColNames.setIcon(GM.getMenuImageIcon("coldefine"));
        this.jBCopyColNames.setToolTipText(this.TIP_COPY_COLNAMES);
        this.initButton(this.jBCopyColNames, (short)9);
        this.add((Component)this.jBCopyColNames, this.getGBC(1, 6));
        this.jBDrawChart.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_drawchart.gif"));
        this.jBDrawChart.setToolTipText(this.splMM.getMessage("panelvaluebar.chart"));
        this.initButton(this.jBDrawChart, (short)7);
        this.add((Component)this.jBDrawChart, this.getGBC(1, 7));
        this.jBShowText.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_showtext.gif"));
        this.jBShowText.setToolTipText(JTableValue.LABEL_VIEW_TEXT);
        this.initButton(this.jBShowText, (short)10);
        this.add((Component)this.jBShowText, this.getGBC(1, 8));
        this.jBPin.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_pin.gif"));
        this.jBPin.setToolTipText(this.PIN_OFF);
        this.initButton(this.jBPin, (short)5);
        this.jBPin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelValueBar.this.setLocked(PanelValueBar.this.jBPin.isSelected());
            }
        });
        this.add((Component)this.jBPin, this.getGBC(1, 9));
        this.jBClose.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/b_close2.gif"));
        this.initButton(this.jBClose, (short)11);
        this.add((Component)this.jBClose, this.getGBC(1, 9));
    }

    private void initButton(AbstractButton button, short cmd) {
        Dimension bSize = new Dimension(25, 25);
        button.setMinimumSize(bSize);
        button.setMaximumSize(bSize);
        button.setPreferredSize(bSize);
        button.setName(String.valueOf(cmd));
        button.addActionListener(this.popupAction);
        button.setEnabled(false);
    }

    private GridBagConstraints getGBC(int r, int c) {
        return this.getGBC(r, c, false);
    }

    private GridBagConstraints getGBC(int r, int c, boolean b) {
        GridBagConstraints gbc = GM.getGBC(r, c, b);
        gbc.insets = new Insets(3, 3, 3, 3);
        return gbc;
    }
}

