/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.app.common.Section;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class TableExtLibs
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    public static final byte COL_NAME = 1;
    private final byte COL_SELECT = (byte)2;
    private final String TITLE_INDEX = this.mm.getMessage("tableselectname.index");
    private final String TITLE_NAME = IdeSplMessage.get().getMessage("tableselectname.dirname");
    private final String TITLE_SELECT = this.mm.getMessage("tableselectname.select");
    private JTableEx tableNames;
    private volatile boolean selectAll = false;
    private Vector<String> existNames;
    private volatile boolean existColor = true;
    private boolean preventChange = false;
    private String filter = null;
    private Map<String, Boolean> nameSelected = new HashMap<String, Boolean>();
    private Component parent;

    public TableExtLibs(JDialog parent) {
        this.parent = parent;
        this.tableNames = new JTableEx(String.valueOf(this.TITLE_INDEX) + "," + this.TITLE_NAME + "," + this.TITLE_SELECT){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!this.isItemDataChanged(row, column, aValue)) {
                    return;
                }
                super.setValueAt(aValue, row, column);
                if (TableExtLibs.this.preventChange) {
                    return;
                }
                TableExtLibs.this.setDataChanged();
                if (column == 2) {
                    boolean selected = aValue != null && (Boolean)aValue != false;
                    TableExtLibs.this.rowSelectedChanged(row, selected);
                    String name = (String)this.data.getValueAt(row, 1);
                    TableExtLibs.this.nameSelected.put(name, new Boolean(selected));
                    int i = 0;
                    while (i < this.getRowCount()) {
                        boolean rSelected;
                        Object tmp = this.data.getValueAt(i, 2);
                        boolean bl = rSelected = tmp != null && (Boolean)tmp != false;
                        if (selected != rSelected) {
                            TableExtLibs.this.selectAll = false;
                            TableExtLibs.this.tableNames.getTableHeader().repaint();
                            return;
                        }
                        ++i;
                    }
                    TableExtLibs.this.selectAll = selected;
                    TableExtLibs.this.allRowsSelected(TableExtLibs.this.selectAll);
                    TableExtLibs.this.tableNames.getTableHeader().repaint();
                }
            }

            @Override
            public void rowfocusChanged(int oldRow, int newRow) {
                TableExtLibs.this.rowChanged(oldRow, newRow);
            }

            @Override
            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                TableExtLibs.this.doubleClick(row, col);
            }
        };
        this.init();
    }

    public void setExistColor(boolean existColor) {
        this.existColor = existColor;
    }

    public int getSelectedRow() {
        return this.tableNames.getSelectedRow();
    }

    public void rowChanged(int oldRow, int newRow) {
    }

    public void doubleClick(int row, int col) {
    }

    public void rowSelectedChanged(int row, boolean selected) {
    }

    public void allRowsSelected(boolean allSelected) {
    }

    public int getRowCount() {
        return this.tableNames.getRowCount();
    }

    public Object getValueAt(int row, int col) {
        return this.tableNames.data.getValueAt(row, col);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public synchronized void setNames(Vector<String> names, boolean reset, boolean selectExist) {
        try {
            this.preventChange = true;
            this.tableNames.acceptText();
            this.tableNames.removeAllRows();
            this.selectAll = false;
            if (!reset) {
                this.nameSelected.clear();
            }
            if (names == null) {
                return;
            }
            int size = names.size();
            Pattern p = null;
            if (StringUtils.isValidString(this.filter)) {
                try {
                    p = Pattern.compile(this.filter, 2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean isAllSelected = true;
            int r = 0;
            while (r < size) {
                Matcher m;
                String name;
                String n = names.get(r);
                String string = name = n == null ? null : n.toString();
                if (p == null || (m = p.matcher(name)).find()) {
                    Boolean selected = Boolean.FALSE;
                    if (reset) {
                        Boolean tmp = this.nameSelected.get(name);
                        if (tmp != null && tmp instanceof Boolean) {
                            selected = tmp;
                        }
                    } else if (selectExist && this.existNames != null) {
                        selected = new Boolean(this.existNames.contains(name));
                    }
                    this.tableNames.insertRow(-1, new Object[]{new Integer(r + 1), name, selected}, false);
                    if (!selected.booleanValue()) {
                        isAllSelected = false;
                    }
                    if (!reset) {
                        this.nameSelected.put(name, selected);
                    }
                }
                ++r;
            }
            this.tableNames.resetIndex();
            if (this.tableNames.getRowCount() > 0) {
                this.tableNames.selectRow(0);
            }
            if (isAllSelected) {
                this.selectAll = true;
                this.tableNames.getTableHeader().repaint();
            }
            this.repaint();
        }
        finally {
            this.preventChange = false;
        }
    }

    public String[] getSelectedNames(String tableName) {
        return this.getSelectedNames(tableName, ".");
    }

    public String[] getSelectedNames(String tableName, String opt) {
        this.tableNames.acceptText();
        int count = this.tableNames.getRowCount();
        Section sec = new Section();
        int i = 0;
        while (i < count) {
            Object tmp = this.tableNames.data.getValueAt(i, 2);
            if (tmp != null && ((Boolean)tmp).booleanValue() && StringUtils.isValidString(tmp = this.tableNames.data.getValueAt(i, 1))) {
                String name = (String)tmp;
                if (StringUtils.isValidString(tableName) && !name.startsWith(String.valueOf(tableName) + opt)) {
                    name = String.valueOf(tableName) + opt + name;
                }
                sec.addSection(name);
            }
            ++i;
        }
        return sec.toStringArray();
    }

    public int[] getSelectedIndexes() {
        this.tableNames.acceptText();
        int count = this.tableNames.getRowCount();
        if (count == 0) {
            return null;
        }
        IntArrayList list = new IntArrayList();
        int i = 0;
        while (i < count) {
            if (this.isRowSelected(i)) {
                list.addInt(i);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toIntArray();
    }

    public boolean isRowSelected(int row) {
        Object s = this.tableNames.data.getValueAt(row, 2);
        return s != null && (Boolean)s != false;
    }

    public void setRowSelected(int row, boolean selected) {
        this.tableNames.data.setValueAt(new Boolean(selected), row, 2);
        this.tableNames.acceptText();
    }

    public void setExistNames(Vector<String> existNames) {
        this.existNames = existNames;
    }

    private void init() {
        this.getViewport().add(this.tableNames);
        this.tableNames.setRowHeight(20);
        this.tableNames.getTableHeader().setReorderingAllowed(false);
        this.tableNames.setIndexCol(0);
        this.tableNames.setColumnEditable(1, false);
        this.tableNames.setSelectionMode(0);
        JTableHeader header = this.tableNames.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int col = TableExtLibs.this.tableNames.columnAtPoint(e.getPoint());
                if (col == 2) {
                    TableExtLibs.this.selectAll(!TableExtLibs.this.selectAll);
                    TableExtLibs.this.setDataChanged();
                }
            }
        });
        int selectWidth = 75;
        this.tableNames.getColumn(2).setHeaderRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox cb = new JCheckBox(TableExtLibs.this.TITLE_SELECT);
                cb.setSelected(TableExtLibs.this.selectAll);
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)cb, "Center");
                p.setFont(table.getFont());
                p.setBorder(new MetalBorders.TableHeaderBorder());
                p.setPreferredSize(new Dimension(75, 20));
                return p;
            }
        });
        this.tableNames.setColumnFixedWidth(2, 75);
        this.tableNames.setColumnCheckBox(2);
        this.tableNames.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (TableExtLibs.this.existColor && TableExtLibs.this.existNames != null && TableExtLibs.this.existNames.contains(value)) {
                    c.setForeground(Color.BLUE);
                } else {
                    c.setForeground(Color.BLACK);
                }
                return c;
            }
        });
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    String[] names = TableExtLibs.this.getSelectedNames(null);
                    if (names == null) {
                        return;
                    }
                    TransferableObject tf = new TransferableObject(names);
                    if (tf != null) {
                        dge.startDrag(Cursor.getPredefinedCursor(12), tf);
                    }
                }
                catch (Exception x) {
                    GM.showException(TableExtLibs.this.parent, x);
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this.tableNames, 1, dgl);
    }

    public void initButton(JButton b) {
        Dimension d = new Dimension(22, 22);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
    }

    public void selectAll(boolean selected) {
        this.selectAll = selected;
        int count = this.tableNames.getRowCount();
        int r = 0;
        while (r < count) {
            this.tableNames.data.setValueAt(new Boolean(this.selectAll), r, 2);
            this.nameSelected.put((String)this.tableNames.data.getValueAt(r, 1), new Boolean(this.selectAll));
            ++r;
        }
        this.tableNames.getTableHeader().repaint();
        this.allRowsSelected(this.selectAll);
    }

    protected void setDataChanged() {
    }
}

