/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart;

import com.scudata.chart.edit.ElementInfo;
import com.scudata.chart.edit.ElementLib;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.spl.chart.ParamInputPanel;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DialogPlotEdit
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int m_option = -1;
    JButton okbtn = new JButton();
    JButton cancelbtn = new JButton();
    JButton btExpandAll = new JButton();
    JButton btCollapseAll = new JButton();
    private JComboBoxEx elmList;
    private JComboBoxEx glist;
    private String plotFunc;
    private ParamInputPanel propPanel;
    private ElementInfo elmInfo;
    private String graphicsName;
    MessageManager mm = ChartMessage.get();

    public DialogPlotEdit(Frame owner, String plotFunc, List<String> graphics) {
        super(owner);
        int pos;
        this.plotFunc = plotFunc;
        this.setTitle(this.mm.getMessage("title.plotedit"));
        this.setModal(true);
        this.setSize(800, 520);
        this.setResizable(true);
        this.btExpandAll.setText(this.mm.getMessage("button.expandAll"));
        this.btExpandAll.setMargin(new Insets(2, 10, 2, 10));
        this.btExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPlotEdit.this.propPanel.expandAll();
            }
        });
        this.btCollapseAll.setText(this.mm.getMessage("button.collapseAll"));
        this.btCollapseAll.setMargin(new Insets(2, 10, 2, 10));
        this.btCollapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPlotEdit.this.propPanel.collapseAll();
            }
        });
        this.okbtn.setText(this.mm.getMessage("button.ok"));
        this.okbtn.setPreferredSize(new Dimension(70, 25));
        this.okbtn.setMargin(new Insets(2, 10, 2, 10));
        this.okbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPlotEdit.this.okbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setText(this.mm.getMessage("button.cancel"));
        this.cancelbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPlotEdit.this.cancelbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setPreferredSize(new Dimension(70, 25));
        this.cancelbtn.setMargin(new Insets(2, 10, 2, 10));
        this.okbtn.setMnemonic('O');
        this.cancelbtn.setMnemonic('C');
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.btExpandAll, GM.getGBC(1, 1));
        panel.add((Component)this.btCollapseAll, GM.getGBC(1, 2));
        panel.add((Component)new JLabel(" "), GM.getGBC(1, 3, true));
        panel.add((Component)this.okbtn, GM.getGBC(1, 4));
        panel.add((Component)this.cancelbtn, GM.getGBC(1, 5));
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)panel, "South");
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new GridBagLayout());
        cmdPanel.add((Component)new JLabel(this.mm.getMessage("label.selG")), GM.getGBC(1, 1));
        this.glist = new JComboBoxEx();
        Vector<String> gnames = new Vector<String>();
        Vector<String> gtitles = new Vector<String>();
        int i = 0;
        while (i < graphics.size()) {
            gnames.add(graphics.get(i));
            gtitles.add(graphics.get(i));
            ++i;
        }
        this.glist.x_setData(gnames, gtitles);
        this.glist.setEditable(true);
        cmdPanel.add((Component)this.glist, GM.getGBC(1, 2, true));
        cmdPanel.add((Component)new JLabel(this.mm.getMessage("label.selTy")), GM.getGBC(1, 3));
        this.elmList = new JComboBoxEx();
        Vector<String> names = new Vector<String>();
        Vector<String> titles = new Vector<String>();
        ArrayList<String> flList = ElementLib.getElementTitleList();
        ArrayList<ArrayList<ElementInfo>> list = ElementLib.getElementInfoList();
        int k = 0;
        while (k < flList.size()) {
            titles.add(flList.get(k));
            names.add("");
            ArrayList<ElementInfo> list1 = list.get(k);
            int i2 = 0;
            while (i2 < list1.size()) {
                ElementInfo ei = list1.get(i2);
                if (!ei.getName().equals("MapAxis")) {
                    names.add(ei.getName());
                    titles.add("    " + ei.getTitle());
                }
                ++i2;
            }
            ++k;
        }
        this.elmList.x_setData(names, titles);
        GridBagConstraints gbc = GM.getGBC(1, 4, true);
        cmdPanel.add((Component)this.elmList, gbc);
        pane.add((Component)cmdPanel, "North");
        this.propPanel = new ParamInputPanel(this);
        pane.add(this.propPanel);
        plotFunc = plotFunc == null ? "" : plotFunc.trim();
        if (plotFunc.startsWith("=")) {
            plotFunc = plotFunc.substring(1);
        }
        if ((pos = plotFunc.indexOf(".")) > 0) {
            this.graphicsName = plotFunc.substring(0, pos);
            plotFunc = plotFunc.substring(pos + 1);
        }
        if (plotFunc.startsWith("plot(")) {
            this.elmInfo = new ElementInfo();
            this.elmInfo.setPlotString(plotFunc);
            this.dispDetail();
            this.glist.x_setSelectedCodeItem(this.graphicsName);
            this.elmList.x_setSelectedCodeItem(this.elmInfo.getName());
            this.glist.setEnabled(false);
            this.elmList.setEnabled(false);
        } else {
            this.glist.addActionListener(this);
            this.elmList.addActionListener(this);
            this.elmList.setSelectedIndex(1);
            this.graphicsName = (String)this.glist.x_getSelectedItem();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogPlotEdit.this.closeDialog();
            }
        });
        GM.setDialogDefaultButton(this, this.okbtn, this.cancelbtn);
    }

    public int getOption() {
        return this.m_option;
    }

    public void dispDetail() {
        this.propPanel.setElementInfo(this.elmInfo);
    }

    private void closeDialog() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void okbtn_actionPerformed(ActionEvent e) {
        if (!StringUtils.isValidString(this.graphicsName)) {
            String message = this.mm.getMessage("DialogPlotEdit.emptyCanvas");
            JOptionPane.showMessageDialog(this, message);
            return;
        }
        this.propPanel.getParamTable().acceptText();
        this.plotFunc = this.elmInfo.toPlotString(this.propPanel.infoList);
        this.m_option = 0;
        this.closeDialog();
    }

    void cancelbtn_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        this.closeDialog();
    }

    public String getPlotFunction() {
        return String.valueOf(this.graphicsName) + "." + this.plotFunc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o.equals(this.glist)) {
            this.graphicsName = (String)this.glist.x_getSelectedItem();
        } else if (o.equals(this.elmList)) {
            String elmName = (String)this.elmList.x_getSelectedItem();
            if (elmName.length() == 0) {
                return;
            }
            this.elmInfo = ElementLib.getElementInfo(elmName);
            this.dispDetail();
        }
    }
}

