/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart;

import com.scudata.ide.common.GM;
import com.scudata.ide.spl.chart.TableInputSeries;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HeaderRenderer
extends JPanel
implements TableCellRenderer,
ActionListener,
MouseListener {
    private static final long serialVersionUID = -6809294871123761055L;
    private static Border border = UIManager.getBorder("TableHeader.cellBorder");
    private static ImageIcon delIcon = GM.getImageIcon("/com/scudata/ide/common/resources/s_del.gif");
    private static ImageIcon showIcon = GM.getImageIcon("/com/scudata/ide/common/resources/m_addrecord.gif");
    private static ImageIcon hideIcon = GM.getImageIcon("/com/scudata/ide/common/resources/m_deleterecord.gif");
    private TableInputSeries seriesTable;
    private int currCol;
    private JLabel label;
    private JButton delButton;
    private JButton extButton;

    public HeaderRenderer() {
        super(new FlowLayout(1, 0, 0));
        this.setBorder(border);
        this.delButton = new JButton(delIcon);
        this.delButton.setMargin(new Insets(0, 0, 0, 0));
        this.delButton.setPreferredSize(new Dimension(23, 22));
        this.delButton.setBorder(null);
        this.delButton.addActionListener(this);
        this.add(this.delButton);
        this.label = new JLabel();
        this.add(this.label);
        this.extButton = new JButton(showIcon);
        this.extButton.setMargin(new Insets(0, 0, 0, 0));
        this.extButton.setPreferredSize(new Dimension(22, 22));
        this.extButton.setBorder(null);
        this.extButton.addActionListener(this);
        this.add(this.extButton);
        this.delButton.setVisible(false);
        this.extButton.setVisible(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableColumn tc;
        String cfg;
        this.seriesTable = (TableInputSeries)table;
        this.currCol = column;
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            boolean hasThis = false;
            MouseListener[] mls = header.getMouseListeners();
            int i = 0;
            while (i < mls.length) {
                if (mls[i].equals(this)) {
                    hasThis = true;
                    break;
                }
                ++i;
            }
            if (!hasThis) {
                header.addMouseListener(this);
            }
            this.label.setFont(header.getFont());
        }
        if ((cfg = (tc = this.seriesTable.getColumn(this.currCol)).getIdentifier().toString()).indexOf(",") < 0) {
            this.delButton.setVisible(false);
            this.extButton.setVisible(false);
        } else {
            this.delButton.setVisible(true);
            this.extButton.setVisible(true);
            String isShow = cfg.substring(cfg.indexOf(",") + 1);
            if ("s".equals(isShow)) {
                this.extButton.setIcon(hideIcon);
            } else {
                this.extButton.setIcon(showIcon);
            }
        }
        if (value != null) {
            this.label.setText(value.toString());
        }
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o.equals(this.delButton)) {
            this.seriesTable.deleteParam(this.currCol);
        } else if (o.equals(this.extButton)) {
            TableColumn tc = this.seriesTable.getColumn(this.currCol);
            String cfg = (String)tc.getIdentifier();
            if (cfg.endsWith("s")) {
                cfg = String.valueOf(cfg.substring(0, cfg.indexOf(","))) + ",h";
                tc.setIdentifier(cfg);
                this.seriesTable.minimizeColumn(this.currCol + 1);
            } else if (cfg.endsWith("h")) {
                cfg = String.valueOf(cfg.substring(0, cfg.indexOf(","))) + ",s";
                tc.setIdentifier(cfg);
                this.seriesTable.recoverColumn(this.currCol + 1);
            }
            this.seriesTable.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x;
        JTableHeader header = (JTableHeader)e.getSource();
        JTable tableView = header.getTable();
        TableColumnModel columnModel = tableView.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(x = e.getX());
        if (viewColumn < 0 || viewColumn != this.currCol) {
            return;
        }
        TableColumn tc = columnModel.getColumn(viewColumn);
        JPanel panel = (JPanel)((Object)tc.getHeaderRenderer());
        if (panel == null || !panel.equals(this)) {
            return;
        }
        int w = 0;
        int i = 0;
        while (i < viewColumn) {
            w += columnModel.getColumn(i).getWidth();
            ++i;
        }
        Component c = this.getComponentAt(panel, x -= w, e.getY());
        if (c == null) {
            return;
        }
        if (c.equals(this.delButton)) {
            this.delButton.doClick();
        } else if (c.equals(this.extButton)) {
            this.extButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private Component getComponentAt(JPanel panel, int x, int y) {
        Component[] children = panel.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i].getBounds().contains(x, y)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }
}

