/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart;

import com.scudata.chart.edit.ElementInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.ide.common.GM;
import com.scudata.ide.spl.chart.TableInputSeries;
import com.scudata.ide.spl.chart.TableParamEdit;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ParamInputPanel
extends JSplitPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private TableParamEdit table;
    private TableInputSeries seriesTable;
    private JButton addRowBtn;
    private JButton delRowBtn;
    private JButton insertBtn;
    ParamInfoList infoList;
    private Dialog owner;

    public void setElementInfo(ElementInfo info) {
        String label = ChartMessage.get().getMessage("label.propedit", info.getTitle());
        this.init(this.owner, label, info.getParamInfoList());
        boolean hasLegendCol = info.getName().equals("Dot") || info.getName().equals("Line") || info.getName().equals("Column") || info.getName().equals("Sector");
        this.table.setColumnVisible(this.table.AXISCOL, hasLegendCol);
    }

    public void setParamInfoList(Dialog owner, ParamInfoList list) {
        String label = ChartMessage.get().getMessage("label.paramedit");
        this.init(owner, label, list);
    }

    public ParamInputPanel(Dialog owner) {
        this.owner = owner;
    }

    public void expandAll() {
        this.table.expandAll();
    }

    public void collapseAll() {
        this.table.collapseAll();
    }

    private void init(Dialog owner, String label, ParamInfoList list) {
        this.infoList = list;
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new BorderLayout());
        paramPanel.add((Component)new JLabel("  " + label), "North");
        this.table = new TableParamEdit(owner, list);
        paramPanel.add(new JScrollPane(this.table));
        this.setLeftComponent(paramPanel);
        JPanel seriesPanel = new JPanel(new BorderLayout());
        JPanel top = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GM.getGBC(1, 1, true);
        gbc.gridwidth = 4;
        top.add((Component)new JLabel(ChartMessage.get().getMessage("label.seriesinput")), gbc);
        this.seriesTable = new TableInputSeries(this.table);
        this.seriesTable.setAutoResizeMode(0);
        this.insertBtn = new JButton(ChartMessage.get().getMessage("button.insertrow"));
        this.insertBtn.addActionListener(this);
        this.insertBtn.setMnemonic('I');
        this.addRowBtn = new JButton(ChartMessage.get().getMessage("button.addrow"));
        this.addRowBtn.addActionListener(this);
        this.addRowBtn.setMnemonic('A');
        this.delRowBtn = new JButton(ChartMessage.get().getMessage("button.delrow"));
        this.delRowBtn.addActionListener(this);
        this.delRowBtn.setMnemonic('D');
        top.add((Component)new JLabel(" "), GM.getGBC(2, 1, true));
        top.add((Component)this.insertBtn, GM.getGBC(2, 2));
        top.add((Component)this.addRowBtn, GM.getGBC(2, 3));
        top.add((Component)this.delRowBtn, GM.getGBC(2, 4));
        seriesPanel.add((Component)top, "North");
        JScrollPane jsp = new JScrollPane(this.seriesTable, 20, 30);
        seriesPanel.add((Component)jsp, "Center");
        this.setRightComponent(seriesPanel);
        this.setDividerLocation(480);
        this.setDividerSize(8);
        this.setOneTouchExpandable(true);
        this.table.seriesTable = this.seriesTable;
    }

    public TableParamEdit getParamTable() {
        return this.table;
    }

    public TableInputSeries getSeriesTable() {
        return this.seriesTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o.equals(this.addRowBtn)) {
            this.seriesTable.myAddRow();
        } else if (o.equals(this.insertBtn)) {
            this.seriesTable.myInsertRow();
        } else if (o.equals(this.delRowBtn)) {
            this.seriesTable.myDelRow();
        }
    }

    public ParamInfoList getParamInfoList() {
        this.table.acceptText();
        return this.infoList;
    }
}

