/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.chart.ChartColor;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextAreaEditor;
import com.scudata.ide.spl.chart.HeaderRenderer;
import com.scudata.ide.spl.chart.TableParamEdit;
import com.scudata.ide.spl.chart.box.EachRowEditor;
import com.scudata.ide.spl.chart.box.EachRowRenderer;
import com.scudata.ide.spl.resources.ChartMessage;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableInputSeries
extends JTableEx {
    private static final long serialVersionUID = 1L;
    private int currCols;
    private TableParamEdit paramTable;
    private String expColName = ChartMessage.get().getMessage("label.exp");
    private String nameColName = ChartMessage.get().getMessage("label.paramname");

    public TableInputSeries(TableParamEdit table) {
        this.paramTable = table;
        this.currCols = 0;
        Object[] colNames = new String[]{this.nameColName, this.expColName, this.nameColName, this.expColName, this.nameColName, this.expColName, this.nameColName, this.expColName, this.nameColName, this.expColName};
        this.data.setColumnIdentifiers(colNames);
        this.addRow();
        this.setRowHeight(25);
        int i = 0;
        while (i < 10) {
            TableColumn tc = this.getColumn(i);
            tc.setHeaderRenderer(new HeaderRenderer());
            if (i % 2 == 0) {
                tc.setPreferredWidth(120);
            } else {
                tc.setPreferredWidth(80);
                tc.setCellEditor(new JTextAreaEditor(this));
            }
            this.minimizeColumn(i);
            ++i;
        }
        this.recoverColumn(0);
        this.recoverColumn(1);
    }

    public void addParam2Edit(int row, Dialog owner) {
        TableColumn expTc;
        TableColumn nameTc;
        int expIndex;
        int nameIndex;
        if (this.currCols == 5) {
            JOptionPane.showMessageDialog(this, ChartMessage.get().getMessage("info.maxparams"));
            return;
        }
        int i = 1;
        while (i <= this.currCols) {
            TableColumn tc = this.getColumn(i * 2 - 2);
            if (tc.getIdentifier().toString().startsWith(String.valueOf(row))) {
                return;
            }
            ++i;
        }
        String propName = this.paramTable.getModel().getValueAt(row, 1).toString();
        String cfg = "";
        if (this.currCols > 0) {
            nameIndex = this.currCols * 2;
            expIndex = this.currCols * 2 + 1;
            this.recoverColumn(nameIndex);
            nameTc = this.getColumn(nameIndex);
            expTc = this.getColumn(expIndex);
            cfg = String.valueOf(row) + ",h";
        } else {
            nameIndex = 0;
            expIndex = 1;
            nameTc = this.getColumn(0);
            expTc = this.getColumn(1);
            cfg = String.valueOf(row) + ",s";
        }
        nameTc.setIdentifier(cfg);
        nameTc.setHeaderValue(propName);
        int w = this.getStringW(propName) + 45 + 10;
        nameTc.setPreferredWidth(w);
        ++this.currCols;
        EachRowEditor ere = (EachRowEditor)this.paramTable.getCellEditor(row, TableParamEdit.iVALUECOL);
        TableCellEditor tce = ere.selectEditor(this.paramTable, row, TableParamEdit.iEDITSTYLECOL);
        nameTc.setCellEditor(tce);
        EachRowRenderer err = (EachRowRenderer)this.paramTable.getCellRenderer(row, TableParamEdit.iVALUECOL);
        TableCellRenderer tcr = err.selectRenderer(this.paramTable, row, TableParamEdit.iEDITSTYLECOL);
        nameTc.setCellRenderer(tcr);
        Object o = this.paramTable.getModel().getValueAt(row, 3);
        if (o != null) {
            o = PgmNormalCell.parseConstValue(o.toString().trim());
        }
        boolean isCC = TableInputSeries.isChartColor(o);
        ParamInfo info = (ParamInfo)this.paramTable.getModel().getValueAt(row, TableParamEdit.iOBJCOL);
        if (o == null || o.toString().trim().length() == 0 || isCC) {
            o = this.paramTable.getModel().getValueAt(row, 2);
            int i2 = 0;
            while (i2 < this.getRowCount()) {
                if (i2 == 0) {
                    this.data.setValueAt(o, i2, nameIndex);
                } else {
                    this.data.setValueAt(info.getDefValue(), i2, nameIndex);
                }
                this.data.setValueAt("", i2, expIndex);
                ++i2;
            }
        } else {
            String exp = ((String)this.paramTable.getModel().getValueAt(row, 3)).trim();
            if (exp.startsWith("[") && !isCC) {
                if (!exp.endsWith("]")) {
                    JOptionPane.showMessageDialog(this, String.valueOf(exp) + ChartMessage.get().getMessage("info.nozkh"));
                    return;
                }
                exp = exp.substring(1, exp.length() - 1).trim();
                ArgumentTokenizer at = new ArgumentTokenizer(exp, ',');
                int addRows = at.countTokens() - this.getRowCount();
                int r = 1;
                while (r <= addRows) {
                    this.myAddRow();
                    ++r;
                }
                r = 0;
                while (r < this.getRowCount()) {
                    if (at.hasMoreTokens()) {
                        Object val;
                        String tmp = at.nextToken().trim();
                        if (Variant.isEquals(tmp, val = PgmNormalCell.parseConstValue(tmp)) || TableInputSeries.isChartColor(val)) {
                            this.data.setValueAt(tmp, r, expIndex);
                            this.data.setValueAt(TableParamEdit.toValueObject(info, tmp), r, nameIndex);
                        } else {
                            this.data.setValueAt(val, r, nameIndex);
                        }
                    } else {
                        this.data.setValueAt("", r, expIndex);
                        this.data.setValueAt(info.getDefValue(), r, nameIndex);
                    }
                    ++r;
                }
            } else {
                int i3 = 0;
                while (i3 < this.getRowCount()) {
                    if (i3 == 0) {
                        if (isCC) {
                            this.data.setValueAt(info.getDefValue(), i3, nameIndex);
                            this.data.setValueAt(exp, i3, expIndex);
                        } else {
                            this.data.setValueAt(TableParamEdit.toValueObject(info, exp), i3, nameIndex);
                            this.data.setValueAt(exp, i3, expIndex);
                        }
                    } else {
                        this.data.setValueAt(info.getDefValue(), i3, nameIndex);
                        this.data.setValueAt("", i3, expIndex);
                    }
                    ++i3;
                }
            }
        }
        this.reDraw();
    }

    public static boolean isChartColor(Object o) {
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence s = (Sequence)o;
        if (s.length() != 6) {
            return false;
        }
        try {
            ChartColor.getInstance(s);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private int getStringW(String s) {
        Font font = this.getTableHeader().getFont();
        FontMetrics fm = new BufferedImage(10, 10, 1).getGraphics().getFontMetrics(font);
        return fm.stringWidth(s);
    }

    public void deleteParam(int colIndex) {
        if (this.currCols == 0) {
            return;
        }
        if (this.currCols == 1) {
            TableColumn tc = this.getColumn(0);
            tc.setHeaderValue(this.nameColName);
            tc.setIdentifier(this.nameColName);
            tc.setPreferredWidth(120);
            tc.setCellRenderer(null);
            tc.setCellEditor(null);
            this.recoverColumn(1);
            int i = 0;
            while (i < this.getRowCount()) {
                this.data.setValueAt(null, i, 0);
                this.data.setValueAt("", i, 1);
                ++i;
            }
        } else {
            int i = colIndex + 2;
            while (i < this.currCols * 2) {
                this.getColumnModel().moveColumn(i, i - 2);
                ++i;
            }
            this.minimizeColumn(this.currCols * 2 - 2);
            this.minimizeColumn(this.currCols * 2 - 1);
        }
        this.reDraw();
        --this.currCols;
    }

    private void reDraw() {
        this.getParent().repaint();
    }

    public void myAddRow() {
        int row = this.addRow();
        int col = 0;
        while (col < this.currCols * 2) {
            ParamInfo info = this.getParamInfo(col);
            if (info != null) {
                this.data.setValueAt(info.getDefValue(), row, col);
            }
            col += 2;
        }
    }

    public void myInsertRow() {
        int row = this.insertRow(this.getSelectedRow(), null);
        int col = 0;
        while (col < this.currCols * 2) {
            ParamInfo info = this.getParamInfo(col);
            if (info != null) {
                this.data.setValueAt(info.getDefValue(), row, col);
            }
            col += 2;
        }
    }

    public void myDelRow() {
        if (this.deleteSelectedRows()) {
            this.updateParams();
        }
    }

    private ParamInfo getParamInfo(int col) {
        int row = this.getParamRow(col);
        if (row < 0) {
            return null;
        }
        return (ParamInfo)this.paramTable.getModel().getValueAt(row, 6);
    }

    private int getParamRow(int col) {
        String cfg;
        int pos;
        if (col % 2 == 1) {
            --col;
        }
        if ((pos = (cfg = this.getColumn(col).getIdentifier().toString()).indexOf(",")) <= 0) {
            return -1;
        }
        int row = -1;
        try {
            row = Integer.parseInt(cfg.substring(0, pos));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return row;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        int nameIndex;
        int expIndex;
        Object oldValue = this.getValueAt(row, column);
        if (column % 2 == 1) {
            aValue = aValue.toString().trim();
            if (oldValue == null) {
                oldValue = "";
            }
            expIndex = column;
            nameIndex = column - 1;
        } else {
            if (oldValue == null) {
                oldValue = "";
            }
            nameIndex = column;
            expIndex = column + 1;
        }
        if (Variant.isEquals(aValue, oldValue)) {
            return;
        }
        super.setValueAt(aValue, row, column);
        ParamInfo info = this.getParamInfo(column);
        if (info == null) {
            return;
        }
        if (column % 2 == 0) {
            super.setValueAt(TableParamEdit.toExpString(info, aValue), row, expIndex);
        } else {
            super.setValueAt(TableParamEdit.toValueObject(info, aValue.toString()), row, nameIndex);
        }
        this.updateParams();
    }

    private String getSeriesValueString(int nameIndex, int expIndex, ParamInfo info) {
        if (this.getRowCount() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("[");
        int r = 0;
        while (r < this.getRowCount()) {
            Object expo = this.getValueAt(r, expIndex);
            Object o = this.getValueAt(r, nameIndex);
            if (o instanceof Color) {
                Color c = (Color)o;
                o = c.getRGB();
            }
            String exps = "";
            if (expo != null) {
                exps = expo.toString().trim();
            }
            if (exps.length() == 0) {
                Object obj;
                if (o == null) {
                    o = "";
                }
                if ((obj = Variant.parse(o.toString(), false)) instanceof Number) {
                    sb.append(o.toString());
                } else if (obj == null) {
                    sb.append("\"\"");
                } else if (obj instanceof Sequence) {
                    sb.append(obj.toString());
                } else {
                    sb.append(Escape.addEscAndQuote(obj.toString()));
                }
            } else {
                sb.append(exps);
            }
            if (r < this.getRowCount() - 1) {
                sb.append(",");
            }
            ++r;
        }
        sb.append("]");
        return sb.toString();
    }

    private void updateParam(int col) {
        int expIndex;
        int nameIndex;
        int paramRow = this.getParamRow(col);
        ParamInfo info = this.getParamInfo(col);
        if (info == null) {
            return;
        }
        if (col % 2 == 0) {
            nameIndex = col;
            expIndex = col + 1;
        } else {
            nameIndex = col - 1;
            expIndex = col;
        }
        String exp = this.getSeriesValueString(nameIndex, expIndex, info);
        this.paramTable.setValueAt(exp, paramRow, TableParamEdit.iEXPCOL);
    }

    public void updateParams() {
        this.acceptText();
        int i = 0;
        while (i < this.currCols * 2) {
            this.updateParam(i);
            i += 2;
        }
    }

    @Override
    public void acceptText() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }
}

