/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.auto;

import com.scudata.chart.edit.ElementInfo;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.spl.chart.auto.PanelParams;
import com.scudata.ide.spl.dialog.DialogDisplayChart;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogGraphEdit
extends JDialog {
    private static final long serialVersionUID = 1L;
    private PanelParams propPanel;
    private ElementInfo elmInfo;
    JButton btExpandAll = new JButton();
    JButton btCollapseAll = new JButton();
    JButton btApply = new JButton("Apply");
    JButton close;
    MessageManager mm = ChartMessage.get();
    private DialogDisplayChart ddc;

    public DialogGraphEdit(DialogDisplayChart ddc) {
        super(ddc);
        int w = 300;
        int h = ddc.getHeight();
        this.ddc = ddc;
        this.setModal(true);
        this.setSize(w, h);
        this.setResizable(true);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.propPanel = new PanelParams(this){

            @Override
            public void refresh() {
            }
        };
        pane.add((Component)this.propPanel, "Center");
        this.btExpandAll.setText(this.mm.getMessage("button.expandAll"));
        this.btExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGraphEdit.this.propPanel.expandAll();
            }
        });
        this.btCollapseAll.setText(this.mm.getMessage("button.collapseAll"));
        this.btCollapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGraphEdit.this.propPanel.collapseAll();
            }
        });
        this.btApply.setText(this.mm.getMessage("button.apply"));
        this.btApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGraphEdit.this.refreshDDC();
            }
        });
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.btExpandAll, GM.getGBC(1, 1));
        tmp.add((Component)this.btCollapseAll, GM.getGBC(1, 2));
        tmp.add((Component)new JLabel(""), GM.getGBC(1, 3, true));
        tmp.add((Component)this.btApply, GM.getGBC(1, 4));
        pane.add((Component)tmp, "South");
        this.elmInfo = new ElementInfo();
        this.elmInfo.setProperties(ddc.getGraphName(), ddc.getProperties());
        this.dispDetail();
        String label = this.mm.getMessage("label.propedit", this.elmInfo.getTitle());
        this.setTitle(label);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogGraphEdit.this.closeDialog();
            }
        });
        int x = ddc.getX() + ddc.getWidth();
        int y = ddc.getY();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = d.width;
        int height = d.height;
        if (x + w > width) {
            x = width - w;
        }
        if (y + h > height) {
            y = height - h;
        }
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGraphEdit.this.closeDialog();
            }
        });
        GM.setDialogDefaultButton(this, this.close, this.close);
        this.setLocation(x, y);
    }

    public void refreshDDC() {
        HashMap<String, Object> p = this.elmInfo.getProperties(this.propPanel.infoList);
        this.ddc.setProperties(p);
    }

    public void dispDetail() {
        this.propPanel.setElementInfo(this.elmInfo);
    }

    private void closeDialog() {
        this.dispose();
    }
}

