/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.chart.ChartColor;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.ColorComboBox;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.chart.box.ChartColorIcon;
import com.scudata.ide.spl.chart.box.TextureComboBox;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChartColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int m_option = -1;
    private ChartColor cc = new ChartColor();
    JLabel labelFillType = new JLabel("Fill type");
    TextureComboBox fillType = new TextureComboBox();
    JCheckBox jianjin = new JCheckBox();
    JButton okbtn = new JButton();
    JButton cancelbtn = new JButton();
    ColorComboBox color1 = new ColorComboBox(true);
    ColorComboBox color2 = new ColorComboBox(true);
    JLabel labelC1 = new JLabel();
    JLabel labelC2 = new JLabel();
    JLabel labelAngle = new JLabel();
    JSpinner angle = new JSpinner();
    JLabel sample = new JLabel();
    ChartColorIcon icon = null;
    boolean isInit = false;

    public ChartColorDialog(Dialog owner) {
        super(owner);
        this.setTitle(ChartMessage.get().getMessage("ccd.setcolor"));
        this.setModal(true);
        this.setSize(400, 280);
        GM.setDialogDefaultButton(this, this.okbtn, this.cancelbtn);
        try {
            this.jbInit();
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ChartColorDialog.this.drawSample();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isEquals(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.equals(c2);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.fillType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int type = (Integer)ChartColorDialog.this.fillType.getSelectedItem();
                boolean en = type == 0;
                ChartColorDialog.this.jianjin.setEnabled(en);
                ChartColorDialog.this.labelAngle.setEnabled(en);
                ChartColorDialog.this.angle.setEnabled(en);
                if (ChartColorDialog.this.isInit) {
                    return;
                }
                ChartColorDialog.this.cc.setType(type);
                if (type != 0) {
                    if (ChartColorDialog.this.isEquals(ChartColorDialog.this.cc.getColor1(), ChartColorDialog.this.cc.getColor2())) {
                        ChartColorDialog.this.color1.setSelectedItem(Color.WHITE.getRGB());
                        ChartColorDialog.this.color2.setSelectedItem(new Color(128, 128, 128).getRGB());
                    }
                    ChartColorDialog.this.jianjin.setSelected(false);
                }
                ChartColorDialog.this.drawSample();
            }
        });
        this.jianjin.setFont(new Font("Dialog", 0, 12));
        this.jianjin.setText(ChartMessage.get().getMessage("ccd.usegradient"));
        this.jianjin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorDialog.this.jianjin_actionPerformed(e);
            }
        });
        this.okbtn.setFont(new Font("Dialog", 0, 12));
        this.okbtn.setMargin(new Insets(2, 5, 2, 5));
        this.okbtn.setText(ChartMessage.get().getMessage("button.ok"));
        this.okbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorDialog.this.okbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setText(ChartMessage.get().getMessage("button.cancel"));
        this.cancelbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorDialog.this.cancelbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setFont(new Font("Dialog", 0, 12));
        this.cancelbtn.setMargin(new Insets(2, 5, 2, 5));
        this.labelC1.setFont(new Font("Dialog", 0, 12));
        this.labelC1.setText(ChartMessage.get().getMessage("ccd.color1"));
        this.labelC2.setText(ChartMessage.get().getMessage("ccd.color2"));
        this.labelC2.setFont(new Font("Dialog", 0, 12));
        this.labelAngle.setFont(new Font("Dialog", 0, 12));
        this.labelAngle.setToolTipText("");
        this.labelAngle.setText(ChartMessage.get().getMessage("ccd.angle"));
        this.angle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChartColorDialog.this.angle_stateChanged(e);
            }
        });
        this.color1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorDialog.this.color1_actionPerformed(e);
            }
        });
        this.color2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartColorDialog.this.color2_actionPerformed(e);
            }
        });
        JPanel panelCenter = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = GM.getGBC(1, 1);
        this.labelFillType.setText(ChartMessage.get().getMessage("ccd.fillType"));
        panelCenter.add((Component)this.labelFillType, gbc);
        gbc = GM.getGBC(1, 2, true);
        gbc.gridwidth = 3;
        panelCenter.add((Component)this.fillType, gbc);
        gbc = GM.getGBC(2, 1, true);
        gbc.gridwidth = 2;
        panelCenter.add((Component)this.jianjin, gbc);
        panelCenter.add((Component)this.labelAngle, GM.getGBC(2, 3));
        panelCenter.add((Component)this.angle, GM.getGBC(2, 4, true));
        panelCenter.add((Component)this.labelC1, GM.getGBC(3, 1));
        panelCenter.add((Component)this.color1, GM.getGBC(3, 2, true));
        panelCenter.add((Component)this.labelC2, GM.getGBC(3, 3));
        panelCenter.add((Component)this.color2, GM.getGBC(3, 4, true));
        this.icon = new ChartColorIcon(this.cc);
        this.sample.setIcon(this.icon);
        gbc = GM.getGBC(4, 1, true, true);
        gbc.gridwidth = 4;
        panelCenter.add((Component)this.sample, gbc);
        this.getContentPane().add((Component)panelCenter, "Center");
        JPanel panelButton = new JPanel(new VFlowLayout());
        panelButton.add(this.okbtn);
        panelButton.add(this.cancelbtn);
        this.getContentPane().add((Component)panelButton, "East");
        this.okbtn.setMnemonic('o');
        this.cancelbtn.setMnemonic('c');
        SpinnerNumberModel smodel = new SpinnerNumberModel(1, -359, 359, 1);
        this.angle.setModel(smodel);
    }

    private Integer getIntColor(Color c) {
        if (c == null) {
            return ChartColor.transparentColor;
        }
        return new Integer(c.getRGB());
    }

    public void setChartColor(ChartColor c) {
        this.cc = c == null ? new ChartColor() : c.deepClone();
        this.isInit = true;
        this.fillType.setSelectedItem(this.cc.getType());
        this.jianjin.setSelected(this.cc.isGradient());
        this.angle.setValue(new Integer(this.cc.getAngle()));
        Color c1 = this.cc.getColor1();
        this.color1.setSelectedItem(this.getIntColor(c1));
        Color c2 = this.cc.getColor2();
        this.color2.setSelectedItem(this.getIntColor(c2));
        this.drawSample();
        this.isInit = false;
        this.fillType.repaint(100L);
    }

    public int getOption() {
        return this.m_option;
    }

    public ChartColor getChartColor() {
        return this.cc;
    }

    void okbtn_actionPerformed(ActionEvent e) {
        this.cc.setGradient(this.jianjin.isSelected());
        this.cc.setColor1(this.color1.getColor());
        this.cc.setColor2(this.color2.getColor());
        this.cc.setAngle((Integer)this.angle.getValue());
        this.m_option = 0;
        this.dispose();
    }

    void cancelbtn_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        this.dispose();
    }

    private void drawSample() {
        boolean en = this.jianjin.isSelected() || this.cc.getType() != 0;
        this.labelC2.setEnabled(en);
        this.color2.setEnabled(en);
        this.icon.setChartColor(this.cc);
        this.icon.setSize(this.sample.getWidth(), this.sample.getHeight());
        this.sample.repaint();
    }

    void jianjin_actionPerformed(ActionEvent e) {
        this.cc.setGradient(this.jianjin.isSelected());
        Integer c1 = this.color1.getColor();
        if (this.jianjin.isSelected() && c1.equals(ColorComboBox.transparentColor)) {
            this.color1.setSelectedIndex(0);
        }
        Integer c2 = this.color2.getColor();
        if (this.jianjin.isSelected() && c2.equals(ColorComboBox.transparentColor)) {
            this.color2.setSelectedIndex(0);
        }
        this.cc.setColor1(this.color1.getColor());
        this.cc.setColor2(this.color2.getColor());
        this.cc.setAngle((Integer)this.angle.getValue());
        this.drawSample();
    }

    void angle_stateChanged(ChangeEvent e) {
        this.cc.setAngle((Integer)this.angle.getValue());
        this.drawSample();
    }

    void color1_actionPerformed(ActionEvent e) {
        Integer c1 = this.color1.getColor();
        if (c1 == ColorComboBox.transparentColor) {
            this.jianjin.setSelected(false);
        }
        this.cc.setColor1(this.color1.getColor());
        this.drawSample();
    }

    void color2_actionPerformed(ActionEvent e) {
        Integer c2 = this.color2.getColor();
        if (c2 == ColorComboBox.transparentColor) {
            this.jianjin.setSelected(false);
        }
        this.cc.setColor2(this.color2.getColor());
        this.drawSample();
    }
}

