/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.chart.ChartColor;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.chart.box.ChartColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ChartColorRender
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -7052984657716825594L;
    private ChartColorIcon icon = new ChartColorIcon();

    public ChartColorRender() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ChartColor cc;
        this.setText(" ");
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (value == null) {
            cc = new ChartColor();
        } else if (value instanceof Color) {
            cc = new ChartColor((Color)value);
        } else if (value instanceof Number) {
            cc = new ChartColor(new Color(((Number)value).intValue()));
        } else if (value instanceof ChartColor) {
            cc = (ChartColor)value;
        } else if (value instanceof Sequence) {
            cc = (ChartColor)((Sequence)value).get(1);
        } else {
            throw new RuntimeException("Invalid value:" + value);
        }
        this.icon.setChartColor(cc);
        int w = ((JTableEx)table).getColumn(column).getWidth();
        int h = table.getRowHeight(row);
        this.setPreferredSize(new Dimension(w, h));
        this.icon.setSize(w, h);
        this.setIcon(this.icon);
        return this;
    }
}

