/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.ide.common.swing.ColorComboBox;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JComboBoxExEditor;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextAreaEditor;
import com.scudata.ide.spl.chart.box.ArrowComboBox;
import com.scudata.ide.spl.chart.box.ChartColorEditor;
import com.scudata.ide.spl.chart.box.DateEditor;
import com.scudata.ide.spl.chart.box.EditStyles;
import com.scudata.ide.spl.chart.box.FontSizeBox;
import com.scudata.ide.spl.chart.box.FontStyleEditor;
import com.scudata.ide.spl.chart.box.LineStyleComboBox;
import com.scudata.ide.spl.chart.box.PointStyleComboBox;
import com.scudata.ide.spl.chart.box.TextureComboBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class EachRowEditor
implements TableCellEditor {
    int currentRow;
    int editTypeCol;
    private JTableEx table;
    public Dialog owner;
    private TableCellEditor editor;
    public TableCellEditor defaultEditor;
    private DefaultCellEditor checkEditor;
    private TableCellEditor lineStyleEditor;
    private TableCellEditor arrowEditor;
    private TableCellEditor simpleArrowEditor;
    private TableCellEditor textureEditor;
    private TableCellEditor colorEditor;
    private TableCellEditor fontEditor;
    private TableCellEditor pointEditor;
    private TableCellEditor fontStyleEditor;
    private TableCellEditor dateEditor;
    private TableCellEditor ticksEditor;
    private TableCellEditor unitEditor;
    private TableCellEditor coordEditor;
    private TableCellEditor axisEditor;
    private TableCellEditor fontsizeEditor;
    private TableCellEditor columnStyleEditor;
    private TableCellEditor chartColorEditor;
    private TableCellEditor halignEditor;
    private TableCellEditor valignEditor;
    private TableCellEditor imageModeEditor;
    private JTextAreaEditor angleEditor;
    private JTextAreaEditor intEditor;
    private JTextAreaEditor doubleEditor;
    private TableCellEditor legendIconEditor;
    private TableCellEditor dateUnitEditor;
    private TableCellEditor urlTargetEditor;
    private TableCellEditor transformEditor;
    private TableCellEditor stackTypeEditor;
    private TableCellEditor displayDataEditor;
    private TableCellEditor legendLocationEditor;
    private TableCellEditor inputColumnTypeEditor;
    private TableCellEditor inputLineTypeEditor;
    private TableCellEditor inputPieTypeEditor;
    private TableCellEditor input2AxisTypeEditor;
    private TableCellEditor inputBarTypeEditor;
    private TableCellEditor inputCharSetEditor;
    private TableCellEditor inputRecErrorEditor;
    ActionListener al;

    public EachRowEditor(final JTableEx table, int editTypeCol, Dialog owner) {
        this.table = table;
        this.editTypeCol = editTypeCol;
        this.owner = owner;
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.stateChanged(new ChangeEvent(e.getSource()));
            }
        };
        this.defaultEditor = table.getDefaultCellEditor(new JTextField(), table);
        JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(this.al);
        checkBox.setHorizontalAlignment(0);
        this.checkEditor = new DefaultCellEditor(checkBox);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            this.selectEditor((MouseEvent)anEvent);
            return this.editor.isCellEditable(anEvent);
        }
        return false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    protected void selectEditor(MouseEvent e) {
        this.currentRow = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        this.editor = this.selectEditor(this.table, this.currentRow, this.editTypeCol);
    }

    public TableCellEditor selectEditor(JTable tbl, int row, int editTypeColumn) {
        int editType = (Integer)tbl.getModel().getValueAt(row, editTypeColumn);
        return this.selectEditor(editType);
    }

    public TableCellEditor selectEditor(int editType) {
        TableCellEditor editor1 = null;
        switch (editType) {
            case 4: {
                if (this.lineStyleEditor == null) {
                    LineStyleComboBox lscb = new LineStyleComboBox();
                    lscb.addActionListener(this.al);
                    this.lineStyleEditor = new DefaultCellEditor(lscb);
                }
                editor1 = this.lineStyleEditor;
                break;
            }
            case 14: {
                if (this.arrowEditor == null) {
                    ArrowComboBox acb = new ArrowComboBox(false);
                    acb.addActionListener(this.al);
                    this.arrowEditor = new DefaultCellEditor(acb);
                }
                editor1 = this.arrowEditor;
                break;
            }
            case 47: {
                if (this.simpleArrowEditor == null) {
                    ArrowComboBox acb = new ArrowComboBox(true);
                    acb.addActionListener(this.al);
                    this.simpleArrowEditor = new DefaultCellEditor(acb);
                }
                editor1 = this.simpleArrowEditor;
                break;
            }
            case 6: {
                if (this.textureEditor == null) {
                    TextureComboBox tcb = new TextureComboBox();
                    tcb.addActionListener(this.al);
                    this.textureEditor = new DefaultCellEditor(tcb);
                }
                editor1 = this.textureEditor;
                break;
            }
            case 3: {
                if (this.colorEditor == null) {
                    ColorComboBox ccb = new ColorComboBox(true);
                    ccb.addActionListener(this.al);
                    this.colorEditor = new DefaultCellEditor(ccb);
                }
                editor1 = this.colorEditor;
                break;
            }
            case 5: {
                if (this.fontEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getFontBox();
                    jcbe.addActionListener(this.al);
                    this.fontEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.fontEditor;
                break;
            }
            case 7: {
                if (this.pointEditor == null) {
                    PointStyleComboBox pscb = new PointStyleComboBox();
                    pscb.addActionListener(this.al);
                    this.pointEditor = new DefaultCellEditor(pscb);
                }
                editor1 = this.pointEditor;
                break;
            }
            case 8: {
                if (this.fontStyleEditor == null) {
                    this.fontStyleEditor = new FontStyleEditor(this.owner);
                }
                editor1 = this.fontStyleEditor;
                break;
            }
            case 13: {
                if (this.dateEditor == null) {
                    this.dateEditor = new DateEditor(this.owner);
                }
                editor1 = this.dateEditor;
                break;
            }
            case 12: {
                if (this.chartColorEditor == null) {
                    this.chartColorEditor = new ChartColorEditor(this.owner);
                }
                editor1 = this.chartColorEditor;
                break;
            }
            case 15: {
                if (this.ticksEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getTicksBox();
                    jcbe.addActionListener(this.al);
                    this.ticksEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.ticksEditor;
                break;
            }
            case 17: {
                if (this.unitEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getUnitBox();
                    jcbe.addActionListener(this.al);
                    this.unitEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.unitEditor;
                break;
            }
            case 18: {
                if (this.coordEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getCoordinateBox();
                    jcbe.addActionListener(this.al);
                    this.coordEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.coordEditor;
                break;
            }
            case 19: {
                if (this.axisEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getAxisBox();
                    jcbe.addActionListener(this.al);
                    this.axisEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.axisEditor;
                break;
            }
            case 21: {
                if (this.halignEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getHAlignBox();
                    jcbe.addActionListener(this.al);
                    this.halignEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.halignEditor;
                break;
            }
            case 22: {
                if (this.valignEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getVAlignBox();
                    jcbe.addActionListener(this.al);
                    this.valignEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.valignEditor;
                break;
            }
            case 46: {
                if (this.imageModeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getImageMode();
                    jcbe.addActionListener(this.al);
                    this.imageModeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.imageModeEditor;
                break;
            }
            case 20: {
                if (this.fontsizeEditor == null) {
                    FontSizeBox fsBox = new FontSizeBox();
                    fsBox.setEditable(true);
                    fsBox.addActionListener(this.al);
                    this.fontsizeEditor = new JComboBoxExEditor(fsBox);
                }
                editor1 = this.fontsizeEditor;
                break;
            }
            case 9: {
                if (this.columnStyleEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getColumnStyleBox();
                    jcbe.addActionListener(this.al);
                    this.columnStyleEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.columnStyleEditor;
                break;
            }
            case 16: {
                if (this.angleEditor == null) {
                    this.angleEditor = new JTextAreaEditor(this.table, 4);
                    this.angleEditor.setArrange(-360, 360, 1);
                }
                editor1 = this.angleEditor;
                break;
            }
            case 24: {
                if (this.intEditor == null) {
                    this.intEditor = new JTextAreaEditor(this.table, 4);
                }
                editor1 = this.intEditor;
                break;
            }
            case 25: {
                if (this.doubleEditor == null) {
                    this.doubleEditor = new JTextAreaEditor(this.table, 6);
                }
                editor1 = this.doubleEditor;
                break;
            }
            case 10: {
                editor1 = this.checkEditor;
                break;
            }
            case 23: {
                if (this.legendIconEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getLegendIconBox();
                    jcbe.addActionListener(this.al);
                    this.legendIconEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.legendIconEditor;
                break;
            }
            case 26: {
                if (this.dateUnitEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getDateUnitBox();
                    jcbe.addActionListener(this.al);
                    this.dateUnitEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.dateUnitEditor;
                break;
            }
            case 28: {
                if (this.urlTargetEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getUrlTargetBox();
                    jcbe.addActionListener(this.al);
                    this.urlTargetEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.urlTargetEditor;
                break;
            }
            case 27: {
                if (this.transformEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getTransformBox();
                    jcbe.addActionListener(this.al);
                    this.transformEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.transformEditor;
                break;
            }
            case 29: {
                if (this.stackTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getStackTypeBox();
                    jcbe.addActionListener(this.al);
                    this.stackTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.stackTypeEditor;
                break;
            }
            case 40: {
                if (this.displayDataEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getDisplayDataBox();
                    jcbe.addActionListener(this.al);
                    this.displayDataEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.displayDataEditor;
                break;
            }
            case 41: {
                if (this.legendLocationEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getLegendLocationBox();
                    jcbe.addActionListener(this.al);
                    this.legendLocationEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.legendLocationEditor;
                break;
            }
            case 42: {
                if (this.inputColumnTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getInputColumnTypeBox();
                    jcbe.addActionListener(this.al);
                    this.inputColumnTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputColumnTypeEditor;
                break;
            }
            case 43: {
                if (this.inputLineTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getInputLineTypeBox();
                    jcbe.addActionListener(this.al);
                    this.inputLineTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputLineTypeEditor;
                break;
            }
            case 44: {
                if (this.inputPieTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getInputPieTypeBox();
                    jcbe.addActionListener(this.al);
                    this.inputPieTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputPieTypeEditor;
                break;
            }
            case 45: {
                if (this.input2AxisTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getInput2AxisTypeBox();
                    jcbe.addActionListener(this.al);
                    this.input2AxisTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.input2AxisTypeEditor;
                break;
            }
            case 60: {
                if (this.inputBarTypeEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getBarcodeType();
                    jcbe.addActionListener(this.al);
                    this.inputBarTypeEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputBarTypeEditor;
                break;
            }
            case 61: {
                if (this.inputCharSetEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getCharSet();
                    jcbe.addActionListener(this.al);
                    this.inputCharSetEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputCharSetEditor;
                break;
            }
            case 62: {
                if (this.inputRecErrorEditor == null) {
                    JComboBoxEx jcbe = EditStyles.getRecError();
                    jcbe.addActionListener(this.al);
                    this.inputRecErrorEditor = new JComboBoxExEditor(jcbe);
                }
                editor1 = this.inputRecErrorEditor;
                break;
            }
            default: {
                editor1 = this.defaultEditor;
            }
        }
        return editor1;
    }

    public void setOwner(Dialog dialog) {
        this.owner = dialog;
    }
}

