/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.ide.common.GM;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class FontStyleDialog
extends JDialog {
    private static final long serialVersionUID = 3611045277241487646L;
    private int m_option = -1;
    private int style;
    JCheckBox bold = new JCheckBox();
    JCheckBox italic = new JCheckBox();
    JCheckBox underLine = new JCheckBox();
    JCheckBox vertical = new JCheckBox();
    JButton okbtn = new JButton();
    JButton cancelbtn = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public FontStyleDialog(Dialog owner) {
        super(owner);
        this.setTitle(ChartMessage.get().getMessage("fontdialog.title"));
        this.setModal(true);
        this.setSize(245, 150);
        GM.setDialogDefaultButton(this, this.okbtn, this.cancelbtn);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.bold.setFont(new Font("Dialog", 0, 12));
        this.bold.setText(ChartMessage.get().getMessage("fontdialog.bold"));
        this.italic.setFont(new Font("Dialog", 0, 12));
        this.italic.setText(ChartMessage.get().getMessage("fontdialog.italic"));
        this.underLine.setFont(new Font("Dialog", 0, 12));
        this.underLine.setActionCommand("");
        this.underLine.setText(ChartMessage.get().getMessage("fontdialog.ul"));
        this.vertical.setFont(new Font("Dialog", 0, 12));
        this.vertical.setActionCommand(ChartMessage.get().getMessage("fontdialog.vert"));
        this.vertical.setText(ChartMessage.get().getMessage("fontdialog.vert"));
        this.okbtn.setFont(new Font("Dialog", 0, 12));
        this.okbtn.setMargin(new Insets(2, 10, 2, 10));
        this.okbtn.setText(ChartMessage.get().getMessage("button.ok"));
        this.okbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontStyleDialog.this.okbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setText(ChartMessage.get().getMessage("button.cancel"));
        this.cancelbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontStyleDialog.this.cancelbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setFont(new Font("Dialog", 0, 12));
        this.cancelbtn.setMargin(new Insets(2, 10, 2, 10));
        this.getContentPane().add((Component)this.underLine, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 40, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.bold, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.vertical, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 49, 0, 23), 0, 0));
        this.getContentPane().add((Component)this.italic, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 49, 0, 47), 0, 0));
        this.getContentPane().add((Component)this.cancelbtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(23, 52, 20, 43), 0, -4));
        this.getContentPane().add((Component)this.okbtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(23, 47, 20, 0), 0, -4));
        this.okbtn.setMnemonic('o');
        this.cancelbtn.setMnemonic('c');
    }

    public void setFontStyle(int style) {
        this.style = style;
        if ((style & 1) != 0) {
            this.bold.setSelected(true);
        } else {
            this.bold.setSelected(false);
        }
        if ((style & 2) != 0) {
            this.italic.setSelected(true);
        } else {
            this.italic.setSelected(false);
        }
        if ((style & 4) != 0) {
            this.underLine.setSelected(true);
        } else {
            this.underLine.setSelected(false);
        }
        if ((style & 8) != 0) {
            this.vertical.setSelected(true);
        } else {
            this.vertical.setSelected(false);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public int getFontStyle() {
        return this.style;
    }

    void okbtn_actionPerformed(ActionEvent e) {
        this.style = 0;
        if (this.bold.isSelected()) {
            ++this.style;
        }
        if (this.italic.isSelected()) {
            this.style += 2;
        }
        if (this.underLine.isSelected()) {
            this.style += 4;
        }
        if (this.vertical.isSelected()) {
            this.style += 8;
        }
        this.m_option = 0;
        this.dispose();
    }

    void cancelbtn_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        this.dispose();
    }
}

